/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.SystemInfo;
import java.awt.datatransfer.DataFlavor;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClipboardUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.Clipboard");
    private static final String USE_LEGACY_MERGE_SORT_PROPERTY_NAME = "java.util.Arrays.useLegacyMergeSort";

    public static <E> E handleClipboardSafely(@NotNull Supplier<E> supplier, @NotNull Supplier<E> onFail) {
        if (supplier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supplier", "com/intellij/openapi/application/ex/ClipboardUtil", "handleClipboardSafely"));
        }
        if (onFail == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onFail", "com/intellij/openapi/application/ex/ClipboardUtil", "handleClipboardSafely"));
        }
        try {
            return ClipboardUtil.useLegacyMergeSort(supplier);
        }
        catch (IllegalStateException e) {
            if (SystemInfo.isWindows) {
                LOG.debug("Clipboard is busy");
            } else {
                LOG.warn((Throwable)e);
            }
        }
        catch (NullPointerException e) {
            LOG.warn("Java bug #6322854", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Java bug #7173464", (Throwable)e);
        }
        return onFail.get();
    }

    private static <T> T useLegacyMergeSort(Supplier<T> supplier) {
        String originalValue = System.getProperty(USE_LEGACY_MERGE_SORT_PROPERTY_NAME);
        System.setProperty(USE_LEGACY_MERGE_SORT_PROPERTY_NAME, "true");
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            if (originalValue != null) {
                System.setProperty(USE_LEGACY_MERGE_SORT_PROPERTY_NAME, originalValue);
            }
        }
    }

    @Nullable
    public static String getTextInClipboard() {
        return (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
    }
}

