/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.generic;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VirtualFileWithDependenciesState {
    public static final DataExternalizer<VirtualFileWithDependenciesState> EXTERNALIZER = new VirtualFileWithDependenciesExternalizer();
    private long mySourceTimestamp;
    private Map<String, Long> myDependencies = new HashMap<String, Long>();

    public VirtualFileWithDependenciesState(long sourceTimestamp) {
        this.mySourceTimestamp = sourceTimestamp;
    }

    public void addDependency(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/compiler/generic/VirtualFileWithDependenciesState", "addDependency"));
        }
        this.myDependencies.put(file2.getUrl(), file2.getTimeStamp());
    }

    public boolean isUpToDate(@NotNull VirtualFile sourceFile) {
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "com/intellij/openapi/compiler/generic/VirtualFileWithDependenciesState", "isUpToDate"));
        }
        if (sourceFile.getTimeStamp() != this.mySourceTimestamp) {
            return false;
        }
        VirtualFileManager manager = VirtualFileManager.getInstance();
        for (Map.Entry<String, Long> entry : this.myDependencies.entrySet()) {
            VirtualFile file2 = manager.findFileByUrl(entry.getKey());
            if (file2 != null && file2.getTimeStamp() == entry.getValue().longValue()) continue;
            return false;
        }
        return true;
    }

    private static class VirtualFileWithDependenciesExternalizer
    implements DataExternalizer<VirtualFileWithDependenciesState> {
        private VirtualFileWithDependenciesExternalizer() {
        }

        public void save(@NotNull DataOutput out, VirtualFileWithDependenciesState value2) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/openapi/compiler/generic/VirtualFileWithDependenciesState$VirtualFileWithDependenciesExternalizer", "save"));
            }
            out.writeLong(value2.mySourceTimestamp);
            Map dependencies = value2.myDependencies;
            out.writeInt(dependencies.size());
            for (Map.Entry entry : dependencies.entrySet()) {
                IOUtil.writeUTF((DataOutput)out, (String)((String)entry.getKey()));
                out.writeLong((Long)entry.getValue());
            }
        }

        public VirtualFileWithDependenciesState read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/openapi/compiler/generic/VirtualFileWithDependenciesState$VirtualFileWithDependenciesExternalizer", "read"));
            }
            VirtualFileWithDependenciesState state = new VirtualFileWithDependenciesState(in.readLong());
            int size = in.readInt();
            while (size-- > 0) {
                String url = IOUtil.readUTF((DataInput)in);
                long timestamp = in.readLong();
                state.myDependencies.put(url, timestamp);
            }
            return state;
        }
    }
}

