/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentSerializationUtil {
    @NotNull
    public static <S> Class<S> getStateClass(@NotNull Class<? extends PersistentStateComponent> aClass) {
        Class result2;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/openapi/components/ComponentSerializationUtil", "getStateClass"));
        }
        TypeVariable variable = PersistentStateComponent.class.getTypeParameters()[0];
        Type type2 = ReflectionUtil.resolveVariableInHierarchy(variable, aClass);
        assert (type2 != null) : aClass;
        Class clazz = result2 = ReflectionUtil.getRawType((Type)type2);
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/ComponentSerializationUtil", "getStateClass"));
        }
        return clazz;
    }

    public static <S> void loadComponentState(@NotNull PersistentStateComponent<S> configuration, @Nullable Element element) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/openapi/components/ComponentSerializationUtil", "loadComponentState"));
        }
        if (element != null) {
            Element state;
            Class<S> stateClass = ComponentSerializationUtil.getStateClass(configuration.getClass());
            Object object = state = stateClass.equals(Element.class) ? element : XmlSerializer.deserialize((Element)element, stateClass);
            if (state != null) {
                configuration.loadState((Object)state);
            }
        }
    }
}

