/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.diff.DirDiffOperation;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.diff.impl.dir.actions.DirDiffAction;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.JBIterable;

public class SynchronizeDiff
extends DirDiffAction {
    private final boolean mySelectedOnly;

    public SynchronizeDiff(DirDiffTableModel model, boolean selectedOnly) {
        super(model);
        this.getTemplatePresentation().setText(selectedOnly ? "Synchronize Selected" : "Synchronize All");
        this.getTemplatePresentation().setIcon(selectedOnly ? AllIcons.Actions.Resume : AllIcons.Actions.Rerun);
        this.mySelectedOnly = selectedOnly;
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        if (!e.getPresentation().isEnabled()) {
            return;
        }
        boolean enabled = !JBIterable.from(this.mySelectedOnly ? this.getModel().getSelectedElements() : this.getModel().getElements()).filter(d -> d.getOperation() == DirDiffOperation.COPY_FROM || d.getOperation() == DirDiffOperation.COPY_TO || d.getOperation() == DirDiffOperation.DELETE).filter(d -> d.getSource() == null || d.getSource().isOperationsEnabled()).filter(d -> d.getTarget() == null || d.getTarget().isOperationsEnabled()).isEmpty();
        e.getPresentation().setEnabled(enabled);
    }

    @Override
    protected void updateState(boolean state) {
        if (this.mySelectedOnly) {
            this.getModel().synchronizeSelected();
        } else {
            this.getModel().synchronizeAll();
        }
    }

    @Override
    public ShortcutSet getShortcut() {
        return CustomShortcutSet.fromString((String[])new String[]{this.mySelectedOnly ? "ENTER" : (SystemInfo.isMac ? "meta ENTER" : "control ENTER")});
    }

    public boolean isSelected(AnActionEvent e) {
        return false;
    }

    @Override
    protected boolean isFullReload() {
        return false;
    }

    @Override
    protected boolean isReloadNeeded() {
        return false;
    }
}

