/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.formove;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.patch.RelativePathCalculator;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PathMerger {
    private PathMerger() {
    }

    @Nullable
    public static VirtualFile getFile(VirtualFile base, String path) {
        return PathMerger.getFile(new VirtualFilePathMerger(base), path);
    }

    @Nullable
    public static VirtualFile getFile(VirtualFile base, String path, List<String> tail) {
        return PathMerger.getFile(new VirtualFilePathMerger(base), path, tail);
    }

    @Nullable
    public static File getFile(File base, String path) {
        return PathMerger.getFile(new IoFilePathMerger(base), path);
    }

    @Nullable
    public static File getFile(File base, String path, List<String> tail) {
        return PathMerger.getFile(new IoFilePathMerger(base), path, tail);
    }

    @Nullable
    public static FilePath getFile(FilePath base, String path) {
        return PathMerger.getFile(new FilePathPathMerger(base), path);
    }

    @Nullable
    public static FilePath getFile(FilePath base, String path, List<String> tail) {
        return PathMerger.getFile(new FilePathPathMerger(base), path, tail);
    }

    @Nullable
    public static <T> T getFile(FilePathMerger<T> merger, String path) {
        if (path == null) {
            return null;
        }
        ArrayList<String> tail = new ArrayList<String>();
        T file2 = PathMerger.getFile(merger, path, tail);
        if (tail.isEmpty()) {
            return file2;
        }
        return null;
    }

    @Nullable
    public static <T> T getFile(FilePathMerger<T> merger, String path, List<String> tail) {
        String[] pieces = RelativePathCalculator.split(path);
        for (int i2 = 0; i2 < pieces.length; ++i2) {
            String piece = pieces[i2];
            if ("".equals(piece) || ".".equals(piece)) continue;
            if ("..".equals(piece)) {
                boolean upResult = merger.up();
                if (upResult) continue;
                return null;
            }
            boolean downResult = merger.down(piece);
            if (downResult) continue;
            if (tail != null) {
                for (int j = i2; j < pieces.length; ++j) {
                    String pieceInner = pieces[j];
                    tail.add(pieceInner);
                }
            }
            return merger.getResult();
        }
        return merger.getResult();
    }

    @Nullable
    public static VirtualFile getBase(VirtualFile base, String path) {
        return PathMerger.getBase(new VirtualFilePathMerger(base), path);
    }

    @Nullable
    public static <T> T getBase(FilePathMerger<T> merger, String path) {
        boolean caseSensitive = SystemInfo.isFileSystemCaseSensitive;
        String[] parts = path.replace("\\", "/").split("/");
        for (int i2 = parts.length - 1; i2 >= 0; --i2) {
            String part = parts[i2];
            if ("".equals(part) || ".".equals(part)) continue;
            if ("..".equals(part)) {
                if (merger.up()) continue;
                return null;
            }
            String vfName = merger.getCurrentName();
            if (vfName == null) {
                return null;
            }
            if (caseSensitive && vfName.equals(part) || !caseSensitive && vfName.equalsIgnoreCase(part)) {
                if (merger.up()) continue;
                return null;
            }
            return null;
        }
        return merger.getResult();
    }

    public static interface FilePathMerger<T> {
        public boolean up();

        public boolean down(String var1);

        public T getResult();

        @Nullable
        public String getCurrentName();
    }

    public static class FilePathPathMerger
    implements FilePathMerger<FilePath> {
        private final IoFilePathMerger myIoDelegate;
        private boolean myIsDirectory;

        public FilePathPathMerger(FilePath base) {
            this.myIoDelegate = new IoFilePathMerger(base.getIOFile());
        }

        @Override
        public boolean down(String name2) {
            return this.myIoDelegate.down(name2);
        }

        @Override
        public boolean up() {
            return this.myIoDelegate.up();
        }

        @Override
        public FilePath getResult() {
            return VcsUtil.getFilePath((File)this.myIoDelegate.getResult(), (boolean)this.myIsDirectory);
        }

        @Override
        public String getCurrentName() {
            return this.myIoDelegate.getCurrentName();
        }

        public void setIsDirectory(boolean isDirectory) {
            this.myIsDirectory = isDirectory;
        }
    }

    public static class IoFilePathMerger
    implements FilePathMerger<File> {
        private File myBase;
        private final List<String> myChildPathElements;

        public IoFilePathMerger(File base) {
            this.myBase = base;
            this.myChildPathElements = new LinkedList<String>();
        }

        @Override
        public boolean up() {
            if (!this.myChildPathElements.isEmpty()) {
                this.myChildPathElements.remove(this.myChildPathElements.size() - 1);
                return true;
            }
            this.myBase = this.myBase.getParentFile();
            return this.myBase != null;
        }

        @Override
        public boolean down(String name2) {
            this.myChildPathElements.add(name2);
            return true;
        }

        @Override
        public File getResult() {
            StringBuilder sb = new StringBuilder();
            for (String element : this.myChildPathElements) {
                if (sb.length() > 0) {
                    sb.append(File.separatorChar);
                }
                sb.append(element);
            }
            return new File(this.myBase, sb.toString());
        }

        @Override
        @Nullable
        public String getCurrentName() {
            if (!this.myChildPathElements.isEmpty()) {
                return this.myChildPathElements.get(this.myChildPathElements.size() - 1);
            }
            return this.myBase == null ? null : this.myBase.getName();
        }
    }

    public static class VirtualFilePathMerger
    implements FilePathMerger<VirtualFile> {
        private VirtualFile myCurrent;

        public VirtualFilePathMerger(VirtualFile current) {
            this.myCurrent = current;
        }

        @Override
        public boolean up() {
            this.myCurrent = this.myCurrent.getParent();
            return this.myCurrent != null;
        }

        @Override
        public boolean down(String name2) {
            VirtualFile nextChild = this.myCurrent.findChild(name2);
            if (nextChild == null) {
                nextChild = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(this.myCurrent.getPath(), name2));
            }
            if (nextChild != null) {
                this.myCurrent = nextChild;
                return true;
            }
            return false;
        }

        @Override
        public VirtualFile getResult() {
            return this.myCurrent;
        }

        @Override
        public String getCurrentName() {
            return this.myCurrent == null ? null : this.myCurrent.getName();
        }
    }
}

