/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.splitter;

import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.EditingSides;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.splitter.FoldingTransformation;
import com.intellij.openapi.diff.impl.splitter.Interval;
import com.intellij.openapi.diff.impl.splitter.LineBlocks;
import com.intellij.openapi.diff.impl.splitter.Transformation;
import com.intellij.openapi.diff.impl.splitter.Trapezium;
import com.intellij.openapi.diff.impl.util.TextDiffType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DividerPolygon {
    @Nullable
    private final Color myColor;
    private final int myStart1;
    private final int myStart2;
    private final int myEnd1;
    private final int myEnd2;
    private final boolean myApplied;
    public static final double CTRL_PROXIMITY_X = 0.3;

    public DividerPolygon(int start1, int start2, int end1, int end2, @Nullable Color color, boolean applied) {
        this.myApplied = applied;
        this.myStart1 = this.advance(start1);
        this.myStart2 = this.advance(start2);
        this.myEnd1 = this.advance(end1);
        this.myEnd2 = this.advance(end2);
        this.myColor = color;
    }

    private int advance(int y) {
        return y == 0 ? y : y + 1;
    }

    private void paint(Graphics2D g, int width) {
        GraphicsUtil.setupAntialiasing((Graphics)g);
        if (!this.myApplied) {
            Shape upperCurve = DividerPolygon.makeCurve(width, this.myStart1, this.myStart2, true);
            Shape lowerCurve = DividerPolygon.makeCurve(width, this.myEnd1, this.myEnd2, false);
            Path2D.Double path = new Path2D.Double();
            path.append(upperCurve, true);
            path.append(lowerCurve, true);
            g.setColor(this.myColor);
            g.fill(path);
            g.setColor(DiffUtil.getFramingColor(this.myColor));
            g.draw(upperCurve);
            g.draw(lowerCurve);
        } else {
            g.setColor(this.myColor);
            g.draw(DividerPolygon.makeCurve(width, this.myStart1 + 1, this.myStart2 + 1, true));
            g.draw(DividerPolygon.makeCurve(width, this.myStart1 + 2, this.myStart2 + 2, true));
            g.draw(DividerPolygon.makeCurve(width, this.myEnd1 + 1, this.myEnd2 + 1, false));
            g.draw(DividerPolygon.makeCurve(width, this.myEnd1 + 2, this.myEnd2 + 2, false));
        }
    }

    private static Shape makeCurve(int width, int y1, int y2, boolean forward) {
        if (forward) {
            return new CubicCurve2D.Double(0.0, y1, (double)width * 0.3, y1, (double)width * 0.7, y2, width, y2);
        }
        return new CubicCurve2D.Double(width, y2, (double)width * 0.7, y2, (double)width * 0.3, y1, 0.0, y1);
    }

    public int hashCode() {
        return this.myStart1 ^ this.myStart2 ^ this.myEnd1 ^ this.myEnd2;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DividerPolygon)) {
            return false;
        }
        DividerPolygon other = (DividerPolygon)obj;
        return this.myStart1 == other.myStart1 && this.myStart2 == other.myStart2 && this.myEnd1 == other.myEnd1 && this.myEnd2 == other.myEnd2 && Comparing.equal((Object)this.myColor, (Object)other.myColor);
    }

    public String toString() {
        return "<" + this.myStart1 + ", " + this.myEnd1 + " : " + this.myStart2 + ", " + this.myEnd2 + "> " + this.myColor;
    }

    public Color getColor() {
        return this.myColor;
    }

    public int getTopLeftY() {
        return this.myStart1;
    }

    public int getTopRightY() {
        return this.myStart2;
    }

    public int getBottomLeftY() {
        return this.myEnd1;
    }

    public int getBottomRightY() {
        return this.myEnd2;
    }

    public boolean isApplied() {
        return this.myApplied;
    }

    public static void paintPolygons(ArrayList<DividerPolygon> polygons, Graphics2D g, int width) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (DividerPolygon polygon : polygons) {
            polygon.paint(g, width);
        }
    }

    public static ArrayList<DividerPolygon> createVisiblePolygons(@NotNull EditingSides sides, @NotNull FragmentSide left, int diffDividerPolygonsOffset) {
        if (sides == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sides", "com/intellij/openapi/diff/impl/splitter/DividerPolygon", "createVisiblePolygons"));
        }
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/intellij/openapi/diff/impl/splitter/DividerPolygon", "createVisiblePolygons"));
        }
        Editor editor1 = sides.getEditor(left);
        Editor editor2 = sides.getEditor(left.otherSide());
        LineBlocks lineBlocks = sides.getLineBlocks();
        Trapezium visibleArea = new Trapezium(DividerPolygon.getVisibleInterval(editor1), DividerPolygon.getVisibleInterval(editor2));
        Interval indices2 = lineBlocks.getVisibleIndices(visibleArea);
        Transformation[] transformations = new Transformation[]{DividerPolygon.getTransformation(editor1), DividerPolygon.getTransformation(editor2)};
        ArrayList<DividerPolygon> polygons = new ArrayList<DividerPolygon>();
        for (int i2 = indices2.getStart(); i2 < indices2.getEnd(); ++i2) {
            Trapezium trapezium = lineBlocks.getTrapezium(i2);
            TextDiffType type2 = lineBlocks.getType(i2);
            Color color = type2.getPolygonColor(editor1);
            polygons.add(DividerPolygon.createPolygon(transformations, trapezium, color, left, diffDividerPolygonsOffset, type2.isApplied()));
        }
        return polygons;
    }

    private static Transformation getTransformation(Editor editor) {
        return new FoldingTransformation(editor);
    }

    private static DividerPolygon createPolygon(@NotNull Transformation[] transformations, @NotNull Trapezium trapezium, @Nullable Color color, @NotNull FragmentSide left, int diffDividerPolygonsOffset, boolean applied) {
        if (transformations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformations", "com/intellij/openapi/diff/impl/splitter/DividerPolygon", "createPolygon"));
        }
        if (trapezium == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trapezium", "com/intellij/openapi/diff/impl/splitter/DividerPolygon", "createPolygon"));
        }
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/intellij/openapi/diff/impl/splitter/DividerPolygon", "createPolygon"));
        }
        Interval base1 = trapezium.getBase(left);
        Interval base2 = trapezium.getBase(left.otherSide());
        Transformation leftTransform = transformations[left.getIndex()];
        Transformation rightTransform = transformations[left.otherSide().getIndex()];
        int start1 = leftTransform.transform(base1.getStart());
        int end1 = leftTransform.transform(base1.getEnd());
        int start2 = rightTransform.transform(base2.getStart());
        int end2 = rightTransform.transform(base2.getEnd());
        return new DividerPolygon(start1 - diffDividerPolygonsOffset, start2 - diffDividerPolygonsOffset, end1 - diffDividerPolygonsOffset, end2 - diffDividerPolygonsOffset, color, applied);
    }

    static Interval getVisibleInterval(Editor editor) {
        int offset = editor.getScrollingModel().getVerticalScrollOffset();
        LogicalPosition logicalPosition = editor.xyToLogicalPosition(new Point(0, offset));
        int line = logicalPosition.line;
        return new Interval(line, editor.getComponent().getHeight() / editor.getLineHeight() + 1);
    }
}

