/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.editor.CaretStateTransferableData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClipboardTextPerCaretSplitter {
    @NotNull
    public List<String> split(@NotNull String input, @Nullable CaretStateTransferableData caretData, int caretCount) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/openapi/editor/ClipboardTextPerCaretSplitter", "split"));
        }
        if (caretCount <= 0) {
            throw new IllegalArgumentException("Caret count must be positive");
        }
        if (caretCount == 1) {
            List<String> list2 = Collections.singletonList(input);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ClipboardTextPerCaretSplitter", "split"));
            }
            return list2;
        }
        ArrayList<String> result2 = new ArrayList<String>(caretCount);
        if (caretData == null) {
            String[] lines = input.split("\n", -1);
            int sourceCaretCount = lines.length == 2 && lines[1].isEmpty() ? 1 : lines.length;
            for (int i2 = 0; i2 < caretCount; ++i2) {
                if (sourceCaretCount == 1) {
                    result2.add(lines[0]);
                    continue;
                }
                result2.add(i2 < lines.length ? lines[i2] : "");
            }
        } else {
            int sourceCaretCount = caretData.startOffsets.length;
            for (int i3 = 0; i3 < caretCount; ++i3) {
                if (sourceCaretCount == 1) {
                    result2.add(input);
                    continue;
                }
                result2.add(i3 < sourceCaretCount ? input.substring(caretData.startOffsets[i3], caretData.endOffsets[i3]) : "");
            }
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ClipboardTextPerCaretSplitter", "split"));
        }
        return arrayList;
    }
}

