/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.ide.CopyPasteManagerEx;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.ContentChooser;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.ui.UIBundle;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiplePasteAction
extends AnAction
implements DumbAware {
    private static final int PASTE_SIMPLE_EXIT_CODE = 2;

    public MultiplePasteAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Component focusedComponent = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (!(focusedComponent instanceof JComponent)) {
            return;
        }
        ClipboardContentChooser chooser = new ClipboardContentChooser(project2);
        if (!chooser.getAllContents().isEmpty()) {
            chooser.show();
        } else {
            chooser.close(1);
        }
        if (chooser.getExitCode() == 0 || chooser.getExitCode() == 2) {
            List selectedContents = chooser.getSelectedContents();
            CopyPasteManagerEx copyPasteManager = CopyPasteManagerEx.getInstanceEx();
            if (selectedContents.size() == 1) {
                copyPasteManager.moveContentToStackTop((Transferable)selectedContents.get(0));
            } else {
                copyPasteManager.setContents(new StringSelection(chooser.getSelectedText()));
            }
            if (editor != null) {
                if (editor.isViewer()) {
                    return;
                }
                AnAction pasteAction = ActionManager.getInstance().getAction(chooser.getExitCode() == 2 ? "EditorPasteSimple" : "$Paste");
                AnActionEvent newEvent = new AnActionEvent(e.getInputEvent(), DataManager.getInstance().getDataContext(focusedComponent), e.getPlace(), e.getPresentation(), ActionManager.getInstance(), e.getModifiers());
                pasteAction.actionPerformed(newEvent);
            } else {
                Action pasteAction = ((JComponent)focusedComponent).getActionMap().get("paste-from-clipboard");
                if (pasteAction != null) {
                    pasteAction.actionPerformed(new ActionEvent(focusedComponent, 1001, ""));
                }
            }
        }
    }

    public void update(AnActionEvent e) {
        boolean enabled = MultiplePasteAction.isEnabled(e);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        } else {
            e.getPresentation().setEnabled(enabled);
        }
    }

    private static boolean isEnabled(AnActionEvent e) {
        Object component = e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        if (!(component instanceof JComponent)) {
            return false;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null) {
            return !editor.isViewer();
        }
        Action pasteAction = ((JComponent)component).getActionMap().get("paste-from-clipboard");
        return pasteAction != null;
    }

    private static class ClipboardContentChooser
    extends ContentChooser<Transferable> {
        public ClipboardContentChooser(Project project2) {
            super(project2, UIBundle.message((String)"choose.content.to.paste.dialog.title", (Object[])new Object[0]), true, true);
            this.setOKButtonText(UIBundle.message((String)"choose.content.to.paste.dialog.ok.button", (Object[])new Object[0]));
        }

        @Nullable
        protected String getHelpId() {
            return "ixPasteSelected";
        }

        @Override
        protected String getStringRepresentationFor(Transferable content) {
            try {
                return (String)content.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException | IOException e1) {
                return "";
            }
        }

        @Override
        @NotNull
        protected List<Transferable> getContents() {
            List<Transferable> list2 = Arrays.asList(CopyPasteManager.getInstance().getAllContents());
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/actions/MultiplePasteAction$ClipboardContentChooser", "getContents"));
            }
            return list2;
        }

        @Override
        protected void removeContentAt(Transferable content) {
            CopyPasteManagerEx.getInstanceEx().removeContent(content);
        }

        protected void createDefaultActions() {
            super.createDefaultActions();
            this.myOKAction = new PasteAction();
        }

        class PasteSimpleAction
        extends DialogWrapper.DialogWrapperAction {
            private PasteSimpleAction() {
                super((DialogWrapper)ClipboardContentChooser.this, UIBundle.message((String)"choose.content.to.paste.dialog.simple.button", (Object[])new Object[0]));
            }

            protected void doAction(ActionEvent e) {
                ClipboardContentChooser.this.close(2);
            }
        }

        class PasteAction
        extends DialogWrapper.OkAction
        implements OptionAction {
            private final Action[] myActions;

            PasteAction() {
                super((DialogWrapper)ClipboardContentChooser.this);
                this.myActions = new Action[]{new PasteSimpleAction()};
            }

            @NotNull
            public Action[] getOptions() {
                if (this.myActions == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/actions/MultiplePasteAction$ClipboardContentChooser$PasteAction", "getOptions"));
                }
                return this.myActions;
            }
        }
    }
}

