/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class EditorColorSchemesComparator
implements Comparator<EditorColorsScheme> {
    public static final EditorColorSchemesComparator INSTANCE = new EditorColorSchemesComparator();
    public static final int DEFAULT_SCHEME = 0;
    public static final int ONE_OF_DEFAULT_SCHEMES = 1;
    public static final int BUNDLED_SCHEME = 2;
    public static final int CUSTOM_SCHEME = 3;

    private EditorColorSchemesComparator() {
    }

    @Override
    public int compare(EditorColorsScheme s1, EditorColorsScheme s2) {
        int order2;
        int order1 = EditorColorSchemesComparator.getOrder(s1);
        if (order1 != (order2 = EditorColorSchemesComparator.getOrder(s2))) {
            return order1 - order2;
        }
        return s1.getName().compareToIgnoreCase(s2.getName());
    }

    private static int getOrder(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/editor/colors/impl/EditorColorSchemesComparator", "getOrder"));
        }
        if (scheme2 instanceof AbstractColorsScheme) {
            AbstractColorsScheme original = ((AbstractColorsScheme)scheme2).getOriginal();
            if (original instanceof DefaultColorsScheme) {
                return "Default".equals(original.getName()) ? 0 : 1;
            }
            if (original instanceof ReadOnlyColorsScheme) {
                return 2;
            }
        }
        return 3;
    }
}

