/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.ui.ColorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorColorSchemesUsagesCollector
extends UsagesCollector {
    public static final String GROUP_ID = "Color Schemes";
    public static final String SCHEME_NAME_OTHER = "Other";
    public static final String[] KNOWN_NAMES = new String[]{"Obsidian", "Visual Studio", "Solarized", "Wombat", "Monkai", "XCode", "Sublime", "Oblivion", "Zenburn", "Cobalt", "Netbeans", "Eclipse", "Aptana", "Flash Builder"};

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() throws CollectUsagesException {
        EditorColorsScheme currentScheme = EditorColorsManager.getInstance().getGlobalScheme();
        HashSet usages = ContainerUtil.newHashSet();
        String schemeName = SCHEME_NAME_OTHER;
        if (currentScheme instanceof AbstractColorsScheme) {
            AbstractColorsScheme original;
            String name2 = currentScheme.getName();
            if (name2.startsWith("_@user_") && (original = ((AbstractColorsScheme)currentScheme).getOriginal()) != null) {
                schemeName = original.getName();
            }
            if (schemeName == SCHEME_NAME_OTHER) {
                String knownName = EditorColorSchemesUsagesCollector.getKnownSchemeName(name2);
                if (knownName != null) {
                    schemeName = knownName;
                }
                boolean isDark = ColorUtil.isDark((Color)currentScheme.getDefaultBackground());
                schemeName = schemeName + " (" + (isDark ? "Dark" : "Light") + ")";
            }
            usages.add(new UsageDescriptor(schemeName, 1));
        }
        HashSet hashSet = usages;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorSchemesUsagesCollector", "getUsages"));
        }
        return hashSet;
    }

    @Nullable
    private static String getKnownSchemeName(@NonNls @NotNull String schemeName) {
        if (schemeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemeName", "com/intellij/openapi/editor/colors/impl/EditorColorSchemesUsagesCollector", "getKnownSchemeName"));
        }
        for (String knownName : KNOWN_NAMES) {
            if (!schemeName.toUpperCase().contains(knownName.toUpperCase())) continue;
            return knownName;
        }
        return null;
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create(GROUP_ID);
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorSchemesUsagesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }
}

