/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.hint.DocumentFragmentTooltipRenderer;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.concurrency.JobScheduler;
import com.intellij.diagnostic.Dumpable;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentFragment;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorDropHandler;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.IndentGuideDescriptor;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.ActionPlan;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorTextInsertHandler;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.ex.SoftWrapChangeListenerAdapter;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.impl.CaretImpl;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.ContextMenuImpl;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorActionPlan;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorFilteringMarkupModelEx;
import com.intellij.openapi.editor.impl.EditorGutterComponentImpl;
import com.intellij.openapi.editor.impl.EditorHighlighterCache;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.impl.EditorSizeAdjustmentStrategy;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.ImmediatePainter;
import com.intellij.openapi.editor.impl.IndentsModelImpl;
import com.intellij.openapi.editor.impl.InlayModelImpl;
import com.intellij.openapi.editor.impl.ScrollingModelImpl;
import com.intellij.openapi.editor.impl.SelectionModelImpl;
import com.intellij.openapi.editor.impl.SettingsImpl;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.TextDrawingCallback;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.SideBorder;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.mac.MacGestureSupportForEditor;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.font.TextHitInfo;
import java.awt.geom.Point2D;
import java.awt.im.InputMethodRequests;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TooManyListenersException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorImpl
extends UserDataHolderBase
implements EditorEx,
HighlighterClient,
Queryable,
Dumpable {
    private static final int MIN_FONT_SIZE = 8;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.EditorImpl");
    private static final Key DND_COMMAND_KEY = Key.create((String)"DndCommand");
    @NonNls
    public static final Object IGNORE_MOUSE_TRACKING = "ignore_mouse_tracking";
    private static final Key<JComponent> PERMANENT_HEADER = Key.create((String)"PERMANENT_HEADER");
    public static final Key<Boolean> DO_DOCUMENT_UPDATE_TEST = Key.create((String)"DoDocumentUpdateTest");
    public static final Key<Boolean> FORCED_SOFT_WRAPS = Key.create((String)"forced.soft.wraps");
    public static final Key<Boolean> SOFT_WRAPS_EXIST = Key.create((String)"soft.wraps.exist");
    public static final Key<Boolean> DISABLE_CARET_POSITION_KEEPING = Key.create((String)"editor.disable.caret.position.keeping");
    static final Key<Boolean> DISABLE_CARET_SHIFT_ON_WHITESPACE_INSERTION = Key.create((String)"editor.disable.caret.shift.on.whitespace.insertion");
    private static final boolean HONOR_CAMEL_HUMPS_ON_TRIPLE_CLICK = Boolean.parseBoolean(System.getProperty("idea.honor.camel.humps.on.triple.click"));
    private static final Key<BufferedImage> BUFFER = Key.create((String)"buffer");
    @NotNull
    private final DocumentEx myDocument;
    private final JPanel myPanel;
    @NotNull
    private final JScrollPane myScrollPane;
    @NotNull
    private final EditorComponentImpl myEditorComponent;
    @NotNull
    private final EditorGutterComponentImpl myGutterComponent;
    private final TraceableDisposable myTraceableDisposable;
    private static final Cursor EMPTY_CURSOR;
    private final CommandProcessor myCommandProcessor;
    @NotNull
    private final MyScrollBar myVerticalScrollBar;
    private final List<EditorMouseListener> myMouseListeners;
    @NotNull
    private final List<EditorMouseMotionListener> myMouseMotionListeners;
    private boolean myIsInsertMode;
    @NotNull
    private final CaretCursor myCaretCursor;
    private final ScrollingTimer myScrollingTimer;
    private final Object MOUSE_DRAGGED_GROUP;
    @NotNull
    private final SettingsImpl mySettings;
    private boolean isReleased;
    @Nullable
    private MouseEvent myMousePressedEvent;
    @Nullable
    private MouseEvent myMouseMovedEvent;
    private final MouseListener myMouseListener;
    private final MouseMotionListener myMouseMotionListener;
    @Nullable
    private EditorMouseEventArea myMousePressArea;
    private int mySavedSelectionStart;
    private int mySavedSelectionEnd;
    private final PropertyChangeSupport myPropertyChangeSupport;
    private MyEditable myEditable;
    @NotNull
    private EditorColorsScheme myScheme;
    private boolean myIsViewer;
    @NotNull
    private final SelectionModelImpl mySelectionModel;
    @NotNull
    private final EditorMarkupModelImpl myMarkupModel;
    @NotNull
    private final EditorFilteringMarkupModelEx myDocumentMarkupModel;
    @NotNull
    private final MarkupModelListener myMarkupModelListener;
    @NotNull
    private final FoldingModelImpl myFoldingModel;
    @NotNull
    private final ScrollingModelImpl myScrollingModel;
    @NotNull
    private final CaretModelImpl myCaretModel;
    @NotNull
    private final SoftWrapModelImpl mySoftWrapModel;
    @NotNull
    private final InlayModelImpl myInlayModel;
    @NotNull
    private static final RepaintCursorCommand ourCaretBlinkingCommand;
    private final DocumentBulkUpdateListener myBulkUpdateListener;
    @MouseSelectionState
    private int myMouseSelectionState;
    @Nullable
    private FoldRegion myMouseSelectedRegion;
    private static final int MOUSE_SELECTION_STATE_NONE = 0;
    private static final int MOUSE_SELECTION_STATE_WORD_SELECTED = 1;
    private static final int MOUSE_SELECTION_STATE_LINE_SELECTED = 2;
    private volatile EditorHighlighter myHighlighter;
    private Disposable myHighlighterDisposable;
    private final TextDrawingCallback myTextDrawingCallback;
    private int myScrollBarOrientation;
    private boolean myMousePressedInsideSelection;
    private boolean myUpdateCursor;
    private int myCaretUpdateVShift;
    @Nullable
    private final Project myProject;
    private long myMouseSelectionChangeTimestamp;
    private int mySavedCaretOffsetForDNDUndoHack;
    private final List<FocusChangeListener> myFocusListeners;
    private MyInputMethodHandler myInputMethodRequestsHandler;
    private InputMethodRequests myInputMethodRequestsSwingWrapper;
    private boolean myIsOneLineMode;
    private boolean myIsRendererMode;
    private VirtualFile myVirtualFile;
    private boolean myIsColumnMode;
    @Nullable
    private Color myForcedBackground;
    @Nullable
    private Dimension myPreferredSize;
    private final Alarm myMouseSelectionStateAlarm;
    private Runnable myMouseSelectionStateResetRunnable;
    private boolean myEmbeddedIntoDialogWrapper;
    private int myDragOnGutterSelectionStartLine;
    private RangeMarker myDraggedRange;
    @NotNull
    private final JPanel myHeaderPanel;
    @Nullable
    private MouseEvent myInitialMouseEvent;
    private boolean myIgnoreMouseEventsConsecutiveToInitial;
    private EditorDropHandler myDropHandler;
    private Condition<RangeHighlighter> myHighlightingFilter;
    @NotNull
    private final IndentsModel myIndentsModel;
    @Nullable
    private CharSequence myPlaceholderText;
    @Nullable
    private TextAttributes myPlaceholderAttributes;
    private boolean myShowPlaceholderWhenFocused;
    private boolean myStickySelection;
    private int myStickySelectionStart;
    private boolean myScrollToCaret;
    private boolean myPurePaintingMode;
    private boolean myPaintSelection;
    private final EditorSizeAdjustmentStrategy mySizeAdjustmentStrategy;
    private final Disposable myDisposable;
    private List<CaretState> myCaretStateBeforeLastPress;
    LogicalPosition myLastMousePressedLocation;
    private VisualPosition myTargetMultiSelectionPosition;
    private boolean myMultiSelectionInProgress;
    private boolean myRectangularSelectionInProgress;
    private boolean myLastPressCreatedCaret;
    private boolean myCurrentDragIsSubstantial;
    private CaretImpl myPrimaryCaret;
    public final boolean myDisableRtl;
    final EditorView myView;
    private boolean myCharKeyPressed;
    private boolean myNeedToSelectPreviousChar;
    private boolean myDocumentChangeInProgress;
    private boolean myErrorStripeNeedsRepaint;
    private String myContextMenuGroupId;
    private boolean myUseEditorAntialiasing;
    private final ImmediatePainter myImmediatePainter;
    private volatile int myExpectedCaretOffset;
    private boolean myBackgroundImageSet;
    private final EditorKind myKind;
    private boolean updatingSize;
    private static final Field decrButtonField;
    private static final Field incrButtonField;
    private static final TooltipGroup FOLDING_TOOLTIP_GROUP;

    EditorImpl(@NotNull Document document, boolean viewer, @Nullable Project project2, @NotNull EditorKind kind2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/EditorImpl", "<init>"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/openapi/editor/impl/EditorImpl", "<init>"));
        }
        this.myTraceableDisposable = new TraceableDisposable(true);
        this.myMouseListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myMouseMotionListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myIsInsertMode = true;
        this.myScrollingTimer = new ScrollingTimer();
        this.MOUSE_DRAGGED_GROUP = new String("MouseDraggedGroup");
        this.myMouseListener = new MyMouseAdapter();
        this.myMouseMotionListener = new MyMouseMotionListener();
        this.mySavedSelectionStart = -1;
        this.mySavedSelectionEnd = -1;
        this.myPropertyChangeSupport = new PropertyChangeSupport(this);
        this.myHighlighterDisposable = Disposer.newDisposable();
        this.myTextDrawingCallback = new MyTextDrawingCallback();
        this.myFocusListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myMouseSelectionStateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myDragOnGutterSelectionStartLine = -1;
        this.myScrollToCaret = true;
        this.mySizeAdjustmentStrategy = new EditorSizeAdjustmentStrategy();
        this.myDisposable = Disposer.newDisposable();
        this.myDisableRtl = Registry.is((String)"editor.disable.rtl");
        this.myContextMenuGroupId = "BasicEditorPopupMenu";
        this.myUseEditorAntialiasing = true;
        this.myExpectedCaretOffset = -1;
        EditorImpl.assertIsDispatchThread();
        this.myProject = project2;
        this.myDocument = (DocumentEx)document;
        this.myScheme = this.createBoundColorSchemeDelegate(null);
        this.myScrollPane = new MyScrollPane();
        this.myIsViewer = viewer;
        this.myKind = kind2;
        this.mySettings = new SettingsImpl(this, project2, kind2);
        if (!this.mySettings.isUseSoftWraps() && this.shouldSoftWrapsBeForced()) {
            this.mySettings.setUseSoftWrapsQuiet();
            this.putUserData(FORCED_SOFT_WRAPS, Boolean.TRUE);
        }
        MarkupModelEx documentMarkup = (MarkupModelEx)DocumentMarkupModel.forDocument(this.myDocument, this.myProject, true);
        this.mySelectionModel = new SelectionModelImpl(this);
        this.myMarkupModel = new EditorMarkupModelImpl(this);
        this.myDocumentMarkupModel = new EditorFilteringMarkupModelEx(this, documentMarkup);
        this.myFoldingModel = new FoldingModelImpl(this);
        this.myCaretModel = new CaretModelImpl(this);
        this.myCaretModel.initCarets();
        this.myScrollingModel = new ScrollingModelImpl(this);
        this.myInlayModel = new InlayModelImpl(this);
        Disposer.register((Disposable)this.myCaretModel, (Disposable)this.myInlayModel);
        this.mySoftWrapModel = new SoftWrapModelImpl(this);
        this.myCommandProcessor = CommandProcessor.getInstance();
        this.myImmediatePainter = new ImmediatePainter(this);
        if (this.myDocument instanceof DocumentImpl) {
            this.myBulkUpdateListener = new EditorDocumentBulkUpdateAdapter();
            ((DocumentImpl)this.myDocument).addInternalBulkModeListener(this.myBulkUpdateListener);
        } else {
            this.myBulkUpdateListener = null;
        }
        this.myMarkupModelListener = new MarkupModelListener(){

            private boolean areRenderersInvolved(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/EditorImpl$1", "areRenderersInvolved"));
                }
                return highlighter.getCustomRenderer() != null || highlighter.getGutterIconRenderer() != null || highlighter.getLineMarkerRenderer() != null || highlighter.getLineSeparatorRenderer() != null;
            }

            @Override
            public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/EditorImpl$1", "afterAdded"));
                }
                this.attributesChanged(highlighter, this.areRenderersInvolved(highlighter), EditorUtil.attributesImpactFontStyleOrColor(highlighter.getTextAttributes()));
            }

            @Override
            public void beforeRemoved(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/EditorImpl$1", "beforeRemoved"));
                }
                this.attributesChanged(highlighter, this.areRenderersInvolved(highlighter), EditorUtil.attributesImpactFontStyleOrColor(highlighter.getTextAttributes()));
            }

            @Override
            public void attributesChanged(@NotNull RangeHighlighterEx highlighter, boolean renderersChanged, boolean fontStyleOrColorChanged) {
                int endLine;
                boolean errorStripeNeedsRepaint;
                if (highlighter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/EditorImpl$1", "attributesChanged"));
                }
                if (EditorImpl.this.myDocument.isInBulkUpdate()) {
                    return;
                }
                if (renderersChanged) {
                    EditorImpl.this.updateGutterSize();
                }
                boolean bl = errorStripeNeedsRepaint = renderersChanged || highlighter.getErrorStripeMarkColor() != null;
                if (EditorImpl.this.myDocumentChangeInProgress) {
                    EditorImpl.this.myErrorStripeNeedsRepaint = EditorImpl.this.myErrorStripeNeedsRepaint | errorStripeNeedsRepaint;
                    return;
                }
                int textLength = EditorImpl.this.myDocument.getTextLength();
                int start = Math.min(Math.max(highlighter.getAffectedAreaStartOffset(), 0), textLength);
                int end = Math.min(Math.max(highlighter.getAffectedAreaEndOffset(), 0), textLength);
                int startLine = start == -1 ? 0 : EditorImpl.this.myDocument.getLineNumber(start);
                int n = endLine = end == -1 ? EditorImpl.this.myDocument.getLineCount() : EditorImpl.this.myDocument.getLineNumber(end);
                if (start != end && fontStyleOrColorChanged) {
                    EditorImpl.this.myView.invalidateRange(start, end);
                }
                if (!EditorImpl.this.myFoldingModel.isInBatchFoldingOperation()) {
                    EditorImpl.this.repaintLines(Math.max(0, startLine - 1), Math.min(endLine + 1, EditorImpl.this.getDocument().getLineCount()));
                }
                if (errorStripeNeedsRepaint) {
                    if (EditorImpl.this.myFoldingModel.isInBatchFoldingOperation()) {
                        EditorImpl.this.myErrorStripeNeedsRepaint = true;
                    } else {
                        EditorImpl.this.myMarkupModel.repaint(start, end);
                    }
                }
                EditorImpl.this.updateCaretCursor();
            }
        };
        this.getFilteredDocumentMarkupModel().addMarkupModelListener(this.myCaretModel, this.myMarkupModelListener);
        this.getMarkupModel().addMarkupModelListener(this.myCaretModel, this.myMarkupModelListener);
        this.myDocument.addDocumentListener(this.myFoldingModel, this.myCaretModel);
        this.myDocument.addDocumentListener(this.myCaretModel, this.myCaretModel);
        this.myDocument.addDocumentListener(new EditorDocumentAdapter(), this.myCaretModel);
        this.myDocument.addDocumentListener(this.mySoftWrapModel, this.myCaretModel);
        this.myFoldingModel.addListener(this.mySoftWrapModel, this.myCaretModel);
        this.myInlayModel.addListener(this.myCaretModel, this.myCaretModel);
        this.myIndentsModel = new IndentsModelImpl(this);
        this.myCaretModel.addCaretListener(new CaretListener(){
            @Nullable
            private LightweightHint myCurrentHint;
            @Nullable
            private IndentGuideDescriptor myCurrentCaretGuide;

            public void caretPositionChanged(CaretEvent e) {
                IndentGuideDescriptor newGuide;
                if (EditorImpl.this.myStickySelection) {
                    int selectionStart = Math.min(EditorImpl.this.myStickySelectionStart, EditorImpl.this.getDocument().getTextLength() - 1);
                    EditorImpl.this.mySelectionModel.setSelection(selectionStart, EditorImpl.this.myCaretModel.getVisualPosition(), EditorImpl.this.myCaretModel.getOffset());
                }
                if (!Comparing.equal((Object)this.myCurrentCaretGuide, (Object)(newGuide = EditorImpl.this.myIndentsModel.getCaretIndentGuide()))) {
                    EditorImpl.this.repaintGuide(newGuide);
                    EditorImpl.this.repaintGuide(this.myCurrentCaretGuide);
                    this.myCurrentCaretGuide = newGuide;
                    if (this.myCurrentHint != null) {
                        this.myCurrentHint.hide();
                        this.myCurrentHint = null;
                    }
                    if (newGuide != null) {
                        Rectangle visibleArea = EditorImpl.this.getScrollingModel().getVisibleArea();
                        int line = newGuide.startLine;
                        if (EditorImpl.this.logicalLineToY(line) < visibleArea.y) {
                            TextRange textRange = new TextRange(EditorImpl.this.myDocument.getLineStartOffset(line), EditorImpl.this.myDocument.getLineEndOffset(line));
                            this.myCurrentHint = EditorFragmentComponent.showEditorFragmentHint(EditorImpl.this, textRange, false, false);
                        }
                    }
                }
            }

            public void caretAdded(CaretEvent e) {
                if (EditorImpl.this.myPrimaryCaret != null) {
                    EditorImpl.this.myPrimaryCaret.updateVisualPosition();
                }
                EditorImpl.this.repaintCaretRegion(e);
                EditorImpl.this.myPrimaryCaret = EditorImpl.this.myCaretModel.getPrimaryCaret();
            }

            public void caretRemoved(CaretEvent e) {
                EditorImpl.this.repaintCaretRegion(e);
                EditorImpl.this.myPrimaryCaret = EditorImpl.this.myCaretModel.getPrimaryCaret();
                EditorImpl.this.myPrimaryCaret.updateVisualPosition();
            }
        });
        this.myCaretCursor = new CaretCursor();
        this.myFoldingModel.flushCaretShift();
        this.myScrollBarOrientation = 1;
        this.mySoftWrapModel.addSoftWrapChangeListener(new SoftWrapChangeListenerAdapter(){

            @Override
            public void recalculationEnds() {
                if (EditorImpl.this.myCaretModel.isUpToDate()) {
                    EditorImpl.this.myCaretModel.updateVisualPosition();
                }
            }
        });
        NullEditorHighlighter highlighter = new NullEditorHighlighter();
        this.setHighlighter(highlighter);
        this.myEditorComponent = new EditorComponentImpl(this);
        this.myScrollPane.putClientProperty(JBScrollPane.BRIGHTNESS_FROM_VIEW, true);
        this.myVerticalScrollBar = (MyScrollBar)((Object)this.myScrollPane.getVerticalScrollBar());
        this.myVerticalScrollBar.setOpaque(false);
        this.myPanel = new JPanel();
        UIUtil.putClientProperty((JComponent)this.myPanel, (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, () -> {
            JComponent component = this.getPermanentHeaderComponent();
            if (component != null && component.getParent() == null) {
                return Collections.singleton(component).iterator();
            }
            return ContainerUtil.emptyIterator();
        });
        this.myHeaderPanel = new MyHeaderPanel();
        this.myGutterComponent = new EditorGutterComponentImpl(this);
        this.initComponent();
        this.myView = new EditorView(this);
        this.myView.reinitSettings();
        this.myInlayModel.addListener((InlayModel.Listener)new InlayModel.SimpleAdapter(){

            public void onUpdated(@NotNull Inlay inlay) {
                if (inlay == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlay", "com/intellij/openapi/editor/impl/EditorImpl$4", "onUpdated"));
                }
                if (EditorImpl.this.myDocument.isInEventsHandling() || EditorImpl.this.myDocument.isInBulkUpdate()) {
                    return;
                }
                EditorImpl.this.validateSize();
                EditorImpl.this.repaint(inlay.getOffset(), inlay.getOffset(), false);
            }
        }, this.myCaretModel);
        if (UISettings.getInstance().getPresentationMode()) {
            this.setFontSize(UISettings.getInstance().getPresentationModeFontSize());
        }
        this.myGutterComponent.updateSize();
        Dimension preferredSize = this.getPreferredSize();
        this.myEditorComponent.setSize(preferredSize);
        this.updateCaretCursor();
        if (SystemInfo.isJavaVersionAtLeast((String)"1.8") && SystemInfo.isMacIntel64 && SystemInfo.isJetBrainsJvm && Registry.is((String)"ide.mac.forceTouch")) {
            new MacGestureSupportForEditor(this.getComponent());
        }
    }

    boolean shouldScrollBarBeOpaque() {
        return !this.myBackgroundImageSet && !Registry.is((String)"editor.transparent.scrollbar");
    }

    public boolean shouldSoftWrapsBeForced() {
        if (this.myProject != null && PsiDocumentManager.getInstance((Project)this.myProject).isDocumentBlockedByPsi((Document)this.myDocument)) {
            return false;
        }
        int lineWidthLimit = Registry.intValue((String)"editor.soft.wrap.force.limit");
        for (int i = 0; i < this.myDocument.getLineCount(); ++i) {
            if (this.myDocument.getLineEndOffset(i) - this.myDocument.getLineStartOffset(i) <= lineWidthLimit) continue;
            return true;
        }
        return false;
    }

    @NotNull
    static Color adjustThumbColor(@NotNull Color base, boolean dark) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/openapi/editor/impl/EditorImpl", "adjustThumbColor"));
        }
        Color color = dark ? ColorUtil.withAlpha((Color)ColorUtil.shift((Color)base, (double)1.35), (double)0.5) : ColorUtil.withAlpha((Color)ColorUtil.shift((Color)base, (double)0.68), (double)0.4);
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "adjustThumbColor"));
        }
        return color;
    }

    boolean isDarkEnough() {
        return ColorUtil.isDark((Color)this.getBackgroundColor());
    }

    private void repaintCaretRegion(CaretEvent e) {
        CaretImpl caretImpl = (CaretImpl)e.getCaret();
        if (caretImpl != null) {
            caretImpl.updateVisualPosition();
            if (caretImpl.hasSelection()) {
                this.repaint(caretImpl.getSelectionStart(), caretImpl.getSelectionEnd(), false);
            }
        }
    }

    @Override
    @NotNull
    public EditorColorsScheme createBoundColorSchemeDelegate(@Nullable EditorColorsScheme customGlobalScheme) {
        MyColorSchemeDelegate myColorSchemeDelegate = new MyColorSchemeDelegate(customGlobalScheme);
        if (myColorSchemeDelegate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "createBoundColorSchemeDelegate"));
        }
        return myColorSchemeDelegate;
    }

    private void repaintGuide(@Nullable IndentGuideDescriptor guide) {
        if (guide != null) {
            this.repaintLines(guide.startLine, guide.endLine);
        }
    }

    @Override
    public int getPrefixTextWidthInPixels() {
        return (int)this.myView.getPrefixTextWidthInPixels();
    }

    @Override
    public void setPrefixTextAndAttributes(@Nullable String prefixText, @Nullable TextAttributes attributes) {
        this.mySoftWrapModel.recalculate();
        this.myView.setPrefix(prefixText, attributes);
    }

    @Override
    public boolean isPurePaintingMode() {
        return this.myPurePaintingMode;
    }

    @Override
    public void setPurePaintingMode(boolean enabled) {
        this.myPurePaintingMode = enabled;
    }

    @Override
    public void registerScrollBarRepaintCallback(@Nullable ButtonlessScrollBarUI.ScrollbarRepaintCallback callback) {
        this.myVerticalScrollBar.registerRepaintCallback(callback);
    }

    @Override
    public int getExpectedCaretOffset() {
        int expectedCaretOffset = this.myExpectedCaretOffset;
        return expectedCaretOffset == -1 ? this.getCaretModel().getOffset() : expectedCaretOffset;
    }

    @Override
    public void setContextMenuGroupId(@Nullable String groupId) {
        this.myContextMenuGroupId = groupId;
    }

    @Override
    @Nullable
    public String getContextMenuGroupId() {
        return this.myContextMenuGroupId;
    }

    @Override
    public void setViewer(boolean isViewer) {
        this.myIsViewer = isViewer;
    }

    public boolean isViewer() {
        return this.myIsViewer || this.myIsRendererMode;
    }

    @Override
    public boolean isRendererMode() {
        return this.myIsRendererMode;
    }

    @Override
    public void setRendererMode(boolean isRendererMode) {
        this.myIsRendererMode = isRendererMode;
    }

    @Override
    public void setFile(VirtualFile vFile) {
        this.myVirtualFile = vFile;
        this.reinitSettings();
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @Override
    public void setSoftWrapAppliancePlace(@NotNull SoftWrapAppliancePlaces place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/editor/impl/EditorImpl", "setSoftWrapAppliancePlace"));
        }
        this.mySettings.setSoftWrapAppliancePlace(place);
    }

    @NotNull
    public SelectionModelImpl getSelectionModel() {
        SelectionModelImpl selectionModelImpl = this.mySelectionModel;
        if (selectionModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getSelectionModel"));
        }
        return selectionModelImpl;
    }

    @Override
    @NotNull
    public MarkupModelEx getMarkupModel() {
        EditorMarkupModelImpl editorMarkupModelImpl = this.myMarkupModel;
        if (editorMarkupModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getMarkupModel"));
        }
        return editorMarkupModelImpl;
    }

    @Override
    @NotNull
    public MarkupModelEx getFilteredDocumentMarkupModel() {
        EditorFilteringMarkupModelEx editorFilteringMarkupModelEx = this.myDocumentMarkupModel;
        if (editorFilteringMarkupModelEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getFilteredDocumentMarkupModel"));
        }
        return editorFilteringMarkupModelEx;
    }

    @Override
    @NotNull
    public FoldingModelImpl getFoldingModel() {
        FoldingModelImpl foldingModelImpl = this.myFoldingModel;
        if (foldingModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getFoldingModel"));
        }
        return foldingModelImpl;
    }

    @NotNull
    public CaretModelImpl getCaretModel() {
        CaretModelImpl caretModelImpl = this.myCaretModel;
        if (caretModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getCaretModel"));
        }
        return caretModelImpl;
    }

    @Override
    @NotNull
    public ScrollingModelEx getScrollingModel() {
        ScrollingModelImpl scrollingModelImpl = this.myScrollingModel;
        if (scrollingModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getScrollingModel"));
        }
        return scrollingModelImpl;
    }

    @Override
    @NotNull
    public SoftWrapModelImpl getSoftWrapModel() {
        SoftWrapModelImpl softWrapModelImpl = this.mySoftWrapModel;
        if (softWrapModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getSoftWrapModel"));
        }
        return softWrapModelImpl;
    }

    @NotNull
    public InlayModelImpl getInlayModel() {
        InlayModelImpl inlayModelImpl = this.myInlayModel;
        if (inlayModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getInlayModel"));
        }
        return inlayModelImpl;
    }

    @NotNull
    public EditorKind getEditorKind() {
        EditorKind editorKind = this.myKind;
        if (editorKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getEditorKind"));
        }
        return editorKind;
    }

    @NotNull
    public EditorSettings getSettings() {
        EditorImpl.assertReadAccess();
        SettingsImpl settingsImpl = this.mySettings;
        if (settingsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getSettings"));
        }
        return settingsImpl;
    }

    public void resetSizes() {
        this.myView.reset();
    }

    @Override
    public void reinitSettings() {
        EditorImpl.assertIsDispatchThread();
        EditorColorsScheme scheme2 = this.myScheme;
        while (scheme2 instanceof DelegateColorScheme) {
            if (scheme2 instanceof MyColorSchemeDelegate) {
                ((MyColorSchemeDelegate)scheme2).updateGlobalScheme();
                break;
            }
            scheme2 = ((DelegateColorScheme)scheme2).getDelegate();
        }
        boolean softWrapsUsedBefore = this.mySoftWrapModel.isSoftWrappingEnabled();
        this.mySettings.reinitSettings();
        this.mySoftWrapModel.reinitSettings();
        this.myCaretModel.reinitSettings();
        this.mySelectionModel.reinitSettings();
        EditorImpl.ourCaretBlinkingCommand.setBlinkCaret(this.mySettings.isBlinkCaret());
        EditorImpl.ourCaretBlinkingCommand.setBlinkPeriod(this.mySettings.getCaretBlinkPeriod());
        this.myView.reinitSettings();
        this.myFoldingModel.rebuild();
        this.myInlayModel.reinitSettings();
        if (softWrapsUsedBefore ^ this.mySoftWrapModel.isSoftWrappingEnabled()) {
            this.validateSize();
        }
        this.myHighlighter.setColorScheme(this.myScheme);
        this.myFoldingModel.refreshSettings();
        this.myGutterComponent.reinitSettings();
        this.myGutterComponent.revalidate();
        this.myEditorComponent.repaint();
        this.updateCaretCursor();
        if (this.myInitialMouseEvent != null) {
            this.myIgnoreMouseEventsConsecutiveToInitial = true;
        }
        this.myCaretModel.updateVisualPosition();
        for (Caret caret : this.getCaretModel().getAllCarets()) {
            caret.moveToOffset(caret.getOffset());
        }
        if (this.myVirtualFile != null && this.myProject != null) {
            EditorNotifications.getInstance((Project)this.myProject).updateNotifications(this.myVirtualFile);
        }
    }

    void throwEditorNotDisposedError(@NonNls @NotNull String msg) {
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/intellij/openapi/editor/impl/EditorImpl", "throwEditorNotDisposedError"));
        }
        this.myTraceableDisposable.throwObjectNotDisposedError(msg);
    }

    public void throwDisposalError(@NonNls @NotNull String msg) {
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/intellij/openapi/editor/impl/EditorImpl", "throwDisposalError"));
        }
        this.myTraceableDisposable.throwDisposalError(msg);
    }

    void release() {
        EditorImpl.assertIsDispatchThread();
        if (this.isReleased) {
            this.throwDisposalError("Double release of editor:");
        }
        this.myTraceableDisposable.kill(null);
        this.isReleased = true;
        this.mySizeAdjustmentStrategy.cancelAllRequests();
        this.myFoldingModel.dispose();
        this.mySoftWrapModel.release();
        this.myMarkupModel.dispose();
        this.myScrollingModel.dispose();
        this.myGutterComponent.dispose();
        this.myMousePressedEvent = null;
        this.myMouseMovedEvent = null;
        Disposer.dispose((Disposable)this.myCaretModel);
        Disposer.dispose((Disposable)this.mySoftWrapModel);
        Disposer.dispose((Disposable)this.myView);
        this.clearCaretThread();
        this.myFocusListeners.clear();
        this.myMouseListeners.clear();
        this.myMouseMotionListeners.clear();
        this.myEditorComponent.removeMouseListener(this.myMouseListener);
        this.myGutterComponent.removeMouseListener(this.myMouseListener);
        this.myEditorComponent.removeMouseMotionListener(this.myMouseMotionListener);
        this.myGutterComponent.removeMouseMotionListener(this.myMouseMotionListener);
        if (this.myBulkUpdateListener != null) {
            ((DocumentImpl)this.myDocument).removeInternalBulkModeListener(this.myBulkUpdateListener);
        }
        Disposer.dispose((Disposable)this.myDisposable);
        this.myVerticalScrollBar.setUI(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCaretThread() {
        RepaintCursorCommand repaintCursorCommand = ourCaretBlinkingCommand;
        synchronized (repaintCursorCommand) {
            if (ourCaretBlinkingCommand.myEditor == this) {
                ourCaretBlinkingCommand.myEditor = null;
            }
        }
    }

    private void initComponent() {
        this.myPanel.setLayout(new BorderLayout());
        this.myPanel.add((Component)this.myHeaderPanel, "North");
        this.myGutterComponent.setOpaque(true);
        this.myScrollPane.setViewportView(this.myEditorComponent);
        this.myScrollPane.setVerticalScrollBarPolicy(22);
        this.myScrollPane.setHorizontalScrollBarPolicy(30);
        this.myScrollPane.setRowHeaderView(this.myGutterComponent);
        this.myEditorComponent.setTransferHandler(new MyTransferHandler());
        this.myEditorComponent.setAutoscrolls(true);
        if (this.mayShowToolbar()) {
            JBLayeredPane layeredPane = new JBLayeredPane(){

                public void doLayout() {
                    Component[] components = this.getComponents();
                    Rectangle r = this.getBounds();
                    for (Component c : components) {
                        if (c instanceof JScrollPane) {
                            c.setBounds(0, 0, r.width, r.height);
                            continue;
                        }
                        Dimension d = c.getPreferredSize();
                        int rightInsets = EditorImpl.this.getVerticalScrollBar().getWidth() + (EditorImpl.this.isMirrored() ? EditorImpl.this.myGutterComponent.getWidth() : 0);
                        c.setBounds(r.width - d.width - rightInsets - 20, 20, d.width, d.height);
                    }
                }

                public Dimension getPreferredSize() {
                    return EditorImpl.this.myScrollPane.getPreferredSize();
                }
            };
            layeredPane.add((Component)this.myScrollPane, JLayeredPane.DEFAULT_LAYER);
            this.myPanel.add((Component)layeredPane);
            new ContextMenuImpl((JLayeredPane)layeredPane, this.myScrollPane, this);
        } else {
            this.myPanel.add(this.myScrollPane);
        }
        this.myEditorComponent.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$6", "keyPressed"));
                }
                if (e.getKeyCode() >= 65 && e.getKeyCode() <= 90) {
                    EditorImpl.this.myCharKeyPressed = true;
                }
            }

            @Override
            public void keyTyped(@NotNull KeyEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/EditorImpl$6", "keyTyped"));
                }
                EditorImpl.this.myNeedToSelectPreviousChar = false;
                if (event.isConsumed()) {
                    return;
                }
                if (EditorImpl.this.processKeyTyped(event)) {
                    event.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                EditorImpl.this.myCharKeyPressed = false;
            }
        });
        this.myEditorComponent.addMouseListener(this.myMouseListener);
        this.myGutterComponent.addMouseListener(this.myMouseListener);
        this.myEditorComponent.addMouseMotionListener(this.myMouseMotionListener);
        this.myGutterComponent.addMouseMotionListener(this.myMouseMotionListener);
        this.myEditorComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$7", "focusGained"));
                }
                EditorImpl.this.myCaretCursor.activate();
                for (Caret caret : EditorImpl.this.myCaretModel.getAllCarets()) {
                    int caretLine = caret.getLogicalPosition().line;
                    EditorImpl.this.repaintLines(caretLine, caretLine);
                }
                EditorImpl.this.fireFocusGained();
            }

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$7", "focusLost"));
                }
                EditorImpl.this.clearCaretThread();
                for (Caret caret : EditorImpl.this.myCaretModel.getAllCarets()) {
                    int caretLine = caret.getLogicalPosition().line;
                    EditorImpl.this.repaintLines(caretLine, caretLine);
                }
                EditorImpl.this.fireFocusLost();
            }
        });
        UiNotifyConnector connector = new UiNotifyConnector((Component)this.myEditorComponent, (Activatable)new Activatable.Adapter(){

            public void showNotify() {
                EditorImpl.this.myGutterComponent.updateSizeOnShowNotify();
            }
        });
        Disposer.register((Disposable)this.getDisposable(), (Disposable)connector);
        try {
            DropTarget dropTarget = this.myEditorComponent.getDropTarget();
            if (dropTarget != null) {
                dropTarget.addDropTargetListener(new DropTargetAdapter(){

                    @Override
                    public void drop(@NotNull DropTargetDropEvent e) {
                        if (e == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$9", "drop"));
                        }
                    }

                    @Override
                    public void dragOver(@NotNull DropTargetDragEvent e) {
                        if (e == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$9", "dragOver"));
                        }
                        Point location = e.getLocation();
                        EditorImpl.this.getCaretModel().moveToVisualPosition(EditorImpl.this.getTargetPosition(location.x, location.y, true));
                        EditorImpl.this.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                        EditorImpl.this.requestFocus();
                    }
                });
            }
        }
        catch (TooManyListenersException e2) {
            LOG.error((Throwable)e2);
        }
        this.myPanel.addHierarchyListener(e -> this.mySoftWrapModel.getApplianceManager().updateAvailableArea());
        this.myPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@NotNull ComponentEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$10", "componentResized"));
                }
                EditorImpl.this.myMarkupModel.recalcEditorDimensions();
                EditorImpl.this.myMarkupModel.repaint(-1, -1);
            }
        });
    }

    private boolean mayShowToolbar() {
        return !this.isEmbeddedIntoDialogWrapper() && !this.isOneLineMode() && ContextMenuImpl.mayShowToolbar(this.myDocument);
    }

    @Override
    public void setFontSize(int fontSize) {
        this.setFontSize(fontSize, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFontSize(int fontSize, @Nullable Point zoomCenter) {
        int oldFontSize = this.myScheme.getEditorFontSize();
        Rectangle visibleArea = this.myScrollingModel.getVisibleArea();
        Point zoomCenterRelative = zoomCenter == null ? new Point() : zoomCenter;
        Point zoomCenterAbsolute = new Point(visibleArea.x + zoomCenterRelative.x, visibleArea.y + zoomCenterRelative.y);
        LogicalPosition zoomCenterLogical = this.xyToLogicalPosition(zoomCenterAbsolute).withoutVisualPositionInfo();
        int oldLineHeight = this.getLineHeight();
        int intraLineOffset = zoomCenterAbsolute.y % oldLineHeight;
        this.myScheme.setEditorFontSize(fontSize);
        fontSize = this.myScheme.getEditorFontSize();
        this.myPropertyChangeSupport.firePropertyChange("fontSize", oldFontSize, fontSize);
        this.myScrollPane.getViewport().invalidate();
        Point shiftedZoomCenterAbsolute = this.logicalPositionToXY(zoomCenterLogical);
        this.myScrollingModel.disableAnimation();
        try {
            this.myScrollingModel.scroll(visibleArea.x == 0 ? 0 : shiftedZoomCenterAbsolute.x - zoomCenterRelative.x, shiftedZoomCenterAbsolute.y - zoomCenterRelative.y + (intraLineOffset * this.getLineHeight() + oldLineHeight / 2) / oldLineHeight);
        }
        finally {
            this.myScrollingModel.enableAnimation();
        }
    }

    public int getFontSize() {
        return this.myScheme.getEditorFontSize();
    }

    @NotNull
    public ActionCallback type(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/EditorImpl", "type"));
        }
        ActionCallback result2 = new ActionCallback();
        for (int i = 0; i < text2.length(); ++i) {
            if (this.processKeyTyped(text2.charAt(i))) continue;
            result2.setRejected();
            ActionCallback actionCallback = result2;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "type"));
            }
            return actionCallback;
        }
        result2.setDone();
        ActionCallback actionCallback = result2;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "type"));
        }
        return actionCallback;
    }

    private boolean processKeyTyped(char c) {
        IdeEventQueue queue = IdeEventQueue.getInstance();
        if (queue.shouldNotTypeInEditor() || ProgressManager.getInstance().hasModalProgressIndicator()) {
            return false;
        }
        FileDocumentManager manager = FileDocumentManager.getInstance();
        VirtualFile file2 = manager.getFile((Document)this.myDocument);
        if (file2 != null && !file2.isValid()) {
            return false;
        }
        DataContext context = this.getDataContext();
        Graphics graphics = GraphicsUtil.safelyGetGraphics((Component)this.myEditorComponent);
        if (graphics != null) {
            this.processKeyTypedImmediately(c, graphics, context);
            graphics.dispose();
        }
        ActionManagerEx.getInstanceEx().fireBeforeEditorTyping(c, context);
        EditorUIUtil.hideCursorInEditor(this);
        this.processKeyTypedNormally(c, context);
        return true;
    }

    void processKeyTypedImmediately(char c, Graphics graphics, DataContext dataContext) {
        EditorActionPlan plan = new EditorActionPlan(this);
        EditorActionManager.getInstance().getTypedAction().beforeActionPerformed((Editor)this, c, dataContext, (ActionPlan)plan);
        this.myImmediatePainter.paint(graphics, plan);
    }

    void processKeyTypedNormally(char c, DataContext dataContext) {
        EditorActionManager.getInstance().getTypedAction().actionPerformed((Editor)this, c, dataContext);
    }

    private void fireFocusLost() {
        for (FocusChangeListener listener2 : this.myFocusListeners) {
            listener2.focusLost(this);
        }
    }

    private void fireFocusGained() {
        for (FocusChangeListener listener2 : this.myFocusListeners) {
            listener2.focusGained(this);
        }
    }

    @Override
    public void setHighlighter(@NotNull EditorHighlighter highlighter) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/EditorImpl", "setHighlighter"));
        }
        if (this.isReleased) {
            return;
        }
        EditorImpl.assertIsDispatchThread();
        DocumentEx document = this.getDocument();
        Disposer.dispose((Disposable)this.myHighlighterDisposable);
        document.addDocumentListener((DocumentListener)highlighter);
        this.myHighlighterDisposable = () -> {
            if (highlighter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/EditorImpl", "lambda$setHighlighter$2"));
            }
            document.removeDocumentListener((DocumentListener)highlighter);
        };
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myHighlighterDisposable);
        highlighter.setEditor((HighlighterClient)this);
        highlighter.setText(document.getImmutableCharSequence());
        if (!(highlighter instanceof EmptyEditorHighlighter)) {
            EditorHighlighterCache.rememberEditorHighlighterForCachesOptimization(document, highlighter);
        }
        this.myHighlighter = highlighter;
        if (this.myPanel != null) {
            this.reinitSettings();
        }
    }

    @Override
    @NotNull
    public EditorHighlighter getHighlighter() {
        EditorImpl.assertReadAccess();
        EditorHighlighter editorHighlighter = this.myHighlighter;
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getHighlighter"));
        }
        return editorHighlighter;
    }

    @NotNull
    public EditorComponentImpl getContentComponent() {
        EditorComponentImpl editorComponentImpl = this.myEditorComponent;
        if (editorComponentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getContentComponent"));
        }
        return editorComponentImpl;
    }

    @Override
    @NotNull
    public EditorGutterComponentImpl getGutterComponentEx() {
        EditorGutterComponentImpl editorGutterComponentImpl = this.myGutterComponent;
        if (editorGutterComponentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getGutterComponentEx"));
        }
        return editorGutterComponentImpl;
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorImpl", "addPropertyChangeListener"));
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(listener2);
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorImpl", "addPropertyChangeListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/editor/impl/EditorImpl", "addPropertyChangeListener"));
        }
        this.addPropertyChangeListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> {
            if (listener2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorImpl", "lambda$addPropertyChangeListener$3"));
            }
            this.removePropertyChangeListener(listener2);
        });
    }

    @Override
    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorImpl", "removePropertyChangeListener"));
        }
        this.myPropertyChangeSupport.removePropertyChangeListener(listener2);
    }

    @Override
    public void setInsertMode(boolean mode) {
        EditorImpl.assertIsDispatchThread();
        boolean oldValue = this.myIsInsertMode;
        this.myIsInsertMode = mode;
        this.myPropertyChangeSupport.firePropertyChange("insertMode", oldValue, mode);
        this.myCaretCursor.repaint();
    }

    public boolean isInsertMode() {
        return this.myIsInsertMode;
    }

    @Override
    public void setColumnMode(boolean mode) {
        EditorImpl.assertIsDispatchThread();
        boolean oldValue = this.myIsColumnMode;
        this.myIsColumnMode = mode;
        this.myPropertyChangeSupport.firePropertyChange("columnMode", oldValue, mode);
    }

    public boolean isColumnMode() {
        return this.myIsColumnMode;
    }

    public int yToVisibleLine(int y) {
        return this.myView.yToVisualLine(y);
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/openapi/editor/impl/EditorImpl", "xyToVisualPosition"));
        }
        VisualPosition visualPosition = this.myView.xyToVisualPosition(p);
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "xyToVisualPosition"));
        }
        return visualPosition;
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point2D p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/openapi/editor/impl/EditorImpl", "xyToVisualPosition"));
        }
        VisualPosition visualPosition = this.myView.xyToVisualPosition(p);
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "xyToVisualPosition"));
        }
        return visualPosition;
    }

    @NotNull
    public Point2D offsetToPoint2D(int offset, boolean leanTowardsLargerOffsets, boolean beforeSoftWrap) {
        Point2D point2D = this.myView.offsetToXY(offset, leanTowardsLargerOffsets, beforeSoftWrap);
        if (point2D == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "offsetToPoint2D"));
        }
        return point2D;
    }

    @NotNull
    public Point offsetToXY(int offset, boolean leanForward, boolean beforeSoftWrap) {
        Point2D point2D = this.offsetToPoint2D(offset, leanForward, beforeSoftWrap);
        Point point = new Point((int)point2D.getX(), (int)point2D.getY());
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "offsetToXY"));
        }
        return point;
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset) {
        VisualPosition visualPosition = this.offsetToVisualPosition(offset, false, false);
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "offsetToVisualPosition"));
        }
        return visualPosition;
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset, boolean leanForward, boolean beforeSoftWrap) {
        VisualPosition visualPosition = this.myView.offsetToVisualPosition(offset, leanForward, beforeSoftWrap);
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "offsetToVisualPosition"));
        }
        return visualPosition;
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        LogicalPosition logicalPosition = this.myView.offsetToLogicalPosition(offset);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "offsetToLogicalPosition"));
        }
        return logicalPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCaretActive() {
        RepaintCursorCommand repaintCursorCommand = ourCaretBlinkingCommand;
        synchronized (repaintCursorCommand) {
            ourCaretBlinkingCommand.myEditor = this;
        }
    }

    public int offsetToVisualLine(int offset) {
        return this.myView.offsetToVisualLine(offset, false);
    }

    public int visualLineStartOffset(int visualLine) {
        return this.myView.visualLineToOffset(visualLine);
    }

    @NotNull
    public LogicalPosition xyToLogicalPosition(@NotNull Point p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/openapi/editor/impl/EditorImpl", "xyToLogicalPosition"));
        }
        Point pp = p.x >= 0 && p.y >= 0 ? p : new Point(Math.max(p.x, 0), Math.max(p.y, 0));
        LogicalPosition logicalPosition = this.visualToLogicalPosition(this.xyToVisualPosition(pp));
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "xyToLogicalPosition"));
        }
        return logicalPosition;
    }

    private int logicalLineToY(int line) {
        int visualLine = line < this.myDocument.getLineCount() ? this.offsetToVisualLine(this.myDocument.getLineStartOffset(line)) : this.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)line, (int)0)).line;
        return this.visibleLineToY(visualLine);
    }

    @NotNull
    public Point logicalPositionToXY(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/EditorImpl", "logicalPositionToXY"));
        }
        VisualPosition visible = this.logicalToVisualPosition(pos);
        Point point = this.visualPositionToXY(visible);
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "logicalPositionToXY"));
        }
        return point;
    }

    @NotNull
    public Point visualPositionToXY(@NotNull VisualPosition visible) {
        if (visible == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visible", "com/intellij/openapi/editor/impl/EditorImpl", "visualPositionToXY"));
        }
        Point2D point2D = this.myView.visualPositionToXY(visible);
        Point point = new Point((int)point2D.getX(), (int)point2D.getY());
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "visualPositionToXY"));
        }
        return point;
    }

    @NotNull
    public Point2D visualPositionToPoint2D(@NotNull VisualPosition visible) {
        if (visible == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visible", "com/intellij/openapi/editor/impl/EditorImpl", "visualPositionToPoint2D"));
        }
        Point2D point2D = this.myView.visualPositionToXY(visible);
        if (point2D == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "visualPositionToPoint2D"));
        }
        return point2D;
    }

    public float getScale() {
        if (!Registry.is((String)"editor.scale.gutter.icons")) {
            return 1.0f;
        }
        float normLineHeight = (float)this.getLineHeight() / this.myScheme.getLineSpacing();
        return normLineHeight / JBUI.scale((float)16.0f);
    }

    public int findNearestDirectionBoundary(int offset, boolean lookForward) {
        return this.myView.findNearestDirectionBoundary(offset, lookForward);
    }

    public int visibleLineToY(int line) {
        return this.myView.visualLineToY(line);
    }

    @Override
    public void repaint(int startOffset, int endOffset) {
        this.repaint(startOffset, endOffset, true);
    }

    void repaint(int startOffset, int endOffset, boolean invalidateTextLayout) {
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        EditorImpl.assertIsDispatchThread();
        endOffset = Math.min(endOffset, this.myDocument.getTextLength());
        if (invalidateTextLayout) {
            this.myView.invalidateRange(startOffset, endOffset);
        }
        if (!this.isShowing()) {
            return;
        }
        if (startOffset <= endOffset) {
            int startLine = this.myDocument.getLineNumber(startOffset);
            int endLine = this.myDocument.getLineNumber(endOffset);
            this.repaintLines(startLine, endLine);
        }
    }

    private boolean isShowing() {
        return this.myGutterComponent.isShowing();
    }

    private void repaintToScreenBottom(int startLine) {
        Rectangle visibleArea = this.getScrollingModel().getVisibleArea();
        int yStartLine = this.logicalLineToY(startLine);
        int yEndLine = visibleArea.y + visibleArea.height;
        this.myEditorComponent.repaintEditorComponent(visibleArea.x, yStartLine, visibleArea.x + visibleArea.width, yEndLine - yStartLine);
        this.myGutterComponent.repaint(0, yStartLine, this.myGutterComponent.getWidth(), yEndLine - yStartLine);
        ((EditorMarkupModelImpl)this.getMarkupModel()).repaint(-1, -1);
    }

    private void repaintLines(int startLine, int endLine) {
        if (!this.isShowing()) {
            return;
        }
        Rectangle visibleArea = this.getScrollingModel().getVisibleArea();
        int yStartLine = this.logicalLineToY(startLine);
        int endVisLine = this.myDocument.getTextLength() <= 0 ? 0 : this.offsetToVisualLine(this.myDocument.getLineEndOffset(Math.min(this.myDocument.getLineCount() - 1, endLine)));
        int height = endVisLine * this.getLineHeight() - yStartLine + this.getLineHeight() + 2;
        this.myEditorComponent.repaintEditorComponent(visibleArea.x, yStartLine, visibleArea.x + visibleArea.width, height);
        this.myGutterComponent.repaint(0, yStartLine, this.myGutterComponent.getWidth(), height);
    }

    private void bulkUpdateStarted() {
        this.myView.getPreferredSize();
        this.myScrollingModel.onBulkDocumentUpdateStarted();
        this.saveCaretRelativePosition();
        this.myCaretModel.onBulkDocumentUpdateStarted();
        this.mySoftWrapModel.onBulkDocumentUpdateStarted();
        this.myFoldingModel.onBulkDocumentUpdateStarted();
    }

    private void bulkUpdateFinished() {
        this.myFoldingModel.onBulkDocumentUpdateFinished();
        this.mySoftWrapModel.onBulkDocumentUpdateFinished();
        this.myView.reset();
        this.myCaretModel.onBulkDocumentUpdateFinished();
        this.setMouseSelectionState(0);
        this.validateSize();
        this.updateGutterSize();
        this.repaintToScreenBottom(0);
        this.updateCaretCursor();
        if (!Boolean.TRUE.equals(this.getUserData(DISABLE_CARET_POSITION_KEEPING))) {
            this.restoreCaretRelativePosition();
        }
    }

    private void beforeChangedUpdate() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myDocumentChangeInProgress = true;
        if (this.isStickySelection()) {
            this.setStickySelection(false);
        }
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        this.saveCaretRelativePosition();
    }

    void invokeDelayedErrorStripeRepaint() {
        if (this.myErrorStripeNeedsRepaint) {
            this.myMarkupModel.repaint(-1, -1);
            this.myErrorStripeNeedsRepaint = false;
        }
    }

    private void changedUpdate(DocumentEvent e) {
        this.myDocumentChangeInProgress = false;
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        if (this.myErrorStripeNeedsRepaint) {
            this.myMarkupModel.repaint(e.getOffset(), e.getOffset() + e.getNewLength());
            this.myErrorStripeNeedsRepaint = false;
        }
        this.setMouseSelectionState(0);
        this.validateSize();
        int startLine = this.offsetToLogicalLine(e.getOffset());
        int endLine = this.offsetToLogicalLine(e.getOffset() + e.getNewLength());
        boolean painted = false;
        if (this.myDocument.getTextLength() > 0) {
            if (startLine != endLine || StringUtil.indexOf((CharSequence)e.getOldFragment(), (char)'\n') != -1) {
                this.myGutterComponent.clearLineToGutterRenderersCache();
            }
            if (EditorImpl.countLineFeeds(e.getOldFragment()) != EditorImpl.countLineFeeds(e.getNewFragment())) {
                this.repaintToScreenBottom(startLine);
                painted = true;
            }
        }
        this.updateCaretCursor();
        if (!painted) {
            this.repaintLines(startLine, endLine);
        }
        if (!(Boolean.TRUE.equals(this.getUserData(DISABLE_CARET_POSITION_KEEPING)) || this.getCaretModel().getOffset() >= e.getOffset() && this.getCaretModel().getOffset() <= e.getOffset() + e.getNewLength())) {
            this.restoreCaretRelativePosition();
        }
    }

    public void hideCursor() {
        if (!this.myIsViewer && Registry.is((String)"ide.hide.cursor.when.typing") && EMPTY_CURSOR != null && EMPTY_CURSOR != this.myEditorComponent.getCursor()) {
            this.myEditorComponent.setCursor(EMPTY_CURSOR);
        }
    }

    private void saveCaretRelativePosition() {
        Rectangle visibleArea = this.getScrollingModel().getVisibleArea();
        Point pos = this.visualPositionToXY(this.getCaretModel().getVisualPosition());
        this.myCaretUpdateVShift = pos.y - visibleArea.y;
    }

    private void restoreCaretRelativePosition() {
        Point caretLocation = this.visualPositionToXY(this.getCaretModel().getVisualPosition());
        int scrollOffset = caretLocation.y - this.myCaretUpdateVShift;
        this.getScrollingModel().disableAnimation();
        this.getScrollingModel().scrollVertically(scrollOffset);
        this.getScrollingModel().enableAnimation();
    }

    public boolean isScrollToCaret() {
        return this.myScrollToCaret;
    }

    public void setScrollToCaret(boolean scrollToCaret) {
        this.myScrollToCaret = scrollToCaret;
    }

    @NotNull
    public Disposable getDisposable() {
        Disposable disposable = this.myDisposable;
        if (disposable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getDisposable"));
        }
        return disposable;
    }

    private static int countLineFeeds(@NotNull CharSequence c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/editor/impl/EditorImpl", "countLineFeeds"));
        }
        return StringUtil.countNewLines((CharSequence)c);
    }

    private void updateGutterSize() {
        EditorImpl.assertIsDispatchThread();
        if (!this.updatingSize) {
            this.updatingSize = true;
            ApplicationManager.getApplication().invokeLater(() -> {
                try {
                    if (!this.isDisposed()) {
                        this.myGutterComponent.updateSize();
                    }
                }
                finally {
                    this.updatingSize = false;
                }
            }, ModalityState.any(), __ -> this.isDisposed());
        }
    }

    void validateSize() {
        if (this.isReleased) {
            return;
        }
        Dimension dim = this.getPreferredSize();
        if (!(dim.equals(this.myPreferredSize) || this.myDocument.isInBulkUpdate() || (dim = this.mySizeAdjustmentStrategy.adjust(dim, this.myPreferredSize, this)).equals(this.myPreferredSize))) {
            this.myPreferredSize = dim;
            this.updateGutterSize();
            this.myEditorComponent.setSize(dim);
            this.myEditorComponent.fireResized();
            this.myMarkupModel.recalcEditorDimensions();
            this.myMarkupModel.repaint(-1, -1);
        }
    }

    void recalculateSizeAndRepaint() {
        this.validateSize();
        this.myEditorComponent.repaintEditorComponent();
    }

    @Override
    @NotNull
    public DocumentEx getDocument() {
        DocumentEx documentEx = this.myDocument;
        if (documentEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getDocument"));
        }
        return documentEx;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getComponent"));
        }
        return jPanel;
    }

    public void addEditorMouseListener(@NotNull EditorMouseListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorImpl", "addEditorMouseListener"));
        }
        this.myMouseListeners.add(listener2);
    }

    public void removeEditorMouseListener(@NotNull EditorMouseListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorImpl", "removeEditorMouseListener"));
        }
        boolean success = this.myMouseListeners.remove(listener2);
        LOG.assertTrue(success || this.isReleased);
    }

    public void addEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorImpl", "addEditorMouseMotionListener"));
        }
        this.myMouseMotionListeners.add(listener2);
    }

    public void removeEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorImpl", "removeEditorMouseMotionListener"));
        }
        boolean success = this.myMouseMotionListeners.remove(listener2);
        LOG.assertTrue(success || this.isReleased);
    }

    @Override
    public boolean isStickySelection() {
        return this.myStickySelection;
    }

    @Override
    public void setStickySelection(boolean enable) {
        this.myStickySelection = enable;
        if (enable) {
            this.myStickySelectionStart = this.getCaretModel().getOffset();
        } else {
            this.mySelectionModel.removeSelection();
        }
    }

    public boolean isDisposed() {
        return this.isReleased;
    }

    public void stopDumbLater() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(this::stopDumb, ModalityState.current(), __ -> this.isDisposed());
    }

    private void stopDumb() {
        this.putUserData(BUFFER, null);
    }

    public void startDumb() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        Rectangle rect = ((JViewport)this.myEditorComponent.getParent()).getViewRect();
        BufferedImage image = UIUtil.createImage((Component)this.myEditorComponent, (int)rect.width, (int)rect.height, (int)1);
        Graphics2D graphics = image.createGraphics();
        graphics.translate(-rect.x, -rect.y);
        graphics.setClip(rect.x, rect.y, rect.width, rect.height);
        this.myEditorComponent.paintComponent(graphics);
        graphics.dispose();
        this.putUserData(BUFFER, image);
    }

    void paint(@NotNull Graphics2D g) {
        BufferedImage buffer;
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl", "paint"));
        }
        Rectangle clip = g.getClipBounds();
        if (clip == null) {
            return;
        }
        if (Registry.is((String)"editor.dumb.mode.available") && (buffer = (BufferedImage)this.getUserData(BUFFER)) != null) {
            Rectangle rect = this.getContentComponent().getVisibleRect();
            UIUtil.drawImage((Graphics)g, (BufferedImage)buffer, null, (int)rect.x, (int)rect.y);
            return;
        }
        if (this.isReleased) {
            g.setColor(this.getDisposedBackground());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            return;
        }
        if (this.myUpdateCursor) {
            this.setCursorPosition();
            this.myUpdateCursor = false;
        }
        if (this.myProject != null && this.myProject.isDisposed()) {
            return;
        }
        this.myView.paint(g);
        boolean isBackgroundImageSet = IdeBackgroundUtil.isEditorBackgroundImageSet(this.myProject);
        if (this.myBackgroundImageSet != isBackgroundImageSet) {
            this.myBackgroundImageSet = isBackgroundImageSet;
            EditorImpl.updateOpaque(this.myScrollPane.getHorizontalScrollBar());
            EditorImpl.updateOpaque(this.myScrollPane.getVerticalScrollBar());
        }
    }

    Color getDisposedBackground() {
        return new JBColor(new Color(128, 255, 128), new Color(128, 255, 128));
    }

    @NotNull
    public IndentsModel getIndentsModel() {
        IndentsModel indentsModel = this.myIndentsModel;
        if (indentsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getIndentsModel"));
        }
        return indentsModel;
    }

    public void setHeaderComponent(JComponent header) {
        this.myHeaderPanel.removeAll();
        JComponent jComponent = header = header == null ? this.getPermanentHeaderComponent() : header;
        if (header != null) {
            this.myHeaderPanel.add(header);
        }
        this.myHeaderPanel.revalidate();
        this.myHeaderPanel.repaint();
    }

    public boolean hasHeaderComponent() {
        JComponent header = this.getHeaderComponent();
        return header != null && header != this.getPermanentHeaderComponent();
    }

    @Override
    @Nullable
    public JComponent getPermanentHeaderComponent() {
        return (JComponent)this.getUserData(PERMANENT_HEADER);
    }

    @Override
    public void setPermanentHeaderComponent(@Nullable JComponent component) {
        this.putUserData(PERMANENT_HEADER, component);
    }

    @Nullable
    public JComponent getHeaderComponent() {
        if (this.myHeaderPanel.getComponentCount() > 0) {
            return (JComponent)this.myHeaderPanel.getComponent(0);
        }
        return null;
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.myScrollPane.setBackground(color);
        if (this.getBackgroundIgnoreForced().equals(color)) {
            this.myForcedBackground = null;
            return;
        }
        this.myForcedBackground = color;
    }

    @NotNull
    Color getForegroundColor() {
        Color color = this.myScheme.getDefaultForeground();
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getForegroundColor"));
        }
        return color;
    }

    @Override
    @NotNull
    public Color getBackgroundColor() {
        if (this.myForcedBackground != null) {
            Color color = this.myForcedBackground;
            if (color == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getBackgroundColor"));
            }
            return color;
        }
        Color color = this.getBackgroundIgnoreForced();
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getBackgroundColor"));
        }
        return color;
    }

    @Override
    @NotNull
    public TextDrawingCallback getTextDrawingCallback() {
        TextDrawingCallback textDrawingCallback = this.myTextDrawingCallback;
        if (textDrawingCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getTextDrawingCallback"));
        }
        return textDrawingCallback;
    }

    @Override
    public void setPlaceholder(@Nullable CharSequence text2) {
        this.myPlaceholderText = text2;
    }

    @Override
    public void setPlaceholderAttributes(@Nullable TextAttributes attributes) {
        this.myPlaceholderAttributes = attributes;
    }

    public TextAttributes getPlaceholderAttributes() {
        return this.myPlaceholderAttributes;
    }

    public CharSequence getPlaceholder() {
        return this.myPlaceholderText;
    }

    @Override
    public void setShowPlaceholderWhenFocused(boolean show) {
        this.myShowPlaceholderWhenFocused = show;
    }

    public boolean getShowPlaceholderWhenFocused() {
        return this.myShowPlaceholderWhenFocused;
    }

    Color getBackgroundColor(@NotNull TextAttributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/openapi/editor/impl/EditorImpl", "getBackgroundColor"));
        }
        Color attrColor = attributes.getBackgroundColor();
        return Comparing.equal((Object)attrColor, (Object)this.myScheme.getDefaultBackground()) ? this.getBackgroundColor() : attrColor;
    }

    @NotNull
    private Color getBackgroundIgnoreForced() {
        Color color = this.myScheme.getDefaultBackground();
        if (this.myDocument.isWritable()) {
            Color color2 = color;
            if (color2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getBackgroundIgnoreForced"));
            }
            return color2;
        }
        Color readOnlyColor = this.myScheme.getColor(EditorColors.READONLY_BACKGROUND_COLOR);
        Color color3 = readOnlyColor != null ? readOnlyColor : color;
        if (color3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getBackgroundIgnoreForced"));
        }
        return color3;
    }

    @Nullable
    public TextRange getComposedTextRange() {
        return this.myInputMethodRequestsHandler == null || this.myInputMethodRequestsHandler.composedText == null ? null : this.myInputMethodRequestsHandler.composedTextRange;
    }

    @Override
    public int getMaxWidthInRange(int startOffset, int endOffset) {
        return this.myView.getMaxWidthInRange(startOffset, endOffset);
    }

    public boolean isPaintSelection() {
        return this.myPaintSelection || !this.isOneLineMode() || IJSwingUtilities.hasFocus(this.getContentComponent());
    }

    public void setPaintSelection(boolean paintSelection) {
        this.myPaintSelection = paintSelection;
    }

    @NotNull
    @NonNls
    public String dumpState() {
        String string = "allow caret inside tab: " + this.mySettings.isCaretInsideTabs() + ", allow caret after line end: " + this.mySettings.isVirtualSpace() + ", soft wraps: " + (this.mySoftWrapModel.isSoftWrappingEnabled() ? "on" : "off") + ", caret model: " + this.getCaretModel().dumpState() + ", soft wraps data: " + this.getSoftWrapModel().dumpState() + "\n\nfolding data: " + this.getFoldingModel().dumpState() + (this.myDocument instanceof DocumentImpl ? "\n\ndocument info: " + ((DocumentImpl)this.myDocument).dumpState() : "") + "\nfont preferences: " + this.myScheme.getFontPreferences() + "\npure painting mode: " + this.myPurePaintingMode + "\ninsets: " + this.myEditorComponent.getInsets() + (this.myView == null ? "" : "\nview: " + this.myView.dumpState());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "dumpState"));
        }
        return string;
    }

    @Nullable
    public CaretRectangle[] getCaretLocations(boolean onlyIfShown) {
        return this.myCaretCursor.getCaretLocations(onlyIfShown);
    }

    public int getAscent() {
        return this.myView.getAscent();
    }

    public int getLineHeight() {
        return this.myView.getLineHeight();
    }

    public int getDescent() {
        return this.myView.getDescent();
    }

    @NotNull
    public FontMetrics getFontMetrics(@JdkConstants.FontStyle int fontType) {
        EditorFontType ft;
        if (fontType == 0) {
            ft = EditorFontType.PLAIN;
        } else if (fontType == 1) {
            ft = EditorFontType.BOLD;
        } else if (fontType == 2) {
            ft = EditorFontType.ITALIC;
        } else if (fontType == 3) {
            ft = EditorFontType.BOLD_ITALIC;
        } else {
            LOG.error("Unknown font type: " + fontType);
            ft = EditorFontType.PLAIN;
        }
        FontMetrics fontMetrics = this.myEditorComponent.getFontMetrics(this.myScheme.getFont(ft));
        if (fontMetrics == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getFontMetrics"));
        }
        return fontMetrics;
    }

    public int getPreferredHeight() {
        return this.isReleased ? 0 : this.myView.getPreferredHeight();
    }

    public Dimension getPreferredSize() {
        return this.isReleased ? new Dimension() : (Registry.is((String)"idea.true.smooth.scrolling.dynamic.scrollbars") ? new Dimension(this.getPreferredWidthOfVisibleLines(), this.myView.getPreferredHeight()) : this.myView.getPreferredSize());
    }

    private int getPreferredWidthOfVisibleLines() {
        Rectangle area = this.getScrollingModel().getVisibleArea();
        VisualPosition begin = this.xyToVisualPosition(area.getLocation());
        VisualPosition end = this.xyToVisualPosition(new Point(area.x + area.width, area.y + area.height));
        return Math.max(this.myView.getPreferredWidth(begin.line, end.line), this.getScrollingWidth());
    }

    private int getScrollingWidth() {
        BoundedRangeModel model;
        JScrollBar scrollbar = this.myScrollPane.getHorizontalScrollBar();
        if (scrollbar != null && (model = scrollbar.getModel()) != null) {
            return model.getValue() + model.getExtent();
        }
        return 0;
    }

    @Override
    @NotNull
    public Dimension getContentSize() {
        Dimension dimension = this.myView.getPreferredSize();
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getContentSize"));
        }
        return dimension;
    }

    @Override
    @NotNull
    public JScrollPane getScrollPane() {
        JScrollPane jScrollPane = this.myScrollPane;
        if (jScrollPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getScrollPane"));
        }
        return jScrollPane;
    }

    public void setBorder(Border border) {
        this.myScrollPane.setBorder(border);
    }

    public Insets getInsets() {
        return this.myScrollPane.getInsets();
    }

    public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/EditorImpl", "logicalPositionToOffset"));
        }
        return this.myView.logicalPositionToOffset(pos);
    }

    public int getVisibleLineCount() {
        return this.getVisibleLogicalLinesCount() + this.getSoftWrapModel().getSoftWrapsIntroducedLinesNumber();
    }

    private int getVisibleLogicalLinesCount() {
        return this.getDocument().getLineCount() - this.myFoldingModel.getTotalNumberOfFoldedLines();
    }

    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition logicalPos) {
        if (logicalPos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalPos", "com/intellij/openapi/editor/impl/EditorImpl", "logicalToVisualPosition"));
        }
        VisualPosition visualPosition = this.myView.logicalToVisualPosition(logicalPos, false);
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "logicalToVisualPosition"));
        }
        return visualPosition;
    }

    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition visiblePos) {
        if (visiblePos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visiblePos", "com/intellij/openapi/editor/impl/EditorImpl", "visualToLogicalPosition"));
        }
        LogicalPosition logicalPosition = this.myView.visualToLogicalPosition(visiblePos);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "visualToLogicalPosition"));
        }
        return logicalPosition;
    }

    private int offsetToLogicalLine(int offset) {
        int textLength = this.myDocument.getTextLength();
        if (textLength == 0) {
            return 0;
        }
        if (offset > textLength || offset < 0) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset + " textLength: " + textLength);
        }
        int lineIndex = this.myDocument.getLineNumber(offset);
        LOG.assertTrue(lineIndex >= 0 && lineIndex < this.myDocument.getLineCount());
        return lineIndex;
    }

    @Override
    public int calcColumnNumber(int offset, int lineIndex) {
        return this.myView.offsetToLogicalPosition((int)offset).column;
    }

    private VisualPosition getTargetPosition(int x, int y, boolean trimToLineWidth) {
        if (this.myDocument.getLineCount() == 0) {
            return new VisualPosition(0, 0);
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        int visualLineCount = this.getVisibleLineCount();
        if (this.yToVisibleLine(y) >= visualLineCount) {
            y = this.visibleLineToY(Math.max(0, visualLineCount - 1));
        }
        VisualPosition visualPosition = this.xyToVisualPosition(new Point(x, y));
        if (trimToLineWidth && !this.mySettings.isVirtualSpace()) {
            LogicalPosition logicalPosition = this.visualToLogicalPosition(visualPosition);
            LogicalPosition lineEndPosition = this.offsetToLogicalPosition(this.myDocument.getLineEndOffset(logicalPosition.line));
            if (logicalPosition.column > lineEndPosition.column) {
                visualPosition = this.logicalToVisualPosition(lineEndPosition.leanForward(true));
            } else if (this.mySoftWrapModel.isInsideSoftWrap(visualPosition)) {
                VisualPosition beforeSoftWrapPosition = this.myView.logicalToVisualPosition(logicalPosition, true);
                visualPosition = visualPosition.line == beforeSoftWrapPosition.line ? beforeSoftWrapPosition : this.myView.logicalToVisualPosition(logicalPosition, false);
            }
        }
        return visualPosition;
    }

    private boolean checkIgnore(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "checkIgnore"));
        }
        if (!this.myIgnoreMouseEventsConsecutiveToInitial) {
            this.myInitialMouseEvent = null;
            return false;
        }
        if (!(this.myInitialMouseEvent == null || e.getComponent() == this.myInitialMouseEvent.getComponent() && e.getPoint().equals(this.myInitialMouseEvent.getPoint()))) {
            this.myIgnoreMouseEventsConsecutiveToInitial = false;
            this.myInitialMouseEvent = null;
            return false;
        }
        this.myIgnoreMouseEventsConsecutiveToInitial = false;
        this.myInitialMouseEvent = null;
        e.consume();
        return true;
    }

    private void processMouseReleased(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "processMouseReleased"));
        }
        if (this.checkIgnore(e)) {
            return;
        }
        if (!(e.getSource() != this.myGutterComponent || this.myMousePressedEvent != null && this.myMousePressedEvent.isConsumed())) {
            this.myGutterComponent.mouseReleased(e);
        }
        if (this.getMouseEventArea(e) != EditorMouseEventArea.EDITING_AREA || e.getY() < 0 || e.getX() < 0) {
            return;
        }
        FoldRegion region = this.getFoldingModel().getFoldingPlaceholderAt(e.getPoint());
        if (e.getX() >= 0 && e.getY() >= 0 && region != null && region == this.myMouseSelectedRegion) {
            this.getFoldingModel().runBatchFoldingOperation(() -> {
                this.myFoldingModel.flushCaretShift();
                region.setExpanded(true);
            });
            this.myGutterComponent.updateSize();
        }
        if (!(this.myMousePressedEvent == null || this.myMousePressedEvent.getClickCount() != 1 || !this.myMousePressedInsideSelection || this.myMousePressedEvent.isShiftDown() || this.myMousePressedEvent.isPopupTrigger() || EditorImpl.isToggleCaretEvent(this.myMousePressedEvent) || EditorImpl.isCreateRectangularSelectionEvent(this.myMousePressedEvent))) {
            this.getSelectionModel().removeSelection();
        }
    }

    @Override
    @NotNull
    public DataContext getDataContext() {
        DataContext dataContext = this.getProjectAwareDataContext(DataManager.getInstance().getDataContext((Component)this.getContentComponent()));
        if (dataContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getDataContext"));
        }
        return dataContext;
    }

    @NotNull
    private DataContext getProjectAwareDataContext(@NotNull DataContext original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/openapi/editor/impl/EditorImpl", "getProjectAwareDataContext"));
        }
        if (CommonDataKeys.PROJECT.getData(original) == this.myProject) {
            DataContext dataContext = original;
            if (dataContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getProjectAwareDataContext"));
            }
            return dataContext;
        }
        DataContext dataContext = dataId -> {
            if (original == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/openapi/editor/impl/EditorImpl", "lambda$getProjectAwareDataContext$8"));
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return this.myProject;
            }
            return original.getData(dataId);
        };
        if (dataContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getProjectAwareDataContext"));
        }
        return dataContext;
    }

    private boolean isInsideGutterWhitespaceArea(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "isInsideGutterWhitespaceArea"));
        }
        EditorMouseEventArea area = this.getMouseEventArea(e);
        return area == EditorMouseEventArea.FOLDING_OUTLINE_AREA && this.myGutterComponent.convertX(e.getX()) > this.myGutterComponent.getWhitespaceSeparatorOffset();
    }

    public EditorMouseEventArea getMouseEventArea(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "getMouseEventArea"));
        }
        if (this.myGutterComponent != e.getSource()) {
            return EditorMouseEventArea.EDITING_AREA;
        }
        int x = this.myGutterComponent.convertX(e.getX());
        return this.myGutterComponent.getEditorMouseAreaByOffset(x);
    }

    private void requestFocus() {
        IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.myProject);
        if (focusManager.getFocusOwner() != this.myEditorComponent) {
            focusManager.requestFocus((Component)this.myEditorComponent, true);
        }
    }

    private void validateMousePointer(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "validateMousePointer"));
        }
        if (e.getSource() == this.myGutterComponent) {
            this.myGutterComponent.validateMousePointer(e);
        } else {
            this.myGutterComponent.setActiveFoldRegion(null);
            if (this.getSelectionModel().hasSelection() && (e.getModifiersEx() & 0xC00) == 0) {
                int offset = this.logicalPositionToOffset(this.xyToLogicalPosition(e.getPoint()));
                if (this.getSelectionModel().getSelectionStart() <= offset && offset < this.getSelectionModel().getSelectionEnd()) {
                    UIUtil.setCursor((Component)this.myEditorComponent, (Cursor)Cursor.getPredefinedCursor(0));
                    return;
                }
            }
            if (!IdeGlassPaneImpl.hasPreProcessedCursor(this.myEditorComponent)) {
                UIUtil.setCursor((Component)this.myEditorComponent, (Cursor)UIUtil.getTextCursor((Color)this.getBackgroundColor()));
            }
        }
    }

    private void runMouseDraggedCommand(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "runMouseDraggedCommand"));
        }
        if (this.myCommandProcessor == null || this.myMousePressedEvent != null && this.myMousePressedEvent.isConsumed()) {
            return;
        }
        this.myCommandProcessor.executeCommand(this.myProject, () -> {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "lambda$runMouseDraggedCommand$9"));
            }
            this.processMouseDragged(e);
        }, "", this.MOUSE_DRAGGED_GROUP, UndoConfirmationPolicy.DEFAULT, (Document)this.getDocument());
    }

    private void processMouseDragged(@NotNull MouseEvent e) {
        boolean columnSelectionDrag;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "processMouseDragged"));
        }
        if (!JBSwingUtilities.isLeftMouseButton((MouseEvent)e) && !JBSwingUtilities.isMiddleMouseButton((MouseEvent)e)) {
            return;
        }
        EditorMouseEventArea eventArea = this.getMouseEventArea(e);
        if (eventArea == EditorMouseEventArea.ANNOTATIONS_AREA) {
            return;
        }
        if (eventArea == EditorMouseEventArea.LINE_MARKERS_AREA || eventArea == EditorMouseEventArea.FOLDING_OUTLINE_AREA && !this.isInsideGutterWhitespaceArea(e)) {
            if (this.myDragOnGutterSelectionStartLine >= 0) {
                this.mySelectionModel.removeSelection();
                this.myCaretModel.moveToOffset(this.myDragOnGutterSelectionStartLine < this.myDocument.getLineCount() ? this.myDocument.getLineStartOffset(this.myDragOnGutterSelectionStartLine) : this.myDocument.getTextLength());
            }
            this.myDragOnGutterSelectionStartLine = -1;
        }
        boolean columnSelectionDragEvent = EditorImpl.isColumnSelectionDragEvent(e);
        boolean toggleCaretEvent = EditorImpl.isToggleCaretEvent(e);
        boolean addRectangularSelectionEvent = EditorImpl.isAddRectangularSelectionEvent(e);
        boolean bl = columnSelectionDrag = this.isColumnMode() && !this.myLastPressCreatedCaret || columnSelectionDragEvent;
        if (!columnSelectionDragEvent && toggleCaretEvent && !this.myLastPressCreatedCaret) {
            return;
        }
        Rectangle visibleArea = this.getScrollingModel().getVisibleArea();
        int x = e.getX();
        if (e.getSource() == this.myGutterComponent) {
            x = 0;
        }
        int dx = 0;
        if (x < visibleArea.x && visibleArea.x > 0) {
            dx = x - visibleArea.x;
        } else if (x > visibleArea.x + visibleArea.width) {
            dx = x - visibleArea.x - visibleArea.width;
        }
        int dy = 0;
        int y = e.getY();
        if (y < visibleArea.y && visibleArea.y > 0) {
            dy = y - visibleArea.y;
        } else if (y > visibleArea.y + visibleArea.height) {
            dy = y - visibleArea.y - visibleArea.height;
        }
        if (dx == 0 && dy == 0) {
            this.myScrollingTimer.stop();
            SelectionModelImpl selectionModel = this.getSelectionModel();
            Caret leadCaret = this.getLeadCaret();
            int oldSelectionStart = leadCaret.getLeadSelectionOffset();
            VisualPosition oldVisLeadSelectionStart = leadCaret.getLeadSelectionPosition();
            int oldCaretOffset = this.getCaretModel().getOffset();
            boolean multiCaretSelection = columnSelectionDrag || toggleCaretEvent;
            VisualPosition newVisualCaret = this.getTargetPosition(x, y, !multiCaretSelection);
            LogicalPosition newLogicalCaret = this.visualToLogicalPosition(newVisualCaret);
            if (multiCaretSelection) {
                this.myMultiSelectionInProgress = true;
                this.myRectangularSelectionInProgress = columnSelectionDrag || addRectangularSelectionEvent;
                this.myTargetMultiSelectionPosition = this.xyToVisualPosition(new Point(Math.max(x, 0), Math.max(y, 0)));
            } else {
                this.getCaretModel().moveToVisualPosition(newVisualCaret);
            }
            int newCaretOffset = this.getCaretModel().getOffset();
            newVisualCaret = this.getCaretModel().getVisualPosition();
            int caretShift = newCaretOffset - this.mySavedSelectionStart;
            if (this.myMousePressedEvent != null && this.getMouseEventArea(this.myMousePressedEvent) != EditorMouseEventArea.EDITING_AREA && this.getMouseEventArea(this.myMousePressedEvent) != EditorMouseEventArea.LINE_NUMBERS_AREA) {
                selectionModel.setSelection(oldSelectionStart, newCaretOffset);
            } else if (multiCaretSelection) {
                if (this.myLastMousePressedLocation != null && (this.myCurrentDragIsSubstantial || !newLogicalCaret.equals((Object)this.myLastMousePressedLocation))) {
                    this.createSelectionTill(newLogicalCaret);
                    this.blockActionsIfNeeded(e, this.myLastMousePressedLocation, newLogicalCaret);
                }
            } else {
                if (this.getMouseSelectionState() != 0) {
                    if (caretShift < 0) {
                        int newSelection = newCaretOffset;
                        if (this.getMouseSelectionState() == 1) {
                            newSelection = this.myCaretModel.getWordAtCaretStart();
                        } else if (this.getMouseSelectionState() == 2) {
                            newSelection = this.logicalPositionToOffset(this.visualToLogicalPosition(new VisualPosition(this.getCaretModel().getVisualPosition().line, 0)));
                        }
                        if (newSelection < 0) {
                            newSelection = newCaretOffset;
                        }
                        selectionModel.setSelection(this.mySavedSelectionEnd, newSelection);
                        this.getCaretModel().moveToOffset(newSelection);
                    } else {
                        int newSelection = newCaretOffset;
                        if (this.getMouseSelectionState() == 1) {
                            newSelection = this.myCaretModel.getWordAtCaretEnd();
                        } else if (this.getMouseSelectionState() == 2) {
                            newSelection = this.logicalPositionToOffset(this.visualToLogicalPosition(new VisualPosition(this.getCaretModel().getVisualPosition().line + 1, 0)));
                        }
                        if (newSelection < 0) {
                            newSelection = newCaretOffset;
                        }
                        selectionModel.setSelection(this.mySavedSelectionStart, newSelection);
                        this.getCaretModel().moveToOffset(newSelection);
                    }
                    this.cancelAutoResetForMouseSelectionState();
                    return;
                }
                if (!this.myMousePressedInsideSelection) {
                    if ((this.myMousePressArea == EditorMouseEventArea.LINE_NUMBERS_AREA || this.myMousePressArea == EditorMouseEventArea.LINE_MARKERS_AREA) && selectionModel.hasSelection()) {
                        if (newCaretOffset >= selectionModel.getSelectionEnd()) {
                            oldSelectionStart = selectionModel.getSelectionStart();
                            oldVisLeadSelectionStart = selectionModel.getSelectionStartPosition();
                        } else if (newCaretOffset <= selectionModel.getSelectionStart()) {
                            oldSelectionStart = selectionModel.getSelectionEnd();
                            oldVisLeadSelectionStart = selectionModel.getSelectionEndPosition();
                        }
                    }
                    if (oldVisLeadSelectionStart != null) {
                        this.setSelectionAndBlockActions(e, oldVisLeadSelectionStart, oldSelectionStart, newVisualCaret, newCaretOffset);
                    } else {
                        this.setSelectionAndBlockActions(e, oldSelectionStart, newCaretOffset);
                    }
                    this.cancelAutoResetForMouseSelectionState();
                } else if (caretShift != 0 && this.myMousePressedEvent != null) {
                    if (this.mySettings.isDndEnabled()) {
                        boolean isCopy = UIUtil.isControlKeyDown((MouseEvent)e) || this.isViewer() || !this.getDocument().isWritable();
                        this.mySavedCaretOffsetForDNDUndoHack = oldCaretOffset;
                        this.getContentComponent().getTransferHandler().exportAsDrag(this.getContentComponent(), e, isCopy ? 1 : 2);
                    } else {
                        selectionModel.removeSelection();
                    }
                }
            }
        } else {
            this.myScrollingTimer.start(dx, dy);
            this.onSubstantialDrag(e);
        }
    }

    private void clearDnDContext() {
        if (this.myDraggedRange != null) {
            this.myDraggedRange.dispose();
            this.myDraggedRange = null;
        }
        this.myGutterComponent.myDnDInProgress = false;
    }

    private void createSelectionTill(@NotNull LogicalPosition targetPosition) {
        if (targetPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetPosition", "com/intellij/openapi/editor/impl/EditorImpl", "createSelectionTill"));
        }
        ArrayList<CaretState> caretStates = new ArrayList<CaretState>(this.myCaretStateBeforeLastPress);
        if (this.myRectangularSelectionInProgress) {
            caretStates.addAll(EditorModificationUtil.calcBlockSelectionState((Editor)this, (LogicalPosition)this.myLastMousePressedLocation, (LogicalPosition)targetPosition));
        } else {
            LogicalPosition selectionStart = this.myLastMousePressedLocation;
            LogicalPosition selectionEnd = targetPosition;
            if (this.getMouseSelectionState() != 0) {
                int newCaretOffset = this.logicalPositionToOffset(targetPosition);
                if (newCaretOffset < this.mySavedSelectionStart) {
                    selectionStart = this.offsetToLogicalPosition(this.mySavedSelectionEnd);
                    if (this.getMouseSelectionState() == 2) {
                        targetPosition = selectionEnd = this.visualToLogicalPosition(new VisualPosition(this.offsetToVisualLine(newCaretOffset), 0));
                    }
                } else {
                    selectionStart = this.offsetToLogicalPosition(this.mySavedSelectionStart);
                    int selectionEndOffset = Math.max(newCaretOffset, this.mySavedSelectionEnd);
                    if (this.getMouseSelectionState() == 1) {
                        targetPosition = selectionEnd = this.offsetToLogicalPosition(selectionEndOffset);
                    } else if (this.getMouseSelectionState() == 2) {
                        targetPosition = selectionEnd = this.visualToLogicalPosition(new VisualPosition(this.offsetToVisualLine(selectionEndOffset) + 1, 0));
                    }
                }
                this.cancelAutoResetForMouseSelectionState();
            }
            caretStates.add(new CaretState(targetPosition, selectionStart, selectionEnd));
        }
        this.myCaretModel.setCaretsAndSelections(caretStates);
    }

    private Caret getLeadCaret() {
        List<Caret> allCarets = this.myCaretModel.getAllCarets();
        Caret firstCaret = allCarets.get(0);
        if (firstCaret == this.myCaretModel.getPrimaryCaret()) {
            return allCarets.get(allCarets.size() - 1);
        }
        return firstCaret;
    }

    private void setSelectionAndBlockActions(@NotNull MouseEvent mouseDragEvent, int startOffset, int endOffset) {
        if (mouseDragEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mouseDragEvent", "com/intellij/openapi/editor/impl/EditorImpl", "setSelectionAndBlockActions"));
        }
        this.mySelectionModel.setSelection(startOffset, endOffset);
        if (this.myCurrentDragIsSubstantial || startOffset != endOffset) {
            this.onSubstantialDrag(mouseDragEvent);
        }
    }

    private void setSelectionAndBlockActions(@NotNull MouseEvent mouseDragEvent, VisualPosition startPosition, int startOffset, VisualPosition endPosition, int endOffset) {
        if (mouseDragEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mouseDragEvent", "com/intellij/openapi/editor/impl/EditorImpl", "setSelectionAndBlockActions"));
        }
        this.mySelectionModel.setSelection(startPosition, startOffset, endPosition, endOffset);
        if (this.myCurrentDragIsSubstantial || startOffset != endOffset || !Comparing.equal((Object)startPosition, (Object)endPosition)) {
            this.onSubstantialDrag(mouseDragEvent);
        }
    }

    private void blockActionsIfNeeded(@NotNull MouseEvent mouseDragEvent, @NotNull LogicalPosition startPosition, @NotNull LogicalPosition endPosition) {
        if (mouseDragEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mouseDragEvent", "com/intellij/openapi/editor/impl/EditorImpl", "blockActionsIfNeeded"));
        }
        if (startPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startPosition", "com/intellij/openapi/editor/impl/EditorImpl", "blockActionsIfNeeded"));
        }
        if (endPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endPosition", "com/intellij/openapi/editor/impl/EditorImpl", "blockActionsIfNeeded"));
        }
        if (this.myCurrentDragIsSubstantial || !startPosition.equals((Object)endPosition)) {
            this.onSubstantialDrag(mouseDragEvent);
        }
    }

    private void onSubstantialDrag(@NotNull MouseEvent mouseDragEvent) {
        if (mouseDragEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mouseDragEvent", "com/intellij/openapi/editor/impl/EditorImpl", "onSubstantialDrag"));
        }
        IdeEventQueue.getInstance().blockNextEvents(mouseDragEvent, IdeEventQueue.BlockMode.ACTIONS);
        this.myCurrentDragIsSubstantial = true;
    }

    void updateCaretCursor() {
        this.myUpdateCursor = true;
    }

    private void setCursorPosition() {
        ArrayList<CaretRectangle> caretPoints = new ArrayList<CaretRectangle>();
        for (Caret caret : this.getCaretModel().getAllCarets()) {
            boolean isRtl = caret.isAtRtlLocation();
            VisualPosition caretPosition = caret.getVisualPosition();
            Point pos1 = this.visualPositionToXY(caretPosition.leanRight(!isRtl));
            Point pos2 = this.visualPositionToXY(new VisualPosition(caretPosition.line, Math.max(0, caretPosition.column + (isRtl ? -1 : 1)), isRtl));
            int width = Math.abs(pos2.x - pos1.x);
            if (!isRtl && this.myInlayModel.hasInlineElementAt(caretPosition)) {
                width = Math.min(width, this.myView.getPlainSpaceWidth());
            }
            caretPoints.add(new CaretRectangle(pos1, width, caret, isRtl));
        }
        this.myCaretCursor.setPositions(caretPoints.toArray(new CaretRectangle[caretPoints.size()]));
    }

    @Override
    public boolean setCaretVisible(boolean b) {
        boolean old = this.myCaretCursor.isActive();
        if (b) {
            this.myCaretCursor.activate();
        } else {
            this.myCaretCursor.passivate();
        }
        return old;
    }

    @Override
    public boolean setCaretEnabled(boolean enabled) {
        boolean old = this.myCaretCursor.isEnabled();
        this.myCaretCursor.setEnabled(enabled);
        return old;
    }

    @Override
    public void addFocusListener(@NotNull FocusChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorImpl", "addFocusListener"));
        }
        this.myFocusListeners.add(listener2);
    }

    @Override
    public void addFocusListener(@NotNull FocusChangeListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorImpl", "addFocusListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/editor/impl/EditorImpl", "addFocusListener"));
        }
        ContainerUtil.add((Object)listener2, this.myFocusListeners, (Disposable)parentDisposable);
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public boolean isOneLineMode() {
        return this.myIsOneLineMode;
    }

    @Override
    public boolean isEmbeddedIntoDialogWrapper() {
        return this.myEmbeddedIntoDialogWrapper;
    }

    @Override
    public void setEmbeddedIntoDialogWrapper(boolean b) {
        EditorImpl.assertIsDispatchThread();
        this.myEmbeddedIntoDialogWrapper = b;
        this.myScrollPane.setFocusable(!b);
        this.myEditorComponent.setFocusCycleRoot(!b);
        this.myEditorComponent.setFocusable(b);
    }

    @Override
    public void setOneLineMode(boolean isOneLineMode) {
        this.myIsOneLineMode = isOneLineMode;
        this.getScrollPane().setInputMap(1, null);
        this.reinitSettings();
    }

    private static void updateOpaque(JScrollBar bar) {
        if (bar instanceof OpaqueAwareScrollBar) {
            bar.setOpaque(((OpaqueAwareScrollBar)((Object)bar)).myOpaque);
        }
    }

    static BasicScrollBarUI createEditorScrollbarUI(@NotNull EditorImpl editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorImpl", "createEditorScrollbarUI"));
        }
        return new EditorScrollBarUI(editor);
    }

    private MyEditable getViewer() {
        if (this.myEditable == null) {
            this.myEditable = new MyEditable();
        }
        return this.myEditable;
    }

    @Override
    public CopyProvider getCopyProvider() {
        return this.getViewer();
    }

    @Override
    public CutProvider getCutProvider() {
        return this.getViewer();
    }

    @Override
    public PasteProvider getPasteProvider() {
        return this.getViewer();
    }

    @Override
    public DeleteProvider getDeleteProvider() {
        return this.getViewer();
    }

    @Override
    public void setColorsScheme(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/editor/impl/EditorImpl", "setColorsScheme"));
        }
        EditorImpl.assertIsDispatchThread();
        this.myScheme = scheme2;
        this.reinitSettings();
    }

    @NotNull
    public EditorColorsScheme getColorsScheme() {
        EditorColorsScheme editorColorsScheme = this.myScheme;
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getColorsScheme"));
        }
        return editorColorsScheme;
    }

    static void assertIsDispatchThread() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    private static void assertReadAccess() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
    }

    @Override
    public void setVerticalScrollbarOrientation(int type2) {
        EditorImpl.assertIsDispatchThread();
        int currentHorOffset = this.myScrollingModel.getHorizontalScrollOffset();
        this.myScrollBarOrientation = type2;
        this.myScrollPane.putClientProperty(JBScrollPane.Flip.class, type2 == 0 ? JBScrollPane.Flip.HORIZONTAL : null);
        this.myScrollingModel.scrollHorizontally(currentHorOffset);
    }

    @Override
    public void setVerticalScrollbarVisible(boolean b) {
        this.myScrollPane.setVerticalScrollBarPolicy(b ? 22 : 21);
    }

    @Override
    public void setHorizontalScrollbarVisible(boolean b) {
        this.myScrollPane.setHorizontalScrollBarPolicy(b ? 30 : 31);
    }

    @Override
    public int getVerticalScrollbarOrientation() {
        return this.myScrollBarOrientation;
    }

    public boolean isMirrored() {
        return this.myScrollBarOrientation != 1;
    }

    @NotNull
    MyScrollBar getVerticalScrollBar() {
        MyScrollBar myScrollBar = this.myVerticalScrollBar;
        if (myScrollBar == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getVerticalScrollBar"));
        }
        return myScrollBar;
    }

    void setHorizontalScrollBarPersistentUI(ScrollBarUI ui) {
        JScrollBar bar = this.myScrollPane.getHorizontalScrollBar();
        if (bar instanceof MyScrollBar) {
            ((MyScrollBar)((Object)bar)).setPersistentUI(ui);
        }
    }

    @MouseSelectionState
    private int getMouseSelectionState() {
        return this.myMouseSelectionState;
    }

    private void setMouseSelectionState(@MouseSelectionState int mouseSelectionState) {
        if (this.getMouseSelectionState() == mouseSelectionState) {
            return;
        }
        this.myMouseSelectionState = mouseSelectionState;
        this.myMouseSelectionChangeTimestamp = System.currentTimeMillis();
        this.myMouseSelectionStateAlarm.cancelAllRequests();
        if (this.myMouseSelectionState != 0) {
            if (this.myMouseSelectionStateResetRunnable == null) {
                this.myMouseSelectionStateResetRunnable = () -> this.resetMouseSelectionState(null);
            }
            this.myMouseSelectionStateAlarm.addRequest(this.myMouseSelectionStateResetRunnable, Registry.intValue((String)"editor.mouseSelectionStateResetTimeout"), ModalityState.stateForComponent((Component)this.myEditorComponent));
        }
    }

    private void resetMouseSelectionState(@Nullable MouseEvent event) {
        MouseEvent e;
        this.setMouseSelectionState(0);
        MouseEvent mouseEvent = e = event != null ? event : this.myMouseMovedEvent;
        if (e != null) {
            this.validateMousePointer(e);
        }
    }

    private void cancelAutoResetForMouseSelectionState() {
        this.myMouseSelectionStateAlarm.cancelAllRequests();
    }

    void replaceInputMethodText(@NotNull InputMethodEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "replaceInputMethodText"));
        }
        if (this.isReleased) {
            return;
        }
        this.getInputMethodRequests();
        this.myInputMethodRequestsHandler.replaceInputMethodText(e);
    }

    void inputMethodCaretPositionChanged(@NotNull InputMethodEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "inputMethodCaretPositionChanged"));
        }
        if (this.isReleased) {
            return;
        }
        this.getInputMethodRequests();
        this.myInputMethodRequestsHandler.setInputMethodCaretPosition(e);
    }

    @NotNull
    InputMethodRequests getInputMethodRequests() {
        if (this.myInputMethodRequestsHandler == null) {
            this.myInputMethodRequestsHandler = new MyInputMethodHandler();
            this.myInputMethodRequestsSwingWrapper = new MyInputMethodHandleSwingThreadWrapper(this.myInputMethodRequestsHandler);
        }
        InputMethodRequests inputMethodRequests = this.myInputMethodRequestsSwingWrapper;
        if (inputMethodRequests == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getInputMethodRequests"));
        }
        return inputMethodRequests;
    }

    @Override
    public boolean processKeyTyped(@NotNull KeyEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "processKeyTyped"));
        }
        if (e.getID() != 400) {
            return false;
        }
        char c = e.getKeyChar();
        if (UIUtil.isReallyTypedEvent((KeyEvent)e)) {
            this.processKeyTyped(c);
            return true;
        }
        return false;
    }

    void beforeModalityStateChanged() {
        this.myScrollingModel.beforeModalityStateChanged();
    }

    EditorDropHandler getDropHandler() {
        return this.myDropHandler;
    }

    public void setDropHandler(@NotNull EditorDropHandler dropHandler) {
        if (dropHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dropHandler", "com/intellij/openapi/editor/impl/EditorImpl", "setDropHandler"));
        }
        this.myDropHandler = dropHandler;
    }

    public void setHighlightingFilter(@Nullable Condition<RangeHighlighter> filter) {
        if (this.myHighlightingFilter == filter) {
            return;
        }
        Condition<RangeHighlighter> oldFilter = this.myHighlightingFilter;
        this.myHighlightingFilter = filter;
        for (RangeHighlighter highlighter : this.myDocumentMarkupModel.getDelegate().getAllHighlighters()) {
            boolean newAvailable;
            boolean oldAvailable = oldFilter == null || oldFilter.value((Object)highlighter);
            boolean bl = newAvailable = filter == null || filter.value((Object)highlighter);
            if (oldAvailable == newAvailable) continue;
            this.myMarkupModelListener.attributesChanged((RangeHighlighterEx)highlighter, true, EditorUtil.attributesImpactFontStyleOrColor(highlighter.getTextAttributes()));
        }
    }

    boolean isHighlighterAvailable(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/EditorImpl", "isHighlighterAvailable"));
        }
        return this.myHighlightingFilter == null || this.myHighlightingFilter.value((Object)highlighter);
    }

    private static boolean isColumnSelectionDragEvent(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "isColumnSelectionDragEvent"));
        }
        return e.isAltDown() && !e.isShiftDown() && !e.isControlDown() && !e.isMetaDown();
    }

    private static boolean isToggleCaretEvent(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "isToggleCaretEvent"));
        }
        return EditorImpl.isMouseActionEvent(e, "EditorAddOrRemoveCaret") || EditorImpl.isAddRectangularSelectionEvent(e);
    }

    private static boolean isAddRectangularSelectionEvent(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "isAddRectangularSelectionEvent"));
        }
        return EditorImpl.isMouseActionEvent(e, "EditorAddRectangularSelectionOnMouseDrag");
    }

    private static boolean isCreateRectangularSelectionEvent(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "isCreateRectangularSelectionEvent"));
        }
        return EditorImpl.isMouseActionEvent(e, "EditorCreateRectangularSelection");
    }

    private static boolean isMouseActionEvent(@NotNull MouseEvent e, String actionId) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "isMouseActionEvent"));
        }
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        if (keymapManager2 == null) {
            return false;
        }
        Keymap keymap = keymapManager2.getActiveKeymap();
        if (keymap == null) {
            return false;
        }
        MouseShortcut mouseShortcut = KeymapUtil.createMouseShortcut((MouseEvent)e);
        String[] mappedActions = keymap.getActionIds(mouseShortcut);
        if (!ArrayUtil.contains((String)actionId, (String[])mappedActions)) {
            return false;
        }
        if (mappedActions.length < 2) {
            return true;
        }
        ActionManager actionManager = ActionManager.getInstance();
        for (String mappedActionId : mappedActions) {
            AnActionEvent actionEvent;
            AnAction action;
            if (actionId.equals(mappedActionId) || !ActionUtil.lastUpdateAndCheckDumb((AnAction)(action = actionManager.getAction(mappedActionId)), (AnActionEvent)(actionEvent = AnActionEvent.createFromAnAction((AnAction)action, (InputEvent)e, (String)"MainMenu", (DataContext)DataManager.getInstance().getDataContext(e.getComponent()))), (boolean)false)) continue;
            return false;
        }
        return true;
    }

    private void selectWordAtCaret(boolean honorCamelCase) {
        this.mySelectionModel.selectWordAtCaret(honorCamelCase);
        this.setMouseSelectionState(1);
        this.mySavedSelectionStart = this.mySelectionModel.getSelectionStart();
        this.mySavedSelectionEnd = this.mySelectionModel.getSelectionEnd();
        this.getCaretModel().moveToOffset(this.mySavedSelectionEnd);
    }

    private boolean tweakSelectionEvent(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "tweakSelectionEvent"));
        }
        return this.getSelectionModel().hasSelection() && e.getButton() == 1 && e.isShiftDown() && this.getMouseEventArea(e) == EditorMouseEventArea.LINE_NUMBERS_AREA;
    }

    private boolean tweakSelectionIfNecessary(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl", "tweakSelectionIfNecessary"));
        }
        if (!this.tweakSelectionEvent(e)) {
            return false;
        }
        int startSelectionOffset = this.getSelectionModel().getSelectionStart();
        int startVisLine = this.offsetToVisualLine(startSelectionOffset);
        int endSelectionOffset = this.getSelectionModel().getSelectionEnd();
        int endVisLine = this.offsetToVisualLine(endSelectionOffset - 1);
        int clickVisLine = this.yToVisibleLine(e.getPoint().y);
        if (clickVisLine < startVisLine) {
            int startOffset = this.logicalPositionToOffset(this.visualToLogicalPosition(new VisualPosition(clickVisLine, 0)));
            this.getSelectionModel().setSelection(startOffset, endSelectionOffset);
            this.getCaretModel().moveToOffset(startOffset);
        } else if (clickVisLine > endVisLine) {
            int endLineOffset = EditorUtil.getVisualLineEndOffset(this, clickVisLine);
            this.getSelectionModel().setSelection(this.getSelectionModel().getSelectionStart(), endLineOffset);
            this.getCaretModel().moveToOffset(endLineOffset, true);
        } else if (startVisLine == endVisLine) {
            this.getSelectionModel().removeSelection();
        } else if (this.getSelectionModel().getLeadSelectionOffset() == endSelectionOffset) {
            if (clickVisLine == startVisLine) {
                ++clickVisLine;
            }
            int startOffset = this.logicalPositionToOffset(this.visualToLogicalPosition(new VisualPosition(clickVisLine, 0)));
            this.getSelectionModel().setSelection(startOffset, endSelectionOffset);
            this.getCaretModel().moveToOffset(startOffset);
        } else {
            if (clickVisLine == endVisLine) {
                --clickVisLine;
            }
            int endLineOffset = EditorUtil.getVisualLineEndOffset(this, clickVisLine);
            this.getSelectionModel().setSelection(startSelectionOffset, endLineOffset);
            this.getCaretModel().moveToOffset(endLineOffset);
        }
        e.consume();
        return true;
    }

    boolean useEditorAntialiasing() {
        return this.myUseEditorAntialiasing;
    }

    public void setUseEditorAntialiasing(boolean value2) {
        this.myUseEditorAntialiasing = value2;
    }

    static boolean handleDrop(@NotNull EditorImpl editor, @NotNull Transferable t, int dropAction) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorImpl", "handleDrop"));
        }
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/openapi/editor/impl/EditorImpl", "handleDrop"));
        }
        EditorDropHandler dropHandler = editor.getDropHandler();
        if (Registry.is((String)"debugger.click.disable.breakpoints")) {
            try {
                GutterDraggableObject object;
                Object attachedObject;
                if (t.isDataFlavorSupported(GutterDraggableObject.flavor) && (attachedObject = t.getTransferData(GutterDraggableObject.flavor)) instanceof GutterIconRenderer && (object = ((GutterIconRenderer)attachedObject).getDraggableObject()) != null) {
                    object.remove();
                    Point mouseLocationOnScreen = MouseInfo.getPointerInfo().getLocation();
                    JComponent editorComponent = editor.getComponent();
                    Point editorComponentLocationOnScreen = editorComponent.getLocationOnScreen();
                    IdeGlassPaneUtil.installPainter((JComponent)editorComponent, (Painter)new ExplosionPainter(new Point(mouseLocationOnScreen.x - editorComponentLocationOnScreen.x, mouseLocationOnScreen.y - editorComponentLocationOnScreen.y), editor.getGutterComponentEx().getDragImage((GutterMark)((GutterIconRenderer)attachedObject))), (Disposable)editor.getDisposable());
                    return true;
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                LOG.warn((Throwable)e);
            }
        }
        if (dropHandler != null && dropHandler.canHandleDrop(t.getTransferDataFlavors())) {
            dropHandler.handleDrop(t, editor.getProject(), null, dropAction);
            return true;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        if (editor.myDraggedRange != null && editor.myDraggedRange.getStartOffset() <= caretOffset && caretOffset < editor.myDraggedRange.getEndOffset()) {
            return false;
        }
        if (editor.myDraggedRange != null) {
            editor.getCaretModel().moveToOffset(editor.mySavedCaretOffsetForDNDUndoHack);
        }
        CommandProcessor.getInstance().executeCommand(editor.myProject, () -> {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorImpl", "lambda$handleDrop$12"));
            }
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/openapi/editor/impl/EditorImpl", "lambda$handleDrop$12"));
            }
            try {
                int offset;
                editor.getSelectionModel().removeSelection();
                if (editor.myDraggedRange != null) {
                    editor.getCaretModel().moveToOffset(caretOffset);
                    offset = caretOffset;
                } else {
                    offset = editor.getCaretModel().getOffset();
                }
                if (editor.getDocument().getRangeGuard(offset, offset) != null) {
                    return;
                }
                editor.putUserData(LAST_PASTED_REGION, null);
                EditorActionHandler pasteHandler = EditorActionManager.getInstance().getActionHandler("EditorPaste");
                LOG.assertTrue(pasteHandler instanceof EditorTextInsertHandler, (Object)String.valueOf(pasteHandler));
                ((EditorTextInsertHandler)pasteHandler).execute((Editor)editor, editor.getDataContext(), () -> {
                    if (t == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/openapi/editor/impl/EditorImpl", "lambda$null$11"));
                    }
                    return t;
                });
                TextRange range = (TextRange)editor.getUserData(LAST_PASTED_REGION);
                if (range != null) {
                    editor.getCaretModel().moveToOffset(range.getStartOffset());
                    editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
                }
            }
            catch (Exception exception) {
                LOG.error((Throwable)exception);
            }
        }, EditorBundle.message((String)"paste.command.name", (Object[])new Object[0]), (Object)DND_COMMAND_KEY, UndoConfirmationPolicy.DEFAULT, (Document)editor.getDocument());
        return true;
    }

    @NotNull
    public EditorGutter getGutter() {
        EditorGutterComponentImpl editorGutterComponentImpl = this.getGutterComponentEx();
        if (editorGutterComponentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl", "getGutter"));
        }
        return editorGutterComponentImpl;
    }

    @Override
    public int calcColumnNumber(@NotNull CharSequence text2, int start, int offset, int tabSize) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/EditorImpl", "calcColumnNumber"));
        }
        return this.myView.offsetToLogicalPosition((int)offset).column;
    }

    public boolean isInDistractionFreeMode() {
        return EditorUtil.isRealFileEditor(this) && (Registry.is((String)"editor.distraction.free.mode") || this.isInPresentationMode());
    }

    boolean isInPresentationMode() {
        return UISettings.getInstance().getPresentationMode() && EditorUtil.isRealFileEditor(this);
    }

    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/editor/impl/EditorImpl", "putInfo"));
        }
        VisualPosition visual = this.getCaretModel().getVisualPosition();
        info.put("caret", visual.getLine() + ":" + visual.getColumn());
    }

    private void invokePopupIfNeeded(EditorMouseEvent event) {
        if (this.myContextMenuGroupId != null && event.getArea() == EditorMouseEventArea.EDITING_AREA && event.getMouseEvent().isPopupTrigger() && !event.isConsumed()) {
            AnAction action;
            String inlayContextMenuGroupId;
            String contextMenuGroupId = this.myContextMenuGroupId;
            Inlay inlay = this.myInlayModel.getElementAt(event.getMouseEvent().getPoint());
            if (inlay != null && (inlayContextMenuGroupId = inlay.getRenderer().getContextMenuGroupId()) != null) {
                contextMenuGroupId = inlayContextMenuGroupId;
            }
            if ((action = CustomActionsSchema.getInstance().getCorrectedAction(contextMenuGroupId)) instanceof ActionGroup) {
                ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("EditorPopup", (ActionGroup)action);
                MouseEvent e = event.getMouseEvent();
                Component c = e.getComponent();
                if (c != null && c.isShowing()) {
                    popupMenu.getComponent().show(c, e.getX(), e.getY());
                }
                e.consume();
            }
        }
    }

    public void validateState() {
        this.myView.validateState();
        this.mySoftWrapModel.validateState();
        this.myFoldingModel.validateState();
        this.myCaretModel.validateState();
        this.myInlayModel.validateState();
    }

    static {
        Cursor emptyCursor = null;
        if (!GraphicsEnvironment.isHeadless()) {
            try {
                emptyCursor = Toolkit.getDefaultToolkit().createCustomCursor(UIUtil.createImage((int)1, (int)1, (int)2), new Point(), "Empty cursor");
            }
            catch (Exception e) {
                LOG.warn("Couldn't create an empty cursor", (Throwable)e);
            }
        }
        EMPTY_CURSOR = emptyCursor;
        ourCaretBlinkingCommand = new RepaintCursorCommand();
        ourCaretBlinkingCommand.start();
        decrButtonField = ReflectionUtil.getDeclaredField(BasicScrollBarUI.class, (String)"decrButton");
        incrButtonField = ReflectionUtil.getDeclaredField(BasicScrollBarUI.class, (String)"incrButton");
        FOLDING_TOOLTIP_GROUP = new TooltipGroup("FOLDING_TOOLTIP_GROUP", 10);
    }

    private static class NullEditorHighlighter
    extends EmptyEditorHighlighter {
        private static final TextAttributes NULL_ATTRIBUTES = new TextAttributes();

        public NullEditorHighlighter() {
            super(NULL_ATTRIBUTES);
        }

        @Override
        public void setAttributes(TextAttributes attributes) {
        }

        @Override
        public void setColorScheme(@NotNull EditorColorsScheme scheme2) {
            if (scheme2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/editor/impl/EditorImpl$NullEditorHighlighter", "setColorScheme"));
            }
        }
    }

    private class MyTextDrawingCallback
    implements TextDrawingCallback {
        private MyTextDrawingCallback() {
        }

        @Override
        public void drawChars(@NotNull Graphics g, @NotNull char[] data, int start, int end, int x, int y, Color color, @NotNull FontInfo fontInfo) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl$MyTextDrawingCallback", "drawChars"));
            }
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/editor/impl/EditorImpl$MyTextDrawingCallback", "drawChars"));
            }
            if (fontInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontInfo", "com/intellij/openapi/editor/impl/EditorImpl$MyTextDrawingCallback", "drawChars"));
            }
            EditorImpl.this.myView.drawChars(g, data, start, end, x, y, color, fontInfo);
        }
    }

    private class MyHeaderPanel
    extends JPanel {
        private int myOldHeight;

        private MyHeaderPanel() {
            super(new BorderLayout());
        }

        @Override
        public void revalidate() {
            this.myOldHeight = this.getHeight();
            super.revalidate();
        }

        @Override
        protected void validateTree() {
            int height = this.myOldHeight;
            super.validateTree();
            if ((height -= this.getHeight()) != 0 && (this.myOldHeight != 0 || this.getComponentCount() <= 0 || EditorImpl.this.getPermanentHeaderComponent() != this.getComponent(0))) {
                EditorImpl.this.myVerticalScrollBar.setValue(EditorImpl.this.myVerticalScrollBar.getValue() - height);
            }
            this.myOldHeight = this.getHeight();
        }
    }

    private class TablessBorder
    extends SideBorder {
        private TablessBorder() {
            super(JBColor.border(), 15);
        }

        public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/editor/impl/EditorImpl$TablessBorder", "paintBorder"));
            }
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorImpl$TablessBorder", "paintBorder"));
            }
            if (c instanceof JComponent) {
                Insets insets = ((JComponent)c).getInsets();
                if (insets.left > 0) {
                    super.paintBorder(c, g, x, y, width, height);
                } else {
                    g.setColor(UIUtil.getPanelBackground());
                    g.fillRect(x, y, width, 1);
                    g.setColor(Gray._50.withAlpha(90));
                    g.fillRect(x, y, width, 1);
                }
            }
        }

        @NotNull
        public Insets getBorderInsets(Component c) {
            boolean paintTop;
            Container splitters = SwingUtilities.getAncestorOfClass(EditorsSplitters.class, c);
            boolean thereIsSomethingAbove = !SystemInfo.isMac || UISettings.getInstance().getShowMainToolbar() || UISettings.getInstance().getShowNavigationBar() || this.toolWindowIsNotEmpty();
            Component header = EditorImpl.this.myHeaderPanel == null ? null : (Component)ArrayUtil.getFirstElement((Object[])EditorImpl.this.myHeaderPanel.getComponents());
            boolean bl = paintTop = thereIsSomethingAbove && header == null && UISettings.getInstance().getEditorTabPlacement() != 1;
            Insets insets = splitters == null ? super.getBorderInsets(c) : new Insets(paintTop ? 1 : 0, 0, 0, 0);
            if (insets == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl$TablessBorder", "getBorderInsets"));
            }
            return insets;
        }

        private boolean toolWindowIsNotEmpty() {
            if (EditorImpl.this.myProject == null) {
                return false;
            }
            ToolWindowManagerEx m = ToolWindowManagerEx.getInstanceEx(EditorImpl.this.myProject);
            return m != null && !m.getIdsOn(ToolWindowAnchor.TOP).isEmpty();
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    private class MyScrollPane
    extends JBScrollPane {
        private MyScrollPane() {
            super(0);
            this.setupCorners();
        }

        public void setUI(ScrollPaneUI ui) {
            super.setUI(ui);
            this.setInputMap(1, null);
        }

        public void layout() {
            if (EditorImpl.this.isInDistractionFreeMode()) {
                EditorImpl.this.myGutterComponent.updateSize(true, true);
            }
            super.layout();
        }

        protected void processMouseWheelEvent(@NotNull MouseWheelEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyScrollPane", "processMouseWheelEvent"));
            }
            if (EditorImpl.this.mySettings.isWheelFontChangeEnabled() && EditorUtil.isChangeFontSize(e)) {
                int size = EditorImpl.this.myScheme.getEditorFontSize() - e.getWheelRotation();
                if (size >= 8) {
                    EditorImpl.this.setFontSize(size, SwingUtilities.convertPoint((Component)((Object)this), e.getPoint(), this.getViewport()));
                }
                return;
            }
            super.processMouseWheelEvent(e);
        }

        @NotNull
        public JScrollBar createHorizontalScrollBar() {
            OpaqueAwareScrollBar opaqueAwareScrollBar = new OpaqueAwareScrollBar(0);
            if (opaqueAwareScrollBar == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl$MyScrollPane", "createHorizontalScrollBar"));
            }
            return opaqueAwareScrollBar;
        }

        @NotNull
        public JScrollBar createVerticalScrollBar() {
            MyScrollBar myScrollBar = new MyScrollBar(1);
            if (myScrollBar == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl$MyScrollPane", "createVerticalScrollBar"));
            }
            return myScrollBar;
        }

        protected void setupCorners() {
            super.setupCorners();
            this.setBorder((Border)((Object)new TablessBorder()));
        }
    }

    private class EditorDocumentBulkUpdateAdapter
    implements DocumentBulkUpdateListener {
        private EditorDocumentBulkUpdateAdapter() {
        }

        @Override
        public void updateStarted(@NotNull Document doc) {
            if (doc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/openapi/editor/impl/EditorImpl$EditorDocumentBulkUpdateAdapter", "updateStarted"));
            }
            if (doc != EditorImpl.this.getDocument()) {
                return;
            }
            EditorImpl.this.bulkUpdateStarted();
        }

        @Override
        public void updateFinished(@NotNull Document doc) {
            if (doc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/openapi/editor/impl/EditorImpl$EditorDocumentBulkUpdateAdapter", "updateFinished"));
            }
            if (doc != EditorImpl.this.getDocument()) {
                return;
            }
            EditorImpl.this.bulkUpdateFinished();
        }
    }

    private class EditorDocumentAdapter
    implements PrioritizedDocumentListener {
        private EditorDocumentAdapter() {
        }

        public void beforeDocumentChange(@NotNull DocumentEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$EditorDocumentAdapter", "beforeDocumentChange"));
            }
            EditorImpl.this.beforeChangedUpdate();
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$EditorDocumentAdapter", "documentChanged"));
            }
            EditorImpl.this.changedUpdate(e);
        }

        @Override
        public int getPriority() {
            return 160;
        }
    }

    private static class MyTransferHandler
    extends TransferHandler {
        private MyTransferHandler() {
        }

        private static EditorImpl getEditor(@NotNull JComponent comp) {
            if (comp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comp", "com/intellij/openapi/editor/impl/EditorImpl$MyTransferHandler", "getEditor"));
            }
            EditorComponentImpl editorComponent = (EditorComponentImpl)comp;
            return editorComponent.getEditor();
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            Component comp = support.getComponent();
            if (!(comp instanceof JComponent)) {
                return false;
            }
            return EditorImpl.handleDrop(MyTransferHandler.getEditor((JComponent)comp), support.getTransferable(), support.getDropAction());
        }

        @Override
        public boolean canImport(@NotNull JComponent comp, @NotNull DataFlavor[] transferFlavors) {
            if (comp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comp", "com/intellij/openapi/editor/impl/EditorImpl$MyTransferHandler", "canImport"));
            }
            if (transferFlavors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transferFlavors", "com/intellij/openapi/editor/impl/EditorImpl$MyTransferHandler", "canImport"));
            }
            EditorImpl editor = MyTransferHandler.getEditor(comp);
            EditorDropHandler dropHandler = editor.getDropHandler();
            if (dropHandler != null && dropHandler.canHandleDrop(transferFlavors)) {
                return true;
            }
            if (Registry.is((String)"debugger.click.disable.breakpoints") && ArrayUtil.contains((Object)GutterDraggableObject.flavor, (Object[])transferFlavors)) {
                return true;
            }
            if (editor.isViewer()) {
                return false;
            }
            int offset = editor.getCaretModel().getOffset();
            if (editor.getDocument().getRangeGuard(offset, offset) != null) {
                return false;
            }
            return ArrayUtil.contains((Object)DataFlavor.stringFlavor, (Object[])transferFlavors);
        }

        @Override
        @Nullable
        protected Transferable createTransferable(JComponent c) {
            EditorImpl editor = MyTransferHandler.getEditor(c);
            String s = editor.getSelectionModel().getSelectedText();
            if (s == null) {
                return null;
            }
            int selectionStart = editor.getSelectionModel().getSelectionStart();
            int selectionEnd = editor.getSelectionModel().getSelectionEnd();
            editor.myDraggedRange = editor.getDocument().createRangeMarker(selectionStart, selectionEnd);
            return new StringSelection(s);
        }

        @Override
        public int getSourceActions(@NotNull JComponent c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/editor/impl/EditorImpl$MyTransferHandler", "getSourceActions"));
            }
            return 3;
        }

        @Override
        protected void exportDone(@NotNull JComponent source, @Nullable Transferable data, int action) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/editor/impl/EditorImpl$MyTransferHandler", "exportDone"));
            }
            if (data == null) {
                return;
            }
            Component last = DnDManager.getInstance().getLastDropHandler();
            if (last != null && !(last instanceof EditorComponentImpl) && !(last instanceof EditorGutterComponentImpl)) {
                return;
            }
            EditorImpl editor = MyTransferHandler.getEditor(source);
            if (action == 2 && !editor.isViewer() && editor.myDraggedRange != null) {
                ((TransactionGuardImpl)TransactionGuard.getInstance()).performUserActivity(() -> MyTransferHandler.removeDraggedOutFragment(editor));
            }
            editor.clearDnDContext();
        }

        private static void removeDraggedOutFragment(EditorImpl editor) {
            if (!FileDocumentManager.getInstance().requestWriting((Document)editor.getDocument(), editor.getProject())) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(editor.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                DocumentEx doc = editor.getDocument();
                doc.startGuardedBlockChecking();
                try {
                    doc.deleteString(editor.myDraggedRange.getStartOffset(), editor.myDraggedRange.getEndOffset());
                }
                catch (ReadOnlyFragmentModificationException e) {
                    EditorActionManager.getInstance().getReadonlyFragmentModificationHandler((Document)doc).handle(e);
                }
                finally {
                    doc.stopGuardedBlockChecking();
                }
            }), EditorBundle.message((String)"move.selection.command.name", (Object[])new Object[0]), (Object)DND_COMMAND_KEY, UndoConfirmationPolicy.DEFAULT, (Document)editor.getDocument());
        }
    }

    private static class ExplosionPainter
    extends AbstractPainter {
        private final Point myExplosionLocation;
        private final Image myImage;
        private static final long TIME_PER_FRAME = 30L;
        private final int myWidth;
        private final int myHeight;
        private long lastRepaintTime = System.currentTimeMillis();
        private int frameIndex;
        private static final int TOTAL_FRAMES = 8;
        private final AtomicBoolean nrp = new AtomicBoolean(true);

        ExplosionPainter(Point explosionLocation, Image image) {
            this.myExplosionLocation = new Point(explosionLocation.x, explosionLocation.y);
            this.myImage = image;
            this.myWidth = this.myImage.getWidth(null);
            this.myHeight = this.myImage.getHeight(null);
        }

        public void executePaint(Component component, Graphics2D g) {
            if (!this.nrp.get()) {
                return;
            }
            long currentTimeMillis = System.currentTimeMillis();
            float alpha = 1.0f - (float)this.frameIndex / 8.0f;
            g.setComposite(AlphaComposite.getInstance(3, alpha));
            Image scaledImage = ImageUtil.scaleImage((Image)this.myImage, (float)alpha);
            int x = this.myExplosionLocation.x - scaledImage.getWidth(null) / 2;
            int y = this.myExplosionLocation.y - scaledImage.getHeight(null) / 2;
            if (currentTimeMillis - this.lastRepaintTime < 30L) {
                UIUtil.drawImage((Graphics)g, (Image)scaledImage, (int)x, (int)y, null);
                JobScheduler.getScheduler().schedule(() -> component.repaint(x, y, this.myWidth, this.myHeight), 30L, TimeUnit.MILLISECONDS);
                return;
            }
            this.lastRepaintTime = currentTimeMillis;
            ++this.frameIndex;
            UIUtil.drawImage((Graphics)g, (Image)scaledImage, (int)x, (int)y, null);
            if (this.frameIndex == 8) {
                this.nrp.set(false);
                IdeGlassPane glassPane = IdeGlassPaneUtil.find((Component)component);
                ApplicationManager.getApplication().invokeLater(() -> glassPane.removePainter((Painter)this));
                component.repaint(x, y, this.myWidth, this.myHeight);
            }
            component.repaint(x, y, this.myWidth, this.myHeight);
        }

        public boolean needsRepaint() {
            return this.nrp.get();
        }
    }

    private class MyColorSchemeDelegate
    extends DelegateColorScheme {
        private final FontPreferencesImpl myFontPreferences;
        private final FontPreferencesImpl myConsoleFontPreferences;
        private final Map<TextAttributesKey, TextAttributes> myOwnAttributes;
        private final Map<ColorKey, Color> myOwnColors;
        private final EditorColorsScheme myCustomGlobalScheme;
        private Map<EditorFontType, Font> myFontsMap;
        private int myMaxFontSize;
        private int myFontSize;
        private int myConsoleFontSize;
        private String myFaceName;

        private MyColorSchemeDelegate(EditorColorsScheme globalScheme) {
            super(globalScheme == null ? EditorColorsManager.getInstance().getGlobalScheme() : globalScheme);
            this.myFontPreferences = new FontPreferencesImpl();
            this.myConsoleFontPreferences = new FontPreferencesImpl();
            this.myOwnAttributes = ContainerUtilRt.newHashMap();
            this.myOwnColors = ContainerUtilRt.newHashMap();
            this.myMaxFontSize = EditorFontsConstants.getMaxEditorFontSize();
            this.myFontSize = -1;
            this.myConsoleFontSize = -1;
            this.myCustomGlobalScheme = globalScheme;
            this.updateGlobalScheme();
        }

        private void reinitFonts() {
            EditorColorsScheme delegate = this.getDelegate();
            String editorFontName = this.getEditorFontName();
            int editorFontSize = this.getEditorFontSize();
            this.updatePreferences(this.myFontPreferences, editorFontName, editorFontSize, delegate == null ? null : delegate.getFontPreferences());
            String consoleFontName = this.getConsoleFontName();
            int consoleFontSize = this.getConsoleFontSize();
            this.updatePreferences(this.myConsoleFontPreferences, consoleFontName, consoleFontSize, delegate == null ? null : delegate.getConsoleFontPreferences());
            this.myFontsMap = new EnumMap<EditorFontType, Font>(EditorFontType.class);
            this.myFontsMap.put(EditorFontType.PLAIN, new Font(editorFontName, 0, editorFontSize));
            this.myFontsMap.put(EditorFontType.BOLD, new Font(editorFontName, 1, editorFontSize));
            this.myFontsMap.put(EditorFontType.ITALIC, new Font(editorFontName, 2, editorFontSize));
            this.myFontsMap.put(EditorFontType.BOLD_ITALIC, new Font(editorFontName, 3, editorFontSize));
            this.myFontsMap.put(EditorFontType.CONSOLE_PLAIN, new Font(consoleFontName, 0, consoleFontSize));
            this.myFontsMap.put(EditorFontType.CONSOLE_BOLD, new Font(consoleFontName, 1, consoleFontSize));
            this.myFontsMap.put(EditorFontType.CONSOLE_ITALIC, new Font(consoleFontName, 2, consoleFontSize));
            this.myFontsMap.put(EditorFontType.CONSOLE_BOLD_ITALIC, new Font(consoleFontName, 3, consoleFontSize));
        }

        private void updatePreferences(FontPreferencesImpl preferences, String fontName, int fontSize, FontPreferences delegatePreferences) {
            preferences.clear();
            preferences.register(fontName, fontSize);
            if (delegatePreferences != null) {
                boolean first = true;
                for (String font : delegatePreferences.getRealFontFamilies()) {
                    if (!first) {
                        preferences.register(font, fontSize);
                    }
                    first = false;
                }
            }
            preferences.setUseLigatures(delegatePreferences != null && delegatePreferences.useLigatures());
        }

        private void reinitFontsAndSettings() {
            this.reinitFonts();
            EditorImpl.this.reinitSettings();
        }

        @Override
        public TextAttributes getAttributes(TextAttributesKey key2) {
            if (this.myOwnAttributes.containsKey(key2)) {
                return this.myOwnAttributes.get(key2);
            }
            return this.getDelegate().getAttributes(key2);
        }

        @Override
        public void setAttributes(@NotNull TextAttributesKey key2, TextAttributes attributes) {
            if (key2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/impl/EditorImpl$MyColorSchemeDelegate", "setAttributes"));
            }
            this.myOwnAttributes.put(key2, attributes);
        }

        @Override
        @Nullable
        public Color getColor(ColorKey key2) {
            if (this.myOwnColors.containsKey(key2)) {
                return this.myOwnColors.get(key2);
            }
            return this.getDelegate().getColor(key2);
        }

        @Override
        public void setColor(ColorKey key2, Color color) {
            this.myOwnColors.put(key2, color);
            EditorImpl.this.myCaretModel.reinitSettings();
            EditorImpl.this.mySelectionModel.reinitSettings();
        }

        @Override
        public int getEditorFontSize() {
            if (this.myFontSize == -1) {
                return this.getDelegate().getEditorFontSize();
            }
            return this.myFontSize;
        }

        @Override
        public void setEditorFontSize(int fontSize) {
            if (fontSize < 8) {
                fontSize = 8;
            }
            if (fontSize > this.myMaxFontSize) {
                fontSize = this.myMaxFontSize;
            }
            if (fontSize == this.myFontSize) {
                return;
            }
            this.myFontSize = fontSize;
            this.reinitFontsAndSettings();
        }

        @Override
        @NotNull
        public FontPreferences getFontPreferences() {
            FontPreferencesImpl fontPreferencesImpl = this.myFontPreferences.getEffectiveFontFamilies().isEmpty() ? this.getDelegate().getFontPreferences() : this.myFontPreferences;
            if (fontPreferencesImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl$MyColorSchemeDelegate", "getFontPreferences"));
            }
            return fontPreferencesImpl;
        }

        @Override
        public void setFontPreferences(@NotNull FontPreferences preferences) {
            if (preferences == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/impl/EditorImpl$MyColorSchemeDelegate", "setFontPreferences"));
            }
            if (Comparing.equal((Object)preferences, (Object)((Object)this.myFontPreferences))) {
                return;
            }
            preferences.copyTo((FontPreferences)this.myFontPreferences);
            this.reinitFontsAndSettings();
        }

        @Override
        @NotNull
        public FontPreferences getConsoleFontPreferences() {
            FontPreferencesImpl fontPreferencesImpl = this.myConsoleFontPreferences.getEffectiveFontFamilies().isEmpty() ? this.getDelegate().getConsoleFontPreferences() : this.myConsoleFontPreferences;
            if (fontPreferencesImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl$MyColorSchemeDelegate", "getConsoleFontPreferences"));
            }
            return fontPreferencesImpl;
        }

        @Override
        public void setConsoleFontPreferences(@NotNull FontPreferences preferences) {
            if (preferences == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/impl/EditorImpl$MyColorSchemeDelegate", "setConsoleFontPreferences"));
            }
            if (Comparing.equal((Object)preferences, (Object)((Object)this.myConsoleFontPreferences))) {
                return;
            }
            preferences.copyTo((FontPreferences)this.myConsoleFontPreferences);
            this.reinitFontsAndSettings();
        }

        @Override
        public String getEditorFontName() {
            if (this.myFaceName == null) {
                return this.getDelegate().getEditorFontName();
            }
            return this.myFaceName;
        }

        @Override
        public void setEditorFontName(String fontName) {
            if (Comparing.equal((String)fontName, (String)this.myFaceName)) {
                return;
            }
            this.myFaceName = fontName;
            this.reinitFontsAndSettings();
        }

        @Override
        public Font getFont(EditorFontType key2) {
            Font font;
            if (this.myFontsMap != null && (font = this.myFontsMap.get(key2)) != null) {
                return font;
            }
            return this.getDelegate().getFont(key2);
        }

        @Override
        public void setFont(EditorFontType key2, Font font) {
            if (this.myFontsMap == null) {
                this.reinitFontsAndSettings();
            }
            this.myFontsMap.put(key2, font);
            EditorImpl.this.reinitSettings();
        }

        @Override
        @Nullable
        public Object clone() {
            return null;
        }

        private void updateGlobalScheme() {
            this.setDelegate(this.myCustomGlobalScheme == null ? EditorColorsManager.getInstance().getGlobalScheme() : this.myCustomGlobalScheme);
        }

        @Override
        public void setDelegate(@NotNull EditorColorsScheme delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/editor/impl/EditorImpl$MyColorSchemeDelegate", "setDelegate"));
            }
            super.setDelegate(delegate);
            int globalFontSize = this.getDelegate().getEditorFontSize();
            this.myMaxFontSize = Math.max(EditorFontsConstants.getMaxEditorFontSize(), globalFontSize);
            this.reinitFonts();
        }

        @Override
        public void setConsoleFontSize(int fontSize) {
            this.myConsoleFontSize = fontSize;
            this.reinitFontsAndSettings();
        }

        @Override
        public int getConsoleFontSize() {
            return this.myConsoleFontSize == -1 ? super.getConsoleFontSize() : this.myConsoleFontSize;
        }
    }

    private class MyMouseMotionListener
    implements MouseMotionListener {
        private MyMouseMotionListener() {
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseMotionListener", "mouseDragged"));
            }
            if (EditorImpl.this.myDraggedRange != null || ((EditorImpl)EditorImpl.this).myGutterComponent.myDnDInProgress) {
                return;
            }
            EditorImpl.this.validateMousePointer(e);
            ((TransactionGuardImpl)TransactionGuard.getInstance()).performUserActivity(() -> {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseMotionListener", "lambda$mouseDragged$0"));
                }
                EditorImpl.this.runMouseDraggedCommand(e);
            });
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            if (event.getArea() == EditorMouseEventArea.LINE_MARKERS_AREA) {
                EditorImpl.this.myGutterComponent.mouseDragged(e);
            }
            for (EditorMouseMotionListener listener2 : EditorImpl.this.myMouseMotionListeners) {
                listener2.mouseDragged(event);
            }
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseMotionListener", "mouseMoved"));
            }
            if (EditorImpl.this.getMouseSelectionState() != 0) {
                if (EditorImpl.this.myMousePressedEvent != null && EditorImpl.this.myMousePressedEvent.getComponent() == e.getComponent()) {
                    Point lastPoint = EditorImpl.this.myMousePressedEvent.getPoint();
                    Point point = e.getPoint();
                    int deadZone = Registry.intValue((String)"editor.mouseSelectionStateResetDeadZone");
                    if (Math.abs(lastPoint.x - point.x) >= deadZone || Math.abs(lastPoint.y - point.y) >= deadZone) {
                        EditorImpl.this.resetMouseSelectionState(e);
                    }
                } else {
                    EditorImpl.this.validateMousePointer(e);
                }
            } else {
                EditorImpl.this.validateMousePointer(e);
            }
            EditorImpl.this.myMouseMovedEvent = e;
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            if (e.getSource() == EditorImpl.this.myGutterComponent) {
                EditorImpl.this.myGutterComponent.mouseMoved(e);
            }
            if (event.getArea() == EditorMouseEventArea.EDITING_AREA) {
                FoldRegion fold = EditorImpl.this.myFoldingModel.getFoldingPlaceholderAt(e.getPoint());
                TooltipController controller = TooltipController.getInstance();
                if (fold != null && !fold.shouldNeverExpand()) {
                    DocumentFragment range = this.createDocumentFragment(fold);
                    Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), EditorImpl.this.getComponent().getRootPane().getLayeredPane());
                    controller.showTooltip((Editor)EditorImpl.this, p, new DocumentFragmentTooltipRenderer(range), false, FOLDING_TOOLTIP_GROUP);
                } else {
                    controller.cancelTooltip(FOLDING_TOOLTIP_GROUP, e, true);
                }
            }
            for (EditorMouseMotionListener listener2 : EditorImpl.this.myMouseMotionListeners) {
                listener2.mouseMoved(event);
            }
        }

        @NotNull
        private DocumentFragment createDocumentFragment(@NotNull FoldRegion fold) {
            int endOffset;
            if (fold == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fold", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseMotionListener", "createDocumentFragment"));
            }
            FoldingGroup group = fold.getGroup();
            int foldStart = fold.getStartOffset();
            if (group != null && EditorImpl.this.offsetToVisualLine(endOffset = EditorImpl.this.myFoldingModel.getEndOffset(group)) == EditorImpl.this.offsetToVisualLine(foldStart)) {
                DocumentFragment documentFragment = new DocumentFragment((Document)EditorImpl.this.myDocument, foldStart, endOffset);
                if (documentFragment == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseMotionListener", "createDocumentFragment"));
                }
                return documentFragment;
            }
            int oldEnd = fold.getEndOffset();
            DocumentFragment documentFragment = new DocumentFragment((Document)EditorImpl.this.myDocument, foldStart, oldEnd);
            if (documentFragment == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseMotionListener", "createDocumentFragment"));
            }
            return documentFragment;
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private MyMouseAdapter() {
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseAdapter", "mousePressed"));
            }
            EditorImpl.this.requestFocus();
            this.runMousePressedCommand(e);
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseAdapter", "mouseReleased"));
            }
            EditorImpl.this.myMousePressArea = null;
            EditorImpl.this.myLastMousePressedLocation = null;
            this.runMouseReleasedCommand(e);
            if (!e.isConsumed() && EditorImpl.this.myMousePressedEvent != null && !EditorImpl.this.myMousePressedEvent.isConsumed() && Math.abs(e.getX() - EditorImpl.this.myMousePressedEvent.getX()) < EditorUtil.getSpaceWidth(0, EditorImpl.this) && Math.abs(e.getY() - EditorImpl.this.myMousePressedEvent.getY()) < EditorImpl.this.getLineHeight()) {
                this.runMouseClickedCommand(e);
            }
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseAdapter", "mouseEntered"));
            }
            this.runMouseEnteredCommand(e);
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseAdapter", "mouseExited"));
            }
            this.runMouseExitedCommand(e);
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            if (event.getArea() == EditorMouseEventArea.LINE_MARKERS_AREA) {
                EditorImpl.this.myGutterComponent.mouseExited(e);
            }
            TooltipController.getInstance().cancelTooltip(FOLDING_TOOLTIP_GROUP, e, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runMousePressedCommand(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseAdapter", "runMousePressedCommand"));
            }
            EditorImpl.this.myLastMousePressedLocation = EditorImpl.this.xyToLogicalPosition(e.getPoint());
            EditorImpl.this.myCaretStateBeforeLastPress = EditorImpl.isToggleCaretEvent(e) ? EditorImpl.this.myCaretModel.getCaretsAndSelections() : Collections.emptyList();
            EditorImpl.this.myCurrentDragIsSubstantial = false;
            EditorImpl.this.clearDnDContext();
            EditorImpl.this.myMousePressedEvent = e;
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            EditorImpl.this.myExpectedCaretOffset = EditorImpl.this.logicalPositionToOffset(EditorImpl.this.myLastMousePressedLocation);
            try {
                for (EditorMouseListener mouseListener : EditorImpl.this.myMouseListeners) {
                    mouseListener.mousePressed(event);
                }
            }
            finally {
                EditorImpl.this.myExpectedCaretOffset = -1;
            }
            if (event.getArea() == EditorMouseEventArea.LINE_MARKERS_AREA || event.getArea() == EditorMouseEventArea.FOLDING_OUTLINE_AREA && !EditorImpl.this.isInsideGutterWhitespaceArea(e)) {
                EditorImpl.this.myDragOnGutterSelectionStartLine = EditorUtil.yPositionToLogicalLine((Editor)EditorImpl.this, e);
            }
            if (event.isConsumed() && !event.getMouseEvent().isPopupTrigger() && event.getArea() != EditorMouseEventArea.EDITING_AREA) {
                return;
            }
            if (EditorImpl.this.myCommandProcessor != null) {
                Runnable runnable2 = () -> {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseAdapter", "lambda$runMousePressedCommand$0"));
                    }
                    if (this.processMousePressed(e) && EditorImpl.this.myProject != null && !EditorImpl.this.myProject.isDefault()) {
                        IdeDocumentHistory.getInstance(EditorImpl.this.myProject).includeCurrentCommandAsNavigation();
                    }
                };
                EditorImpl.this.myCommandProcessor.executeCommand(EditorImpl.this.myProject, runnable2, "", (Object)DocCommandGroupId.noneGroupId((Document)EditorImpl.this.getDocument()), UndoConfirmationPolicy.DEFAULT, (Document)EditorImpl.this.getDocument());
            } else {
                this.processMousePressed(e);
            }
            EditorImpl.this.invokePopupIfNeeded(event);
        }

        private void runMouseClickedCommand(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseAdapter", "runMouseClickedCommand"));
            }
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            for (EditorMouseListener listener2 : EditorImpl.this.myMouseListeners) {
                listener2.mouseClicked(event);
                if (!event.isConsumed()) continue;
                e.consume();
                return;
            }
        }

        private void runMouseReleasedCommand(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseAdapter", "runMouseReleasedCommand"));
            }
            EditorImpl.this.myMultiSelectionInProgress = false;
            EditorImpl.this.myDragOnGutterSelectionStartLine = -1;
            EditorImpl.this.myScrollingTimer.stop();
            if (e.isConsumed()) {
                return;
            }
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            EditorImpl.this.invokePopupIfNeeded(event);
            if (event.isConsumed()) {
                return;
            }
            for (EditorMouseListener listener2 : EditorImpl.this.myMouseListeners) {
                listener2.mouseReleased(event);
                if (!event.isConsumed()) continue;
                e.consume();
                return;
            }
            if (EditorImpl.this.myCommandProcessor != null) {
                Runnable runnable2 = () -> {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseAdapter", "lambda$runMouseReleasedCommand$1"));
                    }
                    EditorImpl.this.processMouseReleased(e);
                };
                EditorImpl.this.myCommandProcessor.executeCommand(EditorImpl.this.myProject, runnable2, "", (Object)DocCommandGroupId.noneGroupId((Document)EditorImpl.this.getDocument()), UndoConfirmationPolicy.DEFAULT, (Document)EditorImpl.this.getDocument());
            } else {
                EditorImpl.this.processMouseReleased(e);
            }
        }

        private void runMouseEnteredCommand(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseAdapter", "runMouseEnteredCommand"));
            }
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            for (EditorMouseListener listener2 : EditorImpl.this.myMouseListeners) {
                listener2.mouseEntered(event);
                if (!event.isConsumed()) continue;
                e.consume();
                return;
            }
        }

        private void runMouseExitedCommand(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseAdapter", "runMouseExitedCommand"));
            }
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            for (EditorMouseListener listener2 : EditorImpl.this.myMouseListeners) {
                listener2.mouseExited(event);
                if (!event.isConsumed()) continue;
                e.consume();
                return;
            }
        }

        private boolean processMousePressed(@NotNull MouseEvent e) {
            boolean isNavigation;
            boolean insideEditorRelatedAreas;
            FoldRegion range;
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseAdapter", "processMousePressed"));
            }
            EditorImpl.this.myInitialMouseEvent = e;
            if (EditorImpl.this.myMouseSelectionState != 0 && System.currentTimeMillis() - EditorImpl.this.myMouseSelectionChangeTimestamp > (long)Registry.intValue((String)"editor.mouseSelectionStateResetTimeout")) {
                EditorImpl.this.resetMouseSelectionState(e);
            }
            int x = e.getX();
            int y = e.getY();
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            EditorMouseEventArea eventArea = EditorImpl.this.getMouseEventArea(e);
            EditorImpl.this.myMousePressArea = eventArea;
            if (eventArea == EditorMouseEventArea.FOLDING_OUTLINE_AREA && (range = EditorImpl.this.myGutterComponent.findFoldingAnchorAt(x, y)) != null) {
                boolean expansion = !range.isExpanded();
                int scrollShift = y - EditorImpl.this.getScrollingModel().getVerticalScrollOffset();
                Runnable processor2 = () -> {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyMouseAdapter", "lambda$processMousePressed$2"));
                    }
                    EditorImpl.this.myFoldingModel.flushCaretShift();
                    range.setExpanded(expansion);
                    if (e.isAltDown()) {
                        for (FoldRegion region : EditorImpl.this.myFoldingModel.getAllFoldRegions()) {
                            if (region.getStartOffset() < range.getStartOffset() || region.getEndOffset() > range.getEndOffset()) continue;
                            region.setExpanded(expansion);
                        }
                    }
                };
                EditorImpl.this.getFoldingModel().runBatchFoldingOperation(processor2);
                y = EditorImpl.this.myGutterComponent.getHeadCenterY(range);
                EditorImpl.this.getScrollingModel().scrollVertically(y - scrollShift);
                EditorImpl.this.myGutterComponent.updateSize();
                EditorImpl.this.validateMousePointer(e);
                e.consume();
                return false;
            }
            if (e.getSource() == EditorImpl.this.myGutterComponent) {
                if (eventArea == EditorMouseEventArea.LINE_MARKERS_AREA || eventArea == EditorMouseEventArea.ANNOTATIONS_AREA || eventArea == EditorMouseEventArea.LINE_NUMBERS_AREA) {
                    if (!EditorImpl.this.tweakSelectionIfNecessary(e)) {
                        EditorImpl.this.myGutterComponent.mousePressed(e);
                    }
                    if (e.isConsumed()) {
                        return false;
                    }
                }
                x = 0;
            }
            int oldSelectionStart = EditorImpl.this.mySelectionModel.getLeadSelectionOffset();
            int oldStart = EditorImpl.this.mySelectionModel.getSelectionStart();
            int oldEnd = EditorImpl.this.mySelectionModel.getSelectionEnd();
            boolean toggleCaret = e.getSource() != EditorImpl.this.myGutterComponent && EditorImpl.isToggleCaretEvent(e);
            boolean lastPressCreatedCaret = EditorImpl.this.myLastPressCreatedCaret;
            if (e.getClickCount() == 1) {
                EditorImpl.this.myLastPressCreatedCaret = false;
            }
            boolean bl = insideEditorRelatedAreas = eventArea == EditorMouseEventArea.LINE_NUMBERS_AREA || eventArea == EditorMouseEventArea.EDITING_AREA || EditorImpl.this.isInsideGutterWhitespaceArea(e);
            if (insideEditorRelatedAreas) {
                VisualPosition visualPosition = EditorImpl.this.getTargetPosition(x, y, true);
                LogicalPosition pos = EditorImpl.this.visualToLogicalPosition(visualPosition);
                if (toggleCaret) {
                    Caret caret = EditorImpl.this.getCaretModel().getCaretAt(visualPosition);
                    if (e.getClickCount() == 1) {
                        if (caret == null) {
                            EditorImpl.this.myLastPressCreatedCaret = EditorImpl.this.getCaretModel().addCaret(visualPosition) != null;
                        } else {
                            EditorImpl.this.getCaretModel().removeCaret(caret);
                        }
                    } else if (e.getClickCount() == 3 && lastPressCreatedCaret) {
                        EditorImpl.this.getCaretModel().moveToVisualPosition(visualPosition);
                    }
                } else if (e.getSource() != EditorImpl.this.myGutterComponent && EditorImpl.isCreateRectangularSelectionEvent(e)) {
                    LogicalPosition anchor;
                    CaretState anchorCaretState = EditorImpl.this.myCaretModel.getCaretsAndSelections().get(0);
                    LogicalPosition logicalPosition = anchor = Objects.equals(anchorCaretState.getCaretPosition(), anchorCaretState.getSelectionStart()) ? anchorCaretState.getSelectionEnd() : anchorCaretState.getSelectionStart();
                    if (anchor == null) {
                        anchor = EditorImpl.this.myCaretModel.getLogicalPosition();
                    }
                    EditorImpl.this.mySelectionModel.setBlockSelection(anchor, pos);
                } else {
                    EditorImpl.this.getCaretModel().removeSecondaryCarets();
                    EditorImpl.this.getCaretModel().moveToVisualPosition(visualPosition);
                }
            }
            if (e.isPopupTrigger()) {
                return false;
            }
            EditorImpl.this.requestFocus();
            int caretOffset = EditorImpl.this.getCaretModel().getOffset();
            int newStart = EditorImpl.this.mySelectionModel.getSelectionStart();
            int newEnd = EditorImpl.this.mySelectionModel.getSelectionEnd();
            EditorImpl.this.myMouseSelectedRegion = EditorImpl.this.myFoldingModel.getFoldingPlaceholderAt(new Point(x, y));
            EditorImpl.this.myMousePressedInsideSelection = EditorImpl.this.mySelectionModel.hasSelection() && caretOffset >= EditorImpl.this.mySelectionModel.getSelectionStart() && caretOffset <= EditorImpl.this.mySelectionModel.getSelectionEnd();
            boolean bl2 = isNavigation = oldStart == oldEnd && newStart == newEnd && oldStart != newStart;
            if (EditorImpl.this.getMouseEventArea(e) == EditorMouseEventArea.LINE_NUMBERS_AREA && e.getClickCount() == 1) {
                EditorImpl.this.mySelectionModel.selectLineAtCaret();
                EditorImpl.this.setMouseSelectionState(2);
                EditorImpl.this.mySavedSelectionStart = EditorImpl.this.mySelectionModel.getSelectionStart();
                EditorImpl.this.mySavedSelectionEnd = EditorImpl.this.mySelectionModel.getSelectionEnd();
                return isNavigation;
            }
            if (insideEditorRelatedAreas) {
                if (e.isShiftDown() && !e.isControlDown() && !e.isAltDown()) {
                    if (EditorImpl.this.getMouseSelectionState() != 0) {
                        if (caretOffset < EditorImpl.this.mySavedSelectionStart) {
                            EditorImpl.this.mySelectionModel.setSelection(EditorImpl.this.mySavedSelectionEnd, caretOffset);
                        } else {
                            EditorImpl.this.mySelectionModel.setSelection(EditorImpl.this.mySavedSelectionStart, caretOffset);
                        }
                    } else {
                        int startToUse = oldSelectionStart;
                        if (EditorImpl.this.mySelectionModel.isUnknownDirection() && caretOffset > startToUse) {
                            startToUse = Math.min(oldStart, oldEnd);
                        }
                        EditorImpl.this.mySelectionModel.setSelection(startToUse, caretOffset);
                    }
                } else if (!EditorImpl.this.myMousePressedInsideSelection && EditorImpl.this.getSelectionModel().hasSelection()) {
                    EditorImpl.this.setMouseSelectionState(0);
                    EditorImpl.this.mySelectionModel.setSelection(caretOffset, caretOffset);
                } else if (!(e.getButton() != 1 || eventArea != EditorMouseEventArea.EDITING_AREA && eventArea != EditorMouseEventArea.LINE_NUMBERS_AREA || toggleCaret && !lastPressCreatedCaret)) {
                    switch (e.getClickCount()) {
                        case 2: {
                            EditorImpl.this.selectWordAtCaret(EditorImpl.this.mySettings.isMouseClickSelectionHonorsCamelWords() && EditorImpl.this.mySettings.isCamelWords());
                            break;
                        }
                        case 3: {
                            if (HONOR_CAMEL_HUMPS_ON_TRIPLE_CLICK && EditorImpl.this.mySettings.isCamelWords()) {
                                EditorImpl.this.selectWordAtCaret(false);
                                break;
                            }
                        }
                        case 4: {
                            EditorImpl.this.mySelectionModel.selectLineAtCaret();
                            EditorImpl.this.setMouseSelectionState(2);
                            EditorImpl.this.mySavedSelectionStart = EditorImpl.this.mySelectionModel.getSelectionStart();
                            EditorImpl.this.mySavedSelectionEnd = EditorImpl.this.mySelectionModel.getSelectionEnd();
                            EditorImpl.this.mySelectionModel.setUnknownDirection(true);
                        }
                    }
                }
            }
            return isNavigation;
        }
    }

    private class MyInputMethodHandler
    implements InputMethodRequests {
        private String composedText;
        private ProperTextRange composedTextRange;

        private MyInputMethodHandler() {
        }

        @Override
        @NotNull
        public Rectangle getTextLocation(TextHitInfo offset) {
            Point caret = EditorImpl.this.logicalPositionToXY(EditorImpl.this.getCaretModel().getLogicalPosition());
            Rectangle r = new Rectangle(caret, new Dimension(1, EditorImpl.this.getLineHeight()));
            Point p = EditorImpl.this.getContentComponent().getLocationOnScreen();
            r.translate(p.x, p.y);
            Rectangle rectangle = r;
            if (rectangle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl$MyInputMethodHandler", "getTextLocation"));
            }
            return rectangle;
        }

        @Override
        @Nullable
        public TextHitInfo getLocationOffset(int x, int y) {
            if (this.composedText != null) {
                Point p = EditorImpl.this.getContentComponent().getLocationOnScreen();
                p.x = x - p.x;
                p.y = y - p.y;
                int pos = EditorImpl.this.logicalPositionToOffset(EditorImpl.this.xyToLogicalPosition(p));
                if (this.composedTextRange.containsOffset(pos)) {
                    return TextHitInfo.leading(pos - this.composedTextRange.getStartOffset());
                }
            }
            return null;
        }

        @Override
        public int getInsertPositionOffset() {
            int caretIndex;
            int composedStartIndex = 0;
            int composedEndIndex = 0;
            if (this.composedText != null) {
                composedStartIndex = this.composedTextRange.getStartOffset();
                composedEndIndex = this.composedTextRange.getEndOffset();
            }
            if ((caretIndex = EditorImpl.this.getCaretModel().getOffset()) < composedStartIndex) {
                return caretIndex;
            }
            if (caretIndex < composedEndIndex) {
                return composedStartIndex;
            }
            return caretIndex - (composedEndIndex - composedStartIndex);
        }

        private String getText(int startIdx, int endIdx) {
            if (startIdx >= 0 && endIdx > startIdx) {
                CharSequence chars = EditorImpl.this.getDocument().getImmutableCharSequence();
                return chars.subSequence(startIdx, endIdx).toString();
            }
            return "";
        }

        @Override
        @NotNull
        public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
            String committed;
            int composedStartIndex = 0;
            int composedEndIndex = 0;
            if (this.composedText != null) {
                composedStartIndex = this.composedTextRange.getStartOffset();
                composedEndIndex = this.composedTextRange.getEndOffset();
            }
            if (beginIndex < composedStartIndex) {
                if (endIndex <= composedStartIndex) {
                    committed = this.getText(beginIndex, endIndex - beginIndex);
                } else {
                    int firstPartLength = composedStartIndex - beginIndex;
                    committed = this.getText(beginIndex, firstPartLength) + this.getText(composedEndIndex, endIndex - beginIndex - firstPartLength);
                }
            } else {
                committed = this.getText(beginIndex + composedEndIndex - composedStartIndex, endIndex - beginIndex);
            }
            AttributedCharacterIterator attributedCharacterIterator = new AttributedString(committed).getIterator();
            if (attributedCharacterIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl$MyInputMethodHandler", "getCommittedText"));
            }
            return attributedCharacterIterator;
        }

        @Override
        public int getCommittedTextLength() {
            int length = EditorImpl.this.getDocument().getTextLength();
            if (this.composedText != null) {
                length -= this.composedText.length();
            }
            return length;
        }

        @Override
        @Nullable
        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }

        @Override
        @Nullable
        public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
            String text2;
            if (EditorImpl.this.myCharKeyPressed) {
                EditorImpl.this.myNeedToSelectPreviousChar = true;
            }
            return (text2 = EditorImpl.this.getSelectionModel().getSelectedText()) == null ? null : new AttributedString(text2).getIterator();
        }

        private void createComposedString(int composedIndex, @NotNull AttributedCharacterIterator text2) {
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/EditorImpl$MyInputMethodHandler", "createComposedString"));
            }
            StringBuffer strBuf = new StringBuffer();
            char c = text2.setIndex(composedIndex);
            while (c != '\uffff') {
                strBuf.append(c);
                c = text2.next();
            }
            this.composedText = new String(strBuf);
        }

        private void setInputMethodCaretPosition(@NotNull InputMethodEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyInputMethodHandler", "setInputMethodCaretPosition"));
            }
            if (this.composedText != null) {
                int dot = this.composedTextRange.getStartOffset();
                TextHitInfo caretPos = e.getCaret();
                if (caretPos != null) {
                    dot += caretPos.getInsertionIndex();
                }
                EditorImpl.this.getCaretModel().moveToOffset(dot);
                EditorImpl.this.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        }

        private void runUndoTransparent(@NotNull Runnable runnable2) {
            if (runnable2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/editor/impl/EditorImpl$MyInputMethodHandler", "runUndoTransparent"));
            }
            CommandProcessor.getInstance().runUndoTransparentAction(() -> {
                if (runnable2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/editor/impl/EditorImpl$MyInputMethodHandler", "lambda$runUndoTransparent$1"));
                }
                CommandProcessor.getInstance().executeCommand(EditorImpl.this.myProject, () -> {
                    if (runnable2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/editor/impl/EditorImpl$MyInputMethodHandler", "lambda$null$0"));
                    }
                    ApplicationManager.getApplication().runWriteAction(runnable2);
                }, "", (Object)EditorImpl.this.getDocument(), UndoConfirmationPolicy.DEFAULT, (Document)EditorImpl.this.getDocument());
            });
        }

        private void replaceInputMethodText(@NotNull InputMethodEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyInputMethodHandler", "replaceInputMethodText"));
            }
            if (EditorImpl.this.myNeedToSelectPreviousChar && SystemInfo.isMac && (Registry.is((String)"ide.mac.pressAndHold.brute.workaround") || Registry.is((String)"ide.mac.pressAndHold.workaround") && (e.getCommittedCharacterCount() > 0 || e.getCaret() == null))) {
                EditorImpl.this.myNeedToSelectPreviousChar = false;
                EditorImpl.this.getCaretModel().runForEachCaret(caret -> {
                    int caretOffset = caret.getOffset();
                    if (caretOffset > 0) {
                        caret.setSelection(caretOffset - 1, caretOffset);
                    }
                });
            }
            int commitCount = e.getCommittedCharacterCount();
            AttributedCharacterIterator text2 = e.getText();
            DocumentEx doc = EditorImpl.this.getDocument();
            if (this.composedText != null) {
                if (!EditorImpl.this.isViewer() && doc.isWritable()) {
                    this.runUndoTransparent(() -> {
                        int docLength = doc.getTextLength();
                        ProperTextRange range = this.composedTextRange.intersection(new TextRange(0, docLength));
                        if (range != null) {
                            doc.deleteString(range.getStartOffset(), range.getEndOffset());
                        }
                    });
                }
                this.composedText = null;
            }
            if (text2 != null) {
                int composedTextIndex;
                text2.first();
                if (commitCount > 0) {
                    char c = text2.current();
                    while (commitCount > 0) {
                        if (c >= ' ' && c != '\u007f') {
                            EditorImpl.this.processKeyTyped(c);
                        }
                        c = text2.next();
                        --commitCount;
                    }
                }
                if (!EditorImpl.this.isViewer() && doc.isWritable() && (composedTextIndex = text2.getIndex()) < text2.getEndIndex()) {
                    this.createComposedString(composedTextIndex, text2);
                    this.runUndoTransparent(() -> EditorModificationUtil.insertStringAtCaret((Editor)EditorImpl.this, (String)this.composedText, (boolean)false, (boolean)false));
                    this.composedTextRange = ProperTextRange.from((int)EditorImpl.this.getCaretModel().getOffset(), (int)this.composedText.length());
                }
            }
        }
    }

    private static class MyInputMethodHandleSwingThreadWrapper
    implements InputMethodRequests {
        private final InputMethodRequests myDelegate;

        private MyInputMethodHandleSwingThreadWrapper(InputMethodRequests delegate) {
            this.myDelegate = delegate;
        }

        @Override
        @NotNull
        public Rectangle getTextLocation(TextHitInfo offset) {
            Rectangle rectangle = (Rectangle)MyInputMethodHandleSwingThreadWrapper.execute(() -> this.myDelegate.getTextLocation(offset));
            if (rectangle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl$MyInputMethodHandleSwingThreadWrapper", "getTextLocation"));
            }
            return rectangle;
        }

        @Override
        public TextHitInfo getLocationOffset(int x, int y) {
            return (TextHitInfo)MyInputMethodHandleSwingThreadWrapper.execute(() -> this.myDelegate.getLocationOffset(x, y));
        }

        @Override
        public int getInsertPositionOffset() {
            return (Integer)MyInputMethodHandleSwingThreadWrapper.execute(this.myDelegate::getInsertPositionOffset);
        }

        @Override
        @NotNull
        public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
            AttributedCharacterIterator attributedCharacterIterator = (AttributedCharacterIterator)MyInputMethodHandleSwingThreadWrapper.execute(() -> this.myDelegate.getCommittedText(beginIndex, endIndex, attributes));
            if (attributedCharacterIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorImpl$MyInputMethodHandleSwingThreadWrapper", "getCommittedText"));
            }
            return attributedCharacterIterator;
        }

        @Override
        public int getCommittedTextLength() {
            return (Integer)MyInputMethodHandleSwingThreadWrapper.execute(this.myDelegate::getCommittedTextLength);
        }

        @Override
        @Nullable
        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }

        @Override
        public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
            return (AttributedCharacterIterator)MyInputMethodHandleSwingThreadWrapper.execute(() -> this.myDelegate.getSelectedText(attributes));
        }

        private static <T> T execute(Computable<T> computable) {
            return (T)UIUtil.invokeAndWaitIfNeeded(computable);
        }
    }

    private class MyEditable
    implements CutProvider,
    CopyProvider,
    PasteProvider,
    DeleteProvider,
    DumbAware {
        private MyEditable() {
        }

        public void performCopy(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/impl/EditorImpl$MyEditable", "performCopy"));
            }
            this.executeAction("EditorCopy", dataContext);
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/impl/EditorImpl$MyEditable", "isCopyEnabled"));
            }
            return true;
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/impl/EditorImpl$MyEditable", "isCopyVisible"));
            }
            return EditorImpl.this.getSelectionModel().hasSelection(true);
        }

        public void performCut(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/impl/EditorImpl$MyEditable", "performCut"));
            }
            this.executeAction("EditorCut", dataContext);
        }

        public boolean isCutEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/impl/EditorImpl$MyEditable", "isCutEnabled"));
            }
            return !EditorImpl.this.isViewer();
        }

        public boolean isCutVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/impl/EditorImpl$MyEditable", "isCutVisible"));
            }
            return this.isCutEnabled(dataContext) && EditorImpl.this.getSelectionModel().hasSelection(true);
        }

        public void performPaste(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/impl/EditorImpl$MyEditable", "performPaste"));
            }
            this.executeAction("EditorPaste", dataContext);
        }

        public boolean isPastePossible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/impl/EditorImpl$MyEditable", "isPastePossible"));
            }
            return !EditorImpl.this.isViewer();
        }

        public boolean isPasteEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/impl/EditorImpl$MyEditable", "isPasteEnabled"));
            }
            return !EditorImpl.this.isViewer();
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/impl/EditorImpl$MyEditable", "deleteElement"));
            }
            this.executeAction("EditorDelete", dataContext);
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/impl/EditorImpl$MyEditable", "canDeleteElement"));
            }
            return !EditorImpl.this.isViewer();
        }

        private void executeAction(@NotNull String actionId, @NotNull DataContext dataContext) {
            if (actionId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/editor/impl/EditorImpl$MyEditable", "executeAction"));
            }
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/impl/EditorImpl$MyEditable", "executeAction"));
            }
            EditorAction action = (EditorAction)ActionManager.getInstance().getAction(actionId);
            if (action != null) {
                action.actionPerformed((Editor)EditorImpl.this, dataContext);
            }
        }
    }

    private static class EditorScrollBarUI
    extends ButtonlessScrollBarUI.Transparent {
        @NotNull
        private final EditorImpl myEditor;

        EditorScrollBarUI(@NotNull EditorImpl editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorImpl$EditorScrollBarUI", "<init>"));
            }
            this.myEditor = editor;
        }

        protected boolean isDark() {
            return this.myEditor.isDarkEnough();
        }

        protected Color adjustColor(Color c) {
            return this.isMacOverlayScrollbar() ? super.adjustColor(c) : EditorImpl.adjustThumbColor(super.adjustColor(c), this.isDark());
        }
    }

    class MyScrollBar
    extends OpaqueAwareScrollBar {
        @NonNls
        private static final String APPLE_LAF_AQUA_SCROLL_BAR_UI_CLASS = "apple.laf.AquaScrollBarUI";
        private ScrollBarUI myPersistentUI;

        private MyScrollBar(int orientation) {
            super(orientation);
            this.setPersistentUI(EditorImpl.createEditorScrollbarUI(EditorImpl.this));
        }

        void setPersistentUI(ScrollBarUI ui) {
            this.myPersistentUI = ui;
            this.setUI(ui);
        }

        public void setUI(ScrollBarUI ui) {
            if (this.myPersistentUI == null) {
                this.myPersistentUI = ui;
            }
            super.setUI(this.myPersistentUI);
        }

        int getDecScrollButtonHeight() {
            ScrollBarUI barUI = this.getUI();
            Insets insets = this.getInsets();
            int top = Math.max(0, insets.top);
            if (barUI instanceof ButtonlessScrollBarUI) {
                return top + ((ButtonlessScrollBarUI)barUI).getDecrementButtonHeight();
            }
            if (barUI instanceof BasicScrollBarUI) {
                try {
                    JButton decrButtonValue = (JButton)decrButtonField.get(barUI);
                    LOG.assertTrue(decrButtonValue != null);
                    return top + decrButtonValue.getHeight();
                }
                catch (Exception exc) {
                    throw new IllegalStateException(exc);
                }
            }
            return top + 15;
        }

        int getIncScrollButtonHeight() {
            ScrollBarUI barUI = this.getUI();
            Insets insets = this.getInsets();
            if (barUI instanceof ButtonlessScrollBarUI) {
                return insets.top + ((ButtonlessScrollBarUI)barUI).getIncrementButtonHeight();
            }
            if (barUI instanceof BasicScrollBarUI) {
                try {
                    JButton incrButtonValue = (JButton)incrButtonField.get(barUI);
                    LOG.assertTrue(incrButtonValue != null);
                    return insets.bottom + incrButtonValue.getHeight();
                }
                catch (Exception exc) {
                    throw new IllegalStateException(exc);
                }
            }
            if (APPLE_LAF_AQUA_SCROLL_BAR_UI_CLASS.equals(barUI.getClass().getName())) {
                return insets.bottom + 30;
            }
            return insets.bottom + 15;
        }

        public int getUnitIncrement(int direction) {
            JViewport vp = EditorImpl.this.myScrollPane.getViewport();
            Rectangle vr = vp.getViewRect();
            return EditorImpl.this.myEditorComponent.getScrollableUnitIncrement(vr, 1, direction);
        }

        public int getBlockIncrement(int direction) {
            JViewport vp = EditorImpl.this.myScrollPane.getViewport();
            Rectangle vr = vp.getViewRect();
            return EditorImpl.this.myEditorComponent.getScrollableBlockIncrement(vr, 1, direction);
        }

        private void registerRepaintCallback(@Nullable ButtonlessScrollBarUI.ScrollbarRepaintCallback callback) {
            if (this.myPersistentUI instanceof ButtonlessScrollBarUI) {
                ((ButtonlessScrollBarUI)this.myPersistentUI).registerRepaintCallback(callback);
            }
        }
    }

    private class OpaqueAwareScrollBar
    extends JBScrollBar {
        private boolean myOpaque;

        private OpaqueAwareScrollBar(int orientation) {
            super(orientation);
            this.addPropertyChangeListener("opaque", event -> {
                this.revalidate();
                this.repaint();
            });
        }

        public void setOpaque(boolean opaque) {
            this.myOpaque = opaque;
            super.setOpaque(opaque || EditorImpl.this.shouldScrollBarBeOpaque());
        }

        public boolean isOptimizedDrawingEnabled() {
            return !EditorImpl.this.myBackgroundImageSet;
        }
    }

    private class ScrollingTimer {
        private Timer myTimer;
        private static final int TIMER_PERIOD = 100;
        private static final int CYCLE_SIZE = 20;
        private int myXCycles;
        private int myYCycles;
        private int myDx;
        private int myDy;
        private int xPassedCycles;
        private int yPassedCycles;

        private ScrollingTimer() {
        }

        private void start(int dx, int dy) {
            this.myDx = 0;
            this.myDy = 0;
            if (dx > 0) {
                this.myXCycles = 20 / dx + 1;
                this.myDx = 1 + dx / 20;
            } else if (dx < 0) {
                this.myXCycles = -20 / dx + 1;
                this.myDx = -1 + dx / 20;
            }
            if (dy > 0) {
                this.myYCycles = 20 / dy + 1;
                this.myDy = 1 + dy / 20;
            } else if (dy < 0) {
                this.myYCycles = -20 / dy + 1;
                this.myDy = -1 + dy / 20;
            }
            if (this.myTimer != null) {
                return;
            }
            this.myTimer = UIUtil.createNamedTimer((String)"Editor scroll timer", (int)100, e -> {
                if (EditorImpl.this.isDisposed()) {
                    this.stop();
                    return;
                }
                EditorImpl.this.myCommandProcessor.executeCommand(EditorImpl.this.myProject, (Runnable)new DocumentRunnable(EditorImpl.this.myDocument, EditorImpl.this.myProject){

                    public void run() {
                        int oldSelectionStart = EditorImpl.this.mySelectionModel.getLeadSelectionOffset();
                        VisualPosition caretPosition = EditorImpl.this.myMultiSelectionInProgress ? EditorImpl.this.myTargetMultiSelectionPosition : EditorImpl.this.getCaretModel().getVisualPosition();
                        int column = caretPosition.column;
                        ScrollingTimer.this.xPassedCycles++;
                        if (ScrollingTimer.this.xPassedCycles >= ScrollingTimer.this.myXCycles) {
                            ScrollingTimer.this.xPassedCycles = 0;
                            column += ScrollingTimer.this.myDx;
                        }
                        int line = caretPosition.line;
                        ScrollingTimer.this.yPassedCycles++;
                        if (ScrollingTimer.this.yPassedCycles >= ScrollingTimer.this.myYCycles) {
                            ScrollingTimer.this.yPassedCycles = 0;
                            line += ScrollingTimer.this.myDy;
                        }
                        line = Math.max(0, line);
                        column = Math.max(0, column);
                        VisualPosition pos = new VisualPosition(line, column);
                        if (!EditorImpl.this.myMultiSelectionInProgress) {
                            EditorImpl.this.getCaretModel().moveToVisualPosition(pos);
                            EditorImpl.this.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                        }
                        int newCaretOffset = EditorImpl.this.getCaretModel().getOffset();
                        int caretShift = newCaretOffset - EditorImpl.this.mySavedSelectionStart;
                        if (EditorImpl.this.getMouseSelectionState() != 0) {
                            if (caretShift < 0) {
                                int newSelection = newCaretOffset;
                                if (EditorImpl.this.getMouseSelectionState() == 1) {
                                    newSelection = EditorImpl.this.myCaretModel.getWordAtCaretStart();
                                } else if (EditorImpl.this.getMouseSelectionState() == 2) {
                                    newSelection = EditorImpl.this.logicalPositionToOffset(EditorImpl.this.visualToLogicalPosition(new VisualPosition(EditorImpl.this.getCaretModel().getVisualPosition().line, 0)));
                                }
                                if (newSelection < 0) {
                                    newSelection = newCaretOffset;
                                }
                                EditorImpl.this.mySelectionModel.setSelection(ScrollingTimer.this.validateOffset(EditorImpl.this.mySavedSelectionEnd), newSelection);
                                EditorImpl.this.getCaretModel().moveToOffset(newSelection);
                            } else {
                                int newSelection = newCaretOffset;
                                if (EditorImpl.this.getMouseSelectionState() == 1) {
                                    newSelection = EditorImpl.this.myCaretModel.getWordAtCaretEnd();
                                } else if (EditorImpl.this.getMouseSelectionState() == 2) {
                                    newSelection = EditorImpl.this.logicalPositionToOffset(EditorImpl.this.visualToLogicalPosition(new VisualPosition(EditorImpl.this.getCaretModel().getVisualPosition().line + 1, 0)));
                                }
                                if (newSelection < 0) {
                                    newSelection = newCaretOffset;
                                }
                                EditorImpl.this.mySelectionModel.setSelection(ScrollingTimer.this.validateOffset(EditorImpl.this.mySavedSelectionStart), newSelection);
                                EditorImpl.this.getCaretModel().moveToOffset(newSelection);
                            }
                            return;
                        }
                        if (EditorImpl.this.myMultiSelectionInProgress && EditorImpl.this.myLastMousePressedLocation != null) {
                            EditorImpl.this.myTargetMultiSelectionPosition = pos;
                            LogicalPosition newLogicalPosition = EditorImpl.this.visualToLogicalPosition(pos);
                            EditorImpl.this.getScrollingModel().scrollTo(newLogicalPosition, ScrollType.RELATIVE);
                            EditorImpl.this.createSelectionTill(newLogicalPosition);
                        } else {
                            EditorImpl.this.mySelectionModel.setSelection(oldSelectionStart, EditorImpl.this.getCaretModel().getOffset());
                        }
                    }
                }, EditorBundle.message((String)"move.cursor.command.name", (Object[])new Object[0]), (Object)DocCommandGroupId.noneGroupId((Document)EditorImpl.this.getDocument()), UndoConfirmationPolicy.DEFAULT, (Document)EditorImpl.this.getDocument());
            });
            this.myTimer.start();
        }

        private void stop() {
            if (this.myTimer != null) {
                this.myTimer.stop();
                this.myTimer = null;
            }
        }

        private int validateOffset(int offset) {
            if (offset < 0) {
                return 0;
            }
            if (offset > EditorImpl.this.myDocument.getTextLength()) {
                return EditorImpl.this.myDocument.getTextLength();
            }
            return offset;
        }
    }

    class CaretCursor {
        private CaretRectangle[] myLocations = new CaretRectangle[]{new CaretRectangle(new Point(0, 0), 0, null, false)};
        private boolean myEnabled;
        private boolean myIsShown;
        private long myStartTime;

        private CaretCursor() {
            this.setEnabled(true);
        }

        public boolean isEnabled() {
            return this.myEnabled;
        }

        public void setEnabled(boolean enabled) {
            this.myEnabled = enabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void activate() {
            boolean blink = EditorImpl.this.mySettings.isBlinkCaret();
            int blinkPeriod = EditorImpl.this.mySettings.getCaretBlinkPeriod();
            RepaintCursorCommand repaintCursorCommand = ourCaretBlinkingCommand;
            synchronized (repaintCursorCommand) {
                ourCaretBlinkingCommand.myEditor = EditorImpl.this;
                ourCaretBlinkingCommand.setBlinkCaret(blink);
                ourCaretBlinkingCommand.setBlinkPeriod(blinkPeriod);
                this.myIsShown = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isActive() {
            RepaintCursorCommand repaintCursorCommand = ourCaretBlinkingCommand;
            synchronized (repaintCursorCommand) {
                return this.myIsShown;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void passivate() {
            RepaintCursorCommand repaintCursorCommand = ourCaretBlinkingCommand;
            synchronized (repaintCursorCommand) {
                this.myIsShown = false;
            }
        }

        private void setPositions(CaretRectangle[] locations) {
            this.myStartTime = System.currentTimeMillis();
            this.myLocations = locations;
            this.myIsShown = true;
        }

        private void repaint() {
            EditorImpl.this.myView.repaintCarets();
        }

        @Nullable
        CaretRectangle[] getCaretLocations(boolean onlyIfShown) {
            if (!(!onlyIfShown || this.isEnabled() && this.myIsShown && !EditorImpl.this.isRendererMode() && IJSwingUtilities.hasFocus(EditorImpl.this.getContentComponent()))) {
                return null;
            }
            return this.myLocations;
        }
    }

    public static class CaretRectangle {
        public final Point myPoint;
        public final int myWidth;
        public final Caret myCaret;
        public final boolean myIsRtl;

        private CaretRectangle(Point point, int width, Caret caret, boolean isRtl) {
            this.myPoint = point;
            this.myWidth = Math.max(width, 2);
            this.myCaret = caret;
            this.myIsRtl = isRtl;
        }
    }

    private static class RepaintCursorCommand
    implements Runnable {
        private long mySleepTime = 500L;
        private boolean myIsBlinkCaret = true;
        @Nullable
        private EditorImpl myEditor;
        private ScheduledFuture<?> mySchedulerHandle;

        private RepaintCursorCommand() {
        }

        public void start() {
            if (this.mySchedulerHandle != null) {
                this.mySchedulerHandle.cancel(false);
            }
            this.mySchedulerHandle = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(this, this.mySleepTime, this.mySleepTime, TimeUnit.MILLISECONDS);
        }

        private void setBlinkPeriod(int blinkPeriod) {
            this.mySleepTime = blinkPeriod > 10 ? (long)blinkPeriod : 10L;
            this.start();
        }

        private void setBlinkCaret(boolean value2) {
            this.myIsBlinkCaret = value2;
        }

        @Override
        public void run() {
            if (this.myEditor != null) {
                CaretCursor activeCursor = this.myEditor.myCaretCursor;
                long time = System.currentTimeMillis();
                if ((time -= activeCursor.myStartTime) > this.mySleepTime) {
                    boolean toRepaint = true;
                    if (this.myIsBlinkCaret) {
                        activeCursor.myIsShown = !activeCursor.myIsShown;
                    } else {
                        toRepaint = !activeCursor.myIsShown;
                        activeCursor.myIsShown = true;
                    }
                    if (toRepaint) {
                        activeCursor.repaint();
                    }
                }
            }
        }
    }

    private static @interface MouseSelectionState {
    }
}

