/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy.view;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.richcopy.model.SyntaxInfo;
import com.intellij.openapi.editor.richcopy.view.RawTextWithMarkup;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.StringBuilderSpinAllocator;
import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSyntaxAwareReaderTransferableData
extends Reader
implements RawTextWithMarkup {
    private static final Logger LOG = Logger.getInstance(AbstractSyntaxAwareReaderTransferableData.class);
    protected String myRawText;
    @NotNull
    protected final SyntaxInfo mySyntaxInfo;
    @NotNull
    private final DataFlavor myDataFlavor;
    @Nullable
    private transient Reader myDelegate;

    public AbstractSyntaxAwareReaderTransferableData(@NotNull SyntaxInfo syntaxInfo, @NotNull DataFlavor dataFlavor) {
        if (syntaxInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syntaxInfo", "com/intellij/openapi/editor/richcopy/view/AbstractSyntaxAwareReaderTransferableData", "<init>"));
        }
        if (dataFlavor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlavor", "com/intellij/openapi/editor/richcopy/view/AbstractSyntaxAwareReaderTransferableData", "<init>"));
        }
        this.mySyntaxInfo = syntaxInfo;
        this.myDataFlavor = dataFlavor;
    }

    @Override
    public DataFlavor getFlavor() {
        return this.myDataFlavor;
    }

    @Override
    public int getOffsetCount() {
        return 0;
    }

    @Override
    public int getOffsets(int[] offsets, int index) {
        return index;
    }

    @Override
    public int setOffsets(int[] offsets, int index) {
        return index;
    }

    @Override
    public int read() throws IOException {
        return this.getDelegate().read();
    }

    @Override
    public int read(@NotNull char[] cbuf, int off, int len) throws IOException {
        if (cbuf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cbuf", "com/intellij/openapi/editor/richcopy/view/AbstractSyntaxAwareReaderTransferableData", "read"));
        }
        return this.getDelegate().read(cbuf, off, len);
    }

    @Override
    public void close() throws IOException {
        this.myDelegate = null;
    }

    @Override
    public void setRawText(String rawText) {
        this.myRawText = rawText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Reader getDelegate() {
        if (this.myDelegate != null) {
            Reader reader = this.myDelegate;
            if (reader == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/richcopy/view/AbstractSyntaxAwareReaderTransferableData", "getDelegate"));
            }
            return reader;
        }
        int maxLength = Registry.intValue((String)"editor.richcopy.max.size.megabytes") * 0x100000;
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            this.build(buffer, maxLength);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        String s = buffer.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resulting text: \n" + s);
        }
        Reader reader = this.myDelegate = new StringReader(s);
        Reader reader2 = reader;
        if (reader2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/richcopy/view/AbstractSyntaxAwareReaderTransferableData", "getDelegate"));
        }
        return reader2;
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
    }

    protected abstract void build(@NotNull StringBuilder var1, int var2);
}

