/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ImportModuleAction;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.wizard.AbstractExternalProjectImportProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.projectImport.ProjectImportProvider;

public class AttachExternalProjectAction
extends AnAction {
    public AttachExternalProjectAction() {
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.attach.external.project.text", (Object[])new Object[]{"external"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.attach.external.project.description", (Object[])new Object[]{"external"}));
    }

    public void update(AnActionEvent e) {
        ProjectSystemId externalSystemId = (ProjectSystemId)ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID.getData(e.getDataContext());
        if (externalSystemId != null) {
            String name2 = externalSystemId.getReadableName();
            e.getPresentation().setText(ExternalSystemBundle.message((String)"action.attach.external.project.text", (Object[])new Object[]{name2}));
            e.getPresentation().setDescription(ExternalSystemBundle.message((String)"action.attach.external.project.description", (Object[])new Object[]{name2}));
        }
        e.getPresentation().setIcon(SystemInfoRt.isMac ? AllIcons.ToolbarDecorator.Mac.Add : AllIcons.ToolbarDecorator.Add);
    }

    public void actionPerformed(AnActionEvent e) {
        ProjectSystemId externalSystemId = (ProjectSystemId)ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID.getData(e.getDataContext());
        if (externalSystemId == null) {
            return;
        }
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        if (manager == null) {
            return;
        }
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        ProjectImportProvider[] projectImportProviders = new ProjectImportProvider[1];
        for (ProjectImportProvider provider : (ProjectImportProvider[])ProjectImportProvider.PROJECT_IMPORT_PROVIDER.getExtensions()) {
            if (!(provider instanceof AbstractExternalProjectImportProvider) || !externalSystemId.equals((Object)((AbstractExternalProjectImportProvider)provider).getExternalSystemId())) continue;
            projectImportProviders[0] = provider;
            break;
        }
        if (projectImportProviders[0] == null) {
            return;
        }
        AddModuleWizard wizard = ImportModuleAction.selectFileAndCreateWizard(project2, null, manager.getExternalProjectDescriptor(), projectImportProviders);
        if (wizard != null && (wizard.getStepCount() <= 0 || wizard.showAndGet())) {
            ImportModuleAction.createFromWizard(project2, wizard);
        }
    }
}

