/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.action.ExternalSystemToggleAction;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ModuleNode;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class IgnoreExternalProjectAction
extends ExternalSystemToggleAction {
    private static final Logger LOG = Logger.getInstance(IgnoreExternalProjectAction.class);

    public IgnoreExternalProjectAction() {
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.ignore.external.project.text", (Object[])new Object[]{"external"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.ignore.external.project.description", (Object[])new Object[]{"external"}));
    }

    public void setSelected(AnActionEvent e, boolean state) {
        ProjectSystemId projectSystemId = this.getSystemId(e);
        ExternalSystemNode<ExternalConfigPathAware> projectNode = IgnoreExternalProjectAction.getProjectNode(e);
        if (projectSystemId == null || projectNode == null || projectNode.getData() == null) {
            return;
        }
        projectNode.setIgnored(state);
        Project project2 = this.getProject(e);
        String externalProjectPath = projectNode.getData().getLinkedExternalProjectPath();
        ExternalProjectInfo externalProjectInfo = ExternalSystemUtil.getExternalProjectInfo(project2, projectSystemId, externalProjectPath);
        if (externalProjectInfo == null || externalProjectInfo.getExternalProjectStructure() == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("external project data not found, path: %s, data: %s", externalProjectPath, externalProjectInfo));
            }
            return;
        }
        DataNode projectDataNode = externalProjectInfo.getExternalProjectStructure();
        ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(projectDataNode, project2, true);
    }

    @Override
    public boolean isSelected(AnActionEvent e) {
        String systemIdName;
        boolean selected = super.isSelected(e);
        ProjectSystemId systemId = this.getSystemId(e);
        String string = systemIdName = systemId != null ? systemId.getReadableName() : "external";
        if (selected) {
            this.setText(e, ExternalSystemBundle.message((String)"action.unignore.external.project.text", (Object[])new Object[]{systemIdName}));
            this.setDescription(e, ExternalSystemBundle.message((String)"action.unignore.external.project.description", (Object[])new Object[]{systemIdName}));
        } else {
            this.setText(e, ExternalSystemBundle.message((String)"action.ignore.external.project.text", (Object[])new Object[]{systemIdName}));
            this.setDescription(e, ExternalSystemBundle.message((String)"action.ignore.external.project.description", (Object[])new Object[]{systemIdName}));
        }
        return selected;
    }

    @Override
    protected boolean isEnabled(AnActionEvent e) {
        if (!super.isEnabled(e)) {
            return false;
        }
        return IgnoreExternalProjectAction.getProjectNode(e) != null;
    }

    @Override
    protected boolean doIsSelected(AnActionEvent e) {
        ExternalSystemNode<ExternalConfigPathAware> projectNode = IgnoreExternalProjectAction.getProjectNode(e);
        if (projectNode == null) {
            return false;
        }
        return projectNode.isIgnored();
    }

    @Nullable
    private static ExternalSystemNode<ExternalConfigPathAware> getProjectNode(AnActionEvent e) {
        List selectedNodes = (List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext());
        if (selectedNodes == null || selectedNodes.size() != 1) {
            return null;
        }
        ExternalSystemNode node = (ExternalSystemNode)selectedNodes.get(0);
        return node instanceof ModuleNode || node instanceof ProjectNode ? node : null;
    }
}

