/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.settings;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import java.awt.Color;
import java.util.Arrays;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public final class LocationSettingType
extends Enum<LocationSettingType> {
    public static final /* enum */ LocationSettingType DEDUCED = new LocationSettingType("setting.type.location.deduced", "TextField.inactiveForeground", "nimbusDisabledText");
    public static final /* enum */ LocationSettingType UNKNOWN = new LocationSettingType("setting.type.location.unknown");
    public static final /* enum */ LocationSettingType EXPLICIT_INCORRECT = new LocationSettingType("setting.type.location.explicit.incorrect");
    public static final /* enum */ LocationSettingType EXPLICIT_CORRECT = new LocationSettingType("setting.type.location.explicit.correct");
    @NotNull
    private final String myDescriptionKey;
    @NotNull
    private final Color myColor;
    private static final /* synthetic */ LocationSettingType[] $VALUES;

    public static LocationSettingType[] values() {
        return (LocationSettingType[])$VALUES.clone();
    }

    public static LocationSettingType valueOf(String name2) {
        return Enum.valueOf(LocationSettingType.class, name2);
    }

    private LocationSettingType(String descriptionKey) {
        if (descriptionKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptionKey", "com/intellij/openapi/externalSystem/model/settings/LocationSettingType", "<init>"));
        }
        this(descriptionKey, "TextField.foreground");
    }

    private LocationSettingType(String descriptionKey, String ... colorKeys) {
        String key2;
        if (descriptionKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptionKey", "com/intellij/openapi/externalSystem/model/settings/LocationSettingType", "<init>"));
        }
        if (colorKeys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorKeys", "com/intellij/openapi/externalSystem/model/settings/LocationSettingType", "<init>"));
        }
        this.myDescriptionKey = descriptionKey;
        Color c = null;
        String[] stringArray = colorKeys;
        int n2 = stringArray.length;
        for (int j = 0; j < n2 && (c = UIManager.getColor(key2 = stringArray[j])) == null; ++j) {
        }
        assert (c != null) : "Can't find color for keys " + Arrays.toString(colorKeys);
        this.myColor = c;
    }

    public String getDescription(@NotNull ProjectSystemId externalSystemId) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/model/settings/LocationSettingType", "getDescription"));
        }
        return ExternalSystemBundle.message((String)this.myDescriptionKey, (Object[])new Object[]{externalSystemId.getReadableName()});
    }

    @NotNull
    public Color getColor() {
        Color color = this.myColor;
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/settings/LocationSettingType", "getColor"));
        }
        return color;
    }

    static {
        $VALUES = new LocationSettingType[]{DEDUCED, UNKNOWN, EXPLICIT_INCORRECT, EXPLICIT_CORRECT};
    }
}

