/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkException;
import com.intellij.openapi.externalSystem.service.execution.InvalidJavaHomeException;
import com.intellij.openapi.externalSystem.service.execution.InvalidSdkException;
import com.intellij.openapi.externalSystem.service.execution.ProjectJdkNotFoundException;
import com.intellij.openapi.externalSystem.service.execution.UndefinedJavaHomeException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemJdkUtil {
    public static final String USE_INTERNAL_JAVA = "#JAVA_INTERNAL";
    public static final String USE_PROJECT_JDK = "#USE_PROJECT_JDK";
    public static final String USE_JAVA_HOME = "#JAVA_HOME";

    @Nullable
    public static Sdk getJdk(@Nullable Project project2, @Nullable String jdkName) throws ExternalSystemJdkException {
        if (jdkName == null) {
            return null;
        }
        if (USE_INTERNAL_JAVA.equals(jdkName)) {
            return JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
        }
        if (USE_PROJECT_JDK.equals(jdkName)) {
            if (project2 != null) {
                Module[] modules;
                Sdk res = ProjectRootManager.getInstance((Project)project2).getProjectSdk();
                if (res != null) {
                    return res;
                }
                for (Module module2 : modules = ModuleManager.getInstance((Project)project2).getModules()) {
                    Sdk sdk = ModuleRootManager.getInstance((Module)module2).getSdk();
                    if (sdk == null || !(sdk.getSdkType() instanceof JavaSdkType)) continue;
                    return sdk;
                }
            }
            if (project2 == null) {
                Sdk recent = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)JavaSdk.getInstance());
                return recent != null ? recent : JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
            }
            throw new ProjectJdkNotFoundException();
        }
        if (USE_JAVA_HOME.equals(jdkName)) {
            String javaHome = System.getenv("JAVA_HOME");
            if (StringUtil.isEmptyOrSpaces((String)javaHome)) {
                throw new UndefinedJavaHomeException();
            }
            if (!ExternalSystemJdkUtil.isValidJdk(javaHome)) {
                throw new InvalidJavaHomeException(javaHome);
            }
            return JavaSdk.getInstance().createJdk("", javaHome);
        }
        Sdk projectJdk = ProjectJdkTable.getInstance().findJdk(jdkName);
        if (projectJdk != null) {
            String homePath = projectJdk.getHomePath();
            if (!ExternalSystemJdkUtil.isValidJdk(homePath)) {
                throw new InvalidSdkException(homePath);
            }
            return projectJdk;
        }
        return null;
    }

    @NotNull
    public static Pair<String, Sdk> getAvailableJdk(@Nullable Project project2) throws ExternalSystemJdkException {
        String javaHome;
        if (project2 != null) {
            Module[] modules;
            Sdk res = ProjectRootManager.getInstance((Project)project2).getProjectSdk();
            if (res != null) {
                Pair pair2 = Pair.create((Object)USE_PROJECT_JDK, (Object)res);
                if (pair2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemJdkUtil", "getAvailableJdk"));
                }
                return pair2;
            }
            for (Module module2 : modules = ModuleManager.getInstance((Project)project2).getModules()) {
                Sdk sdk = ModuleRootManager.getInstance((Module)module2).getSdk();
                if (sdk == null || !(sdk.getSdkType() instanceof JavaSdkType)) continue;
                Pair pair3 = Pair.create((Object)USE_PROJECT_JDK, (Object)sdk);
                if (pair3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemJdkUtil", "getAvailableJdk"));
                }
                return pair3;
            }
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && ExternalSystemJdkUtil.isValidJdk(javaHome = System.getenv("JAVA_HOME"))) {
            Pair pair4 = Pair.create((Object)USE_JAVA_HOME, (Object)JavaSdk.getInstance().createJdk("", javaHome));
            if (pair4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemJdkUtil", "getAvailableJdk"));
            }
            return pair4;
        }
        for (Sdk projectJdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (!ExternalSystemJdkUtil.isValidJdk(projectJdk.getHomePath())) continue;
            Pair pair5 = Pair.create((Object)projectJdk.getName(), (Object)projectJdk);
            if (pair5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemJdkUtil", "getAvailableJdk"));
            }
            return pair5;
        }
        Pair pair6 = Pair.create((Object)USE_INTERNAL_JAVA, (Object)JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk());
        if (pair6 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemJdkUtil", "getAvailableJdk"));
        }
        return pair6;
    }

    public static boolean checkForJdk(@NotNull Project project2, @Nullable String jdkName) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemJdkUtil", "checkForJdk"));
        }
        try {
            Sdk sdk = ExternalSystemJdkUtil.getJdk(project2, jdkName);
            return sdk != null && sdk.getHomePath() != null && JdkUtil.checkForJdk((String)sdk.getHomePath());
        }
        catch (ExternalSystemJdkException externalSystemJdkException) {
            return false;
        }
    }

    private static boolean isValidJdk(@Nullable String homePath) {
        return !StringUtil.isEmptyOrSpaces((String)homePath) && (JdkUtil.checkForJdk((String)homePath) || JdkUtil.checkForJre((String)homePath));
    }
}

