/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.internal;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.internal.AbstractExternalSystemTask;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.keyFMap.KeyFMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemExecuteTaskTask
extends AbstractExternalSystemTask {
    @NotNull
    private final List<String> myTasksToExecute;
    @Nullable
    private final String myVmOptions;
    @Nullable
    private String myArguments;
    @Nullable
    private final String myJvmAgentSetup;
    private final boolean myPassParentEnvs;
    private final Map<String, String> myEnv;

    public ExternalSystemExecuteTaskTask(@NotNull Project project2, @NotNull ExternalSystemTaskExecutionSettings settings, @Nullable String jvmAgentSetup) throws IllegalArgumentException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/internal/ExternalSystemExecuteTaskTask", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/externalSystem/service/internal/ExternalSystemExecuteTaskTask", "<init>"));
        }
        super(settings.getExternalSystemId(), ExternalSystemTaskType.EXECUTE_TASK, project2, settings.getExternalProjectPath());
        this.myTasksToExecute = ContainerUtilRt.newArrayList((Iterable)settings.getTaskNames());
        this.myVmOptions = settings.getVmOptions();
        this.myArguments = settings.getScriptParameters();
        this.myPassParentEnvs = settings.isPassParentEnvs();
        this.myEnv = settings.getEnv();
        this.myJvmAgentSetup = jvmAgentSetup;
    }

    public ExternalSystemExecuteTaskTask(@NotNull ProjectSystemId externalSystemId, @NotNull Project project2, @NotNull List<ExternalTaskPojo> tasksToExecute, @Nullable String vmOptions, @Nullable String arguments, @Nullable String jvmAgentSetup) throws IllegalArgumentException {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/internal/ExternalSystemExecuteTaskTask", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/internal/ExternalSystemExecuteTaskTask", "<init>"));
        }
        if (tasksToExecute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasksToExecute", "com/intellij/openapi/externalSystem/service/internal/ExternalSystemExecuteTaskTask", "<init>"));
        }
        super(externalSystemId, ExternalSystemTaskType.EXECUTE_TASK, project2, ExternalSystemExecuteTaskTask.getLinkedExternalProjectPath(tasksToExecute));
        this.myTasksToExecute = ContainerUtil.map(tasksToExecute, ExternalTaskPojo::getName);
        this.myVmOptions = vmOptions;
        this.myArguments = arguments;
        this.myJvmAgentSetup = jvmAgentSetup;
        this.myPassParentEnvs = true;
        this.myEnv = Collections.emptyMap();
    }

    @NotNull
    public List<String> getTasksToExecute() {
        List<String> list2 = this.myTasksToExecute;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/internal/ExternalSystemExecuteTaskTask", "getTasksToExecute"));
        }
        return list2;
    }

    @Nullable
    public String getVmOptions() {
        return this.myVmOptions;
    }

    @Nullable
    public String getArguments() {
        return this.myArguments;
    }

    public void appendArguments(@NotNull String arguments) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/openapi/externalSystem/service/internal/ExternalSystemExecuteTaskTask", "appendArguments"));
        }
        this.myArguments = this.myArguments == null ? arguments : this.myArguments + ' ' + arguments;
    }

    @Deprecated
    @NotNull
    private static String getLinkedExternalProjectPath(@NotNull Collection<ExternalTaskPojo> tasks) throws IllegalArgumentException {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/intellij/openapi/externalSystem/service/internal/ExternalSystemExecuteTaskTask", "getLinkedExternalProjectPath"));
        }
        if (tasks.isEmpty()) {
            throw new IllegalArgumentException("Can't execute external tasks. Reason: given tasks list is empty");
        }
        String result2 = null;
        for (ExternalTaskPojo task : tasks) {
            String path = task.getLinkedExternalProjectPath();
            if (result2 == null) {
                result2 = path;
                continue;
            }
            if (result2.equals(path)) continue;
            throw new IllegalArgumentException(String.format("Can't execute given external system tasks. Reason: expected that all of them belong to the same external project but they are not (at least two different projects detected - '%s' and '%s'). Tasks: %s", result2, task.getLinkedExternalProjectPath(), tasks));
        }
        assert (result2 != null);
        String string = result2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/internal/ExternalSystemExecuteTaskTask", "getLinkedExternalProjectPath"));
        }
        return string;
    }

    @Override
    protected void doExecute() throws Exception {
        ExternalSystemFacadeManager manager = (ExternalSystemFacadeManager)ServiceManager.getService(ExternalSystemFacadeManager.class);
        ExternalSystemExecutionSettings settings = ExternalSystemApiUtil.getExecutionSettings((Project)this.getIdeProject(), (String)this.getExternalProjectPath(), (ProjectSystemId)this.getExternalSystemId());
        KeyFMap keyFMap = this.getUserMap();
        for (Key key2 : keyFMap.getKeys()) {
            settings.putUserData(key2, keyFMap.get(key2));
        }
        RemoteExternalSystemFacade facade = manager.getFacade(this.getIdeProject(), this.getExternalProjectPath(), this.getExternalSystemId());
        RemoteExternalSystemTaskManager<ExternalSystemExecutionSettings> taskManager = facade.getTaskManager();
        List<String> vmOptions = ExternalSystemExecuteTaskTask.parseCmdParameters(this.myVmOptions);
        List<String> arguments = ExternalSystemExecuteTaskTask.parseCmdParameters(this.myArguments);
        settings.withVmOptions(vmOptions).withArguments(arguments).withEnvironmentVariables(this.myEnv).passParentEnvs(this.myPassParentEnvs);
        taskManager.executeTasks(this.getId(), this.myTasksToExecute, this.getExternalProjectPath(), settings, this.myJvmAgentSetup);
    }

    @Override
    protected boolean doCancel() throws Exception {
        ExternalSystemFacadeManager manager = (ExternalSystemFacadeManager)ServiceManager.getService(ExternalSystemFacadeManager.class);
        RemoteExternalSystemFacade facade = manager.getFacade(this.getIdeProject(), this.getExternalProjectPath(), this.getExternalSystemId());
        RemoteExternalSystemTaskManager taskManager = facade.getTaskManager();
        return taskManager.cancelTask(this.getId());
    }

    private static List<String> parseCmdParameters(@Nullable String cmdArgsLine) {
        return cmdArgsLine != null ? ParametersListUtil.parse((String)cmdArgsLine) : ContainerUtil.newArrayList();
    }
}

