/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.internal;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.internal.InternalExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.service.internal.AbstractExternalSystemTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManagerImpl;
import com.intellij.openapi.externalSystem.service.remote.ExternalSystemProgressNotificationManagerImpl;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemResolveProjectTask
extends AbstractExternalSystemTask {
    private final AtomicReference<DataNode<ProjectData>> myExternalProject;
    @NotNull
    private final String myProjectPath;
    private final boolean myIsPreviewMode;
    @Nullable
    private final String myVmOptions;
    @Nullable
    private final String myArguments;

    public ExternalSystemResolveProjectTask(@NotNull ProjectSystemId externalSystemId, @NotNull Project project2, @NotNull String projectPath, boolean isPreviewMode) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/internal/ExternalSystemResolveProjectTask", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/internal/ExternalSystemResolveProjectTask", "<init>"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/intellij/openapi/externalSystem/service/internal/ExternalSystemResolveProjectTask", "<init>"));
        }
        this(externalSystemId, project2, projectPath, null, null, isPreviewMode);
    }

    public ExternalSystemResolveProjectTask(@NotNull ProjectSystemId externalSystemId, @NotNull Project project2, @NotNull String projectPath, @Nullable String vmOptions, @Nullable String arguments, boolean isPreviewMode) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/internal/ExternalSystemResolveProjectTask", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/internal/ExternalSystemResolveProjectTask", "<init>"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/intellij/openapi/externalSystem/service/internal/ExternalSystemResolveProjectTask", "<init>"));
        }
        super(externalSystemId, ExternalSystemTaskType.RESOLVE_PROJECT, project2, projectPath);
        this.myExternalProject = new AtomicReference();
        this.myProjectPath = projectPath;
        this.myIsPreviewMode = isPreviewMode;
        this.myVmOptions = vmOptions;
        this.myArguments = arguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute() throws Exception {
        ExternalSystemFacadeManager manager = (ExternalSystemFacadeManager)ServiceManager.getService(ExternalSystemFacadeManager.class);
        Project ideProject = this.getIdeProject();
        RemoteExternalSystemProjectResolver<ExternalSystemExecutionSettings> resolver = manager.getFacade(ideProject, this.myProjectPath, this.getExternalSystemId()).getResolver();
        ExternalSystemExecutionSettings settings = ExternalSystemApiUtil.getExecutionSettings((Project)ideProject, (String)this.myProjectPath, (ProjectSystemId)this.getExternalSystemId());
        if (StringUtil.isNotEmpty((String)this.myVmOptions)) {
            settings.withVmOptions((Collection)ParametersListUtil.parse((String)this.myVmOptions));
        }
        if (StringUtil.isNotEmpty((String)this.myArguments)) {
            settings.withArguments((Collection)ParametersListUtil.parse((String)this.myArguments));
        }
        ExternalSystemProgressNotificationManagerImpl progressNotificationManager = (ExternalSystemProgressNotificationManagerImpl)ServiceManager.getService(ExternalSystemProgressNotificationManager.class);
        ExternalSystemTaskId id = this.getId();
        progressNotificationManager.onStart(id, this.myProjectPath);
        try {
            DataNode<ProjectData> project2 = resolver.resolveProjectInfo(id, this.myProjectPath, this.myIsPreviewMode, settings);
            if (project2 != null) {
                this.myExternalProject.set(project2);
                ExternalSystemManager systemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.getExternalSystemId());
                assert (systemManager != null);
                HashSet externalModulePaths = ContainerUtil.newHashSet();
                Collection moduleNodes = ExternalSystemApiUtil.findAll(project2, (Key)ProjectKeys.MODULE);
                for (DataNode node : moduleNodes) {
                    externalModulePaths.add(((ModuleData)node.getData()).getLinkedExternalProjectPath());
                }
                String projectPath = ((ProjectData)project2.getData()).getLinkedExternalProjectPath();
                ExternalProjectSettings linkedProjectSettings = ((AbstractExternalSystemSettings)systemManager.getSettingsProvider().fun((Object)ideProject)).getLinkedProjectSettings(projectPath);
                if (linkedProjectSettings != null) {
                    linkedProjectSettings.setModules((Set)externalModulePaths);
                }
            }
            progressNotificationManager.onSuccess(id);
        }
        finally {
            progressNotificationManager.onEnd(id);
        }
    }

    @Override
    protected boolean doCancel() throws Exception {
        ExternalSystemFacadeManager manager = (ExternalSystemFacadeManager)ServiceManager.getService(ExternalSystemFacadeManager.class);
        Project ideProject = this.getIdeProject();
        RemoteExternalSystemProjectResolver resolver = manager.getFacade(ideProject, this.myProjectPath, this.getExternalSystemId()).getResolver();
        return resolver.cancelTask(this.getId());
    }

    @Nullable
    public DataNode<ProjectData> getExternalProject() {
        return this.myExternalProject.get();
    }

    @Override
    @NotNull
    protected String wrapProgressText(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/externalSystem/service/internal/ExternalSystemResolveProjectTask", "wrapProgressText"));
        }
        String string = ExternalSystemBundle.message((String)"progress.update.text", (Object[])new Object[]{this.getExternalSystemId().getReadableName(), text2});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/internal/ExternalSystemResolveProjectTask", "wrapProgressText"));
        }
        return string;
    }

    @Override
    protected void setState(@NotNull ExternalSystemTaskState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/externalSystem/service/internal/ExternalSystemResolveProjectTask", "setState"));
        }
        super.setState(state);
        if (state.isStopped()) {
            InternalExternalProjectInfo projectInfo = new InternalExternalProjectInfo(this.getExternalSystemId(), this.getExternalProjectPath(), this.getExternalProject());
            long currentTimeMillis = System.currentTimeMillis();
            projectInfo.setLastImportTimestamp(currentTimeMillis);
            projectInfo.setLastSuccessfulImportTimestamp(state == ExternalSystemTaskState.FAILED ? -1L : currentTimeMillis);
            ProjectDataManagerImpl.getInstance().updateExternalProjectData(this.getIdeProject(), projectInfo);
        }
    }
}

