/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.notification;

import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.errorTreeView.EditableMessageElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.externalSystem.service.notification.NotificationMessageElement;
import com.intellij.pom.Navigatable;
import com.intellij.ui.PopupHandler;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.JEditorPane;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditableNotificationMessageElement
extends NotificationMessageElement
implements EditableMessageElement {
    @NotNull
    private final TreeCellEditor myRightTreeCellEditor;
    @NotNull
    private final Notification myNotification;
    @NotNull
    private final Map<String, String> disabledLinks;

    public EditableNotificationMessageElement(@NotNull Notification notification, @NotNull ErrorTreeElementKind kind2, @Nullable GroupingElement parent, String[] message2, @NotNull Navigatable navigatable, String exportText, String rendererTextPrefix) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/externalSystem/service/notification/EditableNotificationMessageElement", "<init>"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/openapi/externalSystem/service/notification/EditableNotificationMessageElement", "<init>"));
        }
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/intellij/openapi/externalSystem/service/notification/EditableNotificationMessageElement", "<init>"));
        }
        super(kind2, parent, message2, navigatable, exportText, rendererTextPrefix);
        this.myNotification = notification;
        this.disabledLinks = ContainerUtil.newHashMap();
        this.myRightTreeCellEditor = new MyCellEditor();
    }

    public void addDisabledLink(@NotNull String url, @Nullable String text2) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/externalSystem/service/notification/EditableNotificationMessageElement", "addDisabledLink"));
        }
        this.disabledLinks.put(url, text2);
    }

    @Override
    @NotNull
    public TreeCellEditor getRightSelfEditor() {
        TreeCellEditor treeCellEditor = this.myRightTreeCellEditor;
        if (treeCellEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/notification/EditableNotificationMessageElement", "getRightSelfEditor"));
        }
        return treeCellEditor;
    }

    @Override
    public boolean startEditingOnMouseMove() {
        return true;
    }

    public static void disableLink(@NotNull HyperlinkEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/notification/EditableNotificationMessageElement", "disableLink"));
        }
        EditableNotificationMessageElement.disableLink(event, null);
    }

    private static void disableLink(@NotNull HyperlinkEvent event, @Nullable String linkText) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/notification/EditableNotificationMessageElement", "disableLink"));
        }
        if (event.getSource() instanceof MyJEditorPane) {
            UIUtil.invokeLaterIfNeeded(() -> {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/notification/EditableNotificationMessageElement", "lambda$disableLink$0"));
                }
                MyJEditorPane editorPane = (MyJEditorPane)event.getSource();
                editorPane.myElement.addDisabledLink(event.getDescription(), linkText);
                editorPane.myElement.updateStyle(editorPane, null, null, true, false);
            });
        }
    }

    @Override
    protected void updateStyle(@NotNull JEditorPane editorPane, @Nullable JTree tree, Object value2, boolean selected, boolean hasFocus) {
        if (editorPane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorPane", "com/intellij/openapi/externalSystem/service/notification/EditableNotificationMessageElement", "updateStyle"));
        }
        super.updateStyle(editorPane, tree, value2, selected, hasFocus);
        HTMLDocument htmlDocument = (HTMLDocument)editorPane.getDocument();
        Style linkStyle = htmlDocument.getStyleSheet().getStyle("linkStyle");
        StyleConstants.setForeground(linkStyle, IdeTooltipManager.getInstance().getLinkForeground(false));
        StyleConstants.setItalic(linkStyle, true);
        HTMLDocument.Iterator iterator = htmlDocument.getIterator(HTML.Tag.A);
        while (iterator.isValid()) {
            boolean disabledLink = false;
            AttributeSet attributes = iterator.getAttributes();
            if (attributes instanceof SimpleAttributeSet) {
                Object attribute = attributes.getAttribute(HTML.Attribute.HREF);
                if (attribute instanceof String && this.disabledLinks.containsKey(attribute)) {
                    disabledLink = true;
                    ((SimpleAttributeSet)attributes).removeAttribute(HTML.Attribute.HREF);
                }
                if (attribute == null) {
                    disabledLink = true;
                }
            }
            if (!disabledLink) {
                htmlDocument.setCharacterAttributes(iterator.getStartOffset(), iterator.getEndOffset() - iterator.getStartOffset(), linkStyle, false);
            }
            iterator.next();
        }
    }

    private class MyCellEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private final JEditorPane editorComponent;
        @Nullable
        private JTree myTree;

        private MyCellEditor() {
            this.editorComponent = EditableNotificationMessageElement.this.installJep(new MyJEditorPane(EditableNotificationMessageElement.this));
            ActivatedHyperlinkListener hyperlinkListener = new ActivatedHyperlinkListener();
            this.editorComponent.addHyperlinkListener(hyperlinkListener);
            this.editorComponent.addMouseListener((MouseListener)new PopupHandler(){

                public void invokePopup(Component comp, int x, int y) {
                    if (MyCellEditor.this.myTree == null) {
                        return;
                    }
                    TreePath path = MyCellEditor.this.myTree.getLeadSelectionPath();
                    if (path == null) {
                        return;
                    }
                    DefaultActionGroup group = new DefaultActionGroup();
                    group.add(ActionManager.getInstance().getAction("EditSource"));
                    group.add(ActionManager.getInstance().getAction("$Copy"));
                    ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("CompilerMessagesPopup", (ActionGroup)group);
                    menu.getComponent().show(comp, x, y);
                }
            });
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row) {
            this.myTree = tree;
            EditableNotificationMessageElement.this.updateStyle(this.editorComponent, tree, value2, selected, false);
            return this.editorComponent;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        private class ActivatedHyperlinkListener
        implements HyperlinkListener {
            private ActivatedHyperlinkListener() {
            }

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                NotificationListener notificationListener;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (notificationListener = EditableNotificationMessageElement.this.myNotification.getListener()) != null) {
                    notificationListener.hyperlinkUpdate(EditableNotificationMessageElement.this.myNotification, e);
                }
            }
        }
    }

    private static class MyJEditorPane
    extends JEditorPane {
        @NotNull
        private final EditableNotificationMessageElement myElement;

        public MyJEditorPane(@NotNull EditableNotificationMessageElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/externalSystem/service/notification/EditableNotificationMessageElement$MyJEditorPane", "<init>"));
            }
            this.myElement = element;
        }
    }
}

