/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.ArtifactExternalDependenciesImporter;
import com.intellij.openapi.externalSystem.service.project.ArtifactExternalDependenciesImporterImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.TestModuleProperties;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.ManifestFileProvider;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.DefaultManifestFileProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractIdeModifiableModelsProvider
extends IdeModelsProviderImpl
implements IdeModifiableModelsProvider {
    private static final Logger LOG = Logger.getInstance(AbstractIdeModifiableModelsProvider.class);
    private ModifiableModuleModel myModifiableModuleModel;
    private Map<Module, ModifiableRootModel> myModifiableRootModels;
    private Map<Module, ModifiableFacetModel> myModifiableFacetModels;
    private Map<Module, String> myProductionModulesForTestModules;
    private Map<Library, Library.ModifiableModel> myModifiableLibraryModels;
    private ModifiableArtifactModel myModifiableArtifactModel;
    private MyPackagingElementResolvingContext myPackagingElementResolvingContext;
    private final ArtifactExternalDependenciesImporter myArtifactExternalDependenciesImporter;
    @NotNull
    private final MyUserDataHolderBase myUserData;

    public AbstractIdeModifiableModelsProvider(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "<init>"));
        }
        super(project2);
        this.myModifiableRootModels = new THashMap();
        this.myModifiableFacetModels = new THashMap();
        this.myProductionModulesForTestModules = new THashMap();
        this.myModifiableLibraryModels = new IdentityHashMap<Library, Library.ModifiableModel>();
        this.myUserData = new MyUserDataHolderBase();
        this.myArtifactExternalDependenciesImporter = new ArtifactExternalDependenciesImporterImpl();
    }

    protected abstract ModifiableArtifactModel doGetModifiableArtifactModel();

    protected abstract ModifiableModuleModel doGetModifiableModuleModel();

    protected abstract ModifiableRootModel doGetModifiableRootModel(Module var1);

    protected abstract ModifiableFacetModel doGetModifiableFacetModel(Module var1);

    protected abstract Library.ModifiableModel doGetModifiableLibraryModel(Library var1);

    @NotNull
    public abstract LibraryTable.ModifiableModel getModifiableProjectLibrariesModel();

    @Override
    @NotNull
    public Module[] getModules() {
        Module[] moduleArray = this.getModifiableModuleModel().getModules();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getModules"));
        }
        return moduleArray;
    }

    protected void processExternalArtifactDependencies() {
        this.myArtifactExternalDependenciesImporter.applyChanges(this.getModifiableArtifactModel(), this.getPackagingElementResolvingContext());
    }

    public PackagingElementResolvingContext getPackagingElementResolvingContext() {
        if (this.myPackagingElementResolvingContext == null) {
            this.myPackagingElementResolvingContext = new MyPackagingElementResolvingContext();
        }
        return this.myPackagingElementResolvingContext;
    }

    @Override
    @NotNull
    public OrderEntry[] getOrderEntries(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getOrderEntries"));
        }
        OrderEntry[] orderEntryArray = this.getRootModel(module2).getOrderEntries();
        if (orderEntryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getOrderEntries"));
        }
        return orderEntryArray;
    }

    @NotNull
    public Module newModule(@NotNull String filePath, String moduleTypeId) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "newModule"));
        }
        Module module2 = this.getModifiableModuleModel().newModule(filePath, moduleTypeId);
        String moduleName = FileUtil.getNameWithoutExtension((File)new File(filePath));
        if (!module2.getName().equals(moduleName)) {
            try {
                this.getModifiableModuleModel().renameModule(module2, moduleName);
            }
            catch (ModuleWithNameAlreadyExists exists) {
                LOG.warn((Throwable)exists);
            }
        }
        module2.setModuleType(moduleTypeId);
        Module module3 = module2;
        if (module3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "newModule"));
        }
        return module3;
    }

    @NotNull
    public Module newModule(@NotNull ModuleData moduleData) {
        if (moduleData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleData", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "newModule"));
        }
        String filePath = moduleData.getModuleFilePath();
        String moduleTypeId = moduleData.getModuleTypeId();
        for (String candidate : this.suggestModuleNameCandidates(moduleData)) {
            Module module2 = this.findIdeModule(candidate);
            if (module2 != null) continue;
            filePath = ExternalSystemApiUtil.toCanonicalPath((String)(moduleData.getModuleFileDirectoryPath() + "/" + candidate + ".iml"));
            break;
        }
        Module module3 = this.newModule(filePath, moduleTypeId);
        if (module3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "newModule"));
        }
        return module3;
    }

    @Override
    @Nullable
    public Module findIdeModule(@NotNull String ideModuleName) {
        if (ideModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModuleName", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "findIdeModule"));
        }
        Module module2 = this.getModifiableModuleModel().findModuleByName(ideModuleName);
        return module2 == null ? this.getModifiableModuleModel().getModuleToBeRenamed(ideModuleName) : module2;
    }

    @Override
    @Nullable
    public Library findIdeLibrary(@NotNull LibraryData libraryData) {
        if (libraryData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryData", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "findIdeLibrary"));
        }
        LibraryTable.ModifiableModel libraryTable = this.getModifiableProjectLibrariesModel();
        for (Library ideLibrary : libraryTable.getLibraries()) {
            if (!ExternalSystemApiUtil.isRelated((Library)ideLibrary, (LibraryData)libraryData)) continue;
            return ideLibrary;
        }
        return null;
    }

    @Override
    @NotNull
    public VirtualFile[] getContentRoots(Module module2) {
        VirtualFile[] virtualFileArray = this.getRootModel(module2).getContentRoots();
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getContentRoots"));
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public VirtualFile[] getSourceRoots(Module module2) {
        VirtualFile[] virtualFileArray = this.getRootModel(module2).getSourceRoots();
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getSourceRoots"));
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public VirtualFile[] getSourceRoots(Module module2, boolean includingTests) {
        VirtualFile[] virtualFileArray = this.getRootModel(module2).getSourceRoots(includingTests);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getSourceRoots"));
        }
        return virtualFileArray;
    }

    @NotNull
    public ModifiableModuleModel getModifiableModuleModel() {
        if (this.myModifiableModuleModel == null) {
            this.myModifiableModuleModel = this.doGetModifiableModuleModel();
        }
        ModifiableModuleModel modifiableModuleModel = this.myModifiableModuleModel;
        if (modifiableModuleModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getModifiableModuleModel"));
        }
        return modifiableModuleModel;
    }

    @NotNull
    public ModifiableRootModel getModifiableRootModel(Module module2) {
        ModifiableRootModel modifiableRootModel = (ModifiableRootModel)this.getRootModel(module2);
        if (modifiableRootModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getModifiableRootModel"));
        }
        return modifiableRootModel;
    }

    @NotNull
    private ModuleRootModel getRootModel(Module module2) {
        ModuleRootModel moduleRootModel = (ModuleRootModel)this.myModifiableRootModels.computeIfAbsent(module2, k -> this.doGetModifiableRootModel(module2));
        if (moduleRootModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getRootModel"));
        }
        return moduleRootModel;
    }

    @NotNull
    public ModifiableFacetModel getModifiableFacetModel(Module module2) {
        ModifiableFacetModel modifiableFacetModel = this.myModifiableFacetModels.computeIfAbsent(module2, k -> this.doGetModifiableFacetModel(module2));
        if (modifiableFacetModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getModifiableFacetModel"));
        }
        return modifiableFacetModel;
    }

    @NotNull
    public ModifiableArtifactModel getModifiableArtifactModel() {
        if (this.myModifiableArtifactModel == null) {
            this.myModifiableArtifactModel = this.doGetModifiableArtifactModel();
        }
        ModifiableArtifactModel modifiableArtifactModel = this.myModifiableArtifactModel;
        if (modifiableArtifactModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getModifiableArtifactModel"));
        }
        return modifiableArtifactModel;
    }

    @Override
    @NotNull
    public Library[] getAllLibraries() {
        Library[] libraryArray = this.getModifiableProjectLibrariesModel().getLibraries();
        if (libraryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getAllLibraries"));
        }
        return libraryArray;
    }

    @Override
    @Nullable
    public Library getLibraryByName(String name2) {
        return this.getModifiableProjectLibrariesModel().getLibraryByName(name2);
    }

    public Library createLibrary(String name2) {
        return this.getModifiableProjectLibrariesModel().createLibrary(name2);
    }

    public Library createLibrary(String name2, @Nullable ProjectModelExternalSource externalSource) {
        return this.getModifiableProjectLibrariesModel().createLibrary(name2, null, externalSource);
    }

    public void removeLibrary(Library library) {
        this.getModifiableProjectLibrariesModel().removeLibrary(library);
    }

    public Library.ModifiableModel getModifiableLibraryModel(Library library) {
        return this.myModifiableLibraryModels.computeIfAbsent(library, k -> this.doGetModifiableLibraryModel(library));
    }

    @Override
    @NotNull
    public String[] getLibraryUrls(@NotNull Library library, @NotNull OrderRootType type2) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getLibraryUrls"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getLibraryUrls"));
        }
        Library.ModifiableModel model = this.myModifiableLibraryModels.get(library);
        if (model != null) {
            String[] stringArray = model.getUrls(type2);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getLibraryUrls"));
            }
            return stringArray;
        }
        String[] stringArray = library.getUrls(type2);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getLibraryUrls"));
        }
        return stringArray;
    }

    public ModalityState getModalityStateForQuestionDialogs() {
        return ModalityState.NON_MODAL;
    }

    public ArtifactExternalDependenciesImporter getArtifactExternalDependenciesImporter() {
        return this.myArtifactExternalDependenciesImporter;
    }

    @Override
    @NotNull
    public List<Module> getAllDependentModules(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getAllDependentModules"));
        }
        ArrayList<Module> list2 = new ArrayList<Module>();
        Graph<Module> graph = this.getModuleGraph();
        Iterator i2 = graph.getOut((Object)module2);
        while (i2.hasNext()) {
            list2.add((Module)i2.next());
        }
        ArrayList<Module> arrayList = list2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getAllDependentModules"));
        }
        return arrayList;
    }

    private Graph<Module> getModuleGraph() {
        return GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<Module>(){

            public Collection<Module> getNodes() {
                return ContainerUtil.list((Object[])AbstractIdeModifiableModelsProvider.this.getModules());
            }

            public Iterator<Module> getIn(Module m) {
                Module[] dependentModules = AbstractIdeModifiableModelsProvider.this.getModifiableRootModel(m).getModuleDependencies(true);
                return Arrays.asList(dependentModules).iterator();
            }
        }));
    }

    public void commit() {
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> {
            this.processExternalArtifactDependencies();
            for (Library.ModifiableModel each : this.myModifiableLibraryModels.values()) {
                each.commit();
            }
            this.getModifiableProjectLibrariesModel().commit();
            Collection<ModifiableRootModel> rootModels = this.myModifiableRootModels.values();
            ModifiableRootModel[] rootModels1 = rootModels.toArray(new ModifiableRootModel[rootModels.size()]);
            for (Object model : rootModels1) {
                assert (!model.isDisposed()) : "Already disposed: " + model;
            }
            if (this.myModifiableModuleModel != null) {
                ModifiableModelCommitter.multiCommit(rootModels1, this.myModifiableModuleModel);
            } else {
                for (Object model : rootModels1) {
                    model.commit();
                }
            }
            for (Map.Entry entry : this.myProductionModulesForTestModules.entrySet()) {
                TestModuleProperties.getInstance((Module)entry.getKey()).setProductionModuleName((String)entry.getValue());
            }
            for (Map.Entry entry : this.myModifiableFacetModels.entrySet()) {
                if (((Module)entry.getKey()).isDisposed()) continue;
                ((ModifiableFacetModel)entry.getValue()).commit();
            }
            if (this.myModifiableArtifactModel != null) {
                this.myModifiableArtifactModel.commit();
            }
        });
        this.myUserData.clear();
    }

    public void dispose() {
        for (ModifiableRootModel modifiableRootModel : this.myModifiableRootModels.values()) {
            if (modifiableRootModel.isDisposed()) continue;
            modifiableRootModel.dispose();
        }
        Disposer.dispose((Disposable)this.getModifiableProjectLibrariesModel());
        for (Library.ModifiableModel modifiableModel : this.myModifiableLibraryModels.values()) {
            if (modifiableModel instanceof LibraryEx && ((LibraryEx)modifiableModel).isDisposed()) continue;
            Disposer.dispose((Disposable)modifiableModel);
        }
        if (this.myModifiableModuleModel != null) {
            this.myModifiableModuleModel.dispose();
        }
        if (this.myModifiableArtifactModel != null) {
            this.myModifiableArtifactModel.dispose();
        }
        this.myModifiableRootModels.clear();
        this.myModifiableFacetModels.clear();
        this.myModifiableLibraryModels.clear();
        this.myUserData.clear();
    }

    public void setTestModuleProperties(Module testModule, String productionModuleName) {
        this.myProductionModulesForTestModules.put(testModule, productionModuleName);
    }

    @Nullable
    public String getProductionModuleName(Module module2) {
        return this.myProductionModulesForTestModules.get(module2);
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "getUserData"));
        }
        return (T)this.myUserData.getUserData(key2);
    }

    public <T> void putUserData(@NotNull Key<T> key2, @Nullable T value2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider", "putUserData"));
        }
        this.myUserData.putUserData(key2, value2);
    }

    private class MyFacetsProvider
    implements FacetsProvider {
        private MyFacetsProvider() {
        }

        @NotNull
        public Facet[] getAllFacets(Module module2) {
            Facet[] facetArray = AbstractIdeModifiableModelsProvider.this.getModifiableFacetModel(module2).getAllFacets();
            if (facetArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyFacetsProvider", "getAllFacets"));
            }
            return facetArray;
        }

        @NotNull
        public <F extends Facet> Collection<F> getFacetsByType(Module module2, FacetTypeId<F> type2) {
            Collection collection = AbstractIdeModifiableModelsProvider.this.getModifiableFacetModel(module2).getFacetsByType(type2);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyFacetsProvider", "getFacetsByType"));
            }
            return collection;
        }

        public <F extends Facet> F findFacet(Module module2, FacetTypeId<F> type2, String name2) {
            return (F)AbstractIdeModifiableModelsProvider.this.getModifiableFacetModel(module2).findFacet(type2, name2);
        }
    }

    private class MyModulesProvider
    implements ModulesProvider {
        private MyModulesProvider() {
        }

        @NotNull
        public Module[] getModules() {
            Module[] moduleArray = AbstractIdeModifiableModelsProvider.this.getModules();
            if (moduleArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyModulesProvider", "getModules"));
            }
            return moduleArray;
        }

        public Module getModule(String name2) {
            return AbstractIdeModifiableModelsProvider.this.findIdeModule(name2);
        }

        public ModuleRootModel getRootModel(@NotNull Module module2) {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyModulesProvider", "getRootModel"));
            }
            return AbstractIdeModifiableModelsProvider.this.getModifiableRootModel(module2);
        }

        public FacetModel getFacetModel(@NotNull Module module2) {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyModulesProvider", "getFacetModel"));
            }
            return AbstractIdeModifiableModelsProvider.this.getModifiableFacetModel(module2);
        }
    }

    private class MyPackagingElementResolvingContext
    implements PackagingElementResolvingContext {
        private final ModulesProvider myModulesProvider;
        private final MyFacetsProvider myFacetsProvider;
        private final ManifestFileProvider myManifestFileProvider;

        private MyPackagingElementResolvingContext() {
            this.myModulesProvider = new MyModulesProvider();
            this.myFacetsProvider = new MyFacetsProvider();
            this.myManifestFileProvider = new DefaultManifestFileProvider(this);
        }

        @NotNull
        public Project getProject() {
            Project project2 = AbstractIdeModifiableModelsProvider.this.myProject;
            if (project2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyPackagingElementResolvingContext", "getProject"));
            }
            return project2;
        }

        @NotNull
        public ArtifactModel getArtifactModel() {
            ModifiableArtifactModel modifiableArtifactModel = AbstractIdeModifiableModelsProvider.this.getModifiableArtifactModel();
            if (modifiableArtifactModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyPackagingElementResolvingContext", "getArtifactModel"));
            }
            return modifiableArtifactModel;
        }

        @NotNull
        public ModulesProvider getModulesProvider() {
            ModulesProvider modulesProvider = this.myModulesProvider;
            if (modulesProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyPackagingElementResolvingContext", "getModulesProvider"));
            }
            return modulesProvider;
        }

        @NotNull
        public FacetsProvider getFacetsProvider() {
            MyFacetsProvider myFacetsProvider = this.myFacetsProvider;
            if (myFacetsProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyPackagingElementResolvingContext", "getFacetsProvider"));
            }
            return myFacetsProvider;
        }

        public Library findLibrary(@NotNull String level, @NotNull String libraryName) {
            if (level == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyPackagingElementResolvingContext", "findLibrary"));
            }
            if (libraryName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyPackagingElementResolvingContext", "findLibrary"));
            }
            if (level.equals("project")) {
                return AbstractIdeModifiableModelsProvider.this.getLibraryByName(libraryName);
            }
            LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(level, AbstractIdeModifiableModelsProvider.this.myProject);
            return table != null ? table.getLibraryByName(libraryName) : null;
        }

        @NotNull
        public ManifestFileProvider getManifestFileProvider() {
            ManifestFileProvider manifestFileProvider = this.myManifestFileProvider;
            if (manifestFileProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$MyPackagingElementResolvingContext", "getManifestFileProvider"));
            }
            return manifestFileProvider;
        }
    }

    private static class MyUserDataHolderBase
    extends UserDataHolderBase {
        private MyUserDataHolderBase() {
        }

        void clear() {
            this.clearUserData();
        }
    }
}

