/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.openapi.externalSystem.service.project.ArtifactExternalDependenciesImporter;
import com.intellij.openapi.roots.ui.configuration.artifacts.ManifestFilesInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.ui.ManifestFileConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactExternalDependenciesImporterImpl
implements ArtifactExternalDependenciesImporter {
    private final ManifestFilesInfo myManifestFiles = new ManifestFilesInfo();
    private final Map<Artifact, List<PackagingElement<?>>> myExternalDependencies = new HashMap();

    @Nullable
    public ManifestFileConfiguration getManifestFile(@NotNull Artifact artifact, @NotNull PackagingElementResolvingContext context) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/openapi/externalSystem/service/project/ArtifactExternalDependenciesImporterImpl", "getManifestFile"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/externalSystem/service/project/ArtifactExternalDependenciesImporterImpl", "getManifestFile"));
        }
        return this.myManifestFiles.getManifestFile(artifact.getRootElement(), artifact.getArtifactType(), context);
    }

    public List<PackagingElement<?>> getExternalDependenciesList(@NotNull Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/openapi/externalSystem/service/project/ArtifactExternalDependenciesImporterImpl", "getExternalDependenciesList"));
        }
        List<PackagingElement<?>> elements = this.myExternalDependencies.get(artifact);
        if (elements == null) {
            elements = new ArrayList();
            this.myExternalDependencies.put(artifact, elements);
        }
        return elements;
    }

    public void applyChanges(ModifiableArtifactModel artifactModel, final PackagingElementResolvingContext context) {
        this.myManifestFiles.saveManifestFiles();
        final ArrayList elementsToInclude = new ArrayList();
        for (Artifact artifact : artifactModel.getArtifacts()) {
            ArtifactUtil.processPackagingElements(artifact, ArtifactElementType.ARTIFACT_ELEMENT_TYPE, new PackagingElementProcessor<ArtifactPackagingElement>(){

                @Override
                public boolean process(@NotNull ArtifactPackagingElement artifactPackagingElement, @NotNull PackagingElementPath path) {
                    List elements;
                    if (artifactPackagingElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactPackagingElement", "com/intellij/openapi/externalSystem/service/project/ArtifactExternalDependenciesImporterImpl$1", "process"));
                    }
                    if (path == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/externalSystem/service/project/ArtifactExternalDependenciesImporterImpl$1", "process"));
                    }
                    Artifact included = artifactPackagingElement.findArtifact(context);
                    CompositePackagingElement<?> parent = path.getLastParent();
                    if (parent != null && included != null && (elements = (List)ArtifactExternalDependenciesImporterImpl.this.myExternalDependencies.get(included)) != null) {
                        elementsToInclude.add(Pair.create(parent, (Object)elements));
                    }
                    return true;
                }
            }, context, false);
        }
        for (Pair pair2 : elementsToInclude) {
            ((CompositePackagingElement)pair2.getFirst()).addOrFindChildren((Collection)pair2.getSecond());
        }
    }
}

