/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.importing.ImportSpec;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.autoimport.ExternalSystemProjectsWatcher;
import com.intellij.openapi.externalSystem.service.project.autoimport.ExternalSystemProjectsWatcherImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsState;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemKeymapExtension;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemRunManagerListener;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemShortcutsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.service.project.manage.TaskActivationState;
import com.intellij.openapi.externalSystem.util.CompositeRunnable;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewImpl;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectFileStoreOptionManager;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ExternalProjectsManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ExternalProjectsManagerImpl
implements ExternalProjectsManager,
PersistentStateComponent<ExternalProjectsState>,
Disposable,
ProjectFileStoreOptionManager {
    private static final Logger LOG = Logger.getInstance(ExternalProjectsManager.class);
    private final AtomicBoolean isInitializationFinished;
    private final AtomicBoolean isInitializationStarted;
    private final CompositeRunnable myPostInitializationActivities;
    @NotNull
    private ExternalProjectsState myState;
    @NotNull
    private final Project myProject;
    private final ExternalSystemRunManagerListener myRunManagerListener;
    private final ExternalSystemTaskActivator myTaskActivator;
    private final ExternalSystemShortcutsManager myShortcutsManager;
    private final List<ExternalProjectsView> myProjectsViews;
    private ExternalSystemProjectsWatcherImpl myWatcher;

    public ExternalProjectsManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl", "<init>"));
        }
        this.isInitializationFinished = new AtomicBoolean();
        this.isInitializationStarted = new AtomicBoolean();
        this.myPostInitializationActivities = new CompositeRunnable();
        this.myState = new ExternalProjectsState();
        this.myProjectsViews = new SmartList();
        this.myProject = project2;
        this.myShortcutsManager = new ExternalSystemShortcutsManager(project2);
        Disposer.register((Disposable)this, (Disposable)this.myShortcutsManager);
        this.myTaskActivator = new ExternalSystemTaskActivator(project2);
        this.myRunManagerListener = new ExternalSystemRunManagerListener(this);
    }

    public static ExternalProjectsManagerImpl getInstance(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl", "getInstance"));
        }
        ExternalProjectsManager service = (ExternalProjectsManager)ServiceManager.getService((Project)project2, ExternalProjectsManager.class);
        return (ExternalProjectsManagerImpl)service;
    }

    public boolean isStoredExternally() {
        return this.myState.storeExternally;
    }

    public void setStoreExternally(boolean value2) {
        this.myState.storeExternally = value2;
        try {
            for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                if (module2.isDisposed()) continue;
                ((ModuleRootManagerImpl)ModuleRootManager.getInstance((Module)module2)).stateChanged();
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl", "getProject"));
        }
        return project2;
    }

    public ExternalSystemShortcutsManager getShortcutsManager() {
        return this.myShortcutsManager;
    }

    public ExternalSystemTaskActivator getTaskActivator() {
        return this.myTaskActivator;
    }

    public ExternalSystemProjectsWatcher getExternalProjectsWatcher() {
        return this.myWatcher;
    }

    public void registerView(@NotNull ExternalProjectsView externalProjectsView) {
        if (externalProjectsView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectsView", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl", "registerView"));
        }
        assert (this.getExternalProjectsView(externalProjectsView.getSystemId()) == null);
        this.init();
        this.myProjectsViews.add(externalProjectsView);
        if (externalProjectsView instanceof ExternalProjectsViewImpl) {
            ExternalProjectsViewImpl view = (ExternalProjectsViewImpl)externalProjectsView;
            view.loadState(this.myState.getExternalSystemsState().get(externalProjectsView.getSystemId().getId()).getProjectsViewState());
            view.init();
        }
    }

    @Nullable
    public ExternalProjectsView getExternalProjectsView(@NotNull ProjectSystemId systemId) {
        if (systemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl", "getExternalProjectsView"));
        }
        for (ExternalProjectsView projectsView : this.myProjectsViews) {
            if (!projectsView.getSystemId().equals((Object)systemId)) continue;
            return projectsView;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.isInitializationStarted.getAndSet(true)) {
            return;
        }
        this.myWatcher = new ExternalSystemProjectsWatcherImpl(this.myProject);
        this.myWatcher.start();
        ExternalProjectsDataStorage.getInstance(this.myProject).load();
        this.myRunManagerListener.attach();
        this.myShortcutsManager.init();
        for (ExternalSystemManager systemManager : ExternalSystemApiUtil.getAllManagers()) {
            Collection<ExternalProjectInfo> externalProjects = ExternalProjectsDataStorage.getInstance(this.myProject).list(systemManager.getSystemId());
            for (ExternalProjectInfo externalProject : externalProjects) {
                if (externalProject.getExternalProjectStructure() == null) continue;
                Collection taskData = ExternalSystemApiUtil.findAllRecursively((DataNode)externalProject.getExternalProjectStructure(), (Key)ProjectKeys.TASK);
                this.myShortcutsManager.scheduleKeymapUpdate(taskData);
            }
            if (externalProjects.isEmpty()) continue;
            this.myShortcutsManager.scheduleRunConfigurationKeymapUpdate(systemManager.getSystemId());
        }
        this.myTaskActivator.init();
        AtomicBoolean atomicBoolean = this.isInitializationFinished;
        synchronized (atomicBoolean) {
            this.isInitializationFinished.set(true);
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                this.myPostInitializationActivities.run();
                this.myPostInitializationActivities.clear();
            });
        }
    }

    public void refreshProject(@NotNull String externalProjectPath, @NotNull ImportSpec importSpec) {
        if (externalProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectPath", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl", "refreshProject"));
        }
        if (importSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importSpec", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl", "refreshProject"));
        }
        ExternalSystemUtil.refreshProject(externalProjectPath, importSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWhenInitialized(Runnable runnable2) {
        AtomicBoolean atomicBoolean = this.isInitializationFinished;
        synchronized (atomicBoolean) {
            if (this.isInitializationFinished.get()) {
                ApplicationManager.getApplication().executeOnPooledThread(runnable2);
            } else {
                this.myPostInitializationActivities.add(runnable2);
            }
        }
    }

    public void updateExternalProjectData(ExternalProjectInfo externalProject) {
        ExternalProjectsDataStorage.getInstance(this.myProject).update(externalProject);
        if (externalProject.getExternalProjectStructure() != null) {
            ProjectData projectData = (ProjectData)externalProject.getExternalProjectStructure().getData();
            ExternalSystemUtil.scheduleExternalViewStructureUpdate(this.myProject, projectData.getOwner());
            Collection taskData = ExternalSystemApiUtil.findAllRecursively((DataNode)externalProject.getExternalProjectStructure(), (Key)ProjectKeys.TASK);
            this.myShortcutsManager.scheduleKeymapUpdate(taskData);
            this.myShortcutsManager.scheduleRunConfigurationKeymapUpdate(projectData.getOwner());
        }
    }

    public void forgetExternalProjectData(@NotNull ProjectSystemId projectSystemId, @NotNull String linkedProjectPath) {
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemId", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl", "forgetExternalProjectData"));
        }
        if (linkedProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkedProjectPath", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl", "forgetExternalProjectData"));
        }
        ExternalProjectsDataStorage.getInstance(this.myProject).remove(projectSystemId, linkedProjectPath);
        ExternalSystemUtil.scheduleExternalViewStructureUpdate(this.myProject, projectSystemId);
    }

    @NotNull
    public ExternalProjectsState getState() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (ExternalProjectsView externalProjectsView : this.myProjectsViews) {
            if (!(externalProjectsView instanceof ExternalProjectsViewImpl)) continue;
            ExternalProjectsViewState externalProjectsViewState = ((ExternalProjectsViewImpl)externalProjectsView).getState();
            ExternalProjectsState.State state = this.myState.getExternalSystemsState().get(externalProjectsView.getSystemId().getId());
            assert (state != null);
            state.setProjectsViewState(externalProjectsViewState);
        }
        ExternalProjectsState externalProjectsState = this.myState;
        if (externalProjectsState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl", "getState"));
        }
        return externalProjectsState;
    }

    @NotNull
    public ExternalProjectsStateProvider getStateProvider() {
        ExternalProjectsStateProvider externalProjectsStateProvider = new ExternalProjectsStateProvider(){

            @Override
            public List<ExternalProjectsStateProvider.TasksActivation> getAllTasksActivation() {
                SmartList result2 = new SmartList();
                Map<String, ProjectSystemId> systemIds = ExternalSystemApiUtil.getAllManagers().stream().collect(Collectors.toMap(o -> o.getSystemId().getId(), o -> o.getSystemId()));
                for (Map.Entry<String, ExternalProjectsState.State> systemState : ExternalProjectsManagerImpl.this.myState.getExternalSystemsState().entrySet()) {
                    ProjectSystemId systemId = systemIds.get(systemState.getKey());
                    if (systemId == null) continue;
                    for (Map.Entry<String, TaskActivationState> activationStateEntry : systemState.getValue().getExternalSystemsTaskActivation().entrySet()) {
                        result2.add(new ExternalProjectsStateProvider.TasksActivation(systemId, activationStateEntry.getKey(), activationStateEntry.getValue()));
                    }
                }
                return result2;
            }

            @Override
            public List<ExternalProjectsStateProvider.TasksActivation> getTasksActivation(@NotNull ProjectSystemId systemId) {
                if (systemId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl$1", "getTasksActivation"));
                }
                Set<Map.Entry<String, TaskActivationState>> entries = ExternalProjectsManagerImpl.this.myState.getExternalSystemsState().get(systemId.getId()).getExternalSystemsTaskActivation().entrySet();
                return ContainerUtil.map(entries, entry -> {
                    if (systemId == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl$1", "lambda$getTasksActivation$2"));
                    }
                    return new ExternalProjectsStateProvider.TasksActivation(systemId, (String)entry.getKey(), (TaskActivationState)entry.getValue());
                });
            }

            @Override
            public TaskActivationState getTasksActivation(@NotNull ProjectSystemId systemId, @NotNull String projectPath) {
                if (systemId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl$1", "getTasksActivation"));
                }
                if (projectPath == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl$1", "getTasksActivation"));
                }
                return ExternalProjectsManagerImpl.this.myState.getExternalSystemsState().get(systemId.getId()).getExternalSystemsTaskActivation().get(projectPath);
            }

            @Override
            public Map<String, TaskActivationState> getProjectsTasksActivationMap(@NotNull ProjectSystemId systemId) {
                if (systemId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl$1", "getProjectsTasksActivationMap"));
                }
                return ExternalProjectsManagerImpl.this.myState.getExternalSystemsState().get(systemId.getId()).getExternalSystemsTaskActivation();
            }
        };
        if (externalProjectsStateProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl", "getStateProvider"));
        }
        return externalProjectsStateProvider;
    }

    public boolean isIgnored(@NotNull ProjectSystemId systemId, @NotNull String projectPath) {
        if (systemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl", "isIgnored"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl", "isIgnored"));
        }
        ExternalProjectInfo projectInfo = ExternalSystemUtil.getExternalProjectInfo(this.myProject, systemId, projectPath);
        if (projectInfo == null) {
            return true;
        }
        return ExternalProjectsDataStorage.getInstance(this.myProject).isIgnored(projectInfo.getExternalProjectPath(), projectPath, ProjectKeys.MODULE);
    }

    public void setIgnored(@NotNull DataNode<?> dataNode, boolean isIgnored) {
        if (dataNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataNode", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl", "setIgnored"));
        }
        ExternalProjectsDataStorage.getInstance(this.myProject).setIgnored(dataNode, isIgnored);
        ExternalSystemKeymapExtension.updateActions(this.myProject, ExternalSystemApiUtil.findAllRecursively(dataNode, (Key)ProjectKeys.TASK));
    }

    public void loadState(ExternalProjectsState state) {
        this.myState = state == null ? new ExternalProjectsState() : state;
    }

    public void dispose() {
        this.myProjectsViews.clear();
        this.myRunManagerListener.detach();
        if (this.myWatcher != null) {
            this.myWatcher.stop();
        }
        this.myWatcher = null;
    }

    public static interface ExternalProjectsStateProvider {
        public List<TasksActivation> getAllTasksActivation();

        public List<TasksActivation> getTasksActivation(@NotNull ProjectSystemId var1);

        public TaskActivationState getTasksActivation(@NotNull ProjectSystemId var1, @NotNull String var2);

        public Map<String, TaskActivationState> getProjectsTasksActivationMap(@NotNull ProjectSystemId var1);

        public static class TasksActivation {
            public final ProjectSystemId systemId;
            public final String projectPath;
            public final TaskActivationState state;

            public TasksActivation(ProjectSystemId systemId, String projectPath, TaskActivationState state) {
                this.systemId = systemId;
                this.projectPath = projectPath;
                this.state = state;
            }
        }
    }
}

