/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataImportListener;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectDataManagerImpl
implements ProjectDataManager {
    private static final Logger LOG = Logger.getInstance(ProjectDataManagerImpl.class);
    private static final com.intellij.openapi.util.Key<Boolean> DATA_READY = com.intellij.openapi.util.Key.create((String)"externalSystem.data.ready");
    @NotNull
    private final NotNullLazyValue<Map<Key<?>, List<ProjectDataService<?, ?>>>> myServices = new NotNullLazyValue<Map<Key<?>, List<ProjectDataService<?, ?>>>>(){

        @NotNull
        protected Map<Key<?>, List<ProjectDataService<?, ?>>> compute() {
            HashMap result2 = ContainerUtilRt.newHashMap();
            for (ProjectDataService service : (ProjectDataService[])ProjectDataService.EP_NAME.getExtensions()) {
                List services = (List)result2.get(service.getTargetDataKey());
                if (services == null) {
                    services = ContainerUtilRt.newArrayList();
                    result2.put(service.getTargetDataKey(), services);
                }
                services.add(service);
            }
            for (List services : result2.values()) {
                ExternalSystemApiUtil.orderAwareSort((List)services);
            }
            HashMap hashMap = result2;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl$1", "compute"));
            }
            return hashMap;
        }
    };

    public static ProjectDataManagerImpl getInstance() {
        ProjectDataManager service = (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class);
        return (ProjectDataManagerImpl)service;
    }

    public void importData(@NotNull Collection<DataNode<?>> nodes, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        ProjectSystemId projectSystemId;
        ProjectData projectData;
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "importData"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "importData"));
        }
        if (project2.isDisposed()) {
            return;
        }
        MultiMap grouped = ExternalSystemApiUtil.recursiveGroup(nodes);
        for (Key key2 : ((Map)this.myServices.getValue()).keySet()) {
            if (grouped.containsKey((Object)key2)) continue;
            grouped.put((Object)key2, Collections.emptyList());
        }
        Collection projects = grouped.get((Object)ProjectKeys.PROJECT);
        assert (projects.size() == 1 || projects.isEmpty());
        DataNode projectNode = (DataNode)ContainerUtil.getFirstItem((Collection)projects);
        if (projectNode != null) {
            projectData = (ProjectData)projectNode.getData();
            projectSystemId = ((ProjectData)projectNode.getData()).getOwner();
            ExternalProjectsDataStorage.getInstance(project2).saveInclusionSettings((DataNode<ProjectData>)projectNode);
        } else {
            projectData = null;
            DataNode aModuleNode = (DataNode)ContainerUtil.getFirstItem((Collection)grouped.get((Object)ProjectKeys.MODULE));
            ProjectSystemId projectSystemId2 = projectSystemId = aModuleNode != null ? ((ModuleData)aModuleNode.getData()).getOwner() : null;
        }
        if (projectSystemId != null) {
            ExternalSystemUtil.scheduleExternalViewStructureUpdate(project2, projectSystemId);
        }
        List onSuccessImportTasks = ContainerUtil.newSmartList();
        try {
            Set entries = grouped.entrySet();
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.setIndeterminate(false);
            }
            int size = entries.size();
            int count = 0;
            List postImportTasks = ContainerUtil.newSmartList();
            for (Map.Entry entry : entries) {
                if (indicator != null) {
                    String message2 = ExternalSystemBundle.message((String)"progress.update.text", (Object[])new Object[]{projectSystemId != null ? projectSystemId.getReadableName() : "", "Refresh " + ProjectDataManagerImpl.getReadableText((Key)entry.getKey())});
                    indicator.setText(message2);
                    indicator.setFraction((double)count++ / (double)size);
                }
                this.doImportData((Key)entry.getKey(), (Collection)entry.getValue(), projectData, project2, modelsProvider, postImportTasks, onSuccessImportTasks);
            }
            for (Runnable postImportTask : postImportTasks) {
                postImportTask.run();
            }
            ProjectDataManagerImpl.commit(modelsProvider, project2, synchronous, "Imported data");
            if (indicator != null) {
                indicator.setIndeterminate(true);
            }
            ((ProjectDataImportListener)project2.getMessageBus().syncPublisher(ProjectDataImportListener.TOPIC)).onImportFinished(projectData != null ? projectData.getLinkedExternalProjectPath() : null);
        }
        catch (Throwable t) {
            ProjectDataManagerImpl.dispose(modelsProvider, project2, synchronous);
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        Runnable runnable2 = () -> {
            for (Runnable onSuccessImportTask : ContainerUtil.reverse((List)onSuccessImportTasks)) {
                onSuccessImportTask.run();
            }
        };
        if (synchronous) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable2);
        }
    }

    @NotNull
    private static String getReadableText(@NotNull Key key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "getReadableText"));
        }
        StringBuilder buffer = new StringBuilder();
        String s = key2.toString();
        for (int i2 = 0; i2 < s.length(); ++i2) {
            char currChar = s.charAt(i2);
            if (Character.isUpperCase(currChar)) {
                if (i2 != 0) {
                    buffer.append(' ');
                }
                buffer.append(StringUtil.toLowerCase((char)currChar));
                continue;
            }
            buffer.append(currChar);
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "getReadableText"));
        }
        return string;
    }

    public <T> void importData(@NotNull Collection<DataNode<T>> nodes, @NotNull Project project2, boolean synchronous) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "importData"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "importData"));
        }
        List dummy = ContainerUtil.newSmartList();
        dummy.addAll(nodes);
        this.importData(dummy, project2, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project2), synchronous);
    }

    public <T> void importData(@NotNull DataNode<T> node, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "importData"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "importData"));
        }
        List dummy = ContainerUtil.newSmartList();
        dummy.add(node);
        this.importData(dummy, project2, modelsProvider, synchronous);
    }

    public <T> void importData(@NotNull DataNode<T> node, @NotNull Project project2, boolean synchronous) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "importData"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "importData"));
        }
        this.importData(node, project2, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project2), synchronous);
    }

    private <T> void doImportData(@NotNull Key<T> key2, @NotNull Collection<DataNode<?>> nodes, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modifiableModelsProvider, @NotNull List<Runnable> postImportTasks, @NotNull List<Runnable> onSuccessImportTasks) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "doImportData"));
        }
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "doImportData"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "doImportData"));
        }
        if (modifiableModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableModelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "doImportData"));
        }
        if (postImportTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postImportTasks", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "doImportData"));
        }
        if (onSuccessImportTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onSuccessImportTasks", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "doImportData"));
        }
        if (project2.isDisposed()) {
            return;
        }
        if (project2 instanceof ProjectImpl) assert (((ProjectImpl)project2).isComponentsCreated());
        List toImport = ContainerUtil.newSmartList();
        List toIgnore = ContainerUtil.newSmartList();
        for (DataNode<?> node : nodes) {
            if (!key2.equals((Object)node.getKey())) continue;
            if (node.isIgnored()) {
                toIgnore.add(node);
                continue;
            }
            toImport.add(node);
        }
        this.ensureTheDataIsReadyToUse(toImport);
        List services = (List)((Map)this.myServices.getValue()).get(key2);
        if (services == null) {
            LOG.warn(String.format("Can't import data nodes '%s'. Reason: no service is registered for key %s. Available services for %s", toImport, key2, ((Map)this.myServices.getValue()).keySet()));
        } else {
            for (ProjectDataService service : services) {
                long importStartTime = System.currentTimeMillis();
                service.importData((Collection)toImport, projectData, project2, modifiableModelsProvider);
                if (LOG.isDebugEnabled()) {
                    long importTimeInMs = System.currentTimeMillis() - importStartTime;
                    LOG.debug(String.format("Service %s imported data in %d ms", service.getClass().getSimpleName(), importTimeInMs));
                }
                if (projectData == null) continue;
                this.ensureTheDataIsReadyToUse(toIgnore);
                long removeStartTime = System.currentTimeMillis();
                Computable orphanIdeDataComputable = service.computeOrphanData((Collection)toImport, projectData, project2, modifiableModelsProvider);
                service.removeData(orphanIdeDataComputable, (Collection)toIgnore, projectData, project2, modifiableModelsProvider);
                if (!LOG.isDebugEnabled()) continue;
                long removeTimeInMs = System.currentTimeMillis() - removeStartTime;
                LOG.debug(String.format("Service %s computed and removed data in %d ms", service.getClass().getSimpleName(), removeTimeInMs));
            }
        }
        if (services != null && projectData != null) {
            postImportTasks.add(() -> {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "lambda$doImportData$1"));
                }
                if (modifiableModelsProvider == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableModelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "lambda$doImportData$1"));
                }
                for (ProjectDataService service : services) {
                    if (!(service instanceof AbstractProjectDataService)) continue;
                    long taskStartTime = System.currentTimeMillis();
                    ((AbstractProjectDataService)service).postProcess((Collection)toImport, projectData, project2, modifiableModelsProvider);
                    if (!LOG.isDebugEnabled()) continue;
                    long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
                    LOG.debug(String.format("Service %s run post import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
                }
            });
            onSuccessImportTasks.add(() -> {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "lambda$doImportData$2"));
                }
                IdeModelsProviderImpl modelsProvider = new IdeModelsProviderImpl(project2);
                for (ProjectDataService service : services) {
                    if (!(service instanceof AbstractProjectDataService)) continue;
                    long taskStartTime = System.currentTimeMillis();
                    ((AbstractProjectDataService)service).onSuccessImport((Collection)toImport, projectData, project2, (IdeModelsProvider)modelsProvider);
                    if (!LOG.isDebugEnabled()) continue;
                    long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
                    LOG.debug(String.format("Service %s run post import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
                }
            });
        }
    }

    public void ensureTheDataIsReadyToUse(@Nullable DataNode dataNode) {
        if (dataNode == null) {
            return;
        }
        if (Boolean.TRUE.equals(dataNode.getUserData(DATA_READY))) {
            return;
        }
        ExternalSystemApiUtil.visit((DataNode)dataNode, dataNode1 -> {
            this.prepareDataToUse((DataNode)dataNode1);
            dataNode1.putUserData(DATA_READY, (Object)Boolean.TRUE);
        });
    }

    public <E, I> void removeData(@NotNull Key<E> key2, @NotNull Collection<I> toRemove2, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "removeData"));
        }
        if (toRemove2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemove", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "removeData"));
        }
        if (toIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toIgnore", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "removeData"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "removeData"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "removeData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "removeData"));
        }
        try {
            List services = (List)((Map)this.myServices.getValue()).get(key2);
            for (ProjectDataService service : services) {
                long removeStartTime = System.currentTimeMillis();
                service.removeData((Computable)new Computable.PredefinedValueComputable(toRemove2), toIgnore, projectData, project2, modelsProvider);
                if (!LOG.isDebugEnabled()) continue;
                long removeTimeInMs = System.currentTimeMillis() - removeStartTime;
                LOG.debug(String.format("Service %s removed data in %d ms", service.getClass().getSimpleName(), removeTimeInMs));
            }
            ProjectDataManagerImpl.commit(modelsProvider, project2, synchronous, "Removed data");
        }
        catch (Throwable t) {
            ProjectDataManagerImpl.dispose(modelsProvider, project2, synchronous);
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
    }

    public <E, I> void removeData(@NotNull Key<E> key2, @NotNull Collection<I> toRemove2, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project2, boolean synchronous) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "removeData"));
        }
        if (toRemove2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemove", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "removeData"));
        }
        if (toIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toIgnore", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "removeData"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "removeData"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "removeData"));
        }
        this.removeData(key2, toRemove2, toIgnore, projectData, project2, new IdeModifiableModelsProviderImpl(project2), synchronous);
    }

    public void updateExternalProjectData(@NotNull Project project2, @NotNull ExternalProjectInfo externalProjectInfo) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "updateExternalProjectData"));
        }
        if (externalProjectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectInfo", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "updateExternalProjectData"));
        }
        if (!project2.isDisposed()) {
            ExternalProjectsManagerImpl.getInstance(project2).updateExternalProjectData(externalProjectInfo);
        }
    }

    @Nullable
    public ExternalProjectInfo getExternalProjectData(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "getExternalProjectData"));
        }
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemId", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "getExternalProjectData"));
        }
        if (externalProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectPath", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "getExternalProjectData"));
        }
        return !project2.isDisposed() ? ExternalProjectsDataStorage.getInstance(project2).get(projectSystemId, externalProjectPath) : null;
    }

    @NotNull
    public Collection<ExternalProjectInfo> getExternalProjectsData(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "getExternalProjectsData"));
        }
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemId", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "getExternalProjectsData"));
        }
        if (!project2.isDisposed()) {
            Collection<ExternalProjectInfo> collection = ExternalProjectsDataStorage.getInstance(project2).list(projectSystemId);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "getExternalProjectsData"));
            }
            return collection;
        }
        List list2 = ContainerUtil.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "getExternalProjectsData"));
        }
        return list2;
    }

    private void ensureTheDataIsReadyToUse(@NotNull Collection<DataNode<?>> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "ensureTheDataIsReadyToUse"));
        }
        for (DataNode<?> node : nodes) {
            this.ensureTheDataIsReadyToUse(node);
        }
    }

    private void prepareDataToUse(@NotNull DataNode dataNode) {
        if (dataNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataNode", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "prepareDataToUse"));
        }
        Map servicesByKey = (Map)this.myServices.getValue();
        List services = (List)servicesByKey.get(dataNode.getKey());
        if (services != null) {
            try {
                dataNode.prepareData((ClassLoader[])ContainerUtil.map2Array((Collection)services, ClassLoader.class, service -> service.getClass().getClassLoader()));
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
                dataNode.clear(true);
            }
        }
    }

    private static void commit(final @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Project project2, boolean synchronous, final @NotNull String commitDesc) {
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "commit"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "commit"));
        }
        if (commitDesc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitDesc", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "commit"));
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project2){

            public void execute() {
                long startTime = System.currentTimeMillis();
                modelsProvider.commit();
                long timeInMs = System.currentTimeMillis() - startTime;
                LOG.debug(String.format("%s committed in %d ms", commitDesc, timeInMs));
            }
        });
    }

    private static void dispose(final @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Project project2, boolean synchronous) {
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "dispose"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl", "dispose"));
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project2){

            public void execute() {
                modelsProvider.dispose();
            }
        });
    }
}

