/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Tag(value="activation")
public class TaskActivationState {
    @Tag(value="before_run")
    @AbstractCollection(surroundWithTag=false, elementTag="task", elementValueAttribute="name")
    public List<String> beforeRunTasks = new ArrayList<String>();
    @Tag(value="before_sync")
    @AbstractCollection(surroundWithTag=false, elementTag="task", elementValueAttribute="name")
    public List<String> beforeSyncTasks = new ArrayList<String>();
    @Tag(value="after_sync")
    @AbstractCollection(surroundWithTag=false, elementTag="task", elementValueAttribute="name")
    public List<String> afterSyncTasks = new ArrayList<String>();
    @Tag(value="before_compile")
    @AbstractCollection(surroundWithTag=false, elementTag="task", elementValueAttribute="name")
    public List<String> beforeCompileTasks = new ArrayList<String>();
    @Tag(value="after_compile")
    @AbstractCollection(surroundWithTag=false, elementTag="task", elementValueAttribute="name")
    public List<String> afterCompileTasks = new ArrayList<String>();
    @Tag(value="after_rebuild")
    @AbstractCollection(surroundWithTag=false, elementTag="task", elementValueAttribute="name")
    public List<String> afterRebuildTask = new ArrayList<String>();
    @Tag(value="before_rebuild")
    @AbstractCollection(surroundWithTag=false, elementTag="task", elementValueAttribute="name")
    public List<String> beforeRebuildTask = new ArrayList<String>();

    public boolean isEmpty() {
        for (ExternalSystemTaskActivator.Phase phase : ExternalSystemTaskActivator.Phase.values()) {
            if (this.getTasks(phase).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public List<String> getTasks(@NotNull ExternalSystemTaskActivator.Phase phase) {
        if (phase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "phase", "com/intellij/openapi/externalSystem/service/project/manage/TaskActivationState", "getTasks"));
        }
        switch (phase) {
            case AFTER_COMPILE: {
                List<String> list2 = this.afterCompileTasks;
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/TaskActivationState", "getTasks"));
                }
                return list2;
            }
            case BEFORE_COMPILE: {
                List<String> list3 = this.beforeCompileTasks;
                if (list3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/TaskActivationState", "getTasks"));
                }
                return list3;
            }
            case AFTER_SYNC: {
                List<String> list4 = this.afterSyncTasks;
                if (list4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/TaskActivationState", "getTasks"));
                }
                return list4;
            }
            case BEFORE_RUN: {
                List<String> list5 = this.beforeRunTasks;
                if (list5 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/TaskActivationState", "getTasks"));
                }
                return list5;
            }
            case BEFORE_SYNC: {
                List<String> list6 = this.beforeSyncTasks;
                if (list6 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/TaskActivationState", "getTasks"));
                }
                return list6;
            }
            case AFTER_REBUILD: {
                List<String> list7 = this.afterRebuildTask;
                if (list7 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/TaskActivationState", "getTasks"));
                }
                return list7;
            }
            case BEFORE_REBUILD: {
                List<String> list8 = this.beforeRebuildTask;
                if (list8 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/TaskActivationState", "getTasks"));
                }
                return list8;
            }
        }
        throw new IllegalArgumentException("Unknown task activation phase: " + (Object)((Object)phase));
    }
}

