/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.wizard;

import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.internal.InternalExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.AbstractIdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.IdeUIModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.settings.AbstractImportFromExternalSystemControl;
import com.intellij.openapi.externalSystem.service.ui.ExternalProjectDataSelectorDialog;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalProjectImportBuilder<C extends AbstractImportFromExternalSystemControl>
extends ProjectImportBuilder<DataNode<ProjectData>> {
    private static final Logger LOG = Logger.getInstance(AbstractExternalProjectImportBuilder.class);
    @NotNull
    private final ProjectDataManager myProjectDataManager;
    @NotNull
    private final C myControl;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    private DataNode<ProjectData> myExternalProjectNode;

    public AbstractExternalProjectImportBuilder(@NotNull com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager projectDataManager, @NotNull C control, @NotNull ProjectSystemId externalSystemId) {
        if (projectDataManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDataManager", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "<init>"));
        }
        if (control == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "control", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "<init>"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "<init>"));
        }
        this((ProjectDataManager)projectDataManager, control, externalSystemId);
    }

    public AbstractExternalProjectImportBuilder(@NotNull ProjectDataManager projectDataManager, @NotNull C control, @NotNull ProjectSystemId externalSystemId) {
        if (projectDataManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDataManager", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "<init>"));
        }
        if (control == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "control", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "<init>"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "<init>"));
        }
        this.myProjectDataManager = projectDataManager;
        this.myControl = control;
        this.myExternalSystemId = externalSystemId;
    }

    @Override
    public List<DataNode<ProjectData>> getList() {
        return Collections.singletonList(this.myExternalProjectNode);
    }

    @Override
    public boolean isMarked(DataNode<ProjectData> element) {
        return true;
    }

    @Override
    public void setList(List<DataNode<ProjectData>> externalSystemProjects) {
    }

    @Override
    public void setOpenProjectSettingsAfter(boolean on) {
    }

    @NotNull
    public C getControl(@Nullable Project currentProject) {
        ((AbstractImportFromExternalSystemControl)this.myControl).setCurrentProject(currentProject);
        C c = this.myControl;
        if (c == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "getControl"));
        }
        return c;
    }

    public void prepare(@NotNull WizardContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "prepare"));
        }
        ((AbstractImportFromExternalSystemControl)this.myControl).setShowProjectFormatPanel(context.isCreatingNewProject());
        ((AbstractImportFromExternalSystemControl)this.myControl).reset();
        String pathToUse = this.getFileToImport();
        ((AbstractImportFromExternalSystemControl)this.myControl).setLinkedProjectPath(pathToUse);
        this.doPrepare(context);
    }

    protected abstract void doPrepare(@NotNull WizardContext var1);

    @Override
    public List<Module> commit(Project project2, ModifiableModuleModel model, ModulesProvider modulesProvider, ModifiableArtifactModel artifactModel) {
        project2.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)Boolean.TRUE);
        DataNode<ProjectData> externalProjectNode = this.getExternalProjectNode();
        if (externalProjectNode != null) {
            this.beforeCommit(externalProjectNode, project2);
        }
        boolean isFromUI = model != null;
        final List modules = ContainerUtil.newSmartList();
        final IdentityHashMap moduleMap = ContainerUtil.newIdentityHashMap();
        AbstractIdeModifiableModelsProvider modelsProvider = isFromUI ? new IdeUIModifiableModelsProvider(project2, model, (ModulesConfigurator)modulesProvider, artifactModel){

            @Override
            protected ModifiableRootModel doGetModifiableRootModel(Module module2) {
                ModifiableRootModel modifiableRootModel = super.doGetModifiableRootModel(module2);
                moduleMap.put(modifiableRootModel, module2);
                return modifiableRootModel;
            }

            @Override
            public void commit() {
                super.commit();
                for (Map.Entry moduleEntry : moduleMap.entrySet()) {
                    modules.add(moduleEntry.getValue());
                }
            }
        } : new IdeModifiableModelsProviderImpl(project2){

            @Override
            @NotNull
            protected ModifiableRootModel doGetModifiableRootModel(@NotNull Module module2) {
                if (module2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder$2", "doGetModifiableRootModel"));
                }
                ModifiableRootModel modifiableRootModel = super.doGetModifiableRootModel(module2);
                moduleMap.put(modifiableRootModel, module2);
                ModifiableRootModel modifiableRootModel2 = modifiableRootModel;
                if (modifiableRootModel2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder$2", "doGetModifiableRootModel"));
                }
                return modifiableRootModel2;
            }

            @Override
            public void commit() {
                super.commit();
                for (Map.Entry moduleEntry : moduleMap.entrySet()) {
                    if (((ModifiableRootModel)moduleEntry.getKey()).isWritable()) continue;
                    modules.add(moduleEntry.getValue());
                }
            }
        };
        AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)this.myExternalSystemId);
        ExternalProjectSettings projectSettings = this.getCurrentExternalProjectSettings();
        HashSet projects = ContainerUtilRt.newHashSet((Iterable)systemSettings.getLinkedProjectsSettings());
        projects.remove(projectSettings);
        projects.add(projectSettings);
        systemSettings.copyFrom(((AbstractImportFromExternalSystemControl)this.myControl).getSystemSettings());
        systemSettings.setLinkedProjectsSettings((Collection)projects);
        if (externalProjectNode != null) {
            if (systemSettings.showSelectiveImportDialogOnInitialImport() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
                ExternalProjectDataSelectorDialog dialog2 = new ExternalProjectDataSelectorDialog(project2, new InternalExternalProjectInfo(this.myExternalSystemId, projectSettings.getExternalProjectPath(), externalProjectNode));
                if (dialog2.hasMultipleDataToSelect()) {
                    dialog2.showAndGet();
                } else {
                    Disposer.dispose((Disposable)dialog2.getDisposable());
                }
            }
            if (!project2.isInitialized()) {
                StartupManager.getInstance((Project)project2).runWhenProjectIsInitialized(() -> this.finishImport(project2, externalProjectNode, isFromUI, modules, modelsProvider, projectSettings));
            } else {
                this.finishImport(project2, externalProjectNode, isFromUI, modules, modelsProvider, projectSettings);
            }
        }
        return modules;
    }

    protected void finishImport(Project project2, DataNode<ProjectData> externalProjectNode, boolean isFromUI, List<Module> modules, IdeModifiableModelsProvider modelsProvider, ExternalProjectSettings projectSettings) {
        this.myProjectDataManager.importData(externalProjectNode, project2, modelsProvider, true);
        this.myExternalProjectNode = null;
        Runnable resolveDependenciesTask = () -> ExternalSystemUtil.refreshProject(project2, this.myExternalSystemId, projectSettings.getExternalProjectPath(), this.createFinalImportCallback(project2, projectSettings), false, ProgressExecutionMode.IN_BACKGROUND_ASYNC, true);
        if (!isFromUI) {
            resolveDependenciesTask.run();
        } else {
            ExternalSystemUtil.invokeLater(project2, ModalityState.NON_MODAL, () -> {
                Object[] committedModules = ModuleManager.getInstance((Project)project2).getModules();
                if (ContainerUtil.list((Object[])committedModules).containsAll(modules)) {
                    resolveDependenciesTask.run();
                }
            });
        }
    }

    protected ExternalProjectRefreshCallback createFinalImportCallback(final @NotNull Project project2, @NotNull ExternalProjectSettings projectSettings) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "createFinalImportCallback"));
        }
        if (projectSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSettings", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "createFinalImportCallback"));
        }
        return new ExternalProjectRefreshCallback(){

            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                if (externalProject == null) {
                    return;
                }
                ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(externalProject, project2, false);
            }

            public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder$3", "onFailure"));
                }
            }
        };
    }

    @NotNull
    private ExternalProjectSettings getCurrentExternalProjectSettings() {
        ExternalProjectSettings result2 = ((AbstractImportFromExternalSystemControl)this.myControl).getProjectSettings().clone();
        File externalProjectConfigFile = this.getExternalProjectConfigToUse(new File(result2.getExternalProjectPath()));
        String linkedProjectPath = FileUtil.toCanonicalPath((String)externalProjectConfigFile.getPath());
        assert (linkedProjectPath != null);
        result2.setExternalProjectPath(linkedProjectPath);
        ExternalProjectSettings externalProjectSettings = result2;
        if (externalProjectSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "getCurrentExternalProjectSettings"));
        }
        return externalProjectSettings;
    }

    protected abstract void beforeCommit(@NotNull DataNode<ProjectData> var1, @NotNull Project var2);

    @Nullable
    private File getProjectFile() {
        String path = ((AbstractImportFromExternalSystemControl)this.myControl).getProjectSettings().getExternalProjectPath();
        return path == null ? null : new File(path);
    }

    public void ensureProjectIsDefined(@NotNull WizardContext wizardContext) throws ConfigurationException {
        if (wizardContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizardContext", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "ensureProjectIsDefined"));
        }
        String externalSystemName = this.myExternalSystemId.getReadableName();
        File projectFile = this.getProjectFile();
        if (projectFile == null) {
            throw new ConfigurationException(ExternalSystemBundle.message((String)"error.project.undefined", (Object[])new Object[0]));
        }
        projectFile = this.getExternalProjectConfigToUse(projectFile);
        final Ref error = new Ref();
        ExternalProjectRefreshCallback callback = new ExternalProjectRefreshCallback(){

            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                AbstractExternalProjectImportBuilder.this.myExternalProjectNode = externalProject;
            }

            public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder$4", "onFailure"));
                }
                if (!StringUtil.isEmpty((String)errorDetails)) {
                    LOG.warn(errorDetails);
                }
                error.set((Object)new ConfigurationException(ExternalSystemBundle.message((String)"error.resolve.with.log_link", (Object[])new Object[]{errorMessage, PathManager.getLogPath()}), ExternalSystemBundle.message((String)"error.resolve.generic", (Object[])new Object[0])));
            }
        };
        Project project2 = this.getProject(wizardContext);
        File finalProjectFile = projectFile;
        String externalProjectPath = FileUtil.toCanonicalPath((String)finalProjectFile.getAbsolutePath());
        Ref exRef = new Ref();
        this.executeAndRestoreDefaultProjectSettings(project2, () -> {
            try {
                ExternalSystemUtil.refreshProject(project2, this.myExternalSystemId, externalProjectPath, callback, true, ProgressExecutionMode.MODAL_SYNC);
            }
            catch (IllegalArgumentException e) {
                exRef.set((Object)new ConfigurationException(e.getMessage(), ExternalSystemBundle.message((String)"error.cannot.parse.project", (Object[])new Object[]{externalSystemName})));
            }
        });
        ConfigurationException ex = (ConfigurationException)((Object)exRef.get());
        if (ex != null) {
            throw ex;
        }
        if (this.myExternalProjectNode == null) {
            ConfigurationException exception = (ConfigurationException)((Object)error.get());
            if (exception != null) {
                throw exception;
            }
        } else {
            this.applyProjectSettings(wizardContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAndRestoreDefaultProjectSettings(@NotNull Project project2, @NotNull Runnable task) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "executeAndRestoreDefaultProjectSettings"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "executeAndRestoreDefaultProjectSettings"));
        }
        AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)this.myExternalSystemId);
        Object systemStateToRestore = null;
        if (systemSettings instanceof PersistentStateComponent) {
            systemStateToRestore = ((PersistentStateComponent)systemSettings).getState();
        }
        systemSettings.copyFrom(((AbstractImportFromExternalSystemControl)this.myControl).getSystemSettings());
        Collection projectSettingsToRestore = systemSettings.getLinkedProjectsSettings();
        HashSet projects = ContainerUtilRt.newHashSet((Iterable)systemSettings.getLinkedProjectsSettings());
        projects.add(this.getCurrentExternalProjectSettings());
        systemSettings.setLinkedProjectsSettings((Collection)projects);
        try {
            task.run();
        }
        finally {
            if (systemStateToRestore != null) {
                ((PersistentStateComponent)systemSettings).loadState(systemStateToRestore);
            } else {
                systemSettings.setLinkedProjectsSettings(projectSettingsToRestore);
            }
        }
    }

    @NotNull
    protected abstract File getExternalProjectConfigToUse(@NotNull File var1);

    @Nullable
    public DataNode<ProjectData> getExternalProjectNode() {
        return this.myExternalProjectNode;
    }

    public void applyProjectSettings(@NotNull WizardContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "applyProjectSettings"));
        }
        if (this.myExternalProjectNode == null) {
            assert (false);
            return;
        }
        context.setProjectName(((ProjectData)this.myExternalProjectNode.getData()).getInternalName());
        context.setProjectFileDirectory(((ProjectData)this.myExternalProjectNode.getData()).getIdeProjectFileDirectoryPath());
        this.applyExtraSettings(context);
    }

    protected abstract void applyExtraSettings(@NotNull WizardContext var1);

    @NotNull
    public Project getProject(@NotNull WizardContext wizardContext) {
        if (wizardContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizardContext", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "getProject"));
        }
        Project result2 = wizardContext.getProject();
        if (result2 == null) {
            result2 = ProjectManager.getInstance().getDefaultProject();
        }
        Project project2 = result2;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "getProject"));
        }
        return project2;
    }
}

