/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.remote.wrapper;

import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemService;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractRemoteExternalSystemServiceWrapper<S extends ExternalSystemExecutionSettings, T extends RemoteExternalSystemService<S>>
implements RemoteExternalSystemService<S> {
    @NotNull
    private final T myDelegate;

    public AbstractRemoteExternalSystemServiceWrapper(@NotNull T delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/externalSystem/service/remote/wrapper/AbstractRemoteExternalSystemServiceWrapper", "<init>"));
        }
        this.myDelegate = delegate;
    }

    @Override
    public void setSettings(@NotNull S settings) throws RemoteException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/externalSystem/service/remote/wrapper/AbstractRemoteExternalSystemServiceWrapper", "setSettings"));
        }
        this.myDelegate.setSettings(settings);
    }

    @Override
    public void setNotificationListener(@NotNull ExternalSystemTaskNotificationListener notificationListener) throws RemoteException {
        if (notificationListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationListener", "com/intellij/openapi/externalSystem/service/remote/wrapper/AbstractRemoteExternalSystemServiceWrapper", "setNotificationListener"));
        }
        this.myDelegate.setNotificationListener(notificationListener);
    }

    @Override
    public boolean isTaskInProgress(@NotNull ExternalSystemTaskId id) throws RemoteException {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/remote/wrapper/AbstractRemoteExternalSystemServiceWrapper", "isTaskInProgress"));
        }
        return this.myDelegate.isTaskInProgress(id);
    }

    @Override
    @NotNull
    public Map<ExternalSystemTaskType, Set<ExternalSystemTaskId>> getTasksInProgress() throws RemoteException {
        Map<ExternalSystemTaskType, Set<ExternalSystemTaskId>> map2 = this.myDelegate.getTasksInProgress();
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/remote/wrapper/AbstractRemoteExternalSystemServiceWrapper", "getTasksInProgress"));
        }
        return map2;
    }

    @NotNull
    public T getDelegate() {
        T t = this.myDelegate;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/remote/wrapper/AbstractRemoteExternalSystemServiceWrapper", "getDelegate"));
        }
        return t;
    }
}

