/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.task;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.service.task.AbstractToolWindowService;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Order(value=-2147483644)
public class ToolWindowModuleService
extends AbstractToolWindowService<ModuleData> {
    @NotNull
    public static final Function<DataNode<ModuleData>, ExternalProjectPojo> MAPPER = node -> ExternalProjectPojo.from((Named)((Named)node.getData()));

    @NotNull
    public Key<ModuleData> getTargetDataKey() {
        Key key2 = ProjectKeys.MODULE;
        if (key2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/task/ToolWindowModuleService", "getTargetDataKey"));
        }
        return key2;
    }

    @Override
    protected void processData(@NotNull Collection<DataNode<ModuleData>> nodes, @NotNull Project project2) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/externalSystem/service/task/ToolWindowModuleService", "processData"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/task/ToolWindowModuleService", "processData"));
        }
        if (nodes.isEmpty()) {
            return;
        }
        ProjectSystemId externalSystemId = ((ModuleData)nodes.iterator().next().getData()).getOwner();
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        assert (manager != null);
        MultiMap grouped = ExternalSystemApiUtil.groupBy(nodes, (Key)ProjectKeys.PROJECT);
        HashMap data = ContainerUtilRt.newHashMap();
        for (Map.Entry entry : grouped.entrySet()) {
            data.put(ExternalProjectPojo.from((Named)((Named)((DataNode)entry.getKey()).getData())), ContainerUtilRt.map2List((Collection)((Collection)entry.getValue()), MAPPER));
        }
        AbstractExternalSystemLocalSettings settings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project2);
        Set<String> pathsToForget = ToolWindowModuleService.detectRenamedProjects(data, settings.getAvailableProjects());
        if (!pathsToForget.isEmpty()) {
            settings.forgetExternalProjects(pathsToForget);
        }
        HashMap projects = ContainerUtilRt.newHashMap((Map)settings.getAvailableProjects());
        projects.putAll(data);
        settings.setAvailableProjects((Map)projects);
    }

    @NotNull
    private static Set<String> detectRenamedProjects(@NotNull Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> currentInfo, @NotNull Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> oldInfo) {
        if (currentInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentInfo", "com/intellij/openapi/externalSystem/service/task/ToolWindowModuleService", "detectRenamedProjects"));
        }
        if (oldInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldInfo", "com/intellij/openapi/externalSystem/service/task/ToolWindowModuleService", "detectRenamedProjects"));
        }
        HashMap map2 = ContainerUtilRt.newHashMap();
        for (Map.Entry<ExternalProjectPojo, Collection<ExternalProjectPojo>> entry : currentInfo.entrySet()) {
            map2.put(entry.getKey().getPath(), entry.getKey().getName());
            for (ExternalProjectPojo pojo : entry.getValue()) {
                map2.put(pojo.getPath(), pojo.getName());
            }
        }
        HashSet result2 = ContainerUtilRt.newHashSet();
        for (Map.Entry<ExternalProjectPojo, Collection<ExternalProjectPojo>> entry : oldInfo.entrySet()) {
            String newName = (String)map2.get(entry.getKey().getPath());
            if (newName != null && !newName.equals(entry.getKey().getName())) {
                result2.add(entry.getKey().getPath());
            }
            for (ExternalProjectPojo pojo : entry.getValue()) {
                newName = (String)map2.get(pojo.getPath());
                if (newName == null || newName.equals(pojo.getName())) continue;
                result2.add(pojo.getPath());
            }
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/task/ToolWindowModuleService", "detectRenamedProjects"));
        }
        return hashSet;
    }
}

