/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.task.ui;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.impl.ContentImpl;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractExternalSystemToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    @NotNull
    private final ProjectSystemId myExternalSystemId;

    protected AbstractExternalSystemToolWindowFactory(@NotNull ProjectSystemId id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/task/ui/AbstractExternalSystemToolWindowFactory", "<init>"));
        }
        this.myExternalSystemId = id;
    }

    public void createToolWindowContent(@NotNull Project project2, @NotNull ToolWindow toolWindow) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/task/ui/AbstractExternalSystemToolWindowFactory", "createToolWindowContent"));
        }
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/openapi/externalSystem/service/task/ui/AbstractExternalSystemToolWindowFactory", "createToolWindowContent"));
        }
        toolWindow.setTitle(this.myExternalSystemId.getReadableName());
        ContentManager contentManager = toolWindow.getContentManager();
        ExternalProjectsViewImpl projectsView = new ExternalProjectsViewImpl(project2, (ToolWindowEx)toolWindow, this.myExternalSystemId);
        ExternalProjectsManagerImpl.getInstance(project2).registerView(projectsView);
        ContentImpl tasksContent = new ContentImpl((JComponent)((Object)projectsView), ExternalSystemBundle.message((String)"tool.window.title.projects", (Object[])new Object[0]), true);
        contentManager.addContent((Content)tasksContent);
    }
}

