/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FileNodeDescriptor
extends NodeDescriptor {
    private FileElement myFileElement;
    private final Icon myOriginalIcon;
    private final String myComment;

    public FileNodeDescriptor(Project project2, @NotNull FileElement element, NodeDescriptor parentDescriptor, Icon closedIcon, String name2, String comment) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/fileChooser/ex/FileNodeDescriptor", "<init>"));
        }
        super(project2, parentDescriptor);
        this.myOriginalIcon = closedIcon;
        this.myComment = comment;
        this.myFileElement = element;
        this.myName = name2;
    }

    public boolean update() {
        VirtualFile file2;
        boolean changed = false;
        if (this.myName == null || this.myComment == null) {
            String newName = this.myFileElement.toString();
            if (!newName.equals(this.myName)) {
                changed = true;
            }
            this.myName = newName;
        }
        if ((file2 = this.myFileElement.getFile()) == null) {
            return true;
        }
        this.setIcon(this.myOriginalIcon);
        if (this.myFileElement.isHidden()) {
            this.setIcon(IconLoader.getTransparentIcon((Icon)this.getIcon()));
        }
        this.myColor = this.myFileElement.isHidden() ? SimpleTextAttributes.DARK_TEXT.getFgColor() : null;
        return changed;
    }

    @NotNull
    public final FileElement getElement() {
        FileElement fileElement = this.myFileElement;
        if (fileElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileChooser/ex/FileNodeDescriptor", "getElement"));
        }
        return fileElement;
    }

    protected final void setElement(FileElement descriptor) {
        this.myFileElement = descriptor;
    }

    public String getComment() {
        return this.myComment;
    }
}

