/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.tree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class FileRefresher
implements Disposable {
    private final ScheduledExecutorService executor = AppExecutorUtil.createBoundedScheduledExecutorService((String)"FileRefresher", (int)1);
    private final boolean recursive;
    private final long delay;
    private final ArrayList<Object> watchers = new ArrayList();
    private final ArrayList<VirtualFile> files = new ArrayList();
    private final AtomicBoolean scheduled = new AtomicBoolean();
    private final AtomicBoolean launched = new AtomicBoolean();
    private final AtomicBoolean paused = new AtomicBoolean();
    private final AtomicBoolean disposed = new AtomicBoolean();
    private RefreshSession session;

    public FileRefresher(boolean recursive, long delay) {
        if (delay <= 0L) {
            throw new IllegalArgumentException("delay");
        }
        this.recursive = recursive;
        this.delay = delay;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    protected Object watch(VirtualFile file2, boolean recursive) {
        VirtualFileSystem fs = file2.getFileSystem();
        if (fs instanceof LocalFileSystem) {
            return LocalFileSystem.getInstance().addRootToWatch(file2.getPath(), recursive);
        }
        return null;
    }

    protected void unwatch(Object watcher) {
        if (watcher instanceof LocalFileSystem.WatchRequest) {
            LocalFileSystem.getInstance().removeWatchedRoot((LocalFileSystem.WatchRequest)watcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void register(VirtualFile file2) {
        if (file2 != null && !this.disposed.get()) {
            ArrayList<Object> arrayList;
            Object watcher = this.watch(file2, this.recursive);
            if (watcher != null) {
                arrayList = this.watchers;
                synchronized (arrayList) {
                    this.watchers.add(watcher);
                }
            }
            arrayList = this.files;
            synchronized (arrayList) {
                this.files.add(file2);
            }
            if (!this.paused.get()) {
                this.schedule();
            }
        }
    }

    public final void pause() {
        this.paused.set(true);
    }

    public final void start() {
        this.paused.set(false);
        this.launch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule() {
        if (this.disposed.get() || this.scheduled.getAndSet(true)) {
            return;
        }
        ArrayList<VirtualFile> arrayList = this.files;
        synchronized (arrayList) {
            if (this.session != null || this.files.isEmpty()) {
                return;
            }
        }
        this.executor.schedule(this::launch, this.delay, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launch() {
        RefreshSession session2;
        if (this.disposed.get() || this.launched.getAndSet(true)) {
            return;
        }
        ArrayList<VirtualFile> arrayList = this.files;
        synchronized (arrayList) {
            if (this.session != null || this.files.isEmpty()) {
                return;
            }
            session2 = RefreshQueue.getInstance().createSession(true, this.recursive, this::finish);
            session2.addAllFiles(this.files);
            this.session = session2;
        }
        this.scheduled.set(false);
        this.launched.set(false);
        session2.launch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish() {
        ArrayList<VirtualFile> arrayList = this.files;
        synchronized (arrayList) {
            this.session = null;
        }
        if (this.launched.getAndSet(false)) {
            this.launch();
        } else if (this.scheduled.getAndSet(false) || !this.paused.get()) {
            this.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (!this.disposed.getAndSet(true)) {
            RefreshSession session2;
            ArrayList<Object> arrayList = this.watchers;
            synchronized (arrayList) {
                this.watchers.forEach(this::unwatch);
                this.watchers.clear();
            }
            ArrayList<VirtualFile> arrayList2 = this.files;
            synchronized (arrayList2) {
                this.files.clear();
                session2 = this.session;
                this.session = null;
            }
            if (session2 != null) {
                RefreshQueue.getInstance().cancelSession(session2.getId());
            }
        }
    }
}

