/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.pom.Navigatable;
import com.intellij.util.EventDispatcher;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRemoteFileEditor
implements TextEditor,
PropertyChangeListener {
    private Editor myMockTextEditor;
    private Navigatable myPendingNavigatable;
    protected final Project myProject;
    private final UserDataHolderBase myUserDataHolder;
    private final EventDispatcher<PropertyChangeListener> myDispatcher;

    protected BaseRemoteFileEditor(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/BaseRemoteFileEditor", "<init>"));
        }
        this.myUserDataHolder = new UserDataHolderBase();
        this.myDispatcher = EventDispatcher.create(PropertyChangeListener.class);
        this.myProject = project2;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        TextEditor textEditor = this.getTextEditor();
        return textEditor == null ? null : textEditor.getStructureViewBuilder();
    }

    @NotNull
    public Editor getEditor() {
        TextEditor fileEditor = this.getTextEditor();
        if (fileEditor != null) {
            Editor editor = fileEditor.getEditor();
            if (editor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/BaseRemoteFileEditor", "getEditor"));
            }
            return editor;
        }
        if (this.myMockTextEditor == null) {
            this.myMockTextEditor = EditorFactory.getInstance().createViewer((Document)new DocumentImpl(""), this.myProject);
        }
        Editor editor = this.myMockTextEditor;
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/BaseRemoteFileEditor", "getEditor"));
        }
        return editor;
    }

    @Nullable
    protected abstract TextEditor getTextEditor();

    public FileEditorLocation getCurrentLocation() {
        TextEditor textEditor = this.getTextEditor();
        return textEditor == null ? null : textEditor.getCurrentLocation();
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        TextEditor textEditor = this.getTextEditor();
        return textEditor == null ? null : textEditor.getBackgroundHighlighter();
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/fileEditor/impl/BaseRemoteFileEditor", "getState"));
        }
        TextEditor textEditor = this.getTextEditor();
        TextEditorState textEditorState = textEditor == null ? new TextEditorState() : textEditor.getState(level);
        if (textEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/BaseRemoteFileEditor", "getState"));
        }
        return textEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/fileEditor/impl/BaseRemoteFileEditor", "setState"));
        }
        TextEditor textEditor = this.getTextEditor();
        if (textEditor != null && state instanceof TextEditorState) {
            textEditor.setState(state);
        }
    }

    public <T> T getUserData(@NotNull Key<T> key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/fileEditor/impl/BaseRemoteFileEditor", "getUserData"));
        }
        TextEditor textEditor = this.getTextEditor();
        return (T)(textEditor == null ? this.myUserDataHolder.getUserData(key2) : textEditor.getUserData(key2));
    }

    public <T> void putUserData(@NotNull Key<T> key2, @Nullable T value2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/fileEditor/impl/BaseRemoteFileEditor", "putUserData"));
        }
        TextEditor textEditor = this.getTextEditor();
        if (textEditor == null) {
            this.myUserDataHolder.putUserData(key2, value2);
        } else {
            textEditor.putUserData(key2, value2);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        TextEditor editor = this.getTextEditor();
        return editor == null || editor.isValid();
    }

    public void dispose() {
        if (this.myMockTextEditor != null) {
            EditorFactory.getInstance().releaseEditor(this.myMockTextEditor);
        }
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/fileEditor/impl/BaseRemoteFileEditor", "addPropertyChangeListener"));
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/fileEditor/impl/BaseRemoteFileEditor", "removePropertyChangeListener"));
        }
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/BaseRemoteFileEditor", "propertyChange"));
        }
        ((PropertyChangeListener)this.myDispatcher.getMulticaster()).propertyChange(event);
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/intellij/openapi/fileEditor/impl/BaseRemoteFileEditor", "canNavigateTo"));
        }
        TextEditor editor = this.getTextEditor();
        return editor == null ? this.isValid() : editor.canNavigateTo(navigatable);
    }

    public final void navigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/intellij/openapi/fileEditor/impl/BaseRemoteFileEditor", "navigateTo"));
        }
        TextEditor editor = this.getTextEditor();
        if (editor != null) {
            editor.navigateTo(navigatable);
        } else if (this.isValid()) {
            this.myPendingNavigatable = navigatable;
        }
    }

    protected final void contentLoaded() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Navigatable navigatable = this.myPendingNavigatable;
        if (navigatable != null) {
            this.myPendingNavigatable = null;
            TextEditor editor = this.getTextEditor();
            assert (editor != null);
            editor.navigateTo(navigatable);
        }
        if (this.myMockTextEditor != null) {
            if (!this.myMockTextEditor.isDisposed()) {
                EditorFactory.getInstance().releaseEditor(this.myMockTextEditor);
            }
            this.myMockTextEditor = null;
        }
    }

    protected final void contentRejected() {
        this.myPendingNavigatable = null;
    }
}

