/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.util.ObjectUtils;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public class LargeFileEditorProvider
extends TextEditorProvider {
    @Override
    public boolean accept(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider", "accept"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider", "accept"));
        }
        return TextEditorProvider.isTextFile(file2) && SingleRootFileViewProvider.isTooLargeForContentLoading(file2);
    }

    @Override
    @NotNull
    public FileEditor createEditor(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider", "createEditor"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider", "createEditor"));
        }
        UserDataHolderBase userDataHolderBase = file2.getFileType().isBinary() ? new LargeBinaryFileEditor(file2) : new LargeTextFileEditor(project2, file2, this);
        if (userDataHolderBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider", "createEditor"));
        }
        return userDataHolderBase;
    }

    @Override
    @NotNull
    public String getEditorTypeId() {
        if ("LargeFileEditor" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider", "getEditorTypeId"));
        }
        return "LargeFileEditor";
    }

    private static class LargeBinaryFileEditor
    extends UserDataHolderBase
    implements FileEditor {
        private final VirtualFile myFile;

        LargeBinaryFileEditor(VirtualFile file2) {
            this.myFile = file2;
        }

        @NotNull
        public JComponent getComponent() {
            JLabel label = new JLabel("Binary file " + this.myFile.getPath() + " is too large (" + StringUtil.formatFileSize((long)this.myFile.getLength()) + ")");
            label.setHorizontalAlignment(0);
            JLabel jLabel = label;
            if (jLabel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider$LargeBinaryFileEditor", "getComponent"));
            }
            return jLabel;
        }

        public JComponent getPreferredFocusedComponent() {
            return null;
        }

        @NotNull
        public String getName() {
            if ("Large file editor" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider$LargeBinaryFileEditor", "getName"));
            }
            return "Large file editor";
        }

        @NotNull
        public FileEditorState getState(@NotNull FileEditorStateLevel level) {
            if (level == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider$LargeBinaryFileEditor", "getState"));
            }
            TextEditorState textEditorState = new TextEditorState();
            if (textEditorState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider$LargeBinaryFileEditor", "getState"));
            }
            return textEditorState;
        }

        public void setState(@NotNull FileEditorState state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider$LargeBinaryFileEditor", "setState"));
            }
        }

        public boolean isModified() {
            return false;
        }

        public boolean isValid() {
            return this.myFile.isValid();
        }

        public void selectNotify() {
        }

        public void deselectNotify() {
        }

        public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
            if (listener2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider$LargeBinaryFileEditor", "addPropertyChangeListener"));
            }
        }

        public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
            if (listener2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider$LargeBinaryFileEditor", "removePropertyChangeListener"));
            }
        }

        public BackgroundEditorHighlighter getBackgroundHighlighter() {
            return null;
        }

        public FileEditorLocation getCurrentLocation() {
            return null;
        }

        public StructureViewBuilder getStructureViewBuilder() {
            return null;
        }

        public void dispose() {
        }
    }

    public static class LargeTextFileEditor
    extends TextEditorImpl {
        LargeTextFileEditor(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull TextEditorProvider provider) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider$LargeTextFileEditor", "<init>"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider$LargeTextFileEditor", "<init>"));
            }
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider$LargeTextFileEditor", "<init>"));
            }
            super(project2, file2, provider);
            ObjectUtils.consumeIfCast((Object)this.getEditor(), EditorEx.class, editorEx -> editorEx.setViewer(true));
        }
    }
}

