/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.options.Scheme;
import org.jetbrains.annotations.NotNull;

final class KeymapScheme
implements Scheme {
    private final KeymapImpl original;
    private KeymapImpl mutable;

    KeymapScheme(@NotNull Keymap keymap) {
        if (keymap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keymap", "com/intellij/openapi/keymap/impl/ui/KeymapScheme", "<init>"));
        }
        this.original = (KeymapImpl)keymap;
    }

    @NotNull
    public String getName() {
        String string = this.getCurrent().getPresentableName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/KeymapScheme", "getName"));
        }
        return string;
    }

    void setName(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/keymap/impl/ui/KeymapScheme", "setName"));
        }
        this.getMutable().setName(name2);
    }

    Keymap getParent() {
        return !this.isMutable() ? null : this.original.getParent();
    }

    @NotNull
    Keymap getOriginal() {
        KeymapImpl keymapImpl = this.original;
        if (keymapImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/KeymapScheme", "getOriginal"));
        }
        return keymapImpl;
    }

    @NotNull
    KeymapImpl getCurrent() {
        KeymapImpl keymapImpl = this.mutable != null ? this.mutable : this.original;
        if (keymapImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/KeymapScheme", "getCurrent"));
        }
        return keymapImpl;
    }

    @NotNull
    KeymapImpl getMutable() {
        if (this.mutable != null) {
            KeymapImpl keymapImpl = this.mutable;
            if (keymapImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/KeymapScheme", "getMutable"));
            }
            return keymapImpl;
        }
        assert (this.isMutable()) : "create a mutable copy for immutable keymap";
        KeymapImpl keymapImpl = this.mutable = this.original.copyTo(new KeymapImpl());
        if (keymapImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/KeymapScheme", "getMutable"));
        }
        return keymapImpl;
    }

    boolean isMutable() {
        return this.original.canModify();
    }

    boolean contains(@NotNull Keymap keymap) {
        if (keymap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keymap", "com/intellij/openapi/keymap/impl/ui/KeymapScheme", "contains"));
        }
        return keymap == this.original || keymap == this.mutable;
    }

    private static boolean contains(@NotNull Keymap keymap, @NotNull String name2) {
        if (keymap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keymap", "com/intellij/openapi/keymap/impl/ui/KeymapScheme", "contains"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/keymap/impl/ui/KeymapScheme", "contains"));
        }
        return name2.equals(keymap.getName()) || name2.equals(keymap.getPresentableName());
    }

    boolean contains(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/keymap/impl/ui/KeymapScheme", "contains"));
        }
        return KeymapScheme.contains(this.original, name2) || this.mutable != null && KeymapScheme.contains(this.mutable, name2);
    }

    boolean canReset() {
        return this.isMutable() && this.getCurrent().getOwnActionIds().length > 0;
    }

    void reset() {
        assert (this.canReset()) : "reset all modified shortcuts unexpectedly";
        this.getMutable().clearOwnActionsIds();
    }

    boolean canReset(@NotNull String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/keymap/impl/ui/KeymapScheme", "canReset"));
        }
        return this.isMutable() && this.getCurrent().hasOwnActionId(actionId);
    }

    void reset(@NotNull String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/keymap/impl/ui/KeymapScheme", "reset"));
        }
        assert (this.canReset(actionId)) : "reset modified action shortcuts unexpectedly";
        this.getMutable().clearOwnActionsId(actionId);
    }

    @NotNull
    Keymap apply() {
        if (this.mutable != null) {
            this.mutable.copyTo(this.original);
        }
        KeymapImpl keymapImpl = this.original;
        if (keymapImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/KeymapScheme", "apply"));
        }
        return keymapImpl;
    }

    @NotNull
    KeymapScheme copy(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/keymap/impl/ui/KeymapScheme", "copy"));
        }
        KeymapImpl keymap = this.original.deriveKeymap(name2);
        if (this.mutable != null) {
            this.mutable.copyTo(keymap);
        }
        KeymapScheme keymapScheme = new KeymapScheme(keymap);
        if (keymapScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/KeymapScheme", "copy"));
        }
        return keymapScheme;
    }
}

