/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ui.MouseShortcutPanel;
import com.intellij.openapi.keymap.impl.ui.ShortcutDialog;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

final class MouseShortcutDialog
extends ShortcutDialog<MouseShortcut> {
    private final JLabel myText = new JLabel("", 0);

    MouseShortcutDialog(Component component, boolean allowDoubleClick) {
        super(component, "mouse.shortcut.dialog.title", new MouseShortcutPanel(allowDoubleClick));
        this.myShortcutPanel.add("North", new JLabel(AllIcons.General.Mouse, 0));
        this.myShortcutPanel.add("Center", this.myText);
        this.myShortcutPanel.setBorder(BorderFactory.createCompoundBorder(JBUI.Borders.customLine((Color)MouseShortcutPanel.BORDER, (int)1, (int)0, (int)1, (int)0), JBUI.Borders.empty((int)20)));
        this.init();
    }

    protected String getHelpId() {
        return "preferences.mouse.shortcut";
    }

    @Override
    MouseShortcut toShortcut(Object value2) {
        return value2 instanceof MouseShortcut ? (MouseShortcut)value2 : null;
    }

    @Override
    void setShortcut(MouseShortcut shortcut) {
        super.setShortcut(shortcut);
        if (shortcut == null) {
            this.myText.setForeground((Color)MouseShortcutPanel.FOREGROUND);
            this.myText.setText(KeyMapBundle.message((String)"dialog.mouse.pad.default.text", (Object[])new Object[0]));
        } else {
            this.myText.setForeground(UIUtil.getLabelForeground());
            this.myText.setText(KeyMapBundle.message((String)"dialog.mouse.pad.shortcut.text", (Object[])new Object[]{KeymapUtil.getMouseShortcutText((MouseShortcut)shortcut)}));
        }
    }

    @Override
    Collection<String> getConflicts(MouseShortcut shortcut, String actionId, Keymap keymap) {
        return Arrays.asList(keymap.getActionIds(shortcut));
    }
}

