/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ProjectTopics;
import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.ModuleStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleDescription;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.module.impl.LoadedModuleDescriptionImpl;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleLoadingErrorDescription;
import com.intellij.openapi.module.impl.ModulePath;
import com.intellij.openapi.module.impl.ModulePathSaveItem;
import com.intellij.openapi.module.impl.SaveItem;
import com.intellij.openapi.module.impl.UnloadedModuleDescriptionImpl;
import com.intellij.openapi.module.impl.UnloadedModulesListStorage;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleManagerImpl
extends ModuleManager
implements Disposable,
PersistentStateComponent<Element>,
ProjectComponent {
    public static final String COMPONENT_NAME = "ProjectModuleManager";
    public static final String ELEMENT_MODULES = "modules";
    public static final String ELEMENT_MODULE = "module";
    public static final String ATTRIBUTE_FILEURL = "fileurl";
    public static final String ATTRIBUTE_FILEPATH = "filepath";
    public static final String ATTRIBUTE_GROUP = "group";
    public static final String IML_EXTENSION = ".iml";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.module.impl.ModuleManagerImpl");
    private static final Key<String> DISPOSED_MODULE_NAME = Key.create((String)"DisposedNeverAddedModuleName");
    public static final String MODULE_GROUP_SEPARATOR = "/";
    protected final Project myProject;
    protected final MessageBus myMessageBus;
    protected volatile ModuleModelImpl myModuleModel;
    private LinkedHashSet<ModulePath> myModulePathsToLoad;
    private final Set<ModulePath> myFailedModulePaths;
    private Map<String, UnloadedModuleDescriptionImpl> myUnloadedModules;
    private double myProgressStep;
    private volatile Module[] myCachedSortedModules;
    private volatile Comparator<Module> myCachedModuleComparator;

    public static ModuleManagerImpl getInstanceImpl(Project project2) {
        return (ModuleManagerImpl)ModuleManagerImpl.getInstance((Project)project2);
    }

    public ModuleManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/module/impl/ModuleManagerImpl", "<init>"));
        }
        this.myModuleModel = new ModuleModelImpl(this);
        this.myFailedModulePaths = new THashSet();
        this.myUnloadedModules = new LinkedHashMap<String, UnloadedModuleDescriptionImpl>();
        this.myProject = project2;
        this.myMessageBus = project2.getMessageBus();
    }

    public void projectOpened() {
        this.fireModulesAdded();
        for (Module module2 : this.myModuleModel.getModules()) {
            ((ModuleEx)module2).projectOpened();
        }
    }

    public void projectClosed() {
        for (Module module2 : this.myModuleModel.getModules()) {
            ((ModuleEx)module2).projectClosed();
        }
    }

    protected void cleanCachedStuff() {
        this.myCachedModuleComparator = null;
        this.myCachedSortedModules = null;
    }

    public void dispose() {
        this.myModuleModel.disposeModel();
    }

    public Element getState() {
        Element e = new Element("state");
        this.writeExternal(e);
        return e;
    }

    public void loadState(Element state) {
        boolean isFirstLoadState = this.myModulePathsToLoad == null;
        this.myModulePathsToLoad = ModuleManagerImpl.getPathsToModuleFiles(state);
        HashSet<String> unloadedModuleNames = new HashSet<String>(UnloadedModulesListStorage.getInstance(this.myProject).getUnloadedModuleNames());
        Iterator iterator = this.myModulePathsToLoad.iterator();
        ArrayList<ModulePath> unloadedModulePaths = new ArrayList<ModulePath>();
        while (iterator.hasNext()) {
            ModulePath modulePath = (ModulePath)iterator.next();
            if (!unloadedModuleNames.contains(modulePath.getModuleName())) continue;
            unloadedModulePaths.add(modulePath);
            iterator.remove();
        }
        List<UnloadedModuleDescriptionImpl> descriptions = UnloadedModuleDescriptionImpl.createFromPaths(unloadedModulePaths, this);
        this.myUnloadedModules.clear();
        for (UnloadedModuleDescriptionImpl description : descriptions) {
            this.myUnloadedModules.put(description.getName(), description);
        }
        if (isFirstLoadState) {
            return;
        }
        ModifiableModuleModel model = this.getModifiableModel();
        Module[] existingModules = model.getModules();
        ModuleGroupInterner groupInterner = new ModuleGroupInterner();
        THashMap modulePathMap = new THashMap(this.myModulePathsToLoad.size());
        for (ModulePath modulePath : this.myModulePathsToLoad) {
            modulePathMap.put(modulePath.getPath(), modulePath);
        }
        for (Module existingModule : existingModules) {
            Object[] group;
            ModulePath correspondingPath = (ModulePath)modulePathMap.remove(existingModule.getModuleFilePath());
            if (correspondingPath == null) {
                model.disposeModule(existingModule);
                continue;
            }
            this.myModulePathsToLoad.remove(correspondingPath);
            String groupStr = correspondingPath.getGroup();
            Object[] objectArray = group = groupStr == null ? null : groupStr.split(MODULE_GROUP_SEPARATOR);
            if (Arrays.equals(group, model.getModuleGroupPath(existingModule))) continue;
            groupInterner.setModuleGroupPath(model, existingModule, (String[])group);
        }
        this.loadModules((ModuleModelImpl)model);
        ApplicationManager.getApplication().runWriteAction(() -> model.commit());
        this.myModulePathsToLoad.clear();
    }

    @NotNull
    public static LinkedHashSet<ModulePath> getPathsToModuleFiles(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getPathsToModuleFiles"));
        }
        LinkedHashSet<ModulePath> paths = new LinkedHashSet<ModulePath>();
        Element modules = element.getChild(ELEMENT_MODULES);
        if (modules != null) {
            for (Element moduleElement : modules.getChildren(ELEMENT_MODULE)) {
                String fileUrlValue = moduleElement.getAttributeValue(ATTRIBUTE_FILEURL);
                String filepath = fileUrlValue == null ? moduleElement.getAttributeValue(ATTRIBUTE_FILEPATH) : VirtualFileManager.extractPath((String)fileUrlValue);
                paths.add(new ModulePath(FileUtilRt.toSystemIndependentName((String)filepath), moduleElement.getAttributeValue(ATTRIBUTE_GROUP)));
            }
        }
        LinkedHashSet<ModulePath> linkedHashSet = paths;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getPathsToModuleFiles"));
        }
        return linkedHashSet;
    }

    protected void loadModules(@NotNull ModuleModelImpl moduleModel) {
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/intellij/openapi/module/impl/ModuleManagerImpl", "loadModules"));
        }
        this.myFailedModulePaths.clear();
        if (this.myModulePathsToLoad == null || this.myModulePathsToLoad.isEmpty()) {
            return;
        }
        this.myFailedModulePaths.addAll(this.myModulePathsToLoad);
        ProgressIndicator globalIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        EmptyProgressIndicator progressIndicator = this.myProject.isDefault() || globalIndicator == null ? new EmptyProgressIndicator() : globalIndicator;
        progressIndicator.setText("Loading modules...");
        progressIndicator.setText2("");
        SmartList modulesWithUnknownTypes = new SmartList();
        List<ModuleLoadingErrorDescription> errors = Collections.synchronizedList(new ArrayList());
        ModuleGroupInterner groupInterner = new ModuleGroupInterner();
        ExecutorService service = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"modules loader", (int)JobSchedulerImpl.CORES_COUNT);
        ArrayList<Pair> tasks = new ArrayList<Pair>();
        THashSet paths = new THashSet();
        boolean parallel = Registry.is((String)"parallel.modules.loading") && !ApplicationManager.getApplication().isDispatchThread();
        for (ModulePath modulePath : this.myModulePathsToLoad) {
            if (progressIndicator.isCanceled()) break;
            String path = modulePath.getPath();
            if (!paths.add(path)) continue;
            if (!parallel) {
                tasks.add(Pair.create(null, (Object)modulePath));
                continue;
            }
            tasks.add(Pair.create(service.submit(() -> this.lambda$loadModules$2((ProgressIndicator)progressIndicator, moduleModel, path, errors, modulePath)), (Object)modulePath));
        }
        for (Pair task : tasks) {
            if (progressIndicator.isCanceled()) break;
            try {
                ModulePath modulePath;
                String groupPathString;
                Module module2;
                if (parallel) {
                    module2 = (Module)((Future)task.first).get();
                } else {
                    module2 = moduleModel.loadModuleInternal(((ModulePath)task.second).getPath());
                    progressIndicator.setFraction(progressIndicator.getFraction() + this.myProgressStep);
                }
                if (module2 == null) continue;
                if (this.isUnknownModuleType(module2)) {
                    modulesWithUnknownTypes.add(module2);
                }
                if ((groupPathString = (modulePath = (ModulePath)task.second).getGroup()) != null) {
                    groupInterner.setModuleGroupPath(moduleModel, module2, groupPathString.split(MODULE_GROUP_SEPARATOR));
                }
                this.myFailedModulePaths.remove(modulePath);
            }
            catch (IOException e) {
                this.reportError(errors, (ModulePath)task.second, e);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        service.shutdown();
        progressIndicator.checkCanceled();
        Application app = ApplicationManager.getApplication();
        if (app.isInternal() || app.isEAP() || ApplicationInfo.getInstance().getBuild().isSnapshot()) {
            THashMap track = new THashMap();
            for (Module module3 : moduleModel.getModules()) {
                for (String url : ModuleRootManager.getInstance((Module)module3).getContentRootUrls()) {
                    Module oldModule = track.put(url, module3);
                    if (oldModule == null) continue;
                    LOG.error("Module '" + module3.getName() + "' and module '" + oldModule.getName() + "' have the same content root: " + url);
                }
            }
        }
        this.onModuleLoadErrors(moduleModel, errors);
        this.showUnknownModuleTypeNotification((List<Module>)modulesWithUnknownTypes);
    }

    private void reportError(List<ModuleLoadingErrorDescription> errors, ModulePath modulePath, Exception e) {
        errors.add(new ModuleLoadingErrorDescription(ProjectBundle.message((String)"module.cannot.load.error", (Object[])new Object[]{modulePath.getPath(), e.getMessage()}), modulePath, this));
    }

    public int getModulePathsCount() {
        return this.myModulePathsToLoad == null ? 0 : this.myModulePathsToLoad.size();
    }

    public void setProgressStep(double step) {
        this.myProgressStep = step;
    }

    protected boolean isUnknownModuleType(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "isUnknownModuleType"));
        }
        return false;
    }

    protected void showUnknownModuleTypeNotification(@NotNull List<Module> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/openapi/module/impl/ModuleManagerImpl", "showUnknownModuleTypeNotification"));
        }
    }

    protected void fireModuleAdded(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModuleAdded"));
        }
        ((ModuleListener)this.myMessageBus.syncPublisher(ProjectTopics.MODULES)).moduleAdded(this.myProject, module2);
    }

    protected void fireModuleRemoved(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModuleRemoved"));
        }
        ((ModuleListener)this.myMessageBus.syncPublisher(ProjectTopics.MODULES)).moduleRemoved(this.myProject, module2);
    }

    protected void fireBeforeModuleRemoved(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireBeforeModuleRemoved"));
        }
        ((ModuleListener)this.myMessageBus.syncPublisher(ProjectTopics.MODULES)).beforeModuleRemoved(this.myProject, module2);
    }

    protected void fireModulesRenamed(@NotNull List<Module> modules, @NotNull Map<Module, String> oldNames) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULES, "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModulesRenamed"));
        }
        if (oldNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNames", "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModulesRenamed"));
        }
        if (!modules.isEmpty()) {
            ((ModuleListener)this.myMessageBus.syncPublisher(ProjectTopics.MODULES)).modulesRenamed(this.myProject, modules, module2 -> {
                if (oldNames == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNames", "com/intellij/openapi/module/impl/ModuleManagerImpl", "lambda$fireModulesRenamed$3"));
                }
                return (String)oldNames.get(module2);
            });
        }
    }

    private void onModuleLoadErrors(@NotNull ModuleModelImpl moduleModel, @NotNull List<ModuleLoadingErrorDescription> errors) {
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/intellij/openapi/module/impl/ModuleManagerImpl", "onModuleLoadErrors"));
        }
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/openapi/module/impl/ModuleManagerImpl", "onModuleLoadErrors"));
        }
        if (errors.isEmpty()) {
            return;
        }
        ModuleModelImpl.access$502(moduleModel, null);
        for (ModuleLoadingErrorDescription error : errors) {
            ModuleEx module2 = moduleModel.getModuleByFilePath(error.getModulePath().getPath());
            if (module2 == null) continue;
            moduleModel.myModules.remove(module2.getName());
            ApplicationManager.getApplication().invokeLater(() -> Disposer.dispose((Disposable)module2), module2.getDisposed());
        }
        this.fireModuleLoadErrors(errors);
    }

    protected void fireModuleLoadErrors(@NotNull List<ModuleLoadingErrorDescription> errors) {
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModuleLoadErrors"));
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            throw new RuntimeException(errors.get(0).getDescription());
        }
        ProjectLoadingErrorsNotifier.getInstance(this.myProject).registerErrors(errors);
    }

    public void removeFailedModulePath(@NotNull ModulePath modulePath) {
        if (modulePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulePath", "com/intellij/openapi/module/impl/ModuleManagerImpl", "removeFailedModulePath"));
        }
        this.myFailedModulePaths.remove(modulePath);
    }

    @NotNull
    public ModifiableModuleModel getModifiableModel() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ModuleModelImpl moduleModelImpl = new ModuleModelImpl(this.myModuleModel);
        if (moduleModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getModifiableModel"));
        }
        return moduleModelImpl;
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/module/impl/ModuleManagerImpl", "writeExternal"));
        }
        Module[] collection = this.getModules();
        ArrayList<SaveItem> sorted = new ArrayList<SaveItem>(collection.length + this.myFailedModulePaths.size() + this.myUnloadedModules.size());
        for (Module module2 : collection) {
            sorted.add(new ModuleSaveItem(module2));
        }
        for (ModulePath modulePath : this.myFailedModulePaths) {
            sorted.add(new ModulePathSaveItem(modulePath));
        }
        for (UnloadedModuleDescriptionImpl description : this.myUnloadedModules.values()) {
            sorted.add(new ModulePathSaveItem(description.getModulePath()));
        }
        if (!sorted.isEmpty()) {
            Collections.sort(sorted, Comparator.comparing(SaveItem::getModuleName));
            Element modules = new Element(ELEMENT_MODULES);
            for (SaveItem saveItem : sorted) {
                saveItem.writeExternal(modules);
            }
            element.addContent(modules);
        }
    }

    @NotNull
    public Module newModule(@NotNull String filePath, String moduleTypeId) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl", "newModule"));
        }
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module2 = modifiableModel.newModule(filePath, moduleTypeId);
        modifiableModel.commit();
        Module module3 = module2;
        if (module3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "newModule"));
        }
        return module3;
    }

    @NotNull
    public Module loadModule(@NotNull String filePath) throws IOException, ModuleWithNameAlreadyExists {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl", "loadModule"));
        }
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module2 = modifiableModel.loadModule(filePath);
        modifiableModel.commit();
        Module module3 = module2;
        if (module3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "loadModule"));
        }
        return module3;
    }

    public void disposeModule(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "disposeModule"));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "lambda$disposeModule$5"));
            }
            ModifiableModuleModel modifiableModel = this.getModifiableModel();
            modifiableModel.disposeModule(module2);
            modifiableModel.commit();
        });
    }

    @NotNull
    public Module[] getModules() {
        if (this.myModuleModel.myIsWritable) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        Module[] moduleArray = this.myModuleModel.getModules();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getModules"));
        }
        return moduleArray;
    }

    @NotNull
    public Module[] getSortedModules() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.deliverPendingEvents();
        if (this.myCachedSortedModules == null) {
            this.myCachedSortedModules = this.myModuleModel.getSortedModules();
        }
        if (this.myCachedSortedModules == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getSortedModules"));
        }
        return this.myCachedSortedModules;
    }

    public Module findModuleByName(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/module/impl/ModuleManagerImpl", "findModuleByName"));
        }
        return this.myModuleModel.findModuleByName(name2);
    }

    @NotNull
    public Comparator<Module> moduleDependencyComparator() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.deliverPendingEvents();
        if (this.myCachedModuleComparator == null) {
            this.myCachedModuleComparator = this.myModuleModel.moduleDependencyComparator();
        }
        Comparator<Module> comparator2 = this.myCachedModuleComparator;
        if (comparator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "moduleDependencyComparator"));
        }
        return comparator2;
    }

    protected void deliverPendingEvents() {
    }

    @NotNull
    public Graph<Module> moduleGraph() {
        Graph<Module> graph = this.moduleGraph(true);
        if (graph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "moduleGraph"));
        }
        return graph;
    }

    @NotNull
    public Graph<Module> moduleGraph(boolean includeTests) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Graph graph = this.myModuleModel.moduleGraph(includeTests);
        if (graph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "moduleGraph"));
        }
        return graph;
    }

    @NotNull
    public List<Module> getModuleDependentModules(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "getModuleDependentModules"));
        }
        SmartList result2 = new SmartList();
        for (Module aModule : this.getModules()) {
            if (!ModuleManagerImpl.isModuleDependsOn(aModule, module2)) continue;
            result2.add(aModule);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getModuleDependentModules"));
        }
        return smartList;
    }

    public boolean isModuleDependent(@NotNull Module module2, @NotNull Module onModule) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "isModuleDependent"));
        }
        if (onModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onModule", "com/intellij/openapi/module/impl/ModuleManagerImpl", "isModuleDependent"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return ModuleManagerImpl.isModuleDependsOn(module2, onModule);
    }

    private static boolean isModuleDependsOn(@NotNull Module module2, @NotNull Module onModule) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "isModuleDependsOn"));
        }
        if (onModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onModule", "com/intellij/openapi/module/impl/ModuleManagerImpl", "isModuleDependsOn"));
        }
        return ModuleRootManager.getInstance((Module)module2).isDependsOn(onModule);
    }

    protected void fireModulesAdded() {
        for (Module module2 : this.myModuleModel.getModules()) {
            this.fireModuleAddedInWriteAction((ModuleEx)module2);
        }
    }

    protected void fireModuleAddedInWriteAction(@NotNull ModuleEx module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModuleAddedInWriteAction"));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "lambda$fireModuleAddedInWriteAction$6"));
            }
            if (!module2.isLoaded()) {
                module2.moduleAdded();
                this.fireModuleAdded(module2);
            }
        });
    }

    public static void commitModelWithRunnable(@NotNull ModifiableModuleModel model, Runnable runnable2) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/module/impl/ModuleManagerImpl", "commitModelWithRunnable"));
        }
        ((ModuleModelImpl)model).commitWithRunnable(runnable2);
    }

    @NotNull
    protected abstract ModuleEx createModule(@NotNull String var1);

    @NotNull
    protected abstract ModuleEx createAndLoadModule(@NotNull String var1) throws IOException;

    private void commitModel(ModuleModelImpl moduleModel, Runnable runnable2) {
        THashSet removedModules;
        THashSet addedModules;
        ModuleModelImpl.access$502(this.myModuleModel, null);
        this.incModificationCount();
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        List<Module> oldModules = Arrays.asList(this.myModuleModel.getModules());
        THashSet newModules = Arrays.asList(moduleModel.getModules());
        if (oldModules.isEmpty()) {
            addedModules = newModules;
            removedModules = Collections.emptyList();
        } else {
            addedModules = new THashSet(newModules);
            addedModules.removeAll(oldModules);
            removedModules = new THashSet(oldModules);
            removedModules.removeAll((Collection<?>)newModules);
        }
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(() -> this.lambda$commitModel$7((Collection)removedModules, moduleModel, oldModules, runnable2, (Collection)addedModules), false, true);
    }

    public void fireModuleRenamedByVfsEvent(@NotNull Module module2, @NotNull String oldName) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModuleRenamedByVfsEvent"));
        }
        if (oldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldName", "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModuleRenamedByVfsEvent"));
        }
        Module moduleInMap = this.myModuleModel.myModules.remove(oldName);
        LOG.assertTrue(moduleInMap == null || moduleInMap == module2);
        this.myModuleModel.myModules.put(module2.getName(), module2);
        this.incModificationCount();
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(() -> {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "lambda$fireModuleRenamedByVfsEvent$8"));
            }
            if (oldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldName", "com/intellij/openapi/module/impl/ModuleManagerImpl", "lambda$fireModuleRenamedByVfsEvent$8"));
            }
            this.fireModulesRenamed(Collections.singletonList(module2), Collections.singletonMap(module2, oldName));
        }, false, true);
    }

    public String[] getModuleGroupPath(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "getModuleGroupPath"));
        }
        return this.myModuleModel.getModuleGroupPath(module2);
    }

    public boolean hasModuleGroups() {
        return this.myModuleModel.hasModuleGroups();
    }

    public Collection<ModuleDescription> getAllModuleDescriptions() {
        Module[] modules = this.getModules();
        ArrayList<ModuleDescription> descriptions = new ArrayList<ModuleDescription>(modules.length + this.myUnloadedModules.size());
        for (Module module2 : modules) {
            descriptions.add((ModuleDescription)new LoadedModuleDescriptionImpl(module2));
        }
        descriptions.addAll(this.myUnloadedModules.values());
        return descriptions;
    }

    public Collection<UnloadedModuleDescription> getUnloadedModuleDescriptions() {
        return Collections.unmodifiableCollection(this.myUnloadedModules.values());
    }

    @Nullable
    public UnloadedModuleDescription getUnloadedModuleDescription(@NotNull String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getUnloadedModuleDescription"));
        }
        return this.myUnloadedModules.get(moduleName);
    }

    public void setUnloadedModules(@NotNull List<String> unloadedModuleNames) {
        if (unloadedModuleNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unloadedModuleNames", "com/intellij/openapi/module/impl/ModuleManagerImpl", "setUnloadedModules"));
        }
        if (this.myUnloadedModules.keySet().equals(unloadedModuleNames)) {
            return;
        }
        UnloadedModulesListStorage.getInstance(this.myProject).setUnloadedModuleNames(unloadedModuleNames);
        ModifiableModuleModel model = this.getModifiableModel();
        LinkedHashMap<String, UnloadedModuleDescriptionImpl> toLoad = new LinkedHashMap<String, UnloadedModuleDescriptionImpl>(this.myUnloadedModules);
        this.myUnloadedModules.clear();
        for (String name2 : unloadedModuleNames) {
            if (toLoad.containsKey(name2)) {
                this.myUnloadedModules.put(name2, (UnloadedModuleDescriptionImpl)toLoad.remove(name2));
                continue;
            }
            Module module2 = this.findModuleByName(name2);
            if (module2 == null) continue;
            LoadedModuleDescriptionImpl description = new LoadedModuleDescriptionImpl(module2);
            ModuleSaveItem saveItem = new ModuleSaveItem(module2);
            ModulePath modulePath = new ModulePath(saveItem.getModuleFilePath(), saveItem.getGroupPathString());
            VirtualFilePointerManager pointerManager = VirtualFilePointerManager.getInstance();
            List contentRoots = ContainerUtil.map((Object[])ModuleRootManager.getInstance((Module)module2).getContentRootUrls(), url -> pointerManager.create(url, (Disposable)this, null));
            UnloadedModuleDescriptionImpl unloadedModuleDescription = new UnloadedModuleDescriptionImpl(modulePath, description.getDependencyModuleNames(), contentRoots);
            ServiceKt.getStateStore((ComponentManager)module2).save(new ArrayList<Pair<StateStorage.SaveSession, VirtualFile>>());
            model.disposeModule(module2);
            this.myUnloadedModules.put(name2, unloadedModuleDescription);
        }
        ArrayList<ModulePath> oldFailedPaths = new ArrayList<ModulePath>(this.myFailedModulePaths);
        this.myModulePathsToLoad = toLoad.values().stream().map(d -> d.getModulePath()).collect(Collectors.toCollection(LinkedHashSet::new));
        this.loadModules((ModuleModelImpl)model);
        ApplicationManager.getApplication().runWriteAction(() -> model.commit());
        this.myFailedModulePaths.addAll(oldFailedPaths);
        this.myModulePathsToLoad.clear();
    }

    public void setModuleGroupPath(Module module2, String[] groupPath) {
        this.myModuleModel.setModuleGroupPath(module2, groupPath);
    }

    private /* synthetic */ void lambda$commitModel$7(Collection removedModules, ModuleModelImpl moduleModel, Collection oldModules, Runnable runnable2, Collection addedModules) {
        for (Object removedModule : removedModules) {
            this.fireBeforeModuleRemoved((Module)removedModule);
            this.cleanCachedStuff();
        }
        if (!moduleModel.myModulesToDispose.isEmpty()) {
            ArrayList neverAddedModules = new ArrayList(moduleModel.myModulesToDispose);
            neverAddedModules.removeAll(oldModules);
            for (Module neverAddedModule : neverAddedModules) {
                neverAddedModule.putUserData(DISPOSED_MODULE_NAME, (Object)neverAddedModule.getName());
                Disposer.dispose((Disposable)neverAddedModule);
            }
        }
        if (runnable2 != null) {
            runnable2.run();
        }
        Map modulesToNewNamesMap = moduleModel.myModuleToNewName;
        Set modulesToBeRenamed = modulesToNewNamesMap.keySet();
        modulesToBeRenamed.removeAll(moduleModel.myModulesToDispose);
        ArrayList<Module> modules = new ArrayList<Module>();
        HashMap oldNames = ContainerUtil.newHashMap();
        for (Module module2 : modulesToBeRenamed) {
            oldNames.put(module2, module2.getName());
            moduleModel.myModules.remove(module2.getName());
            modules.add(module2);
            ((ModuleEx)module2).rename((String)modulesToNewNamesMap.get(module2), true);
            moduleModel.myModules.put(module2.getName(), module2);
        }
        moduleModel.myIsWritable = false;
        this.myModuleModel = moduleModel;
        for (Module module2 : removedModules) {
            this.fireModuleRemoved(module2);
            this.cleanCachedStuff();
            Disposer.dispose((Disposable)module2);
            this.cleanCachedStuff();
        }
        for (Module addedModule : addedModules) {
            ((ModuleEx)addedModule).moduleAdded();
            this.cleanCachedStuff();
            this.fireModuleAdded(addedModule);
            this.cleanCachedStuff();
        }
        this.cleanCachedStuff();
        this.fireModulesRenamed(modules, oldNames);
        this.cleanCachedStuff();
    }

    private /* synthetic */ Module lambda$loadModules$2(ProgressIndicator progressIndicator, @NotNull ModuleModelImpl moduleModel, String path, List errors, ModulePath modulePath) throws Exception {
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/intellij/openapi/module/impl/ModuleManagerImpl", "lambda$loadModules$2"));
        }
        progressIndicator.setFraction(progressIndicator.getFraction() + this.myProgressStep);
        return (Module)ProgressManager.getInstance().runProcess(() -> {
            if (moduleModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/intellij/openapi/module/impl/ModuleManagerImpl", "lambda$null$1"));
            }
            try {
                return this.myProject.isDisposed() ? null : moduleModel.loadModuleInternal(path);
            }
            catch (IOException e) {
                this.reportError(errors, modulePath, e);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            return null;
        }, (ProgressIndicator)ProgressWrapper.wrap(progressIndicator));
    }

    static class ModuleModelImpl
    implements ModifiableModuleModel {
        final Map<String, Module> myModules;
        private volatile Module[] myModulesCache;
        private final List<Module> myModulesToDispose;
        private final Map<Module, String> myModuleToNewName;
        private final Map<String, Module> myNewNameToModule;
        private boolean myIsWritable;
        private Map<Module, String[]> myModuleGroupPath;
        private final ModuleManagerImpl myManager;

        private ModuleModelImpl(@NotNull ModuleManagerImpl manager) {
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "<init>"));
            }
            this.myModules = Collections.synchronizedMap(new LinkedHashMap());
            this.myModulesToDispose = new ArrayList<Module>();
            this.myModuleToNewName = new com.intellij.util.containers.HashMap();
            this.myNewNameToModule = new com.intellij.util.containers.HashMap();
            this.myManager = manager;
            this.myIsWritable = false;
        }

        private ModuleModelImpl(@NotNull ModuleModelImpl that) {
            if (that == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "<init>"));
            }
            this.myModules = Collections.synchronizedMap(new LinkedHashMap());
            this.myModulesToDispose = new ArrayList<Module>();
            this.myModuleToNewName = new com.intellij.util.containers.HashMap();
            this.myNewNameToModule = new com.intellij.util.containers.HashMap();
            this.myManager = that.myManager;
            this.myModules.putAll(that.myModules);
            Map<Module, String[]> groupPath = that.myModuleGroupPath;
            if (groupPath != null) {
                this.myModuleGroupPath = new THashMap();
                this.myModuleGroupPath.putAll(that.myModuleGroupPath);
            }
            this.myIsWritable = true;
        }

        private void assertWritable() {
            LOG.assertTrue(this.myIsWritable, (Object)"Attempt to modify committed ModifiableModuleModel");
        }

        @NotNull
        public Module[] getModules() {
            Module[] cache = this.myModulesCache;
            if (cache == null) {
                Collection<Module> modules = this.myModules.values();
                this.myModulesCache = cache = modules.toArray(new Module[modules.size()]);
            }
            if (cache == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getModules"));
            }
            return cache;
        }

        @NotNull
        private Module[] getSortedModules() {
            Module[] allModules = (Module[])this.getModules().clone();
            Arrays.sort(allModules, this.moduleDependencyComparator());
            if (allModules == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getSortedModules"));
            }
            return allModules;
        }

        public void renameModule(@NotNull Module module2, @NotNull String newName) throws ModuleWithNameAlreadyExists {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "renameModule"));
            }
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "renameModule"));
            }
            Module oldModule = this.getModuleByNewName(newName);
            this.myNewNameToModule.remove(this.myModuleToNewName.get(module2));
            if (module2.getName().equals(newName)) {
                this.myModuleToNewName.remove(module2);
                this.myNewNameToModule.remove(newName);
            } else {
                this.myModuleToNewName.put(module2, newName);
                this.myNewNameToModule.put(newName, module2);
            }
            if (oldModule != null) {
                throw new ModuleWithNameAlreadyExists(ProjectBundle.message((String)"module.already.exists.error", (Object[])new Object[]{newName}), newName);
            }
        }

        public Module getModuleToBeRenamed(@NotNull String newName) {
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getModuleToBeRenamed"));
            }
            return this.myNewNameToModule.get(newName);
        }

        private Module getModuleByNewName(@NotNull String newName) {
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getModuleByNewName"));
            }
            Module moduleToBeRenamed = this.getModuleToBeRenamed(newName);
            if (moduleToBeRenamed != null) {
                return moduleToBeRenamed;
            }
            Module moduleWithOldName = this.findModuleByName(newName);
            return this.myModuleToNewName.get(moduleWithOldName) == null ? moduleWithOldName : null;
        }

        public String getNewName(@NotNull Module module2) {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getNewName"));
            }
            return this.myModuleToNewName.get(module2);
        }

        @NotNull
        public Module newModule(@NotNull String filePath, String moduleTypeId) {
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "newModule"));
            }
            Module module2 = this.newModule(filePath, moduleTypeId, null);
            if (module2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "newModule"));
            }
            return module2;
        }

        @NotNull
        public Module newModule(@NotNull String filePath, @NotNull String moduleTypeId, @Nullable Map<String, String> options) {
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "newModule"));
            }
            if (moduleTypeId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleTypeId", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "newModule"));
            }
            this.assertWritable();
            filePath = FileUtil.toSystemIndependentName((String)ModuleModelImpl.resolveShortWindowsName(filePath));
            ModuleEx module2 = this.getModuleByFilePath(filePath);
            if (module2 != null) {
                ModuleEx moduleEx = module2;
                if (moduleEx == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "newModule"));
                }
                return moduleEx;
            }
            ModuleEx newModule = module2 = this.myManager.createModule(filePath);
            String finalFilePath = filePath;
            this.initModule(module2, () -> {
                if (moduleTypeId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleTypeId", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "lambda$newModule$0"));
                }
                ((ModuleStore)((Object)ServiceKt.getStateStore((ComponentManager)newModule))).setPath(finalFilePath, true);
                newModule.setModuleType(moduleTypeId);
                if (options != null) {
                    for (Map.Entry option : options.entrySet()) {
                        newModule.setOption((String)option.getKey(), (String)option.getValue());
                    }
                }
            });
            ModuleEx moduleEx = module2;
            if (moduleEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "newModule"));
            }
            return moduleEx;
        }

        @NotNull
        private static String resolveShortWindowsName(@NotNull String filePath) {
            String string;
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "resolveShortWindowsName"));
            }
            try {
                string = FileUtil.resolveShortWindowsName((String)filePath);
            }
            catch (IOException ignored) {
                String string2 = filePath;
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "resolveShortWindowsName"));
                }
                return string2;
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "resolveShortWindowsName"));
            }
            return string;
        }

        @Nullable
        private ModuleEx getModuleByFilePath(@NotNull String filePath) {
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getModuleByFilePath"));
            }
            for (Module module2 : this.getModules()) {
                if (!(SystemInfo.isFileSystemCaseSensitive ? module2.getModuleFilePath().equals(filePath) : module2.getModuleFilePath().equalsIgnoreCase(filePath))) continue;
                return (ModuleEx)module2;
            }
            return null;
        }

        @NotNull
        public Module loadModule(@NotNull String filePath) throws IOException, ModuleWithNameAlreadyExists {
            ModuleEx moduleEx;
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "loadModule"));
            }
            this.assertWritable();
            String resolvedPath = FileUtilRt.toSystemIndependentName((String)ModuleModelImpl.resolveShortWindowsName(filePath));
            try {
                ModuleEx module2 = this.getModuleByFilePath(resolvedPath);
                moduleEx = module2 == null ? this.loadModuleInternal(resolvedPath) : module2;
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                throw new IOException(ProjectBundle.message((String)"module.corrupted.file.error", (Object[])new Object[]{FileUtilRt.toSystemDependentName((String)resolvedPath), e.getMessage()}), e);
            }
            if (moduleEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "loadModule"));
            }
            return moduleEx;
        }

        @NotNull
        private Module loadModuleInternal(@NotNull String filePath) throws IOException {
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "loadModuleInternal"));
            }
            StandardFileSystems.local().refreshAndFindFileByPath(filePath);
            Module module2 = (Module)ReadAction.compute(() -> {
                if (filePath == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "lambda$loadModuleInternal$2"));
                }
                ModuleEx module2 = this.myManager.createAndLoadModule(filePath);
                this.initModule(module2, () -> {
                    if (filePath == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "lambda$null$1"));
                    }
                    ((ModuleStore)((Object)ServiceKt.getStateStore((ComponentManager)module2))).setPath(filePath, false);
                });
                return module2;
            });
            if (module2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "loadModuleInternal"));
            }
            return module2;
        }

        private void initModule(@NotNull ModuleEx module2, @Nullable Runnable beforeComponentCreation) {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "initModule"));
            }
            module2.init(beforeComponentCreation);
            this.myModulesCache = null;
            this.myModules.put(module2.getName(), module2);
        }

        public void disposeModule(@NotNull Module module2) {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "disposeModule"));
            }
            this.assertWritable();
            this.myModulesCache = null;
            if (this.myModules.remove(module2.getName()) != null) {
                this.myModulesToDispose.add(module2);
            }
            if (this.myModuleGroupPath != null) {
                this.myModuleGroupPath.remove(module2);
            }
        }

        public Module findModuleByName(@NotNull String name2) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "findModuleByName"));
            }
            Module module2 = this.myModules.get(name2);
            if (module2 != null && !module2.isDisposed()) {
                return module2;
            }
            return null;
        }

        private Comparator<Module> moduleDependencyComparator() {
            DFSTBuilder builder = new DFSTBuilder(this.moduleGraph(true));
            return builder.comparator();
        }

        private Graph<Module> moduleGraph(final boolean includeTests) {
            return GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<Module>(){

                public Collection<Module> getNodes() {
                    return myModules.values();
                }

                public Iterator<Module> getIn(Module m) {
                    Module[] dependentModules = ModuleRootManager.getInstance((Module)m).getDependencies(includeTests);
                    return Arrays.asList(dependentModules).iterator();
                }
            }));
        }

        public void commit() {
            ModifiableModelCommitter.multiCommit(Collections.emptyList(), (ModifiableModuleModel)this);
        }

        private void commitWithRunnable(Runnable runnable2) {
            this.myManager.commitModel(this, runnable2);
            this.clearRenamingStuff();
        }

        private void clearRenamingStuff() {
            this.myModuleToNewName.clear();
            this.myNewNameToModule.clear();
        }

        public void dispose() {
            this.assertWritable();
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            THashSet existingModules = new THashSet(Arrays.asList(this.myManager.myModuleModel.getModules()));
            for (Module thisModule : this.getModules()) {
                if (existingModules.contains(thisModule)) continue;
                Disposer.dispose((Disposable)thisModule);
            }
            for (Module moduleToDispose : this.myModulesToDispose) {
                if (existingModules.contains(moduleToDispose)) continue;
                Disposer.dispose((Disposable)moduleToDispose);
            }
            this.clearRenamingStuff();
        }

        public boolean isChanged() {
            if (!this.myIsWritable) {
                return false;
            }
            return !this.myModules.equals(this.myManager.myModuleModel.myModules) || !Comparing.equal(this.myManager.myModuleModel.myModuleGroupPath, this.myModuleGroupPath);
        }

        private void disposeModel() {
            Module[] modules = this.getModules();
            this.myModulesCache = null;
            for (Module module2 : modules) {
                Disposer.dispose((Disposable)module2);
            }
            this.myModules.clear();
            this.myModuleGroupPath = null;
        }

        public String[] getModuleGroupPath(Module module2) {
            return this.myModuleGroupPath == null ? null : this.myModuleGroupPath.get(module2);
        }

        public boolean hasModuleGroups() {
            return this.myModuleGroupPath != null && !this.myModuleGroupPath.isEmpty();
        }

        public void setModuleGroupPath(@NotNull Module module2, @Nullable(value="null means remove") String[] groupPath) {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "setModuleGroupPath"));
            }
            if (this.myModuleGroupPath == null) {
                this.myModuleGroupPath = new THashMap();
            }
            if (groupPath == null) {
                this.myModuleGroupPath.remove(module2);
            } else {
                this.myModuleGroupPath.put(module2, groupPath);
            }
        }

        static /* synthetic */ Module[] access$502(ModuleModelImpl x0, Module[] x1) {
            x0.myModulesCache = x1;
            return x1;
        }
    }

    private class ModuleSaveItem
    extends SaveItem {
        private final Module myModule;

        public ModuleSaveItem(Module module2) {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleSaveItem", "<init>"));
            }
            this.myModule = module2;
        }

        @Override
        @NotNull
        protected String getModuleName() {
            String string = this.myModule.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleSaveItem", "getModuleName"));
            }
            return string;
        }

        @Override
        protected String getGroupPathString() {
            String[] groupPath = ModuleManagerImpl.this.getModuleGroupPath(this.myModule);
            return groupPath != null ? StringUtil.join((String[])groupPath, (String)ModuleManagerImpl.MODULE_GROUP_SEPARATOR) : null;
        }

        @Override
        @NotNull
        protected String getModuleFilePath() {
            String string = this.myModule.getModuleFilePath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleSaveItem", "getModuleFilePath"));
            }
            return string;
        }
    }

    private static class ModuleGroupInterner {
        private final StringInterner groups = new StringInterner();
        private final Map<String[], String[]> paths = new THashMap((TObjectHashingStrategy)new TObjectHashingStrategy<String[]>(){

            public int computeHashCode(String[] object) {
                return Arrays.hashCode(object);
            }

            public boolean equals(String[] o1, String[] o2) {
                return Arrays.equals(o1, o2);
            }
        });

        private ModuleGroupInterner() {
        }

        private void setModuleGroupPath(@NotNull ModifiableModuleModel model, @NotNull Module module2, @Nullable String[] group) {
            String[] cached;
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleGroupInterner", "setModuleGroupPath"));
            }
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleGroupInterner", "setModuleGroupPath"));
            }
            String[] stringArray = cached = group == null ? null : this.paths.get(group);
            if (cached == null && group != null) {
                cached = new String[group.length];
                for (int i = 0; i < group.length; ++i) {
                    String g = group[i];
                    cached[i] = (String)this.groups.intern((Object)g);
                }
                this.paths.put(cached, cached);
            }
            model.setModuleGroupPath(module2, cached);
        }
    }
}

