/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryRuntimeClasspathScope
extends GlobalSearchScope {
    private final ProjectFileIndex myIndex;
    private final Set<VirtualFile> myEntries;
    private int myCachedHashCode;

    public LibraryRuntimeClasspathScope(@NotNull Project project2, @NotNull Collection<Module> modules) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope", "<init>"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope", "<init>"));
        }
        super(project2);
        this.myEntries = new LinkedHashSet<VirtualFile>();
        this.myIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        THashSet processedSdk = new THashSet();
        THashSet processedLibraries = new THashSet();
        THashSet processedModules = new THashSet();
        Condition condition2 = arg_0 -> LibraryRuntimeClasspathScope.lambda$new$0((Set)processedModules, arg_0);
        for (Module module2 : modules) {
            this.buildEntries(module2, (Set<Module>)processedModules, (Set<Library>)processedLibraries, (Set<Sdk>)processedSdk, (Condition<OrderEntry>)condition2);
        }
    }

    public LibraryRuntimeClasspathScope(@NotNull Project project2, @NotNull LibraryOrderEntry entry) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope", "<init>"));
        }
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope", "<init>"));
        }
        super(project2);
        this.myEntries = new LinkedHashSet<VirtualFile>();
        this.myIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        Collections.addAll(this.myEntries, entry.getRootFiles(OrderRootType.CLASSES));
        Collections.addAll(this.myEntries, entry.getRootFiles(OrderRootType.SOURCES));
    }

    public int hashCode() {
        if (this.myCachedHashCode == 0) {
            this.myCachedHashCode = this.myEntries.hashCode();
        }
        return this.myCachedHashCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != LibraryRuntimeClasspathScope.class) {
            return false;
        }
        LibraryRuntimeClasspathScope that = (LibraryRuntimeClasspathScope)((Object)object);
        return that.myEntries.equals(this.myEntries);
    }

    private void buildEntries(@NotNull Module module2, final @NotNull Set<Module> processedModules, final @NotNull Set<Library> processedLibraries, final @NotNull Set<Sdk> processedSdk, @NotNull Condition<OrderEntry> condition2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope", "buildEntries"));
        }
        if (processedModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedModules", "com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope", "buildEntries"));
        }
        if (processedLibraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedLibraries", "com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope", "buildEntries"));
        }
        if (processedSdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedSdk", "com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope", "buildEntries"));
        }
        if (condition2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope", "buildEntries"));
        }
        if (!processedModules.add(module2)) {
            return;
        }
        ModuleRootManager.getInstance((Module)module2).orderEntries().recursively().satisfying(condition2).process((RootPolicy)new RootPolicy<Set<VirtualFile>>(){

            public Set<VirtualFile> visitLibraryOrderEntry(LibraryOrderEntry libraryOrderEntry, Set<VirtualFile> value2) {
                Library library = libraryOrderEntry.getLibrary();
                if (library != null && processedLibraries.add(library)) {
                    ContainerUtil.addAll(value2, (Object[])libraryOrderEntry.getRootFiles(OrderRootType.CLASSES));
                    ContainerUtil.addAll(value2, (Object[])libraryOrderEntry.getRootFiles(OrderRootType.SOURCES));
                }
                return value2;
            }

            public Set<VirtualFile> visitModuleSourceOrderEntry(ModuleSourceOrderEntry moduleSourceOrderEntry, Set<VirtualFile> value2) {
                processedModules.add(moduleSourceOrderEntry.getOwnerModule());
                ContainerUtil.addAll(value2, (Object[])moduleSourceOrderEntry.getRootModel().getSourceRoots());
                return value2;
            }

            public Set<VirtualFile> visitModuleOrderEntry(ModuleOrderEntry moduleOrderEntry, Set<VirtualFile> value2) {
                Module depModule = moduleOrderEntry.getModule();
                if (depModule != null) {
                    ContainerUtil.addAll(value2, (Object[])ModuleRootManager.getInstance((Module)depModule).getSourceRoots());
                }
                return value2;
            }

            public Set<VirtualFile> visitJdkOrderEntry(JdkOrderEntry jdkOrderEntry, Set<VirtualFile> value2) {
                Sdk jdk = jdkOrderEntry.getJdk();
                if (jdk != null && processedSdk.add(jdk)) {
                    ContainerUtil.addAll(value2, (Object[])jdkOrderEntry.getRootFiles(OrderRootType.CLASSES));
                    ContainerUtil.addAll(value2, (Object[])jdkOrderEntry.getRootFiles(OrderRootType.SOURCES));
                }
                return value2;
            }
        }, this.myEntries);
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope", "contains"));
        }
        return this.myEntries.contains(this.getFileRoot(file2));
    }

    @Nullable
    private VirtualFile getFileRoot(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope", "getFileRoot"));
        }
        if (this.myIndex.isInContent(file2) || this.myIndex.isInLibrarySource(file2)) {
            return this.myIndex.getSourceRootForFile(file2);
        }
        if (this.myIndex.isInLibraryClasses(file2)) {
            return this.myIndex.getClassRootForFile(file2);
        }
        return null;
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope", "compare"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope", "compare"));
        }
        VirtualFile r1 = this.getFileRoot(file1);
        VirtualFile r2 = this.getFileRoot(file2);
        for (VirtualFile root : this.myEntries) {
            if (Comparing.equal((Object)r1, (Object)root)) {
                return 1;
            }
            if (!Comparing.equal((Object)r2, (Object)root)) continue;
            return -1;
        }
        return 0;
    }

    @NotNull
    public List<VirtualFile> getRoots() {
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(this.myEntries);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope", "getRoots"));
        }
        return arrayList;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/openapi/module/impl/scopes/LibraryRuntimeClasspathScope", "isSearchInModuleContent"));
        }
        return false;
    }

    public boolean isSearchInLibraries() {
        return true;
    }

    private static /* synthetic */ boolean lambda$new$0(Set processedModules, OrderEntry orderEntry) {
        if (orderEntry instanceof ModuleOrderEntry) {
            Module module2 = ((ModuleOrderEntry)orderEntry).getModule();
            return module2 != null && !processedModules.contains(module2);
        }
        return true;
    }
}

