/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Queue;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class ModuleWithDependentsScope
extends GlobalSearchScope {
    private final Module myModule;
    private final ProjectFileIndex myProjectFileIndex;
    private final Set<Module> myModules;
    private final GlobalSearchScope myProjectScope;

    ModuleWithDependentsScope(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/module/impl/scopes/ModuleWithDependentsScope", "<init>"));
        }
        super(module2.getProject());
        this.myModule = module2;
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)module2.getProject()).getFileIndex();
        this.myProjectScope = ProjectScope.getProjectScope((Project)module2.getProject());
        this.myModules = ModuleWithDependentsScope.buildDependents(this.myModule);
    }

    private static Set<Module> buildDependents(Module module2) {
        THashSet result2 = new THashSet();
        result2.add(module2);
        THashSet processedExporting = new THashSet();
        ModuleIndex index = ModuleWithDependentsScope.getModuleIndex(module2.getProject());
        Queue walkingQueue = new Queue(10);
        walkingQueue.addLast((Object)module2);
        while (!walkingQueue.isEmpty()) {
            Module current = (Module)walkingQueue.pullFirst();
            processedExporting.add(current);
            result2.addAll(index.plainUsages.get((Object)current));
            for (Module dependent : index.exportingUsages.get((Object)current)) {
                result2.add(dependent);
                if (!processedExporting.add(dependent)) continue;
                walkingQueue.addLast((Object)dependent);
            }
        }
        return result2;
    }

    private static ModuleIndex getModuleIndex(Project project2) {
        return (ModuleIndex)CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)project2, () -> {
            ModuleIndex index = new ModuleIndex();
            for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
                for (OrderEntry orderEntry : ModuleRootManager.getInstance((Module)module2).getOrderEntries()) {
                    Module referenced;
                    if (!(orderEntry instanceof ModuleOrderEntry) || (referenced = ((ModuleOrderEntry)orderEntry).getModule()) == null) continue;
                    MultiMap<Module, Module> map2 = ((ModuleOrderEntry)orderEntry).isExported() ? index.exportingUsages : index.plainUsages;
                    map2.putValue((Object)referenced, (Object)module2);
                }
            }
            return CachedValueProvider.Result.create((Object)index, (Object[])new Object[]{ProjectRootManager.getInstance((Project)project2)});
        });
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/module/impl/scopes/ModuleWithDependentsScope", "contains"));
        }
        return this.contains(file2, false);
    }

    boolean contains(@NotNull VirtualFile file2, boolean myOnlyTests) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/module/impl/scopes/ModuleWithDependentsScope", "contains"));
        }
        Module moduleOfFile = this.myProjectFileIndex.getModuleForFile(file2);
        if (moduleOfFile == null || !this.myModules.contains(moduleOfFile)) {
            return false;
        }
        if (myOnlyTests && !TestSourcesFilter.isTestSources((VirtualFile)file2, (Project)moduleOfFile.getProject())) {
            return false;
        }
        return this.myProjectScope.contains(file2);
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/openapi/module/impl/scopes/ModuleWithDependentsScope", "compare"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/openapi/module/impl/scopes/ModuleWithDependentsScope", "compare"));
        }
        return 0;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/openapi/module/impl/scopes/ModuleWithDependentsScope", "isSearchInModuleContent"));
        }
        return this.myModules.contains(aModule);
    }

    public boolean isSearchInLibraries() {
        return false;
    }

    public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myModule.getProject());
        return ContainerUtil.mapNotNull(DirectoryIndex.getInstance(this.myModule.getProject()).getDependentUnloadedModules(this.myModule), arg_0 -> ((ModuleManager)moduleManager).getUnloadedModuleDescription(arg_0));
    }

    @NonNls
    public String toString() {
        return "Module with dependents:" + this.myModule.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleWithDependentsScope)) {
            return false;
        }
        ModuleWithDependentsScope moduleWithDependentsScope = (ModuleWithDependentsScope)((Object)o);
        return this.myModule.equals(moduleWithDependentsScope.myModule);
    }

    public int hashCode() {
        return this.myModule.hashCode();
    }

    private static class ModuleIndex {
        final MultiMap<Module, Module> plainUsages = MultiMap.create();
        final MultiMap<Module, Module> exportingUsages = MultiMap.create();

        private ModuleIndex() {
        }
    }
}

