/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AbstractProgressIndicatorExBase
extends AbstractProgressIndicatorBase
implements ProgressIndicatorEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.progress.util.ProgressIndicatorBase");
    private final boolean myReusable;
    private volatile List<ProgressIndicatorEx> myStateDelegates;
    private volatile WeakList<TaskInfo> myFinished;
    private volatile boolean myWasStarted;
    private TaskInfo myOwnerTask;

    public AbstractProgressIndicatorExBase(boolean reusable) {
        this.myReusable = reusable;
    }

    public AbstractProgressIndicatorExBase() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        AbstractProgressIndicatorExBase abstractProgressIndicatorExBase = this;
        synchronized (abstractProgressIndicatorExBase) {
            super.start();
            this.delegateRunningChange(ProgressIndicator::start);
        }
        this.myWasStarted = true;
    }

    @Override
    public void stop() {
        super.stop();
        this.delegateRunningChange(ProgressIndicator::stop);
    }

    @Override
    public void cancel() {
        super.cancel();
        this.delegateRunningChange(ProgressIndicator::cancel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish(@NotNull TaskInfo task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase", "finish"));
        }
        WeakList finished2 = this.myFinished;
        if (finished2 == null) {
            AbstractProgressIndicatorExBase abstractProgressIndicatorExBase = this;
            synchronized (abstractProgressIndicatorExBase) {
                finished2 = this.myFinished;
                if (finished2 == null) {
                    this.myFinished = finished2 = new WeakList();
                }
            }
        }
        if (!finished2.addIfAbsent((Object)task)) {
            return;
        }
        this.delegateRunningChange(each -> {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase", "lambda$finish$0"));
            }
            each.finish(task);
        });
    }

    @Override
    public boolean isFinished(@NotNull TaskInfo task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase", "isFinished"));
        }
        WeakList<TaskInfo> list2 = this.myFinished;
        return list2 != null && list2.contains(task);
    }

    protected void setOwnerTask(TaskInfo owner2) {
        this.myOwnerTask = owner2;
    }

    @Override
    public void processFinish() {
        if (this.myOwnerTask != null) {
            this.finish(this.myOwnerTask);
            this.myOwnerTask = null;
        }
    }

    @Override
    public final void checkCanceled() {
        super.checkCanceled();
        this.delegate(ProgressIndicator::checkCanceled);
    }

    @Override
    public void setText(String text2) {
        super.setText(text2);
        this.delegateProgressChange(each -> each.setText(text2));
    }

    @Override
    public void setText2(String text2) {
        super.setText2(text2);
        this.delegateProgressChange(each -> each.setText2(text2));
    }

    @Override
    public void setFraction(double fraction) {
        super.setFraction(fraction);
        this.delegateProgressChange(each -> each.setFraction(fraction));
    }

    @Override
    public synchronized void pushState() {
        super.pushState();
        this.delegateProgressChange(ProgressIndicator::pushState);
    }

    @Override
    public synchronized void popState() {
        super.popState();
        this.delegateProgressChange(ProgressIndicator::popState);
    }

    @Override
    public void startNonCancelableSection() {
        super.startNonCancelableSection();
        this.delegateProgressChange(ProgressIndicator::startNonCancelableSection);
    }

    @Override
    public void finishNonCancelableSection() {
        super.finishNonCancelableSection();
        this.delegateProgressChange(ProgressIndicator::finishNonCancelableSection);
    }

    @Override
    protected boolean isReuseable() {
        return this.myReusable;
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        super.setIndeterminate(indeterminate);
        this.delegateProgressChange(each -> each.setIndeterminate(indeterminate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addStateDelegate(@NotNull ProgressIndicatorEx delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase", "addStateDelegate"));
        }
        delegate.initStateFrom(this);
        AbstractProgressIndicatorExBase abstractProgressIndicatorExBase = this;
        synchronized (abstractProgressIndicatorExBase) {
            List stateDelegates = this.myStateDelegates;
            if (stateDelegates == null) {
                this.myStateDelegates = stateDelegates = ContainerUtil.createLockFreeCopyOnWriteList();
            } else {
                LOG.assertTrue(!stateDelegates.contains(delegate), (Object)("Already registered: " + delegate));
            }
            stateDelegates.add(delegate);
        }
    }

    protected void delegateProgressChange(@NotNull IndicatorAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase", "delegateProgressChange"));
        }
        this.delegate(action);
        this.onProgressChange();
    }

    protected void delegateRunningChange(@NotNull IndicatorAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase", "delegateRunningChange"));
        }
        this.delegate(action);
        this.onRunningChange();
    }

    private void delegate(@NotNull IndicatorAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase", "delegate"));
        }
        List<ProgressIndicatorEx> list2 = this.myStateDelegates;
        if (list2 != null && !list2.isEmpty()) {
            for (ProgressIndicatorEx each : list2) {
                action.execute(each);
            }
        }
    }

    protected void onProgressChange() {
    }

    protected void onRunningChange() {
    }

    @Override
    public boolean wasStarted() {
        return this.myWasStarted;
    }

    @FunctionalInterface
    protected static interface IndicatorAction {
        public void execute(@NotNull ProgressIndicatorEx var1);
    }
}

