/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinder;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.ProjectRootContainerImpl;
import com.intellij.openapi.projectRoots.impl.SdkVersionUtil;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.impl.JavaSdkUtil;

public class JavaSdkImpl
extends JavaSdk {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.impl.JavaSdkImpl");
    public static final DataKey<Boolean> KEY = DataKey.create((String)"JavaSdk");
    private static final String VM_EXE_NAME = "java";
    private static final Pattern VERSION_STRING_PATTERN = Pattern.compile("^(.*)java version \"([1234567890_.]*)\"(.*)$");
    private static final String JAVA_VERSION_PREFIX = "java version ";
    private static final String OPENJDK_VERSION_PREFIX = "openjdk version ";
    private final Map<String, String> myCachedSdkHomeToVersionString = new ConcurrentHashMap<String, String>();
    private final Map<String, JavaSdkVersion> myCachedVersionStringToJavaVersion = new ConcurrentHashMap<String, JavaSdkVersion>();

    public JavaSdkImpl(VirtualFileManager fileManager, final FileTypeManager fileTypeManager) {
        super("JavaSDK");
        fileManager.addVirtualFileListener(new VirtualFileListener(){

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl$1", "fileDeleted"));
                }
                this.updateCache(event);
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl$1", "contentsChanged"));
                }
                this.updateCache(event);
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl$1", "fileCreated"));
                }
                this.updateCache(event);
            }

            private void updateCache(VirtualFileEvent event) {
                VirtualFile file2 = event.getFile();
                if (FileTypes.ARCHIVE.equals(fileTypeManager.getFileTypeByFileName(event.getFileName()))) {
                    String filePath = file2.getPath();
                    if (JavaSdkImpl.this.myCachedSdkHomeToVersionString.keySet().removeIf(sdkHome -> FileUtil.isAncestor((String)sdkHome, (String)filePath, (boolean)false))) {
                        JavaSdkImpl.this.myCachedVersionStringToJavaVersion.clear();
                    }
                }
            }
        });
    }

    @NotNull
    public String getPresentableName() {
        String string = ProjectBundle.message((String)"sdk.java.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "getPresentableName"));
        }
        return string;
    }

    public Icon getIcon() {
        return AllIcons.Nodes.PpJdk;
    }

    @NotNull
    public String getHelpTopic() {
        if ("reference.project.structure.sdk.java" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "getHelpTopic"));
        }
        return "reference.project.structure.sdk.java";
    }

    @NotNull
    public Icon getIconForAddAction() {
        Icon icon = AllIcons.General.AddJdk;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "getIconForAddAction"));
        }
        return icon;
    }

    @Nullable
    public String getDefaultDocumentationUrl(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "getDefaultDocumentationUrl"));
        }
        JavaSdkVersion version = this.getVersion(sdk);
        if (version == JavaSdkVersion.JDK_1_5) {
            return "http://docs.oracle.com/javase/1.5.0/docs/api/";
        }
        if (version == JavaSdkVersion.JDK_1_6) {
            return "http://docs.oracle.com/javase/6/docs/api/";
        }
        if (version == JavaSdkVersion.JDK_1_7) {
            return "http://docs.oracle.com/javase/7/docs/api/";
        }
        if (version == JavaSdkVersion.JDK_1_8) {
            return "http://docs.oracle.com/javase/8/docs/api/";
        }
        if (version == JavaSdkVersion.JDK_1_9) {
            return "http://download.java.net/java/jdk9/docs/api/";
        }
        return null;
    }

    @Nullable
    public String getDownloadSdkUrl() {
        return "http://www.oracle.com/technetwork/java/javase/downloads/index.html";
    }

    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkModel", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "createAdditionalDataConfigurable"));
        }
        if (sdkModificator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkModificator", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "createAdditionalDataConfigurable"));
        }
        return null;
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        if (additionalData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalData", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "saveAdditionalData"));
        }
        if (additional == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additional", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "saveAdditionalData"));
        }
    }

    public String getBinPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "getBinPath"));
        }
        return JavaSdkImpl.getConvertedHomePath(sdk) + "bin";
    }

    public String getToolsPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "getToolsPath"));
        }
        String versionString = sdk.getVersionString();
        boolean isJdk1_x = versionString != null && (versionString.contains("1.0") || versionString.contains("1.1"));
        return JavaSdkImpl.getConvertedHomePath(sdk) + "lib" + File.separator + (isJdk1_x ? "classes.zip" : "tools.jar");
    }

    public String getVMExecutablePath(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "getVMExecutablePath"));
        }
        return this.getBinPath(sdk) + File.separator + VM_EXE_NAME;
    }

    private static String getConvertedHomePath(Sdk sdk) {
        String homePath = sdk.getHomePath();
        assert (homePath != null) : sdk;
        String path = FileUtil.toSystemDependentName((String)homePath);
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        return path;
    }

    public String suggestHomePath() {
        Collection<String> paths = this.suggestHomePaths();
        return paths.isEmpty() ? null : paths.iterator().next();
    }

    @NotNull
    public Collection<String> suggestHomePaths() {
        List<String> list2 = JavaHomeFinder.suggestHomePaths();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "suggestHomePaths"));
        }
        return list2;
    }

    @NotNull
    public FileChooserDescriptor getHomeChooserDescriptor() {
        FileChooserDescriptor descriptor = super.getHomeChooserDescriptor();
        descriptor.putUserData(KEY, (Object)Boolean.TRUE);
        FileChooserDescriptor fileChooserDescriptor2 = descriptor;
        if (fileChooserDescriptor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "getHomeChooserDescriptor"));
        }
        return fileChooserDescriptor2;
    }

    @NotNull
    public String adjustSelectedSdkHome(@NotNull String homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "adjustSelectedSdkHome"));
        }
        if (SystemInfo.isMac) {
            File home = new File(homePath, "/Home");
            if (home.exists()) {
                String string = home.getPath();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "adjustSelectedSdkHome"));
                }
                return string;
            }
            home = new File(homePath, "Contents/Home");
            if (home.exists()) {
                String string = home.getPath();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "adjustSelectedSdkHome"));
                }
                return string;
            }
        }
        String string = homePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "adjustSelectedSdkHome"));
        }
        return string;
    }

    public boolean isValidSdkHome(String path) {
        return JdkUtil.checkForJdk((String)path);
    }

    public String suggestSdkName(String currentSdkName, String sdkHome) {
        String versionString;
        String versionString2;
        Matcher matcher;
        boolean replaceNameWithVersion;
        String suggestedName = currentSdkName != null && !currentSdkName.isEmpty() ? ((replaceNameWithVersion = (matcher = VERSION_STRING_PATTERN.matcher(currentSdkName)).matches()) ? ((versionString2 = this.getVersionString(sdkHome)) == null ? currentSdkName : matcher.replaceFirst("$1" + versionString2 + "$3")) : currentSdkName) : ((versionString = this.getVersionString(sdkHome)) == null ? ProjectBundle.message((String)"sdk.java.unknown.name", (Object[])new Object[0]) : JavaSdkImpl.getVersionNumber(versionString));
        return suggestedName;
    }

    @NotNull
    private static String getVersionNumber(@NotNull String versionString) {
        if (versionString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionString", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "getVersionNumber"));
        }
        if (versionString.startsWith(JAVA_VERSION_PREFIX) || versionString.startsWith(OPENJDK_VERSION_PREFIX)) {
            int dotIdx;
            boolean openJdk = versionString.startsWith(OPENJDK_VERSION_PREFIX);
            if ((versionString = versionString.substring(openJdk ? OPENJDK_VERSION_PREFIX.length() : JAVA_VERSION_PREFIX.length())).startsWith("\"") && versionString.endsWith("\"")) {
                versionString = versionString.substring(1, versionString.length() - 1);
            }
            if ((dotIdx = versionString.indexOf(46)) > 0) {
                try {
                    int major = Integer.parseInt(versionString.substring(0, dotIdx));
                    int minorDot = versionString.indexOf(46, dotIdx + 1);
                    if (minorDot > 0) {
                        int minor = Integer.parseInt(versionString.substring(dotIdx + 1, minorDot));
                        versionString = major + "." + minor;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        String string = versionString;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "getVersionNumber"));
        }
        return string;
    }

    public void setupSdkPaths(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "setupSdkPaths"));
        }
        String homePath = sdk.getHomePath();
        assert (homePath != null) : sdk;
        File jdkHome = new File(homePath);
        SdkModificator sdkModificator = sdk.getSdkModificator();
        List<VirtualFile> classes2 = JavaSdkImpl.findClasses(jdkHome, false);
        LinkedHashSet<VirtualFile> previousRoots = new LinkedHashSet<VirtualFile>(Arrays.asList(sdkModificator.getRoots(OrderRootType.CLASSES)));
        sdkModificator.removeRoots(OrderRootType.CLASSES);
        previousRoots.removeAll(new HashSet<VirtualFile>(classes2));
        for (VirtualFile aClass : classes2) {
            sdkModificator.addRoot(aClass, OrderRootType.CLASSES);
        }
        for (VirtualFile root : previousRoots) {
            sdkModificator.addRoot(root, OrderRootType.CLASSES);
        }
        JavaSdkImpl.addSources(jdkHome, sdkModificator);
        this.addDocs(jdkHome, sdkModificator, sdk);
        JavaSdkImpl.attachJdkAnnotations(sdkModificator);
        sdkModificator.commitChanges();
    }

    public static void attachJdkAnnotations(@NotNull SdkModificator modificator) {
        if (modificator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modificator", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "attachJdkAnnotations"));
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        ArrayList<String> pathsChecked = new ArrayList<String>();
        String path = FileUtil.toSystemIndependentName((String)PathManager.getHomePath()) + "/java/jdkAnnotations";
        VirtualFile root = lfs.findFileByPath(path);
        pathsChecked.add(path);
        if (root == null) {
            path = FileUtil.toSystemIndependentName((String)PathManager.getHomePath()) + "/community/java/jdkAnnotations";
            root = lfs.findFileByPath(path);
            pathsChecked.add(path);
        }
        if (root == null) {
            String url = "jar://" + FileUtil.toSystemIndependentName((String)PathManager.getHomePath()) + "/lib/jdkAnnotations.jar!/";
            root = VirtualFileManager.getInstance().findFileByUrl(url);
            pathsChecked.add(FileUtil.toSystemIndependentName((String)PathManager.getHomePath()) + "/lib/jdkAnnotations.jar");
        }
        if (root == null) {
            StringBuilder msg = new StringBuilder("Paths checked:\n");
            for (String p : pathsChecked) {
                File f = new File(p);
                msg.append(p).append("; ").append(f.exists()).append("; ").append(Arrays.toString(f.getParentFile().list())).append('\n');
            }
            LOG.error("JDK annotations not found", new String[]{msg.toString()});
            return;
        }
        OrderRootType annoType = AnnotationOrderRootType.getInstance();
        modificator.removeRoot(root, annoType);
        modificator.addRoot(root, annoType);
    }

    public final String getVersionString(String sdkHome) {
        String versionString = this.myCachedSdkHomeToVersionString.get(sdkHome);
        if (versionString == null && !StringUtil.isEmpty((String)(versionString = SdkVersionUtil.detectJdkVersion((String)sdkHome)))) {
            this.myCachedSdkHomeToVersionString.put(sdkHome, versionString);
        }
        return versionString;
    }

    public JavaSdkVersion getVersion(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "getVersion"));
        }
        String versionString = sdk.getVersionString();
        return versionString == null ? null : this.myCachedVersionStringToJavaVersion.computeIfAbsent(versionString, JavaSdkVersion::fromVersionString);
    }

    @Nullable
    public JavaSdkVersion getVersion(@NotNull String versionString) {
        if (versionString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionString", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "getVersion"));
        }
        return JavaSdkVersion.fromVersionString((String)versionString);
    }

    public boolean isOfVersionOrHigher(@NotNull Sdk sdk, @NotNull JavaSdkVersion version) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "isOfVersionOrHigher"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "isOfVersionOrHigher"));
        }
        JavaSdkVersion sdkVersion = this.getVersion(sdk);
        return sdkVersion != null && sdkVersion.isAtLeast(version);
    }

    @NotNull
    public Sdk createJdk(@NotNull String jdkName, @NotNull String home, boolean isJre) {
        if (jdkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdkName", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "createJdk"));
        }
        if (home == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "home", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "createJdk"));
        }
        ProjectJdkImpl jdk = new ProjectJdkImpl(jdkName, (SdkTypeId)this);
        SdkModificator sdkModificator = jdk.getSdkModificator();
        String path = home.replace(File.separatorChar, '/');
        sdkModificator.setHomePath(path);
        sdkModificator.setVersionString(jdkName);
        File jdkHomeFile = new File(home);
        JavaSdkImpl.addClasses(jdkHomeFile, sdkModificator, isJre);
        JavaSdkImpl.addSources(jdkHomeFile, sdkModificator);
        this.addDocs(jdkHomeFile, sdkModificator, null);
        sdkModificator.commitChanges();
        ProjectJdkImpl projectJdkImpl = jdk;
        if (projectJdkImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "createJdk"));
        }
        return projectJdkImpl;
    }

    @NotNull
    public Sdk createMockJdk(@NotNull String jdkName, @NotNull String home, boolean isJre) {
        if (jdkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdkName", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "createMockJdk"));
        }
        if (home == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "home", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "createMockJdk"));
        }
        String homePath = home.replace(File.separatorChar, '/');
        File jdkHomeFile = new File(homePath);
        final ProjectRootContainerImpl rootContainer = new ProjectRootContainerImpl(true);
        SdkModificator sdkModificator = new SdkModificator(){

            public String getName() {
                throw new UnsupportedOperationException();
            }

            public void setName(String name2) {
                throw new UnsupportedOperationException();
            }

            public String getHomePath() {
                throw new UnsupportedOperationException();
            }

            public void setHomePath(String path) {
                throw new UnsupportedOperationException();
            }

            public String getVersionString() {
                throw new UnsupportedOperationException();
            }

            public void setVersionString(String versionString) {
                throw new UnsupportedOperationException();
            }

            public SdkAdditionalData getSdkAdditionalData() {
                throw new UnsupportedOperationException();
            }

            public void setSdkAdditionalData(SdkAdditionalData data) {
                throw new UnsupportedOperationException();
            }

            public VirtualFile[] getRoots(OrderRootType rootType) {
                throw new UnsupportedOperationException();
            }

            public void removeRoot(VirtualFile root, OrderRootType rootType) {
                throw new UnsupportedOperationException();
            }

            public void removeRoots(OrderRootType rootType) {
                throw new UnsupportedOperationException();
            }

            public void removeAllRoots() {
                throw new UnsupportedOperationException();
            }

            public void commitChanges() {
                throw new UnsupportedOperationException();
            }

            public boolean isWritable() {
                throw new UnsupportedOperationException();
            }

            public void addRoot(VirtualFile root, OrderRootType rootType) {
                rootContainer.addRoot(root, rootType);
            }
        };
        rootContainer.changeRoots(() -> {
            JavaSdkImpl.addClasses(jdkHomeFile, sdkModificator, isJre);
            JavaSdkImpl.addSources(jdkHomeFile, sdkModificator);
        });
        ProjectJdkImpl jdk = new ProjectJdkImpl(jdkName, (SdkTypeId)this, homePath, jdkName){

            @Override
            public void setName(@NotNull String name2) {
                if (name2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl$3", "setName"));
                }
                this.throwReadOnly();
            }

            @Override
            public void readExternal(@NotNull Element element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl$3", "readExternal"));
                }
                this.throwReadOnly();
            }

            @Override
            public void readExternal(@NotNull Element element, @Nullable ProjectJdkTable projectJdkTable) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl$3", "readExternal"));
                }
                this.throwReadOnly();
            }

            @Override
            @NotNull
            public SdkModificator getSdkModificator() {
                this.throwReadOnly();
                if (null == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl$3", "getSdkModificator"));
                }
                return null;
            }

            @Override
            public void setSdkAdditionalData(SdkAdditionalData data) {
                this.throwReadOnly();
            }

            @Override
            public void addRoot(VirtualFile root, OrderRootType rootType) {
                this.throwReadOnly();
            }

            @Override
            public void removeRoot(VirtualFile root, OrderRootType rootType) {
                this.throwReadOnly();
            }

            @Override
            public void removeRoots(OrderRootType rootType) {
                this.throwReadOnly();
            }

            @Override
            public void removeAllRoots() {
                this.throwReadOnly();
            }

            @Override
            public boolean isWritable() {
                return false;
            }

            @Override
            public void update() {
                this.throwReadOnly();
            }

            @Override
            public VirtualFile[] getRoots(OrderRootType rootType) {
                return rootContainer.getRootFiles(rootType);
            }

            @Override
            @NotNull
            public RootProvider getRootProvider() {
                RootProvider rootProvider = new RootProvider(){

                    @NotNull
                    public String[] getUrls(@NotNull OrderRootType rootType) {
                        if (rootType == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl$3$1", "getUrls"));
                        }
                        String[] stringArray = (String[])ContainerUtil.map2Array((Object[])this.getFiles(rootType), String.class, VirtualFile::getUrl);
                        if (stringArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl$3$1", "getUrls"));
                        }
                        return stringArray;
                    }

                    @NotNull
                    public VirtualFile[] getFiles(@NotNull OrderRootType rootType) {
                        if (rootType == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl$3$1", "getFiles"));
                        }
                        VirtualFile[] virtualFileArray = this.getRoots(rootType);
                        if (virtualFileArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl$3$1", "getFiles"));
                        }
                        return virtualFileArray;
                    }

                    public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2) {
                        if (listener2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl$3$1", "addRootSetChangedListener"));
                        }
                    }

                    public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2, @NotNull Disposable parentDisposable) {
                        if (listener2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl$3$1", "addRootSetChangedListener"));
                        }
                        if (parentDisposable == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl$3$1", "addRootSetChangedListener"));
                        }
                    }

                    public void removeRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2) {
                        if (listener2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl$3$1", "removeRootSetChangedListener"));
                        }
                    }
                };
                if (rootProvider == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl$3", "getRootProvider"));
                }
                return rootProvider;
            }

            private void throwReadOnly() {
                throw new IncorrectOperationException("Can't modify, MockJDK is read-only, consider calling .clone() first");
            }
        };
        jdk.copyRootsFrom(rootContainer);
        ProjectJdkImpl projectJdkImpl = jdk;
        if (projectJdkImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "createMockJdk"));
        }
        return projectJdkImpl;
    }

    private static void addClasses(File file2, SdkModificator sdkModificator, boolean isJre) {
        for (VirtualFile virtualFile : JavaSdkImpl.findClasses(file2, isJre)) {
            sdkModificator.addRoot(virtualFile, OrderRootType.CLASSES);
        }
    }

    @NotNull
    private static List<VirtualFile> findClasses(File file2, boolean isJre) {
        ArrayList result2 = ContainerUtil.newArrayList();
        VirtualFileManager fileManager = VirtualFileManager.getInstance();
        if (JdkUtil.isModularRuntime((File)file2)) {
            VirtualFile jrt = fileManager.findFileByUrl("jrt://" + JavaSdkImpl.getPath(file2) + "!/");
            if (jrt != null) {
                ContainerUtil.addAll((Collection)result2, (Object[])jrt.getChildren());
            }
        } else {
            for (File root : JavaSdkUtil.getJdkClassesRoots((File)file2, (boolean)isJre)) {
                String url = VfsUtil.getUrlForLibraryRoot((File)root);
                ContainerUtil.addIfNotNull((Collection)result2, (Object)fileManager.findFileByUrl(url));
            }
        }
        Collections.sort(result2, Comparator.comparing(VirtualFile::getPath));
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "findClasses"));
        }
        return arrayList;
    }

    private static void addSources(@NotNull File jdkHome, @NotNull SdkModificator sdkModificator) {
        VirtualFile fxSrc;
        if (jdkHome == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdkHome", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "addSources"));
        }
        if (sdkModificator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkModificator", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "addSources"));
        }
        VirtualFile jdkSrc = JavaSdkImpl.findSources(jdkHome, "src");
        if (jdkSrc != null) {
            if (jdkSrc.findChild("java.base") != null) {
                Stream.of(jdkSrc.getChildren()).filter(VirtualFile::isDirectory).forEach(root -> {
                    if (sdkModificator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkModificator", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "lambda$addSources$1"));
                    }
                    sdkModificator.addRoot(root, OrderRootType.SOURCES);
                });
            } else {
                sdkModificator.addRoot(jdkSrc, OrderRootType.SOURCES);
            }
        }
        if ((fxSrc = JavaSdkImpl.findSources(jdkHome, "javafx-src")) != null) {
            sdkModificator.addRoot(fxSrc, OrderRootType.SOURCES);
        }
    }

    @Nullable
    private static VirtualFile findSources(File jdkHome, String srcName) {
        File srcArc = new File(jdkHome, srcName + ".jar");
        if (!srcArc.exists()) {
            srcArc = new File(jdkHome, srcName + ".zip");
        }
        if (!srcArc.exists()) {
            srcArc = new File(jdkHome, "lib/" + srcName + ".zip");
        }
        if (srcArc.exists()) {
            VirtualFile srcRoot = JavaSdkImpl.findInJar(srcArc, "src");
            if (srcRoot == null) {
                srcRoot = JavaSdkImpl.findInJar(srcArc, "");
            }
            return srcRoot;
        }
        File srcDir = new File(jdkHome, "src");
        if (srcDir.isDirectory()) {
            return LocalFileSystem.getInstance().findFileByPath(JavaSdkImpl.getPath(srcDir));
        }
        return null;
    }

    private void addDocs(File jdkHome, SdkModificator sdkModificator, @Nullable Sdk sdk) {
        OrderRootType docRootType = JavadocOrderRootType.getInstance();
        VirtualFile apiDocs = JavaSdkImpl.findDocs(jdkHome, "docs/api");
        if (apiDocs != null) {
            sdkModificator.addRoot(apiDocs, docRootType);
        } else if (SystemInfo.isMac) {
            VirtualFile appleDocs;
            VirtualFile commonDocs = JavaSdkImpl.findDocs(jdkHome, "docs");
            if (commonDocs == null) {
                commonDocs = JavaSdkImpl.findInJar(new File(jdkHome, "docs.jar"), "doc/api");
            }
            if (commonDocs == null) {
                commonDocs = JavaSdkImpl.findInJar(new File(jdkHome, "docs.jar"), "docs/api");
            }
            if (commonDocs != null) {
                sdkModificator.addRoot(commonDocs, docRootType);
            }
            if ((appleDocs = JavaSdkImpl.findDocs(jdkHome, "appledocs")) == null) {
                appleDocs = JavaSdkImpl.findInJar(new File(jdkHome, "appledocs.jar"), "appledoc/api");
            }
            if (appleDocs != null) {
                sdkModificator.addRoot(appleDocs, docRootType);
            }
        }
        if (sdk != null && sdkModificator.getRoots(docRootType).length == 0 && sdkModificator.getRoots(OrderRootType.SOURCES).length == 0) {
            VirtualFile fxDocUrl;
            VirtualFile onlineDoc;
            String docUrl = this.getDefaultDocumentationUrl(sdk);
            if (docUrl != null && (onlineDoc = VirtualFileManager.getInstance().findFileByUrl(docUrl)) != null) {
                sdkModificator.addRoot(onlineDoc, docRootType);
            }
            if (this.getVersion(sdk) == JavaSdkVersion.JDK_1_7 && (fxDocUrl = VirtualFileManager.getInstance().findFileByUrl("http://docs.oracle.com/javafx/2/api/")) != null) {
                sdkModificator.addRoot(fxDocUrl, docRootType);
            }
        }
    }

    @Nullable
    private static VirtualFile findDocs(@NotNull File jdkHome, @NotNull String relativePath) {
        if (jdkHome == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdkHome", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "findDocs"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "findDocs"));
        }
        File docDir = new File(jdkHome.getAbsolutePath(), relativePath);
        return docDir.isDirectory() ? LocalFileSystem.getInstance().findFileByPath(JavaSdkImpl.getPath(docDir)) : null;
    }

    private static VirtualFile findInJar(File jarFile, String relativePath) {
        if (!jarFile.exists()) {
            return null;
        }
        String url = "jar://" + JavaSdkImpl.getPath(jarFile) + "!/" + relativePath;
        return VirtualFileManager.getInstance().findFileByUrl(url);
    }

    private static String getPath(File jarFile) {
        return FileUtil.toSystemIndependentName((String)jarFile.getAbsolutePath());
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "isRootTypeApplicable"));
        }
        return type2 == OrderRootType.CLASSES || type2 == OrderRootType.SOURCES || type2 == JavadocOrderRootType.getInstance() || type2 == AnnotationOrderRootType.getInstance();
    }
}

