/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.impl.DirectoryInfoImpl;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryInfoWithExcludePatterns
extends DirectoryInfoImpl {
    private static final Logger LOG = Logger.getInstance(DirectoryInfoWithExcludePatterns.class);
    @Nullable
    private final FileTypeAssocTable<Boolean> myContentExcludePatterns;
    @Nullable
    private final Condition<VirtualFile> myLibraryExcludeCondition;

    public DirectoryInfoWithExcludePatterns(@NotNull VirtualFile root, Module module2, VirtualFile contentRoot, VirtualFile sourceRoot, VirtualFile libraryClassRoot, boolean inModuleSource, boolean inLibrarySource, boolean isExcluded, int sourceRootTypeId, @Nullable FileTypeAssocTable<Boolean> contentExcludePatterns, @Nullable Condition<VirtualFile> libraryExcludeCondition, @Nullable String unloadedModuleName) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/roots/impl/DirectoryInfoWithExcludePatterns", "<init>"));
        }
        super(root, module2, contentRoot, sourceRoot, libraryClassRoot, inModuleSource, inLibrarySource, isExcluded, sourceRootTypeId, unloadedModuleName);
        this.myContentExcludePatterns = contentExcludePatterns;
        this.myLibraryExcludeCondition = libraryExcludeCondition;
        LOG.assertTrue(this.myContentExcludePatterns != null || this.myLibraryExcludeCondition != null, (Object)("Directory info of '" + root + "' with exclude patterns have no any exclude patterns: " + this.toString()));
    }

    @Override
    public boolean isInLibrarySource(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/DirectoryInfoWithExcludePatterns", "isInLibrarySource"));
        }
        return this.myInLibrarySource && !this.isExcludedByCondition(file2, this.myLibraryExcludeCondition);
    }

    private boolean isExcludedByCondition(@NotNull VirtualFile file2, @Nullable Condition<VirtualFile> condition2) {
        VirtualFile current;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/DirectoryInfoWithExcludePatterns", "isExcludedByCondition"));
        }
        if (condition2 == null) {
            return false;
        }
        for (current = DirectoryInfoWithExcludePatterns.getPhysicalFile(file2); current != null && !this.myRoot.equals(current); current = current.getParent()) {
            if (!condition2.value((Object)current)) continue;
            return true;
        }
        if (current == null) {
            LOG.error("File " + file2 + " is not under this directory (" + this.myRoot + ")");
        }
        return false;
    }

    private boolean isExcludedByPatterns(@NotNull VirtualFile file2, @Nullable FileTypeAssocTable<Boolean> patterns) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/DirectoryInfoWithExcludePatterns", "isExcludedByPatterns"));
        }
        return patterns != null && this.isExcludedByCondition(file2, (Condition<VirtualFile>)((Condition)f -> patterns.findAssociatedFileType(f.getNameSequence()) != null));
    }

    private static VirtualFile getPhysicalFile(VirtualFile file2) {
        return file2 instanceof VirtualFileWindow ? ((VirtualFileWindow)file2).getDelegate() : file2;
    }

    @Override
    public boolean isExcluded(@NotNull VirtualFile file2) {
        VirtualFile current;
        boolean inContent;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/DirectoryInfoWithExcludePatterns", "isExcluded"));
        }
        if (this.myExcluded) {
            return true;
        }
        if (this.myLibraryExcludeCondition == null && this.myContentExcludePatterns == null) {
            LOG.error("Directory info of '" + this.getRoot() + "' with exclude patterns have no any exclude patterns: " + this.toString());
            return false;
        }
        boolean bl = inContent = this.getContentRoot() != null;
        if (!inContent && !this.myInLibrarySource) {
            return false;
        }
        for (current = DirectoryInfoWithExcludePatterns.getPhysicalFile(file2); current != null && !this.myRoot.equals(current); current = current.getParent()) {
            boolean excludedFromLibrary;
            CharSequence name2 = current.getNameSequence();
            boolean excludedFromModule = this.myContentExcludePatterns != null && this.myContentExcludePatterns.findAssociatedFileType(name2) != null;
            boolean bl2 = excludedFromLibrary = this.myLibraryExcludeCondition != null && this.myLibraryExcludeCondition.value((Object)current);
            if (inContent && !excludedFromModule || this.myInLibrarySource && !excludedFromLibrary) continue;
            return true;
        }
        if (current == null) {
            LOG.error("File " + file2 + " is not under this directory (" + this.myRoot + ")");
        }
        return false;
    }

    @Override
    public boolean isInModuleSource(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/DirectoryInfoWithExcludePatterns", "isInModuleSource"));
        }
        return this.myInModuleSource && !this.isExcludedByPatterns(file2, this.myContentExcludePatterns);
    }
}

