/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrderEntryUtil {
    private OrderEntryUtil() {
    }

    @Nullable
    public static LibraryOrderEntry findLibraryOrderEntry(@NotNull ModuleRootModel model, @Nullable Library library) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/roots/impl/OrderEntryUtil", "findLibraryOrderEntry"));
        }
        if (library == null) {
            return null;
        }
        for (OrderEntry orderEntry : model.getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry) || !library.equals(((LibraryOrderEntry)orderEntry).getLibrary())) continue;
            return (LibraryOrderEntry)orderEntry;
        }
        return null;
    }

    @Nullable
    public static LibraryOrderEntry findLibraryOrderEntry(@NotNull ModuleRootModel model, @NotNull String libraryName) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/roots/impl/OrderEntryUtil", "findLibraryOrderEntry"));
        }
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/openapi/roots/impl/OrderEntryUtil", "findLibraryOrderEntry"));
        }
        for (OrderEntry orderEntry : model.getOrderEntries()) {
            String libName;
            if (!(orderEntry instanceof LibraryOrderEntry) || !libraryName.equals(libName = ((LibraryOrderEntry)orderEntry).getLibraryName())) continue;
            return (LibraryOrderEntry)orderEntry;
        }
        return null;
    }

    @Nullable
    public static ModuleOrderEntry findModuleOrderEntry(@NotNull ModuleRootModel model, @Nullable Module module2) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/roots/impl/OrderEntryUtil", "findModuleOrderEntry"));
        }
        if (module2 == null) {
            return null;
        }
        for (OrderEntry orderEntry : model.getOrderEntries()) {
            if (!(orderEntry instanceof ModuleOrderEntry) || !module2.equals(((ModuleOrderEntry)orderEntry).getModule())) continue;
            return (ModuleOrderEntry)orderEntry;
        }
        return null;
    }

    @Nullable
    public static JdkOrderEntry findJdkOrderEntry(@NotNull ModuleRootModel model, @Nullable Sdk sdk) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/roots/impl/OrderEntryUtil", "findJdkOrderEntry"));
        }
        if (sdk == null) {
            return null;
        }
        for (OrderEntry orderEntry : model.getOrderEntries()) {
            if (!(orderEntry instanceof JdkOrderEntry) || !sdk.equals(((JdkOrderEntry)orderEntry).getJdk())) continue;
            return (JdkOrderEntry)orderEntry;
        }
        return null;
    }

    public static boolean equals(OrderEntry orderEntry1, OrderEntry orderEntry2) {
        if (orderEntry1 instanceof JdkOrderEntry && orderEntry2 instanceof JdkOrderEntry) {
            JdkOrderEntry jdkOrderEntry1 = (JdkOrderEntry)orderEntry1;
            JdkOrderEntry jdkOrderEntry2 = (JdkOrderEntry)orderEntry2;
            return Comparing.equal((Object)jdkOrderEntry1.getJdk(), (Object)jdkOrderEntry2.getJdk()) && Comparing.strEqual((String)jdkOrderEntry1.getJdkName(), (String)jdkOrderEntry2.getJdkName());
        }
        if (orderEntry1 instanceof LibraryOrderEntry && orderEntry2 instanceof LibraryOrderEntry) {
            LibraryOrderEntry jdkOrderEntry1 = (LibraryOrderEntry)orderEntry1;
            LibraryOrderEntry jdkOrderEntry2 = (LibraryOrderEntry)orderEntry2;
            return Comparing.equal((Object)jdkOrderEntry1.getLibrary(), (Object)jdkOrderEntry2.getLibrary());
        }
        if (orderEntry1 instanceof ModuleSourceOrderEntry && orderEntry2 instanceof ModuleSourceOrderEntry) {
            ModuleSourceOrderEntry jdkOrderEntry1 = (ModuleSourceOrderEntry)orderEntry1;
            ModuleSourceOrderEntry jdkOrderEntry2 = (ModuleSourceOrderEntry)orderEntry2;
            return Comparing.equal((Object)jdkOrderEntry1.getOwnerModule(), (Object)jdkOrderEntry2.getOwnerModule());
        }
        if (orderEntry1 instanceof ModuleOrderEntry && orderEntry2 instanceof ModuleOrderEntry) {
            ModuleOrderEntry jdkOrderEntry1 = (ModuleOrderEntry)orderEntry1;
            ModuleOrderEntry jdkOrderEntry2 = (ModuleOrderEntry)orderEntry2;
            return Comparing.equal((Object)jdkOrderEntry1.getModule(), (Object)jdkOrderEntry2.getModule());
        }
        return false;
    }

    public static boolean equals(Library library1, Library library2) {
        if (library1 == library2) {
            return true;
        }
        if (library1 == null || library2 == null) {
            return false;
        }
        LibraryTable table = library1.getTable();
        if (table != null) {
            if (library2.getTable() != table) {
                return false;
            }
            String name2 = library1.getName();
            return name2 != null && name2.equals(library2.getName());
        }
        if (library2.getTable() != null) {
            return false;
        }
        for (OrderRootType type2 : OrderRootType.getAllTypes()) {
            if (Comparing.equal((Object[])library1.getUrls(type2), (Object[])library2.getUrls(type2))) continue;
            return false;
        }
        return true;
    }

    public static void addLibraryToRoots(LibraryOrderEntry libraryOrderEntry, Module module2) {
        Library library = libraryOrderEntry.getLibrary();
        if (library == null) {
            return;
        }
        OrderEntryUtil.addLibraryToRoots(module2, library);
    }

    public static void addLibraryToRoots(@NotNull Module module2, @NotNull Library library) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/impl/OrderEntryUtil", "addLibraryToRoots"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/impl/OrderEntryUtil", "addLibraryToRoots"));
        }
        ModuleRootManager manager = ModuleRootManager.getInstance((Module)module2);
        ModifiableRootModel rootModel = manager.getModifiableModel();
        if (library.getTable() == null) {
            Library jarLibrary = rootModel.getModuleLibraryTable().createLibrary();
            Library.ModifiableModel libraryModel = jarLibrary.getModifiableModel();
            for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
                VirtualFile[] files;
                for (VirtualFile jarFile : files = library.getFiles(orderRootType)) {
                    libraryModel.addRoot(jarFile, orderRootType);
                }
            }
            libraryModel.commit();
        } else {
            rootModel.addLibraryEntry(library);
        }
        rootModel.commit();
    }

    private static int findLibraryOrderEntry(@NotNull OrderEntry[] entries, @NotNull Library library) {
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "com/intellij/openapi/roots/impl/OrderEntryUtil", "findLibraryOrderEntry"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/impl/OrderEntryUtil", "findLibraryOrderEntry"));
        }
        for (int i2 = 0; i2 < entries.length; ++i2) {
            OrderEntry entry = entries[i2];
            if (!(entry instanceof LibraryOrderEntry) || !library.equals(((LibraryOrderEntry)entry).getLibrary())) continue;
            return i2;
        }
        return -1;
    }

    public static void replaceLibrary(@NotNull ModifiableRootModel model, @NotNull Library oldLibrary, @NotNull Library newLibrary) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/roots/impl/OrderEntryUtil", "replaceLibrary"));
        }
        if (oldLibrary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldLibrary", "com/intellij/openapi/roots/impl/OrderEntryUtil", "replaceLibrary"));
        }
        if (newLibrary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLibrary", "com/intellij/openapi/roots/impl/OrderEntryUtil", "replaceLibrary"));
        }
        int i2 = OrderEntryUtil.findLibraryOrderEntry(model.getOrderEntries(), oldLibrary);
        if (i2 == -1) {
            return;
        }
        model.addLibraryEntry(newLibrary);
        OrderEntryUtil.replaceLibraryByAdded(model, i2);
    }

    public static void replaceLibraryEntryByAdded(@NotNull ModifiableRootModel model, @NotNull LibraryOrderEntry entry) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/roots/impl/OrderEntryUtil", "replaceLibraryEntryByAdded"));
        }
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/openapi/roots/impl/OrderEntryUtil", "replaceLibraryEntryByAdded"));
        }
        int i2 = ArrayUtil.indexOf((Object[])model.getOrderEntries(), (Object)entry);
        if (i2 == -1) {
            return;
        }
        OrderEntryUtil.replaceLibraryByAdded(model, i2);
    }

    private static void replaceLibraryByAdded(ModifiableRootModel model, int toReplace) {
        OrderEntry[] entries = model.getOrderEntries();
        LibraryOrderEntry newEntry = (LibraryOrderEntry)entries[entries.length - 1];
        LibraryOrderEntry libraryEntry = (LibraryOrderEntry)entries[toReplace];
        boolean exported = libraryEntry.isExported();
        DependencyScope scope = libraryEntry.getScope();
        model.removeOrderEntry((OrderEntry)libraryEntry);
        newEntry.setExported(exported);
        newEntry.setScope(scope);
        OrderEntry[] newEntries = new OrderEntry[entries.length - 1];
        System.arraycopy(entries, 0, newEntries, 0, toReplace);
        newEntries[toReplace] = newEntry;
        System.arraycopy(entries, toReplace + 1, newEntries, toReplace + 1, entries.length - toReplace - 2);
        model.rearrangeOrderEntries(newEntries);
    }

    public static <T extends OrderEntry> void processOrderEntries(@NotNull Module module2, @NotNull Class<T> orderEntryClass, @NotNull Processor<T> processor2) {
        OrderEntry[] orderEntries;
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/impl/OrderEntryUtil", "processOrderEntries"));
        }
        if (orderEntryClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderEntryClass", "com/intellij/openapi/roots/impl/OrderEntryUtil", "processOrderEntries"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/roots/impl/OrderEntryUtil", "processOrderEntries"));
        }
        for (OrderEntry orderEntry : orderEntries = ModuleRootManager.getInstance((Module)module2).getOrderEntries()) {
            if (orderEntryClass.isInstance(orderEntry) && !processor2.process(orderEntryClass.cast(orderEntry))) break;
        }
    }

    public static DependencyScope intersectScopes(DependencyScope scope1, DependencyScope scope2) {
        if (scope1 == scope2) {
            return scope1;
        }
        if (scope1 == DependencyScope.COMPILE) {
            return scope2;
        }
        if (scope2 == DependencyScope.COMPILE) {
            return scope1;
        }
        if (scope1 == DependencyScope.TEST || scope2 == DependencyScope.TEST) {
            return DependencyScope.TEST;
        }
        return scope1;
    }

    @NotNull
    public static List<Library> getModuleLibraries(@NotNull ModuleRootModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/roots/impl/OrderEntryUtil", "getModuleLibraries"));
        }
        OrderEntry[] orderEntries = model.getOrderEntries();
        ArrayList<Library> libraries = new ArrayList<Library>();
        for (OrderEntry orderEntry : orderEntries) {
            LibraryOrderEntry entry;
            if (!(orderEntry instanceof LibraryOrderEntry) || !(entry = (LibraryOrderEntry)orderEntry).isModuleLevel()) continue;
            libraries.add(entry.getLibrary());
        }
        ArrayList<Library> arrayList = libraries;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/OrderEntryUtil", "getModuleLibraries"));
        }
        return arrayList;
    }
}

