/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelElement;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.TestModuleProperties;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="TestModuleProperties")
public class TestModulePropertiesImpl
extends TestModuleProperties
implements PersistentStateComponent<TestModulePropertiesState>,
ProjectModelElement {
    private final ModulePointerManager myModulePointerManager;
    private ModulePointer myProductionModulePointer;
    private Module myModule;

    public TestModulePropertiesImpl(@NotNull Module module2, @NotNull ModulePointerManager modulePointerManager) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/impl/TestModulePropertiesImpl", "<init>"));
        }
        if (modulePointerManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulePointerManager", "com/intellij/openapi/roots/impl/TestModulePropertiesImpl", "<init>"));
        }
        this.myModule = module2;
        this.myModulePointerManager = modulePointerManager;
    }

    @Override
    @Nullable
    public String getProductionModuleName() {
        return this.myProductionModulePointer != null ? this.myProductionModulePointer.getModuleName() : null;
    }

    @Override
    @Nullable
    public Module getProductionModule() {
        return this.myProductionModulePointer != null ? this.myProductionModulePointer.getModule() : null;
    }

    @Override
    public void setProductionModuleName(@Nullable String moduleName) {
        this.myProductionModulePointer = moduleName != null ? this.myModulePointerManager.create(moduleName) : null;
    }

    @Nullable
    public TestModulePropertiesState getState() {
        TestModulePropertiesState state = new TestModulePropertiesState();
        state.moduleName = this.getProductionModuleName();
        return state;
    }

    public void loadState(TestModulePropertiesState state) {
        this.setProductionModuleName(state.moduleName);
    }

    @Nullable
    public ProjectModelExternalSource getExternalSource() {
        return ExternalProjectSystemRegistry.getInstance().getExternalSource(this.myModule);
    }

    public static class TestModulePropertiesState {
        @Attribute(value="production-module")
        public String moduleName;
    }
}

