/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class JarDirectories
implements JDOMExternalizable {
    private final MultiMap<OrderRootType, String> myDirectories = new MultiMap();
    private final MultiMap<OrderRootType, String> myRecursivelyIncluded = new MultiMap();
    @NonNls
    private static final String JAR_DIRECTORY_ELEMENT = "jarDirectory";
    @NonNls
    private static final String URL_ATTR = "url";
    @NonNls
    private static final String RECURSIVE_ATTR = "recursive";
    @NonNls
    private static final String ROOT_TYPE_ATTR = "type";
    public static final OrderRootType DEFAULT_JAR_DIRECTORY_TYPE = OrderRootType.CLASSES;

    public void copyFrom(JarDirectories other) {
        this.myDirectories.clear();
        this.myDirectories.putAllValues(other.myDirectories);
        this.myRecursivelyIncluded.clear();
        this.myRecursivelyIncluded.putAllValues(other.myRecursivelyIncluded);
    }

    public boolean contains(OrderRootType rootType, String url) {
        return this.myDirectories.get((Object)rootType).contains(url);
    }

    public boolean isRecursive(OrderRootType rootType, String url) {
        return this.myRecursivelyIncluded.get((Object)rootType).contains(url);
    }

    public void add(OrderRootType rootType, String url, boolean recursively) {
        this.myDirectories.putValue((Object)rootType, (Object)url);
        if (recursively) {
            this.myRecursivelyIncluded.putValue((Object)rootType, (Object)url);
        }
    }

    public void remove(OrderRootType rootType, String url) {
        this.myDirectories.remove((Object)rootType, (Object)url);
        this.myRecursivelyIncluded.remove((Object)rootType, (Object)url);
    }

    public void clear() {
        this.myDirectories.clear();
        this.myRecursivelyIncluded.clear();
    }

    public Collection<OrderRootType> getRootTypes() {
        return this.myDirectories.keySet();
    }

    public Collection<String> getDirectories(OrderRootType rootType) {
        return this.myDirectories.get((Object)rootType);
    }

    public Collection<? extends String> getAllDirectories() {
        return this.myDirectories.values();
    }

    public boolean isEmpty() {
        return this.myDirectories.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JarDirectories)) {
            return false;
        }
        JarDirectories that = (JarDirectories)o;
        return this.myDirectories.equals(that.myDirectories) && this.myRecursivelyIncluded.equals(that.myRecursivelyIncluded);
    }

    public int hashCode() {
        return 31 * this.myDirectories.hashCode() + this.myRecursivelyIncluded.hashCode();
    }

    public String toString() {
        return "JAR dirs: " + this.myDirectories.values();
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.clear();
        List jarDirs = element.getChildren(JAR_DIRECTORY_ELEMENT);
        for (Element jarDir : jarDirs) {
            String url = jarDir.getAttributeValue(URL_ATTR);
            String recursive = jarDir.getAttributeValue(RECURSIVE_ATTR);
            OrderRootType rootType = JarDirectories.getJarDirectoryRootType(jarDir.getAttributeValue(ROOT_TYPE_ATTR));
            if (url == null) continue;
            this.add(rootType, url, Boolean.parseBoolean(recursive));
        }
    }

    private static OrderRootType getJarDirectoryRootType(@Nullable String type2) {
        for (PersistentOrderRootType rootType : OrderRootType.getAllPersistentTypes()) {
            if (!rootType.name().equals(type2)) continue;
            return rootType;
        }
        return DEFAULT_JAR_DIRECTORY_TYPE;
    }

    public void writeExternal(Element element) {
        List<OrderRootType> rootTypes = LibraryImpl.sortRootTypes(this.getRootTypes());
        for (OrderRootType rootType : rootTypes) {
            ArrayList<String> urls = new ArrayList<String>(this.getDirectories(rootType));
            Collections.sort(urls, String.CASE_INSENSITIVE_ORDER);
            for (String url : urls) {
                Element jarDirElement = new Element(JAR_DIRECTORY_ELEMENT);
                jarDirElement.setAttribute(URL_ATTR, url);
                jarDirElement.setAttribute(RECURSIVE_ATTR, Boolean.toString(this.isRecursive(rootType, url)));
                if (!rootType.equals((Object)DEFAULT_JAR_DIRECTORY_TYPE)) {
                    jarDirElement.setAttribute(ROOT_TYPE_ATTR, rootType.name());
                }
                element.addContent(jarDirElement);
            }
        }
    }
}

