/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibrariesHelper;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.text.StringTokenizer;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class LibrariesHelperImpl
extends LibrariesHelper {
    public VirtualFile findJarByClass(Library library, @NonNls String fqn) {
        return library == null ? null : this.findRootByClass(Arrays.asList(library.getFiles(OrderRootType.CLASSES)), fqn);
    }

    @Nullable
    public VirtualFile findRootByClass(List<VirtualFile> roots, String fqn) {
        for (VirtualFile file2 : roots) {
            if (!LibrariesHelperImpl.findInFile(file2, new StringTokenizer(fqn, "."))) continue;
            return file2;
        }
        return null;
    }

    public boolean isClassAvailableInLibrary(Library library, String fqn) {
        String[] urls = library.getUrls(OrderRootType.CLASSES);
        return this.isClassAvailable(urls, fqn);
    }

    public boolean isClassAvailable(String[] urls, String fqn) {
        for (String url : urls) {
            VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(url);
            if (file2 == null) continue;
            if (!(file2.getFileSystem() instanceof JarFileSystem) && !file2.isDirectory()) {
                file2 = JarFileSystem.getInstance().getJarRootForLocalFile(file2);
            }
            if (file2 == null || !LibrariesHelperImpl.findInFile(file2, new StringTokenizer(fqn, "."))) continue;
            return true;
        }
        return false;
    }

    private static boolean findInFile(VirtualFile root, StringTokenizer filePath) {
        VirtualFile child;
        if (!filePath.hasMoreTokens()) {
            return true;
        }
        String name2 = filePath.nextToken();
        if (!filePath.hasMoreTokens()) {
            name2 = name2 + ".class";
        }
        return (child = root.findChild(name2)) != null && LibrariesHelperImpl.findInFile(child, filePath);
    }
}

