/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries.ui;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class RootFilter
extends RootDetector {
    public RootFilter(OrderRootType rootType, boolean jarDirectory, String presentableRootTypeName) {
        super(rootType, jarDirectory, presentableRootTypeName);
    }

    public abstract boolean isAccepted(@NotNull VirtualFile var1, @NotNull ProgressIndicator var2);

    @Override
    @NotNull
    public Collection<VirtualFile> detectRoots(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
        if (rootCandidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootCandidate", "com/intellij/openapi/roots/libraries/ui/RootFilter", "detectRoots"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/roots/libraries/ui/RootFilter", "detectRoots"));
        }
        if (this.isAccepted(rootCandidate, progressIndicator)) {
            List<VirtualFile> list2 = Collections.singletonList(rootCandidate);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/libraries/ui/RootFilter", "detectRoots"));
            }
            return list2;
        }
        List<VirtualFile> list3 = Collections.emptyList();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/libraries/ui/RootFilter", "detectRoots"));
        }
        return list3;
    }
}

