/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetectionUtil;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaVfsSourceRootDetectionUtil {
    private JavaVfsSourceRootDetectionUtil() {
    }

    @NotNull
    public static List<VirtualFile> suggestRoots(@NotNull VirtualFile dir, final @NotNull ProgressIndicator progressIndicator) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/roots/ui/configuration/JavaVfsSourceRootDetectionUtil", "suggestRoots"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/roots/ui/configuration/JavaVfsSourceRootDetectionUtil", "suggestRoots"));
        }
        if (!dir.isDirectory()) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/JavaVfsSourceRootDetectionUtil", "suggestRoots"));
            }
            return list2;
        }
        final FileTypeManager typeManager = FileTypeManager.getInstance();
        final ArrayList<VirtualFile> foundDirectories = new ArrayList<VirtualFile>();
        try {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)dir, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                @NotNull
                public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file2) {
                    if (file2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/ui/configuration/JavaVfsSourceRootDetectionUtil$1", "visitFileEx"));
                    }
                    progressIndicator.checkCanceled();
                    if (file2.isDirectory()) {
                        if (typeManager.isFileIgnored(file2) || StringUtil.startsWithIgnoreCase((String)file2.getName(), (String)"testData")) {
                            VirtualFileVisitor.Result result2 = SKIP_CHILDREN;
                            if (result2 == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/JavaVfsSourceRootDetectionUtil$1", "visitFileEx"));
                            }
                            return result2;
                        }
                    } else {
                        VirtualFile root;
                        FileType type2 = typeManager.getFileTypeByFileName(file2.getName());
                        if (StdFileTypes.JAVA == type2 && (root = JavaVfsSourceRootDetectionUtil.suggestRootForJavaFile(file2)) != null) {
                            foundDirectories.add(root);
                            VirtualFileVisitor.Result result3 = 1.skipTo((VirtualFile)root);
                            if (result3 == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/JavaVfsSourceRootDetectionUtil$1", "visitFileEx"));
                            }
                            return result3;
                        }
                    }
                    VirtualFileVisitor.Result result4 = CONTINUE;
                    if (result4 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/JavaVfsSourceRootDetectionUtil$1", "visitFileEx"));
                    }
                    return result4;
                }
            });
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        ArrayList<VirtualFile> arrayList = foundDirectories;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/JavaVfsSourceRootDetectionUtil", "suggestRoots"));
        }
        return arrayList;
    }

    @Nullable
    private static VirtualFile suggestRootForJavaFile(VirtualFile javaFile) {
        if (javaFile.isDirectory()) {
            return null;
        }
        CharSequence chars = LoadTextUtil.loadText(javaFile);
        String packageName = JavaSourceRootDetectionUtil.getPackageName(chars);
        if (packageName != null) {
            VirtualFile root = javaFile.getParent();
            int index = packageName.length();
            while (index > 0) {
                boolean equalsToToken;
                int index1 = packageName.lastIndexOf(46, index - 1);
                String token = packageName.substring(index1 + 1, index);
                String dirName = root.getName();
                boolean bl = equalsToToken = SystemInfo.isFileSystemCaseSensitive ? dirName.equals(token) : dirName.equalsIgnoreCase(token);
                if (!equalsToToken) {
                    return null;
                }
                if ((root = root.getParent()) == null) {
                    return null;
                }
                index = index1;
            }
            return root;
        }
        return null;
    }
}

