/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.ModuleDescription;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.roots.ui.configuration.ModuleDescriptionTreeNode;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/ModuleDescriptionNode;", "Ljavax/swing/tree/DefaultMutableTreeNode;", "Lcom/intellij/openapi/roots/ui/configuration/ModuleDescriptionTreeNode;", "moduleDescription", "Lcom/intellij/openapi/module/ModuleDescription;", "moduleGrouper", "Lcom/intellij/openapi/module/ModuleGrouper;", "(Lcom/intellij/openapi/module/ModuleDescription;Lcom/intellij/openapi/module/ModuleGrouper;)V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "getModuleDescription", "()Lcom/intellij/openapi/module/ModuleDescription;", "getModuleGrouper", "()Lcom/intellij/openapi/module/ModuleGrouper;", "text", "", "getText", "()Ljava/lang/String;", "lang-impl"})
final class ModuleDescriptionNode
extends DefaultMutableTreeNode
implements ModuleDescriptionTreeNode {
    @NotNull
    private final ModuleDescription moduleDescription;
    @NotNull
    private final ModuleGrouper moduleGrouper;

    @Override
    @NotNull
    public String getText() {
        String string = this.moduleDescription.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"moduleDescription.name");
        return this.moduleGrouper.getShortenedNameByFullModuleName(string);
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Nodes.Module;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.Nodes.Module");
        return icon;
    }

    @NotNull
    public final ModuleDescription getModuleDescription() {
        return this.moduleDescription;
    }

    @NotNull
    public final ModuleGrouper getModuleGrouper() {
        return this.moduleGrouper;
    }

    public ModuleDescriptionNode(@NotNull ModuleDescription moduleDescription, @NotNull ModuleGrouper moduleGrouper) {
        Intrinsics.checkParameterIsNotNull((Object)moduleDescription, (String)"moduleDescription");
        Intrinsics.checkParameterIsNotNull((Object)moduleGrouper, (String)"moduleGrouper");
        this.moduleDescription = moduleDescription;
        this.moduleGrouper = moduleGrouper;
    }
}

