/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.ComplexPackagingElementNode;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ComplexElementSubstitutionParameters {
    private final Set<ComplexPackagingElementType<?>> myTypesToSubstitute = new HashSet();
    private final Set<ComplexPackagingElement<?>> mySubstituted = new HashSet();

    public void setSubstituteAll() {
        ContainerUtil.addAll(this.myTypesToSubstitute, (Object[])PackagingElementFactory.getInstance().getComplexElementTypes());
        this.mySubstituted.clear();
    }

    public void setSubstituteNone() {
        this.myTypesToSubstitute.clear();
        this.mySubstituted.clear();
    }

    public boolean shouldSubstitute(@NotNull ComplexPackagingElement<?> element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/ui/configuration/artifacts/ComplexElementSubstitutionParameters", "shouldSubstitute"));
        }
        ComplexPackagingElementType type2 = (ComplexPackagingElementType)element.getType();
        return this.myTypesToSubstitute.contains(type2) || this.mySubstituted.contains(element);
    }

    public void setShowContent(ComplexPackagingElementType<?> type2, boolean showContent) {
        if (showContent) {
            this.myTypesToSubstitute.add(type2);
        } else {
            this.myTypesToSubstitute.remove(type2);
        }
        Iterator<ComplexPackagingElement<?>> iterator = this.mySubstituted.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getType().equals(type2)) continue;
            iterator.remove();
        }
    }

    public Set<ComplexPackagingElementType<?>> getTypesToSubstitute() {
        return Collections.unmodifiableSet(this.myTypesToSubstitute);
    }

    public void setShowContent(ComplexPackagingElementNode complexNode) {
        this.mySubstituted.addAll(complexNode.getPackagingElements());
    }

    public void doNotSubstitute(ComplexPackagingElement<?> element) {
        this.mySubstituted.remove(element);
    }

    public boolean isShowContentForType(@NotNull ComplexPackagingElementType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/roots/ui/configuration/artifacts/ComplexElementSubstitutionParameters", "isShowContentForType"));
        }
        return this.myTypesToSubstitute.contains(type2);
    }

    public boolean isAllSubstituted() {
        return this.myTypesToSubstitute.containsAll(Arrays.asList(PackagingElementFactory.getInstance().getComplexElementTypes()));
    }

    public boolean isNoneSubstituted() {
        return this.myTypesToSubstitute.isEmpty() && this.mySubstituted.isEmpty();
    }

    public void setTypesToShowContent(Collection<ComplexPackagingElementType<?>> types) {
        this.myTypesToSubstitute.clear();
        this.myTypesToSubstitute.addAll(types);
    }
}

