/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.facet.Facet;
import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.facet.impl.invalid.InvalidFacet;
import com.intellij.facet.impl.ui.FacetEditorImpl;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.FacetProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class FacetConfigurable
extends ProjectStructureElementConfigurable<Facet> {
    private final Facet myFacet;
    private final ModulesConfigurator myModulesConfigurator;
    private String myFacetName;
    private FacetProjectStructureElement myProjectStructureElement;

    public FacetConfigurable(Facet facet, StructureConfigurableContext context, Runnable updateTree) {
        super(!facet.getType().isOnlyOneFacetAllowed() && !(facet instanceof InvalidFacet), updateTree);
        this.myFacet = facet;
        this.myModulesConfigurator = context.getModulesConfigurator();
        this.myFacetName = this.myFacet.getName();
        this.myProjectStructureElement = new FacetProjectStructureElement(context, facet);
    }

    public void setDisplayName(String name2) {
        if (!name2.equals(this.myFacetName)) {
            this.getFacetsConfigurator().getOrCreateModifiableModel(this.myFacet.getModule()).rename(this.myFacet, name2);
            this.myFacetName = name2;
        }
    }

    @Override
    public ProjectStructureElement getProjectStructureElement() {
        return this.myProjectStructureElement;
    }

    private ProjectFacetsConfigurator getFacetsConfigurator() {
        return this.myModulesConfigurator.getFacetsConfigurator();
    }

    public Facet getEditableObject() {
        return this.myFacet;
    }

    public String getBannerSlogan() {
        return ProjectBundle.message((String)"facet.banner.text", (Object[])new Object[]{this.myFacetName});
    }

    public JComponent createOptionsPanel() {
        return this.getEditor().getComponent();
    }

    public FacetEditorImpl getEditor() {
        return this.getFacetsConfigurator().getOrCreateEditor(this.myFacet);
    }

    @Nls
    public String getDisplayName() {
        return this.myFacetName;
    }

    @Nullable
    public Icon getIcon(boolean open2) {
        return this.myFacet.getType().getIcon();
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        FacetEditorImpl facetEditor = this.getFacetsConfigurator().getEditor(this.myFacet);
        return facetEditor != null ? facetEditor.getHelpTopic() : null;
    }

    public boolean isModified() {
        return false;
    }

    public void apply() throws ConfigurationException {
    }
}

