/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import java.util.Collections;
import java.util.List;

public class SdkProjectStructureElement
extends ProjectStructureElement {
    private final Sdk mySdk;

    public SdkProjectStructureElement(StructureConfigurableContext context, Sdk sdk) {
        super(context);
        this.mySdk = this.getModifiableSdk(sdk);
    }

    private Sdk getModifiableSdk(Sdk sdk) {
        Sdk modifiableSdk = ProjectStructureConfigurable.getInstance(this.myContext.getProject()).getProjectJdksModel().getProjectSdks().get(sdk);
        return modifiableSdk != null ? modifiableSdk : sdk;
    }

    public Sdk getSdk() {
        return this.mySdk;
    }

    @Override
    public void check(ProjectStructureProblemsHolder problemsHolder) {
    }

    @Override
    public List<ProjectStructureElementUsage> getUsagesInElement() {
        return Collections.emptyList();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SdkProjectStructureElement)) {
            return false;
        }
        return this.mySdk.equals(((SdkProjectStructureElement)o).mySdk);
    }

    @Override
    public int hashCode() {
        return this.mySdk.hashCode();
    }

    @Override
    public String getPresentableName() {
        return this.mySdk.getName();
    }

    @Override
    public String getTypeName() {
        return "SDK";
    }

    @Override
    public String getId() {
        return "sdk:" + this.mySdk.getName();
    }
}

